
# -*- coding: utf-8 -*-

# Originally <http://GitHub.com/phillip-nguyen/cocoa-python>

u'''A basic, partial, U{ctypes
<http://Docs.Python.org/2.7/library/ctypes.html>}-based Python binding to
the I{macOS} Objective-C Cocoa runtime and several other I{macOS} libraries.

This is the U{cocoa-python<http://GitHub.com/phillip-nguyen/cocoa-python>}
package by I{Phillip Nguyen (C) 2011}, modified, extended, tested,
documented and published under the original
U{New BSD License<http://OpenSource.org/licenses/BSD-3-Clause>} and the
U{MIT License<http://OpenSource.org/licenses/MIT>}.

In addition to the U{pycocoa<http://PyPI.Python.org/pypi/PyCocoa>} package,
the distribution files contain several tests, examples and
U{documentation <http://mrjean1.GitHub.io/PyCocoa>} (generated by
U{Epydoc<http://PyPI.Python.org/pypi/epydoc>} using command line:
C{epydoc --html --no-private --no-source --name=PyCocoa --url=... -v pycocoa}).

The example I{simple_VLCplayer.py} requires installation of the U{VLC App
<http://www.VideoLan.org/vlc/download-macosx.html>} for I{macOS} and the
corresponging U{Python-VLC<http://PyPI.Python.org/pypi/python-vlc>} binding.

The tests and examples have only been run with 64-bit Python 2.7.14 and
3.6.4 (with U{VLC<http://PyPI.Python.org/pypi/python-vlc>} 2.2.6 and 3.0.1)
and only on macOS 10.13.3 High Sierra.

All PyCocoa source code has been statically
U{checked<http://GitHub.com/ActiveState/code/tree/master/recipes/Python/546532_PyChecker_postprocessor>}
with U{PyChecker<http://PyPI.Python.org/pypi/pychecker>},
U{PyFlakes<http://PyPI.Python.org/pypi/pyflakes>},
U{PyCodeStyle<http://PyPI.Python.org/pypi/pycodestyle>} (formerly Pep8) and
U{McCabe<http://PyPI.Python.org/pypi/mccabe>} using 64-bit Python 2.7.14 and with
U{Flake8<http://PyPI.Python.org/pypi/flake8>} on 64-bit Python 3.6.4.

To install PyCocoa, type C{pip install PyCocoa} or C{easy_install PyCocoa}
in a terminal window.  Alternatively, download C{PyCocoa-} from
U{PyPI<http://PyPI.Python.org/pypi/PyCocoa/>} or
U{GitHub<http://GitHub.com/mrJean1/PyCocoa>}, C{unzip} the downloaded file,
C{cd} to directory C{PyCocoa-} and type C{python setup.py install}.  To
run the PyCocoa tests, type C{python setup.py test} before installation.

Two alternatives to PyCocoa are (a) U{PyObjC<http://PyPI.Python.org/pypi/pyobjc/>},
the most comprehensive Python to Objective-C bridge and (b)
U{Rubicon-ObjC<http://PyPI.Python.org/pypi/rubicon-objc/>} for Python 3.5+,
taking advantage of Python's new
U{typing<http://Docs.Python.org/3/library/typing.html>} annotations.

__

U{Copyright (C) 2011 -- Phillip Nguyen -- All Rights Reserved.
<http://OpenSource.org/licenses/BSD-3-Clause>}

C{Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:}

C{1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.}

C{2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.}

C{3. Neither the name of objective-ctypes nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.}

C{THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.}

__

U{Copyright (C) 2017-2018 -- mrJean1 at Gmail dot com
<http://OpenSource.org/licenses/MIT>}

C{Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:}

C{The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.}

C{THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.}

@newfield example: Example, Examples

@var libobjc: The macOS C{objc} library (C{ctypes.CDLL})
'''

from os.path import abspath, dirname
import sys

p = sys.platform
if not p.startswith('darwin'):
    raise NotImplementedError('%s not supported, only %s' % (p, 'macOS'))
del p

# PyChecker chockes on .import
d = dirname(abspath(__file__))
if d not in sys.path:
    sys.path.insert(0, d)
del d

from nstypes import *  # PYCHOK expected
from oclibs  import *  # PYCHOK expected
from octypes import *  # PYCHOK expected
from runtime import *  # PYCHOK expected

# the typical styleMask for NSWindow
NSUsualWindowMask = NSClosableWindowMask  | NSMiniaturizableWindowMask \
                  | NSResizableWindowMask | NSTitledWindowMask  # PYCHOK expected

# if needed, for backward compatibility with cocoa-python:
# CFSTR                         = CFString                   # PYCHOK expected
# objc                          = libobjc                    # PYCHOK expected
# OBJC_SUPER                    = objc_super                 # PYCHOK expected
# OBJC_SUPER_PTR                = objc_super_ptr             # PYCHOK expected
# ObjCClass.get_class_method    = ObjCClass.get_classmethod  # PYCHOK expected
# ObjCClass.get_instance_method = ObjCClass.get_method       # PYCHOK expected
# cfarray_to_list               = cfArray2list               # PYCHOK expected
# cfnumber_to_number            = cfNumber2num               # PYCHOK expected
# cfset_to_set                  = cfSet2set                  # PYCHOK expected
# cfstring_to_string            = cfString2str               # PYCHOK expected
# cftype_to_value               = cfType2py                  # PYCHOK expected
# create_subclass               = add_subclass               # PYCHOK expected
# get_instance_variable         = get_ivar                   # PYCHOK expected
# get_NSString                  = NSString                   # PYCHOK expected
# get_object_class              = get_classof                # PYCHOK expected
# get_superclass_of_object      = get_superclassof           # PYCHOK expected
# parse_type_encoding           = split_encoding             # PYCHOK expected
# set_instance_variable         = set_ivar                   # PYCHOK expected

__all__ = tuple(sorted(set(_ for _ in locals().keys() if
                       not _.startswith(('_', 'CFUNCTION', 'c_', 'lib')))))
__version__ = '18.03.15'

if __name__ == '__main__':

    from octypes import _allist  # PYCHOK expected

    _allist(__all__, locals(), __version__, 'pycocoa')
