# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class ResourceStatus(str, Enum):

    healthy = "Healthy"  #: This assessment on the resource is healthy
    not_applicable = "NotApplicable"  #: This assessment is not applicable to this resource
    off_by_policy = "OffByPolicy"  #: This assessment is turned off by policy on this subscription
    not_healthy = "NotHealthy"  #: This assessment on the resource is not healthy


class PricingTier(str, Enum):

    free = "Free"  #: Get free Azure security center experience with basic security features
    standard = "Standard"  #: Get the standard Azure security center experience with advanced security features


class ValueType(str, Enum):

    ip_cidr = "IpCidr"  #: An IP range in CIDR format (e.g. '192.168.0.1/8').
    string = "String"  #: Any string value.


class SecuritySolutionStatus(str, Enum):

    enabled = "Enabled"
    disabled = "Disabled"


class ExportData(str, Enum):

    raw_events = "RawEvents"  #: Agent raw events


class DataSource(str, Enum):

    twin_data = "TwinData"  #: Devices twin data


class RecommendationType(str, Enum):

    io_t_acrauthentication = "IoT_ACRAuthentication"  #: Authentication schema used for pull an edge module from an ACR repository does not use Service Principal Authentication.
    io_t_agent_sends_unutilized_messages = "IoT_AgentSendsUnutilizedMessages"  #: IoT agent message size capacity is currently underutilized, causing an increase in the number of sent messages. Adjust message intervals for better utilization.
    io_t_baseline = "IoT_Baseline"  #: Identified security related system configuration issues.
    io_t_edge_hub_mem_optimize = "IoT_EdgeHubMemOptimize"  #: You can optimize Edge Hub memory usage by turning off protocol heads for any protocols not used by Edge modules in your solution.
    io_t_edge_logging_options = "IoT_EdgeLoggingOptions"  #: Logging is disabled for this edge module.
    io_t_inconsistent_module_settings = "IoT_InconsistentModuleSettings"  #: A minority within a device security group has inconsistent Edge Module settings with the rest of their group.
    io_t_install_agent = "IoT_InstallAgent"  #: Install the Azure Security of Things Agent.
    io_t_ipfilter_deny_all = "IoT_IPFilter_DenyAll"  #: IP Filter Configuration should have rules defined for allowed traffic and should deny all other traffic by default.
    io_t_ipfilter_permissive_rule = "IoT_IPFilter_PermissiveRule"  #: An Allow IP Filter rules source IP range is too large. Overly permissive rules might expose your IoT hub to malicious intenders.
    io_t_open_ports = "IoT_OpenPorts"  #: A listening endpoint was found on the device.
    io_t_permissive_firewall_policy = "IoT_PermissiveFirewallPolicy"  #: An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny all traffic by default and define rules to allow necessary communication to/from the device.
    io_t_permissive_input_firewall_rules = "IoT_PermissiveInputFirewallRules"  #: A rule in the firewall has been found that contains a permissive pattern for a wide range of IP addresses or Ports.
    io_t_permissive_output_firewall_rules = "IoT_PermissiveOutputFirewallRules"  #: A rule in the firewall has been found that contains a permissive pattern for a wide range of IP addresses or Ports.
    io_t_privileged_docker_options = "IoT_PrivilegedDockerOptions"  #: Edge module is configured to run in privileged mode, with extensive Linux capabilities or with host-level network access (send/receive data to host machine).
    io_t_shared_credentials = "IoT_SharedCredentials"  #: Same authentication credentials to the IoT Hub used by multiple devices. This could indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device impersonation by an attacker.
    io_t_vulnerable_tls_cipher_suite = "IoT_VulnerableTLSCipherSuite"  #: Insecure TLS configurations detected. Immediate upgrade recommended.


class RecommendationConfigStatus(str, Enum):

    disabled = "Disabled"
    enabled = "Enabled"


class UnmaskedIpLoggingStatus(str, Enum):

    disabled = "Disabled"  #: Unmasked IP logging is disabled
    enabled = "Enabled"  #: Unmasked IP logging is enabled


class ReportedSeverity(str, Enum):

    informational = "Informational"
    low = "Low"
    medium = "Medium"
    high = "High"


class AlertSeverity(str, Enum):

    informational = "Informational"
    low = "Low"
    medium = "Medium"
    high = "High"


class AlertIntent(str, Enum):

    unknown = "Unknown"
    pre_attack = "PreAttack"
    initial_access = "InitialAccess"
    persistence = "Persistence"
    privilege_escalation = "PrivilegeEscalation"
    defense_evasion = "DefenseEvasion"
    credential_access = "CredentialAccess"
    discovery = "Discovery"
    lateral_movement = "LateralMovement"
    execution = "Execution"
    collection = "Collection"
    exfiltration = "Exfiltration"
    command_and_control = "CommandAndControl"
    impact = "Impact"
    probing = "Probing"
    exploitation = "Exploitation"


class RecommendationSeverity(str, Enum):

    unknown = "Unknown"
    not_applicable = "NotApplicable"
    healthy = "Healthy"
    off_by_policy = "OffByPolicy"
    low = "Low"
    medium = "Medium"
    high = "High"


class AutoProvision(str, Enum):

    on = "On"  #: Install missing security agent on VMs automatically
    off = "Off"  #: Do not install security agent on the VMs automatically


class Rank(str, Enum):

    none = "None"
    low = "Low"
    medium = "Medium"
    high = "High"
    critical = "Critical"


class AlertNotifications(str, Enum):

    on = "On"  #: Get notifications on new alerts
    off = "Off"  #: Don't get notifications on new alerts


class AlertsToAdmins(str, Enum):

    on = "On"  #: Send notification on new alerts to the subscription's admins
    off = "Off"  #: Don't send notification on new alerts to the subscription's admins


class State(str, Enum):

    passed = "Passed"  #: All supported regulatory compliance controls in the given standard have a passed state
    failed = "Failed"  #: At least one supported regulatory compliance control in the given standard has a state of failed
    skipped = "Skipped"  #: All supported regulatory compliance controls in the given standard have a state of skipped
    unsupported = "Unsupported"  #: No supported regulatory compliance data for the given standard


class SubAssessmentStatusCode(str, Enum):

    healthy = "Healthy"  #: The resource is healthy
    unhealthy = "Unhealthy"  #: The resource has a security issue that needs to be addressed
    not_applicable = "NotApplicable"  #: Assessment for this resource did not happen


class Severity(str, Enum):

    low = "Low"
    medium = "Medium"
    high = "High"


class EventSource(str, Enum):

    assessments = "Assessments"
    sub_assessments = "SubAssessments"
    alerts = "Alerts"


class PropertyType(str, Enum):

    string = "String"
    integer = "Integer"
    number = "Number"
    boolean = "Boolean"


class Operator(str, Enum):

    equals = "Equals"
    greater_than = "GreaterThan"
    greater_than_or_equal_to = "GreaterThanOrEqualTo"
    lesser_than = "LesserThan"
    lesser_than_or_equal_to = "LesserThanOrEqualTo"
    not_equals = "NotEquals"
    contains = "Contains"
    starts_with = "StartsWith"
    ends_with = "EndsWith"


class RuleState(str, Enum):

    enabled = "Enabled"
    disabled = "Disabled"
    expired = "Expired"


class Category(str, Enum):

    compute = "Compute"
    networking = "Networking"
    data = "Data"
    identity_and_access = "IdentityAndAccess"
    io_t = "IoT"


class UserImpact(str, Enum):

    low = "Low"
    moderate = "Moderate"
    high = "High"


class ImplementationEffort(str, Enum):

    low = "Low"
    moderate = "Moderate"
    high = "High"


class Threats(str, Enum):

    account_breach = "accountBreach"
    data_exfiltration = "dataExfiltration"
    data_spillage = "dataSpillage"
    malicious_insider = "maliciousInsider"
    elevation_of_privilege = "elevationOfPrivilege"
    threat_resistance = "threatResistance"
    missing_coverage = "missingCoverage"
    denial_of_service = "denialOfService"


class AssessmentType(str, Enum):

    built_in = "BuiltIn"  #: Azure Security Center managed assessments
    custom_policy = "CustomPolicy"  #: User defined policies that are automatically ingested from Azure Policy to Azure Security Center
    customer_managed = "CustomerManaged"  #: User assessments pushed directly by the user or other third party to Azure Security Center
    verified_partner = "VerifiedPartner"  #: An assessment that was created by a verified 3rd party if the user connected it to ASC


class AssessmentStatusCode(str, Enum):

    healthy = "Healthy"  #: The resource is healthy
    unhealthy = "Unhealthy"  #: The resource has a security issue that needs to be addressed
    not_applicable = "NotApplicable"  #: Assessment for this resource did not happen


class Direction(str, Enum):

    inbound = "Inbound"
    outbound = "Outbound"


class TransportProtocol(str, Enum):

    tcp = "TCP"
    udp = "UDP"


class Intent(str, Enum):

    unknown = "Unknown"  #: Unknown
    pre_attack = "PreAttack"  #: PreAttack could be either an attempt to access a certain resource regardless of a malicious intent, or a failed attempt to gain access to a target system to gather information prior to exploitation. This step is usually detected as an attempt, originating from outside the network, to scan the target system and find a way in.  Further details on the PreAttack stage can be read in [MITRE Pre-Att&ck matrix](https://attack.mitre.org/matrices/pre/).
    initial_access = "InitialAccess"  #: InitialAccess is the stage where an attacker manages to get foothold on the attacked resource.
    persistence = "Persistence"  #: Persistence is any access, action, or configuration change to a system that gives a threat actor a persistent presence on that system.
    privilege_escalation = "PrivilegeEscalation"  #: Privilege escalation is the result of actions that allow an adversary to obtain a higher level of permissions on a system or network.
    defense_evasion = "DefenseEvasion"  #: Defense evasion consists of techniques an adversary may use to evade detection or avoid other defenses.
    credential_access = "CredentialAccess"  #: Credential access represents techniques resulting in access to or control over system, domain, or service credentials that are used within an enterprise environment.
    discovery = "Discovery"  #: Discovery consists of techniques that allow the adversary to gain knowledge about the system and internal network.
    lateral_movement = "LateralMovement"  #: Lateral movement consists of techniques that enable an adversary to access and control remote systems on a network and could, but does not necessarily, include execution of tools on remote systems.
    execution = "Execution"  #: The execution tactic represents techniques that result in execution of adversary-controlled code on a local or remote system.
    collection = "Collection"  #: Collection consists of techniques used to identify and gather information, such as sensitive files, from a target network prior to exfiltration.
    exfiltration = "Exfiltration"  #: Exfiltration refers to techniques and attributes that result or aid in the adversary removing files and information from a target network.
    command_and_control = "CommandAndControl"  #: The command and control tactic represents how adversaries communicate with systems under their control within a target network.
    impact = "Impact"  #: Impact events primarily try to directly reduce the availability or integrity of a system, service, or network; including manipulation of data to impact a business or operational process.
    probing = "Probing"  #: Probing could be either an attempt to access a certain resource regardless of a malicious intent, or a failed attempt to gain access to a target system to gather information prior to exploitation.
    exploitation = "Exploitation"  #: Exploitation is the stage where an attacker manages to get a foothold on the attacked resource. This stage is relevant for compute hosts and resources such as user accounts, certificates etc.


class AlertStatus(str, Enum):

    active = "Active"  #: An alert which doesn't specify a value is assigned the status 'Active'
    resolved = "Resolved"  #: Alert closed after handling
    dismissed = "Dismissed"  #: Alert dismissed as false positive


class Protocol(str, Enum):

    tcp = "TCP"
    udp = "UDP"
    all = "*"


class Status(str, Enum):

    revoked = "Revoked"
    initiated = "Initiated"


class StatusReason(str, Enum):

    expired = "Expired"
    user_requested = "UserRequested"
    newer_request_initiated = "NewerRequestInitiated"


class SecurityFamily(str, Enum):

    waf = "Waf"
    ngfw = "Ngfw"
    saas_waf = "SaasWaf"
    va = "Va"


class AadConnectivityState(str, Enum):

    discovered = "Discovered"
    not_licensed = "NotLicensed"
    connected = "Connected"


class ExternalSecuritySolutionKind(str, Enum):

    cef = "CEF"
    ata = "ATA"
    aad = "AAD"


class ControlType(str, Enum):

    built_in = "BuiltIn"  #: Azure Security Center managed assessments
    custom = "Custom"  #: Non Azure Security Center managed assessments


class ProvisioningState(str, Enum):

    succeeded = "Succeeded"
    failed = "Failed"
    updating = "Updating"


class HybridComputeProvisioningState(str, Enum):

    valid = "Valid"  #: Valid service principal details.
    invalid = "Invalid"  #: Invalid service principal details.
    expired = "Expired"  #: the service principal details are expired


class AuthenticationProvisioningState(str, Enum):

    valid = "Valid"  #: Valid connector
    invalid = "Invalid"  #: Invalid connector
    expired = "Expired"  #: the connection has expired
    incorrect_policy = "IncorrectPolicy"  #: Incorrect policy of the connector


class PermissionProperty(str, Enum):

    awsaws_security_hub_read_only_access = "AWS::AWSSecurityHubReadOnlyAccess"  #: This permission provides read only access to AWS Security Hub resources.
    aws_security_audit = "AWS::SecurityAudit"  #: This permission grants access to read security configuration metadata.
    aws_amazon_ssm_automation_role = "AWS::AmazonSSMAutomationRole"  #: The permission provides for EC2 Automation service to execute activities defined within Automation documents.
    gcp_security_center_admin_viewer = "GCP::Security Center Admin Viewer"  #: This permission provides read only access to GCP Security Command Center.


class ScanTriggerType(str, Enum):

    on_demand = "OnDemand"  #: OnDemand
    recurring = "Recurring"  #: Recurring


class ScanState(str, Enum):

    failed = "Failed"  #: Failed
    failed_to_run = "FailedToRun"  #: FailedToRun
    in_progress = "InProgress"  #: InProgress
    passed = "Passed"  #: Passed


class RuleStatus(str, Enum):

    non_finding = "NonFinding"  #: NonFinding
    finding = "Finding"  #: Finding
    internal_error = "InternalError"  #: InternalError


class RuleSeverity(str, Enum):

    high = "High"  #: High
    medium = "Medium"  #: Medium
    low = "Low"  #: Low
    informational = "Informational"  #: Informational
    obsolete = "Obsolete"  #: Obsolete


class RuleType(str, Enum):

    binary = "Binary"  #: Binary
    baseline_expected = "BaselineExpected"  #: BaselineExpected
    positive_list = "PositiveList"  #: PositiveList
    negative_list = "NegativeList"  #: NegativeList


class VersionKind(str, Enum):

    latest = "Latest"
    previous = "Previous"
    preview = "Preview"


class MacSignificance(str, Enum):

    primary = "Primary"
    secondary = "Secondary"


class RelationToIpStatus(str, Enum):

    guess = "Guess"
    certain = "Certain"


class ManagementState(str, Enum):

    managed = "Managed"
    unmanaged = "Unmanaged"


class AuthorizationState(str, Enum):

    authorized = "Authorized"
    unauthorized = "Unauthorized"


class DeviceCriticality(str, Enum):

    important = "Important"
    standard = "Standard"


class PurdueLevel(str, Enum):

    process_control = "ProcessControl"
    supervisory = "Supervisory"
    enterprise = "Enterprise"


class ProgrammingState(str, Enum):

    programming_device = "ProgrammingDevice"
    not_programming_device = "NotProgrammingDevice"


class ScanningFunctionality(str, Enum):

    scanner_device = "ScannerDevice"
    not_scanner_device = "NotScannerDevice"


class DeviceStatus(str, Enum):

    active = "Active"
    removed = "Removed"


class ExpandEnum(str, Enum):

    links = "links"  #: All links associated with an assessment
    metadata = "metadata"  #: Assessment metadata


class ConnectionType(str, Enum):

    internal = "Internal"
    external = "External"


class ExpandControlsEnum(str, Enum):

    definition = "definition"  #: Add definition object for each control
