from __future__ import absolute_import
import colander
import deform


@colander.deferred
def deferred_csrf_default(node, kw):
    request = kw.get('request')
    csrf_token = request.session.get_csrf_token()
    return csrf_token


@colander.deferred
def deferred_csrf_validator(node, kw):
    def validate_csrf(node, value):
        request = kw.get('request')
        csrf_token = request.session.get_csrf_token()
        if value != csrf_token:
            raise ValueError('Bad CSRF token')
    return validate_csrf


class CSRFSchema(colander.MappingSchema):
    csrf_token = colander.SchemaNode(
        colander.String(),
        default=deferred_csrf_default,
        validator=deferred_csrf_validator,
        widget=deform.widget.HiddenWidget(),
    )
