# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import managed_secrets_pb2 as managed__secrets__pb2


class ManagedSecretsStub(object):
    """ManagedSecret is a private vertical for creating, reading, updating,
    deleting, listing and rotating the managed secrets in the secrets engines as
    an authenticated user.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.List = channel.unary_unary(
                '/v1.ManagedSecrets/List',
                request_serializer=managed__secrets__pb2.ManagedSecretListRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretListResponse.FromString,
                )
        self.ListByActor = channel.unary_unary(
                '/v1.ManagedSecrets/ListByActor',
                request_serializer=managed__secrets__pb2.ManagedSecretListRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretListResponse.FromString,
                )
        self.Create = channel.unary_unary(
                '/v1.ManagedSecrets/Create',
                request_serializer=managed__secrets__pb2.ManagedSecretCreateRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretCreateResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.ManagedSecrets/Update',
                request_serializer=managed__secrets__pb2.ManagedSecretUpdateRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretUpdateResponse.FromString,
                )
        self.Rotate = channel.unary_unary(
                '/v1.ManagedSecrets/Rotate',
                request_serializer=managed__secrets__pb2.ManagedSecretRotateRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretRotateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.ManagedSecrets/Delete',
                request_serializer=managed__secrets__pb2.ManagedSecretDeleteRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretDeleteResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.ManagedSecrets/Get',
                request_serializer=managed__secrets__pb2.ManagedSecretGetRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretGetResponse.FromString,
                )
        self.Retrieve = channel.unary_unary(
                '/v1.ManagedSecrets/Retrieve',
                request_serializer=managed__secrets__pb2.ManagedSecretRetrieveRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretRetrieveResponse.FromString,
                )
        self.Validate = channel.unary_unary(
                '/v1.ManagedSecrets/Validate',
                request_serializer=managed__secrets__pb2.ManagedSecretValidateRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretValidateResponse.FromString,
                )
        self.Logs = channel.unary_unary(
                '/v1.ManagedSecrets/Logs',
                request_serializer=managed__secrets__pb2.ManagedSecretLogsRequest.SerializeToString,
                response_deserializer=managed__secrets__pb2.ManagedSecretLogsResponse.FromString,
                )


class ManagedSecretsServicer(object):
    """ManagedSecret is a private vertical for creating, reading, updating,
    deleting, listing and rotating the managed secrets in the secrets engines as
    an authenticated user.
    """

    def List(self, request, context):
        """List returns Managed Secrets from a Secret Engine.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListByActor(self, request, context):
        """List returns Managed Secrets for an Actor from a Secret Engine.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Create(self, request, context):
        """Create creates a Managed Secret
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update updates a Managed Secret
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Rotate(self, request, context):
        """Rotate forces rotation of Managed Secret
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete deletes a Managed Secret
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get gets details of a Managed Secret without sensitive data
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Retrieve(self, request, context):
        """Retrieve returns Managed Secret with sensitive data
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Validate(self, request, context):
        """Validate returns the result of testing the stored credential against the
        secret engine.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Logs(self, request, context):
        """Logs returns the audit records for the managed secret. This may be replaced
        in the future.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ManagedSecretsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=managed__secrets__pb2.ManagedSecretListRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretListResponse.SerializeToString,
            ),
            'ListByActor': grpc.unary_unary_rpc_method_handler(
                    servicer.ListByActor,
                    request_deserializer=managed__secrets__pb2.ManagedSecretListRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretListResponse.SerializeToString,
            ),
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=managed__secrets__pb2.ManagedSecretCreateRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretCreateResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=managed__secrets__pb2.ManagedSecretUpdateRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretUpdateResponse.SerializeToString,
            ),
            'Rotate': grpc.unary_unary_rpc_method_handler(
                    servicer.Rotate,
                    request_deserializer=managed__secrets__pb2.ManagedSecretRotateRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretRotateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=managed__secrets__pb2.ManagedSecretDeleteRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretDeleteResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=managed__secrets__pb2.ManagedSecretGetRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretGetResponse.SerializeToString,
            ),
            'Retrieve': grpc.unary_unary_rpc_method_handler(
                    servicer.Retrieve,
                    request_deserializer=managed__secrets__pb2.ManagedSecretRetrieveRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretRetrieveResponse.SerializeToString,
            ),
            'Validate': grpc.unary_unary_rpc_method_handler(
                    servicer.Validate,
                    request_deserializer=managed__secrets__pb2.ManagedSecretValidateRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretValidateResponse.SerializeToString,
            ),
            'Logs': grpc.unary_unary_rpc_method_handler(
                    servicer.Logs,
                    request_deserializer=managed__secrets__pb2.ManagedSecretLogsRequest.FromString,
                    response_serializer=managed__secrets__pb2.ManagedSecretLogsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.ManagedSecrets', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ManagedSecrets(object):
    """ManagedSecret is a private vertical for creating, reading, updating,
    deleting, listing and rotating the managed secrets in the secrets engines as
    an authenticated user.
    """

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/List',
            managed__secrets__pb2.ManagedSecretListRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListByActor(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/ListByActor',
            managed__secrets__pb2.ManagedSecretListRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Create',
            managed__secrets__pb2.ManagedSecretCreateRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Update',
            managed__secrets__pb2.ManagedSecretUpdateRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Rotate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Rotate',
            managed__secrets__pb2.ManagedSecretRotateRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretRotateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Delete',
            managed__secrets__pb2.ManagedSecretDeleteRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Get',
            managed__secrets__pb2.ManagedSecretGetRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Retrieve(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Retrieve',
            managed__secrets__pb2.ManagedSecretRetrieveRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretRetrieveResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Validate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Validate',
            managed__secrets__pb2.ManagedSecretValidateRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretValidateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Logs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ManagedSecrets/Logs',
            managed__secrets__pb2.ManagedSecretLogsRequest.SerializeToString,
            managed__secrets__pb2.ManagedSecretLogsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
