#!/usr/bin/env python
"""
Copyright 2012 GroupDocs.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *
from groupdocs.FileStream import FileStream
from groupdocs.ApiClient import ApiException

class MergeApi(object):

    def __init__(self, apiClient):
        self.apiClient = apiClient
        self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def AddJobDocumentDataSource(self, userId, jobId, fileId, datasourceId, **kwargs):
        """Add job document datasource

        Args:
            userId, str: User GUID (required)
            jobId, int: Job indetifier (required)
            fileId, int: File indetifier (required)
            datasourceId, int: Datasource indetifier (required)
            
        Returns: AddDocumentDataSourceResponse
        """
        if( userId == None or jobId == None or fileId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'jobId', 'fileId', 'datasourceId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocumentDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentDataSourceResponse')
        return responseObject
        
        
    def AddJobDocumentDataSourceFields(self, userId, jobId, fileId, body, **kwargs):
        """Add job document datasource fields

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id (required)
            fileId, str: File GUID (required)
            body, List[DatasourceField]: Fields (required)
            
        Returns: AddDocumentDataSourceResponse
        """
        if( userId == None or jobId == None or fileId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'jobId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocumentDataSourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentDataSourceResponse')
        return responseObject
        
        
    def FillQuestionnaire(self, userId, collectorId, datasourceId, **kwargs):
        """Merge datasource

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Collector global unique identifier to fill (required)
            datasourceId, str: Datasource identifier (required)
            targetType, str: Filled document type (optional)
            emailResults, str: Email results (optional)
            callbackUrl, str: Callback url (optional)
            
        Returns: MergeTemplateResponse
        """
        if( userId == None or collectorId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId', 'datasourceId', 'targetType', 'emailResults', 'callbackUrl']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method FillQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}&callback={callbackUrl}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('targetType' in params):
            queryParams['new_type'] = self.apiClient.toPathValue(params['targetType'])
        if ('emailResults' in params):
            queryParams['email_results'] = self.apiClient.toPathValue(params['emailResults'])
        if ('callbackUrl' in params):
            queryParams['callback'] = self.apiClient.toPathValue(params['callbackUrl'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def FillExecution(self, userId, executionId, datasourceId, **kwargs):
        """Scheduled questionnaire execution fullfilment job

        Args:
            userId, str: User global unique identifier (required)
            executionId, str: Execution global unique identifier to fill (required)
            datasourceId, str: Datasource identifier (required)
            targetType, str: Filled document type (optional)
            emailResults, str: Email results (optional)
            callbackUrl, str: Callback url (optional)
            
        Returns: MergeTemplateResponse
        """
        if( userId == None or executionId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'executionId', 'datasourceId', 'targetType', 'emailResults', 'callbackUrl']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method FillExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}&callback={callbackUrl}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('targetType' in params):
            queryParams['new_type'] = self.apiClient.toPathValue(params['targetType'])
        if ('emailResults' in params):
            queryParams['email_results'] = self.apiClient.toPathValue(params['emailResults'])
        if ('callbackUrl' in params):
            queryParams['callback'] = self.apiClient.toPathValue(params['callbackUrl'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def MergeDatasource(self, userId, fileId, datasourceId, **kwargs):
        """Merge datasource

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            datasourceId, str: Datasource id (required)
            targetType, str: Target type (optional)
            emailResults, str: Email results (optional)
            
        Returns: MergeTemplateResponse
        """
        if( userId == None or fileId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'datasourceId', 'targetType', 'emailResults']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MergeDatasource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('targetType' in params):
            queryParams['new_type'] = self.apiClient.toPathValue(params['targetType'])
        if ('emailResults' in params):
            queryParams['email_results'] = self.apiClient.toPathValue(params['emailResults'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def MergeDatasourceFields(self, userId, fileId, body, **kwargs):
        """Merge datasource fields

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            targetType, str: Target type (optional)
            emailResults, str: Email results (optional)
            assemblyName, str: Assembly name (optional)
            body, List[DatasourceField]: Fields (required)
            
        Returns: MergeTemplateResponse
        """
        if( userId == None or fileId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'targetType', 'emailResults', 'assemblyName', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MergeDatasourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/datasources?new_type={targetType}&email_results={emailResults}&assembly_name={assemblyName}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('targetType' in params):
            queryParams['new_type'] = self.apiClient.toPathValue(params['targetType'])
        if ('emailResults' in params):
            queryParams['email_results'] = self.apiClient.toPathValue(params['emailResults'])
        if ('assemblyName' in params):
            queryParams['assembly_name'] = self.apiClient.toPathValue(params['assemblyName'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def GetQuestionnaire(self, userId, questionnaireId, **kwargs):
        """Get questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: GetQuestionnaireResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireResponse')
        return responseObject
        
        
    def GetQuestionnaireByCollector(self, userId, collectorId, **kwargs):
        """Get questionnaire by collector guid

        Args:
            userId, str: User GUID (required)
            collectorId, str: Collector GUID (required)
            
        Returns: GetQuestionnaireResponse
        """
        if( userId == None or collectorId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireByCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collector/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireResponse')
        return responseObject
        
        
    def GetQuestionnaires(self, userId, **kwargs):
        """Get questionnaires

        Args:
            userId, str: User GUID (required)
            status, str: Questionnaire status to filter by (optional)
            pageNumber, int: Page number to return questionnaires on (optional)
            pageSize, int: Number of questionnaires to return (optional)
            orderBy, str: Order by column (optional)
            isAscending, bool: Order by ascending or descending (optional)
            
        Returns: GetQuestionnairesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'status', 'pageNumber', 'pageSize', 'orderBy', 'isAscending']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaires" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires?status={status}&page_number={pageNumber}&page_size={pageSize}&orderBy={orderBy}&isAscending={isAscending}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('status' in params):
            queryParams['status'] = self.apiClient.toPathValue(params['status'])
        if ('pageNumber' in params):
            queryParams['page_number'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageSize' in params):
            queryParams['page_size'] = self.apiClient.toPathValue(params['pageSize'])
        if ('orderBy' in params):
            queryParams['orderBy'] = self.apiClient.toPathValue(params['orderBy'])
        if ('isAscending' in params):
            queryParams['isAscending'] = self.apiClient.toPathValue(params['isAscending'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnairesResponse')
        return responseObject
        
        
    def GetQuestionnairesByName(self, userId, **kwargs):
        """Get questionnaires

        Args:
            userId, str: User GUID (required)
            name, str: Questionnaire name (optional)
            status, str: Questionnaire status to filter by (optional)
            pageNumber, int: Page number to return questionnaires on (optional)
            pageSize, int: Number of questionnaires to return (optional)
            orderBy, str: Order by column (optional)
            isAscending, bool: Order by ascending or descending (optional)
            
        Returns: GetQuestionnairesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'name', 'status', 'pageNumber', 'pageSize', 'orderBy', 'isAscending']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnairesByName" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/filter?name={name}&status={status}&page_number={pageNumber}&page_size={pageSize}&orderBy={orderBy}&isAscending={isAscending}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('status' in params):
            queryParams['status'] = self.apiClient.toPathValue(params['status'])
        if ('pageNumber' in params):
            queryParams['page_number'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageSize' in params):
            queryParams['page_size'] = self.apiClient.toPathValue(params['pageSize'])
        if ('orderBy' in params):
            queryParams['orderBy'] = self.apiClient.toPathValue(params['orderBy'])
        if ('isAscending' in params):
            queryParams['isAscending'] = self.apiClient.toPathValue(params['isAscending'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnairesResponse')
        return responseObject
        
        
    def CreateQuestionnaire(self, userId, body, **kwargs):
        """Create questionnaire

        Args:
            userId, str: User GUID (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: CreateQuestionnaireResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreateQuestionnaireResponse')
        return responseObject
        
        
    def UpdateQuestionnaire(self, userId, questionnaireId, body, **kwargs):
        """Update questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: UpdateQuestionnaireResponse
        """
        if( userId == None or questionnaireId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireResponse')
        return responseObject
        
        
    def DeleteQuestionnaire(self, userId, questionnaireId, **kwargs):
        """Delete questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: DeleteQuestionnaireResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireResponse')
        return responseObject
        
        
    def DeleteQuestionnairesList(self, userId, **kwargs):
        """Delete list of questionnaires by GUIDs

        Args:
            userId, str: User GUID (required)
            body, List[str]: List of GUID (optional)
            
        Returns: DeleteQuestionnaireListResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnairesList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/list'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireListResponse')
        return responseObject
        
        
    def GetDocumentQuestionnaires(self, userId, fileId, **kwargs):
        """Get document questionnaires

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentQuestionnairesResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentQuestionnaires" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentQuestionnairesResponse')
        return responseObject
        
        
    def CreateDocumentQuestionnaire(self, userId, fileId, body, **kwargs):
        """Create document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: AddDocumentQuestionnaireResponse
        """
        if( userId == None or fileId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentQuestionnaireResponse')
        return responseObject
        
        
    def AddDocumentQuestionnaire(self, userId, fileId, questionnaireId, **kwargs):
        """Add document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: AddDocumentQuestionnaireResponse
        """
        if( userId == None or fileId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentQuestionnaireResponse')
        return responseObject
        
        
    def DeleteDocumentQuestionnaire(self, userId, fileId, questionnaireId, **kwargs):
        """Delete document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: DeleteDocumentQuestionnaireResponse
        """
        if( userId == None or fileId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteDocumentQuestionnaireResponse')
        return responseObject
        
        
    def AddDataSource(self, userId, body, **kwargs):
        """Add datasource

        Args:
            userId, str: User GUID (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def UpdateDataSource(self, userId, datasourceId, body, **kwargs):
        """Update datasource

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """
        if( userId == None or datasourceId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'datasourceId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def UpdateDataSourceFields(self, userId, datasourceId, body, **kwargs):
        """Update datasource fields

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """
        if( userId == None or datasourceId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'datasourceId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateDataSourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}/fields'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def DeleteDataSource(self, userId, datasourceId, **kwargs):
        """Delete datasource fields

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            
        Returns: DeleteDatasourceResponse
        """
        if( userId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'datasourceId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteDatasourceResponse')
        return responseObject
        
        
    def DeleteDataSourceList(self, userId, **kwargs):
        """Delete list of datasource fields

        Args:
            userId, str: User GUID (required)
            body, List[str]: List of Id (optional)
            
        Returns: DeleteDatasourceListResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteDataSourceList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/list'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteDatasourceListResponse')
        return responseObject
        
        
    def GetDataSource(self, userId, datasourceId, **kwargs):
        """Get datasource

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            fields, str: Fields (optional)
            
        Returns: GetDatasourceResponse
        """
        if( userId == None or datasourceId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'datasourceId', 'fields']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}?field={fields}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('fields' in params):
            queryParams['field'] = self.apiClient.toPathValue(params['fields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDatasourceResponse')
        return responseObject
        
        
    def GetQuestionnaireDataSources(self, userId, questionnaireId, **kwargs):
        """Get questionnaire datasources

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: QuestionnaireId id (required)
            includeFields, bool: Include fields (optional)
            
        Returns: GetDatasourcesResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'includeFields']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireDataSources" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/datasources?include_fields={includeFields}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('includeFields' in params):
            queryParams['include_fields'] = self.apiClient.toPathValue(params['includeFields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDatasourcesResponse')
        return responseObject
        
        
    def AddQuestionnaireExecution(self, userId, collectorId, body, **kwargs):
        """Add questionnaire execution

        Args:
            userId, str: User GUID (required)
            collectorId, str: Questionnaire collector id (required)
            body, QuestionnaireExecutionInfo: Execution (required)
            
        Returns: AddQuestionnaireExecutionResponse
        """
        if( userId == None or collectorId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}/executions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddQuestionnaireExecutionResponse')
        return responseObject
        
        
    def GetQuestionnaireCollectorExecutions(self, userId, collectorId, **kwargs):
        """Get questionnaire collector executions

        Args:
            userId, str: User GUID (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            
        Returns: GetQuestionnaireExecutionsResponse
        """
        if( userId == None or collectorId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireCollectorExecutions" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}/executions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireExecutionsResponse')
        return responseObject
        
        
    def GetQuestionnaireExecutions(self, userId, questionnaireId, **kwargs):
        """Get questionnaire executions

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire global unique identifier (required)
            
        Returns: GetQuestionnaireExecutionsResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireExecutions" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/executions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireExecutionsResponse')
        return responseObject
        
        
    def GetQuestionnaireExecution(self, userId, executionId, **kwargs):
        """Get questionnaire execution

        Args:
            userId, str: User GUID (required)
            executionId, str: Questionnaire execution global unique identifier (required)
            
        Returns: GetQuestionnaireExecutionResponse
        """
        if( userId == None or executionId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'executionId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireExecutionResponse')
        return responseObject
        
        
    def DeleteQuestionnaireExecution(self, userId, executionId, **kwargs):
        """Removes questionnaire execution

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            
        Returns: DeleteQuestionnaireExecutionResponse
        """
        if( userId == None or executionId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'executionId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireExecutionResponse')
        return responseObject
        
        
    def DeleteQuestionnaireExecutionList(self, userId, **kwargs):
        """Removes questionnaire execution

        Args:
            userId, str: User GUID (required)
            body, List[str]: List of GUID (optional)
            
        Returns: DeleteQuestionnaireExecutionListResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireExecutionList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/list'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireExecutionListResponse')
        return responseObject
        
        
    def UpdateQuestionnaireExecution(self, userId, executionId, body, **kwargs):
        """Update questionnaire execution

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            body, QuestionnaireExecutionInfo: Execution (required)
            
        Returns: UpdateQuestionnaireExecutionResponse
        """
        if( userId == None or executionId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'executionId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireExecutionResponse')
        return responseObject
        
        
    def UpdateQuestionnaireExecutionStatus(self, userId, executionId, body, **kwargs):
        """Update questionnaire execution status

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            body, str: Status (required)
            
        Returns: UpdateQuestionnaireExecutionResponse
        """
        if( userId == None or executionId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'executionId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireExecutionStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}/status'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireExecutionResponse')
        return responseObject
        
        
    def GetQuestionnaireCollectors(self, userId, questionnaireId, orderBy, isAsc, **kwargs):
        """Get questionnaire collectors

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire identifier (required)
            orderBy, str: Order by column (required)
            isAsc, bool: Order by ascending or descending (required)
            
        Returns: GetQuestionnaireCollectorsResponse
        """
        if( userId == None or questionnaireId == None or orderBy == None or isAsc == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'orderBy', 'isAsc']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireCollectors" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/collectors?orderBy={orderBy}&isAsc={isAsc}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('orderBy' in params):
            queryParams['orderBy'] = self.apiClient.toPathValue(params['orderBy'])
        if ('isAsc' in params):
            queryParams['isAsc'] = self.apiClient.toPathValue(params['isAsc'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireCollectorsResponse')
        return responseObject
        
        
    def GetQuestionnaireCollector(self, userId, collectorId, **kwargs):
        """Returns questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            
        Returns: GetQuestionnaireCollectorResponse
        """
        if( userId == None or collectorId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireCollectorResponse')
        return responseObject
        
        
    def AddQuestionnaireCollector(self, userId, questionnaireId, body, **kwargs):
        """Add questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire identifier (required)
            body, QuestionnaireCollectorInfo: Questionnaire collector to be added (required)
            
        Returns: AddQuestionnaireCollectorResponse
        """
        if( userId == None or questionnaireId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/collectors'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddQuestionnaireCollectorResponse')
        return responseObject
        
        
    def UpdateQuestionnaireCollector(self, userId, collectorId, body, **kwargs):
        """Update questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            body, QuestionnaireCollectorInfo: Questionnaire collector data (required)
            
        Returns: UpdateQuestionnaireCollectorResponse
        """
        if( userId == None or collectorId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireCollectorResponse')
        return responseObject
        
        
    def DeleteQuestionnaireCollector(self, userId, collectorId, **kwargs):
        """Removes questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            
        Returns: DeleteQuestionnaireCollectorResponse
        """
        if( userId == None or collectorId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireCollectorResponse')
        return responseObject
        
        
    def DeleteQuestionnaireCollectorList(self, userId, **kwargs):
        """Removes questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            body, List[str]: Collector's GUID list (optional)
            
        Returns: DeleteQuestionnaireCollectorListResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireCollectorList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/list'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireCollectorListResponse')
        return responseObject
        
        
    def GetTemplates(self, userId, **kwargs):
        """Get template documents information

        Args:
            userId, str: User global unique identifier (required)
            
        Returns: GetTemplatesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetTemplates" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/templates'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetTemplatesResponse')
        return responseObject
        
        
    def GetQuestionnaireFields(self, userId, questionnaireId, **kwargs):
        """Get questionnaire fields

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire global unique identifier (required)
            includeGeometry, bool: A flag indicating whether fields coordinates and size should be included into the response. (optional)
            
        Returns: TemplateFieldsResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'includeGeometry']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/fields?include_geometry={includeGeometry}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('includeGeometry' in params):
            queryParams['include_geometry'] = self.apiClient.toPathValue(params['includeGeometry'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TemplateFieldsResponse')
        return responseObject
        
        
    def GetQuestionnaireMetadata(self, userId, questionnaireId, **kwargs):
        """Get questionnaire metadata

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire global unique identifier (required)
            
        Returns: GetQuestionnaireMetadataResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireMetadata" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/metadata'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireMetadataResponse')
        return responseObject
        
        
    def UpdateQuestionnaireMetadata(self, userId, questionnaireId, body, **kwargs):
        """Update questionnaire metadata

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire global unique identifier (required)
            body, QuestionnaireMetadata: Questionnaire metadata to update (required)
            
        Returns: UpdateQuestionnaireResponse
        """
        if( userId == None or questionnaireId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireMetadata" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/metadata'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireResponse')
        return responseObject
        
        
    def CopyFileToTemplates(self, userId, path, **kwargs):
        """Copy file to template

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            mode, str: Mode (optional)
            Groupdocs_Move, str: File ID (move) (optional)
            Groupdocs_Copy, str: File ID (copy) (optional)
            
        Returns: GetTemplatesResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'mode', 'Groupdocs_Move', 'Groupdocs_Copy']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CopyFileToTemplates" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{*path}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('mode' in params):
            queryParams['mode'] = self.apiClient.toPathValue(params['mode'])
        if ('Groupdocs_Move' in params):
            headerParams['Groupdocs-Move'] = params['Groupdocs_Move']
        if ('Groupdocs_Copy' in params):
            headerParams['Groupdocs-Copy'] = params['Groupdocs_Copy']
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetTemplatesResponse')
        return responseObject
        
        
    def GetDocumentByQuestionnaire(self, userId, questionnaireId, **kwargs):
        """Get associated document by questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire GUID (required)
            
        Returns: GetQuestionnaireDocumentResponse
        """
        if( userId == None or questionnaireId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentByQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/document'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireDocumentResponse')
        return responseObject
        
        
    


