/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultSocket;

public class DefaultFuture
implements Future {
    private final DefaultSocket socket;
    private CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private long time = -1L;
    private TimeUnit tu;
    private TimeoutException te = null;
    private IOException ioException;

    public DefaultFuture(DefaultSocket socket) {
        this.socket = socket;
    }

    public long time() {
        return this.time;
    }

    public TimeUnit timeUnit() {
        return this.tu;
    }

    public DefaultFuture timeoutException(TimeoutException te) {
        this.te = te;
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public void done() {
        this.done.set(true);
        this.latch.countDown();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future finishOrThrowException() throws IOException {
        this.done();
        try {
            if (this.ioException != null) {
                throw this.ioException;
            }
        }
        finally {
            this.ioException = null;
        }
        return this;
    }

    @Override
    public Future ioException(IOException t) {
        this.ioException = t;
        this.done();
        return this;
    }

    protected void reset() {
        this.done.set(false);
        this.latch = new CountDownLatch(1);
    }

    @Override
    public Socket get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.time = timeout;
        this.tu = unit;
        try {
            if (!this.latch.await(timeout, unit) || this.te != null) {
                throw this.te == null ? new TimeoutException() : this.te;
            }
        }
        finally {
            this.te = null;
        }
        return this.socket;
    }

    protected Socket socket() {
        return this.socket;
    }

    @Override
    public Future fire(Object data) throws IOException {
        this.reset();
        this.socket.internalSocket().write(this.socket.request(), data);
        return this;
    }
}

