#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" common icons """

# pytkapp: common icons
#
# Copyright (c) 2013 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys
if    sys.hexversion >= 0x03000000:
    from tkinter import Tk, PhotoImage
else:
    from Tkinter import Tk, PhotoImage
from pytkapp.tkw.tkw_tooltippedbtn import ToolTippedBtn    

gv_child_header_icon='''\
R0lGODlhEAAQAPczAJGX/3H/eZAAh3H/rpxx/2OQAJH/mP///3F6///r0f/70QCQdJHB/0wAcExw
AP/5sfD/0QB0kPDR/wBNsACOsABbz3BoAFHd/3Gv/1Gd/9H2///R69Hl/9H/9hF5/zGK/3Hk/5Hq
/3AAabHS/7Hw/1AASwBwWjdQAABQQP+/sQA+kLBjAHA/APDhAM92AJCGAFAtAM/DAP+mMQAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABL07AAAAMgAAHyRBRXLGPW4
AFEAEnyRBRUTeAVtAAB8kQAAAJEEPQAAfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIoAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAS9gC/v/MIAAAAEgAVABL2rO4YAMB8kHyRQP///0C7/458
kQAB1gAARfT8AIAAEsAQABL2rO4YAHB8kHyRBf///wAA/z0AAHyRBBL2MAlfAAB8gQAAANubxP//
AMQAzwDbmwAAGAAAABgAAAAS9gAAQAAAAPwAAAAS9QAAAAAAAAAAAAAAAAAADAACAAEAAHyQAf38
AOXlfzB8kHyBDAAC9PZMAFQAEgAS9gAACAAOAIgAAADboAAAAAL0AE8AAHyAGgAC9AAAAADAAAAA
AAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAJDl5SDAfPR8gwAAAoD2EiH5BAkAAP8ALAAAAAAQABAA
AAikAAEEEDCAQAEABv4pXKgQwYEEBx4CUACA4cIFCiJGnHggoUWHGhUwaOAAgcV/CB5A0Pgw4skI
ESWwnEChQgWGFjSuPFDhAoYMF242PKBhAweeDA508PABhNAICiAerQDiANAQThWKYMkzxIELIzqQ
EFrCxIkSKHiOSAGChIaxJxeqCKFBQ4gJFlbEVaiirwoWLVy82MsQRgwZegkvhMFisGKLAQEAOw==
'''

gv_subchild_header_icon='''\
R0lGODlhEAAQAPcAAAAAAG5wbYGDgHN0cK66yKK61Ke5zG1va6e3yIqs0cXX6pu52ZCsy4WHg4iK
hY2PiqKuu4Soz9zm8uTs9cra7I2x2Jewy////6K40KTA3tnk8d3n8sPV6qK/34Cl0PDw749ZAqe1
woiq0LvQ6M3c7t7o86jB3JSwzsfHxu7qxs+tcZ+40ZGz1rvQ5qa+2Je109HS0O/rx9KsaqGDVYSE
gqOko7PI3X+n0Zm00ZWWk6SHV7i4t42OjLCxr+3mxc+qaaCDVu3lxMifZKCEV4mAaomLhu/v7nBb
OcKriqOFVefcyoeJhP7+/UxCJmtXNszBr+/v74KEf/r6+e7u7bOplsLCwsvLyuLi4n1/e/7+/vf3
9+np6eXl5erq6oyOiYaIg4WHgouNiAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABL03AAAAMgAAHyRBRavePWo
AFEAEnyRBRYTeAVtAAB8kQAAAJEEPQAAfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIoAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAANgAAABX3gBQ/vL4AAAAEgAWABL2nO4YAMB8kHyRQP///0C7/458
kQAB1gAARfTsAIAAEsAQABL2nO4YAHB8kHyRBf///wAA/z0AAHyRBBL2IAlfAAB8gQAAAOPciP//
AIgA2QDj3AAAGAAAAAgAAAAS9gAAQAAAAOwAAAAS9QAAAAAAAAAAAAAAAAAADAACAAEAAHyQAf3s
AOXlfzB8kHyBDAABsPY8AEQAEgAS9gAACAAOANQAAADj7wAAAAGwAE8AAHyAGgABsAAAAADAAAAA
AAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAJDl5SDAfLB8gwAAAXD2EiH5BAkAAP8ALAAAAAAQABAA
AAjDAP8J/Ceg4MCDCAX8K0AQYUIECRQsYCCggYOLBwVAiCBhAoUKFgRcGOlgoAAMGTRs4NDBg4AP
Hy6AACFQQAgRI0iUMHFCAIoPIFKooElwBYsWLl4IgAE0hox/NGnUEGDjBg4BOVCAcKojao0dPAoK
6AHUxw8gRGmAvfABhVsQQYQMAUFkII9/bGEaOYIkCQglSxAy0QuiiRMQT6BEQSgF5hQAIKhUsXIF
C8KRF7Jo2XKFSxfFCItcdLDkC5gvqB2qdhgQADs=
'''

gv_child_header_close='''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgoAP8JHEiwoMGCAAAQTIhQ4T+GBhNCPDgxokSKDis+dChQ48GPIEEGBAA7
'''

gv_child_header_maximize='''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgsAP8JHEhwIICDCBEaTJjQYEGBABw+jAjx4T+KFy1ixEhwo8aFDA9aHElSYEAAOw==
'''

gv_child_header_restore='''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgsAP8JHEiwIICDCAv+Q5jQIEEADxlChDhQ4sSHESkK1LhQIUeOGyUqHEmSZEAAOw==
'''

gv_child_header_help='''\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'''

gv_app_toolbar_toogle_logpane='''\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'''

gv_app_toolbar_cascade='''\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'''

gv_app_toolbar_tile='''\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'''

gv_app_toolbar_closeall='''\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'''

gv_app_toolbar_add='''\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'''

gv_app_toolbar_close='''\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'''

gv_app_toolbar_restore_child='''\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'''

gv_app_toolbar_maximize_child='''\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=
'''

gv_app_options='''\
R0lGODlhEAAQANUAAP///yg0P9HZ4VNeae7x9oOQnKSor1NgaUxWYXeDkN7f3/T3+N3l7bS+yNfg
6HR+ieLn66mwtquxt3N9h3iDjtHZ4+Dn7ZujrKissL7FzNLb5XB7h5Ccqf39/KCnri45RLrE0e/v
7ri8v9PY37/GzS87Rp2su3eDjmx5hEJNV2Ztd+Pn64iVoba8wd3j6MXN1oCNmdzh5GNsdigzPnJ9
idPV2LnCydrd4lBdZ0VPWZagqYOPmU1WYP///wAAAAAAACH5BAEAAAAALAAAAAAQABAAhf///yg0
P9HZ4VNeae7x9oOQnKSor1NgaUxWYXeDkN7f3/T3+N3l7bS+yNfg6HR+ieLn66mwtquxt3N9h3iD
jtHZ4+Dn7ZujrKissL7FzNLb5XB7h5Ccqf39/KCnri45RLrE0e/v7ri8v9PY37/GzS87Rp2su3eD
jmx5hEJNV2Ztd+Pn64iVoba8wd3j6MXN1oCNmdzh5GNsdigzPnJ9idPV2LnCydrd4lBdZ0VPWZag
qYOPmU1WYP///wAAAAAAAAavQIBwyCoUWMOk0AiACZ3M5C5DSCQsFishoxviSITFAtDpAMQE0kF4
IJhGIUilAgmNTIQ1W6EAnT4fJyB8ehQ0KDU2HDlCPBw2NSg0FBtCIi8DSQMvIkIbDw4OGC6ZQwMu
GKEPJTMIBi0GpQOvBggzJUIIAhcxsbMxFwIIQwECKwIeNxISNx7GAgFCARECDdUMDNbWEdHSEwIp
MtgyKQIT3cTRKhoaKgAB6Erv8PFCQQA7
'''

gv_options_openfile='''\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'''

gv_options_openfolder='''\
R0lGODlhEAAQALMAAMqjN///ovrvgPbhRfvyafPYM/biZvz1j/jpVfjpdP///wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg8qjN///ovrvgPbhRfvyafPYM/biZvz1j/jpVfjpdP///wAA
AAAAAAAAAAAAAAAAAAQ+UMlJq7046w36VkAgdqRHAQKCCGwrAKdRzvDUiXge1CBgFMAgUGYDJAbI
JDLB6xwI0Cj00AzpcrwejfTpaiIAOw==
'''

gv_options_calendar='''\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'''

gv_app_action_back='''\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==
'''

gv_icon_computer='''\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=
'''
gv_icon_db='''\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'''

gv_icon_tux='''\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'''

gv_icon_user='''\
R0lGODlhEAAQAMQTAGShuKaigbSxp5rU73rO8XjF6nva+e3im+/t1cbDn8nGp////+/t1o2/znzi
/4y7y+3t7Yy1x/Tz4////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABMALAAAAAAQABAAAAVT4CSOZGkGKGqS6OGq6xQcSn0EsZwk0o7HAoRQKMgJBIzkMQc4OgExgKOx
qDYc0BLAwH1AHlxDdgQgmAmRM2EsAgwK8HhhwG4P7nh6FMDv5/6AKyEAOw==
'''

gv_icon_group='''\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'''

gv_icon_action_add='''\
R0lGODlhEAAQALMMAJy4ZLjyctX2p8L6e8numMj/gbLtba3pZ6PhXqjlY8X9fr32dv///wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAAAQ6kMlJq714ApApKAXXMYCiiB0wDKi1bcvytmRg33gLCLxg
GD0BbXY4zDKARIJ2ASAQTBeBEHVVR1hMBAA7
'''

gv_icon_action_check='''\
R0lGODlhEAAQALMPAJy4ZKvoZrLtbcT8fqXjYMrumMj/gc3xnLnzc9Hzob/4edX2p9n5q+D9s937
sP///yH5BAEAAA8ALAAAAAAQABAAAAQ38MlJq704awrAloBheBowDA2JAYriqFMHIggDg4LQ5csN
JoFgIOGLHQiEQ5FTKCwrso90SpVEAAA7
'''

gv_icon_action_delete='''\
R0lGODlhEAAQALMNALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAAAQ+sMlJq704XwAo34bRNUA4eoogcKpyekwgB8xbAUVe2Dfi
I7wJgEBIJIhBwOGw4CyWPMBgMJJSN6+PZsvtViIAOw==
'''

gv_icon_action_remove='''\
R0lGODlhEAAQAJEDALhkZPanp/+Bgf///yH5BAEAAAMALAAAAAAQABAAAAIbnI+py+0PIwO02gSE
3hwgEITi6H3WKaXqyrYFADs=
'''

gv_icon_search='''\
R0lGODlhEAAQAMQUAF2UuqqqqpjM85LE76HW+I+/7dz0/9ju/JTG8Kjf/OPj4/j4+Ozs7NHm+Nft
/Nrx/tHn+M/k99Pp+vn5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABQALAAAAAAQABAAAAVQICWOZFkCKGCeRmuoKwU8SZ088OkQfO/kI4BEQCxKgCJAY8BsNpCySGFK
jUBlEIQWAQEEYoCD+ABQML6rlHdhRsdEAfb5PYpP3PQAns6nhwAAOw==
'''

gv_icon_edit='''\
R0lGODlhEAAQAMQSAF2UurBUVrq6uuDg4Hm67HOv5W+n3/ZZeIy55ZvX+ZnR9o+/6nOu5NxFU5TI
8I++6X/F9H5+fv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABIALAAAAAAQABAAAAVCoCSOZGmeaBkEKRkcB9sCSdA08gk8DPPmJQDCQEQASYBFYbkAoAAOgtTh
PAkGAAVEUbUOsImu9YptSSKCtHnNbqNCADs=
'''

gv_icon_save='''\
R0lGODlhEAAQAMQZAGONqVuNr66urvj4+P39/cLCwpDJ9/Pz8/T09ICHkpzJ8ZrH8KTR963d/aHO
9Z++0Kva/abU+anX+vv7+7W6wcLf9vX19Z3L89Pt/////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABkALAAAAAAQABAAAAVvYCaOZCkCASCsrACUAfYQNEFRxBOQQQMMwEEiMQA0dqIABIBoIoYIAASZ
CUgA2GxWQg1EDOBwONJlaM+MrgNQawMc3QtgUqjXJ4BLV/ELBgEKXQsAFnZ1FgALXRUAB46PBwAV
VCgqLSuVJpqbnCQhADs=
'''

gv_icon_player_forward='''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAixAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1y5chcQ6kSJUp6
A+WFC+ehSS5vNXPNDCdvYLxu3UTIENJJqBBQQOMNRKdNm1AppJ6maopuoDlr1krMqdWsRJxeWK2Z
G0hu2rQzv5IlG5PW7DRyA8U9m0usrt25z8QN/Las76+/gPsu+zbQGzJkuxIrTnzY28BtkN1KngZ5
2yeBBjMP/BcQADs=
'''

gv_icon_player_play='''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAipAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKMthSZYyJb2B
8sLJDOfhhp+ZMuUNjNetZzcRMmL0iOUz3kB02pJqAyrjiyyl6Aaas0bVWokpoIZVtWZuILlpYJNB
wZWsLNhp5AaKe8aWmNu3bJ+JG/htmd1fePPaXfZtoDdkyHYJHiwYsLeB2xKfXTwt8bZPAg1KHvgv
IAA7
'''

gv_icon_player_rewind='''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAivAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKMtdM4NyJUp6
A+WFm3mryBBvNYfMlDcwXrduj2DIsMLoxdCf8Qai06btEY2hip5aYYpuoDlrWGEl4dIs1RIuWM0N
JDetbLJelZKdzVSW3EBxz+ISm0s37jNxA78t2/urr9+9y74N9IYM2a7DiA8X9jZwm+OykCE73vZJ
oMHLA/8FBAA7
'''

gv_icon_player_back='''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAipAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKFMm05KyHL2B
8sLJlFnnxZCZ4eQNjNetJ6oYJGRY6dkz3kB02pJu+iFDaNKk6Aaas0bVWrA6PLhUtWZuILlpYJOJ
jcUoGdhp5AaKe8aWmNu3bJ+JG/htmd1fePPaXfZtoDdkyHYJHiwYsLeB2xKfXTwt8bZPAg1KHvgv
IAA7
'''

def run_demo():
    """ some demo """
    
    def name2clipboard(wroot, pv_name=''):
        wroot.clipboard_clear()
        wroot.clipboard_append(pv_name)
    
    root = Tk()
    root.title(__file__)
    
    ll_imgs = [x for x in globals() if isinstance(x, str) and not x.startswith('__') and x not in ('PhotoImage', 'run_demo', 'Tk', 'ToolTippedBtn') and x not in sys.modules]
    ll_imgs.sort()
    lv_lenimgs = len(ll_imgs)
    
    lv_pos = 0
    lv_x = int(len(ll_imgs) ** 0.6)
    
    lv_r = 0
    while lv_pos < lv_lenimgs:       
        lv_c = 0
        for i in range(lv_x):
            if lv_pos >= lv_lenimgs:
                break
            try:
                img = PhotoImage(data=globals()[ll_imgs[lv_pos]])
                b = ToolTippedBtn(root, 
                                  tooltip=ll_imgs[lv_pos], 
                                  image=img,
                                  command=lambda ev=None, wr=root, wt=ll_imgs[lv_pos]: name2clipboard(wr, wt))
                b.grid(row=lv_r, column=lv_c)
                lv_c += 1
                lv_pos += 1
            except Exception as err:
                print(err.message)
        lv_r += 1
        
    root.resizable(width=False, height=False)
    root.mainloop()
        
if __name__ == '__main__':    
    run_demo()
