__author__ = 'meredydd'

import random, string

import anvil
from . import _server



def _gen_id():
    return ''.join(random.SystemRandom().choice(string.ascii_letters + string.digits) for _ in range(10))


# requestId->_IncomingRequest
_incoming_requests = {}


class StreamingMedia(anvil.Media):
    def __init__(self, content_type, name):
        self._content_type = content_type
        self._content = b''
        self._complete = False
        self._name = name

    def add_content(self, data, last_chunk=False):
        self._content += data
        self._complete = last_chunk

    def is_complete(self):
        return self._complete

    def get_content_type(self):
        return self._content_type

    def get_bytes(self):
        return self._content

    def get_url(self):
        raise None

    def get_name(self):
        return self._name


class IncomingReqResp:
    def __init__(self, json):
        self.media = {}

        def reconstruct_data_media(d):
            reconstructed = StreamingMedia(d['mime-type'], d.get("name", None))
            self.media[d['id']] = reconstructed
            return reconstructed

        self.json = _server._reconstruct_objects(json, reconstruct_data_media)

        _incoming_requests[self.json["id"]] = self
        self.maybe_execute()

    def add_binary_data(self, json, data):
        self.media[json['mediaId']].add_content(data, json['lastChunk'])
        if json['lastChunk']:
            self.maybe_execute()

    def is_ready(self):
        for id in self.media:
            if not self.media[id].is_complete():
                return False
        return True

    def maybe_execute(self):
        if not self.is_ready():
            return

        del _incoming_requests[self.json["id"]]

        self.execute()


def deserialise(json):
    pass


_next_hdr = None


def process_blob_header(hdr):
    global _next_hdr
    _next_hdr = hdr


def process_blob(blob):
    global _next_hdr
    _incoming_requests[_next_hdr['requestId']].add_binary_data(_next_hdr, blob)
    _next_hdr = None


def serialise(reqresp, do_send):
    media = []

    def enqueue_media(m):
        media_id = _gen_id()
        media.append((media_id, m))
        return {"id": media_id}

    reqresp = _server.fill_out_media(reqresp, enqueue_media)

    do_send(reqresp)

    for (id,m) in media:
        data = m.get_bytes()
        l = len(data)
        i = 0
        n = 0
        while i < l:
            chunk_len = min(l - i, 10000)

            do_send({'type': 'CHUNK_HEADER', 'requestId': reqresp['id'], 'mediaId': id,
                     'chunkIndex': n, 'lastChunk': (i + chunk_len == l)},
                    data[i:(i+chunk_len)])

            i += chunk_len
            n += 1
