# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Capability(Model):
    """Cosmos DB capability object.

    :param name: Name of the Cosmos DB capability. For example, "name":
     "EnableCassandra". Current values also include "EnableTable" and
     "EnableGremlin".
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Capability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class CassandraKeyspace(Resource):
    """An Azure Cosmos DB Cassandra keyspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param cassandra_keyspace_id: Required. Name of the Cosmos DB Cassandra
     keyspace
    :type cassandra_keyspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cassandra_keyspace_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'cassandra_keyspace_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CassandraKeyspace, self).__init__(**kwargs)
        self.cassandra_keyspace_id = kwargs.get('cassandra_keyspace_id', None)


class CassandraKeyspaceCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB Cassandra keyspace.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a Cassandra
     keyspace
    :type resource: ~azure.mgmt.cosmosdb.models.CassandraKeyspaceResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'CassandraKeyspaceResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(CassandraKeyspaceCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class CassandraKeyspaceResource(Model):
    """Cosmos DB Cassandra keyspace id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra keyspace
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CassandraKeyspaceResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class CassandraPartitionKey(Model):
    """Cosmos DB Cassandra table partition key.

    :param name: Name of the Cosmos DB Cassandra table partition key
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CassandraPartitionKey, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CassandraSchema(Model):
    """Cosmos DB Cassandra table schema.

    :param columns: List of Cassandra table columns.
    :type columns: list[~azure.mgmt.cosmosdb.models.Column]
    :param partition_keys: List of partition key.
    :type partition_keys:
     list[~azure.mgmt.cosmosdb.models.CassandraPartitionKey]
    :param cluster_keys: List of cluster key.
    :type cluster_keys: list[~azure.mgmt.cosmosdb.models.ClusterKey]
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[Column]'},
        'partition_keys': {'key': 'partitionKeys', 'type': '[CassandraPartitionKey]'},
        'cluster_keys': {'key': 'clusterKeys', 'type': '[ClusterKey]'},
    }

    def __init__(self, **kwargs):
        super(CassandraSchema, self).__init__(**kwargs)
        self.columns = kwargs.get('columns', None)
        self.partition_keys = kwargs.get('partition_keys', None)
        self.cluster_keys = kwargs.get('cluster_keys', None)


class CassandraTable(Resource):
    """An Azure Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param cassandra_table_id: Required. Name of the Cosmos DB Cassandra table
    :type cassandra_table_id: str
    :param default_ttl: Time to live of the Cosmos DB Cassandra table
    :type default_ttl: int
    :param schema: Schema of the Cosmos DB Cassandra table
    :type schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cassandra_table_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'cassandra_table_id': {'key': 'properties.id', 'type': 'str'},
        'default_ttl': {'key': 'properties.defaultTtl', 'type': 'int'},
        'schema': {'key': 'properties.schema', 'type': 'CassandraSchema'},
    }

    def __init__(self, **kwargs):
        super(CassandraTable, self).__init__(**kwargs)
        self.cassandra_table_id = kwargs.get('cassandra_table_id', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.schema = kwargs.get('schema', None)


class CassandraTableCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB Cassandra table.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a Cassandra table
    :type resource: ~azure.mgmt.cosmosdb.models.CassandraTableResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'CassandraTableResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(CassandraTableCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class CassandraTableResource(Model):
    """Cosmos DB Cassandra table id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Cassandra table
    :type id: str
    :param default_ttl: Time to live of the Cosmos DB Cassandra table
    :type default_ttl: int
    :param schema: Schema of the Cosmos DB Cassandra table
    :type schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'schema': {'key': 'schema', 'type': 'CassandraSchema'},
    }

    def __init__(self, **kwargs):
        super(CassandraTableResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.schema = kwargs.get('schema', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ClusterKey(Model):
    """Cosmos DB Cassandra table cluster key.

    :param name: Name of the Cosmos DB Cassandra table cluster key
    :type name: str
    :param order_by: Order of the Cosmos DB Cassandra table cluster key, only
     support "Asc" and "Desc"
    :type order_by: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterKey, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.order_by = kwargs.get('order_by', None)


class Column(Model):
    """Cosmos DB Cassandra table column.

    :param name: Name of the Cosmos DB Cassandra table column
    :type name: str
    :param type: Type of the Cosmos DB Cassandra table column
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Column, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class ConflictResolutionPolicy(Model):
    """The conflict resolution policy for the container.

    :param mode: Indicates the conflict resolution mode. Possible values
     include: 'LastWriterWins', 'Custom'. Default value: "LastWriterWins" .
    :type mode: str or ~azure.mgmt.cosmosdb.models.ConflictResolutionMode
    :param conflict_resolution_path: The conflict resolution path in the case
     of LastWriterWins mode.
    :type conflict_resolution_path: str
    :param conflict_resolution_procedure: The procedure to resolve conflicts
     in the case of custom mode.
    :type conflict_resolution_procedure: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'conflict_resolution_path': {'key': 'conflictResolutionPath', 'type': 'str'},
        'conflict_resolution_procedure': {'key': 'conflictResolutionProcedure', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConflictResolutionPolicy, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', "LastWriterWins")
        self.conflict_resolution_path = kwargs.get('conflict_resolution_path', None)
        self.conflict_resolution_procedure = kwargs.get('conflict_resolution_procedure', None)


class ConsistencyPolicy(Model):
    """The consistency policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to Azure.

    :param default_consistency_level: Required. The default consistency level
     and configuration settings of the Cosmos DB account. Possible values
     include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong',
     'ConsistentPrefix'
    :type default_consistency_level: str or
     ~azure.mgmt.cosmosdb.models.DefaultConsistencyLevel
    :param max_staleness_prefix: When used with the Bounded Staleness
     consistency level, this value represents the number of stale requests
     tolerated. Accepted range for this value is 1 – 2,147,483,647. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_staleness_prefix: long
    :param max_interval_in_seconds: When used with the Bounded Staleness
     consistency level, this value represents the time amount of staleness (in
     seconds) tolerated. Accepted range for this value is 5 - 86400. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_interval_in_seconds: int
    """

    _validation = {
        'default_consistency_level': {'required': True},
        'max_staleness_prefix': {'maximum': 2147483647, 'minimum': 1},
        'max_interval_in_seconds': {'maximum': 86400, 'minimum': 5},
    }

    _attribute_map = {
        'default_consistency_level': {'key': 'defaultConsistencyLevel', 'type': 'DefaultConsistencyLevel'},
        'max_staleness_prefix': {'key': 'maxStalenessPrefix', 'type': 'long'},
        'max_interval_in_seconds': {'key': 'maxIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConsistencyPolicy, self).__init__(**kwargs)
        self.default_consistency_level = kwargs.get('default_consistency_level', None)
        self.max_staleness_prefix = kwargs.get('max_staleness_prefix', None)
        self.max_interval_in_seconds = kwargs.get('max_interval_in_seconds', None)


class ContainerPartitionKey(Model):
    """The configuration of the partition key to be used for partitioning data
    into multiple partitions.

    :param paths: List of paths using which data within the container can be
     partitioned
    :type paths: list[str]
    :param kind: Indicates the kind of algorithm used for partitioning.
     Possible values include: 'Hash', 'Range'. Default value: "Hash" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.PartitionKind
    """

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[str]'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerPartitionKey, self).__init__(**kwargs)
        self.paths = kwargs.get('paths', None)
        self.kind = kwargs.get('kind', "Hash")


class DatabaseAccount(Resource):
    """An Azure Cosmos DB database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param kind: Indicates the type of database account. This can only be set
     at database account creation. Possible values include: 'GlobalDocumentDB',
     'MongoDB', 'Parse'. Default value: "GlobalDocumentDB" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :param provisioning_state:
    :type provisioning_state: str
    :ivar document_endpoint: The connection endpoint for the Cosmos DB
     database account.
    :vartype document_endpoint: str
    :ivar database_account_offer_type: The offer type for the Cosmos DB
     database account. Default value: Standard. Possible values include:
     'Standard'
    :vartype database_account_offer_type: str or
     ~azure.mgmt.cosmosdb.models.DatabaseAccountOfferType
    :param ip_range_filter: Cosmos DB Firewall Support: This value specifies
     the set of IP addresses or IP address ranges in CIDR form to be included
     as the allowed list of client IPs for a given database account. IP
     addresses/ranges must be comma separated and must not contain any spaces.
    :type ip_range_filter: str
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param consistency_policy: The consistency policy for the Cosmos DB
     database account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :ivar write_locations: An array that contains the write location for the
     Cosmos DB account.
    :vartype write_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar read_locations: An array that contains of the read locations enabled
     for the Cosmos DB account.
    :vartype read_locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar failover_policies: An array that contains the regions ordered by
     their failover priorities.
    :vartype failover_policies:
     list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'document_endpoint': {'readonly': True},
        'database_account_offer_type': {'readonly': True},
        'write_locations': {'readonly': True},
        'read_locations': {'readonly': True},
        'failover_policies': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'document_endpoint': {'key': 'properties.documentEndpoint', 'type': 'str'},
        'database_account_offer_type': {'key': 'properties.databaseAccountOfferType', 'type': 'DatabaseAccountOfferType'},
        'ip_range_filter': {'key': 'properties.ipRangeFilter', 'type': 'str'},
        'is_virtual_network_filter_enabled': {'key': 'properties.isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'properties.enableAutomaticFailover', 'type': 'bool'},
        'consistency_policy': {'key': 'properties.consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[Capability]'},
        'write_locations': {'key': 'properties.writeLocations', 'type': '[Location]'},
        'read_locations': {'key': 'properties.readLocations', 'type': '[Location]'},
        'failover_policies': {'key': 'properties.failoverPolicies', 'type': '[FailoverPolicy]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'properties.enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'properties.enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'properties.connectorOffer', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccount, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', "GlobalDocumentDB")
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.document_endpoint = None
        self.database_account_offer_type = None
        self.ip_range_filter = kwargs.get('ip_range_filter', None)
        self.is_virtual_network_filter_enabled = kwargs.get('is_virtual_network_filter_enabled', None)
        self.enable_automatic_failover = kwargs.get('enable_automatic_failover', None)
        self.consistency_policy = kwargs.get('consistency_policy', None)
        self.capabilities = kwargs.get('capabilities', None)
        self.write_locations = None
        self.read_locations = None
        self.failover_policies = None
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.enable_multiple_write_locations = kwargs.get('enable_multiple_write_locations', None)
        self.enable_cassandra_connector = kwargs.get('enable_cassandra_connector', None)
        self.connector_offer = kwargs.get('connector_offer', None)


class DatabaseAccountConnectionString(Model):
    """Connection string for the Cosmos DB account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar connection_string: Value of the connection string
    :vartype connection_string: str
    :ivar description: Description of the connection string
    :vartype description: str
    """

    _validation = {
        'connection_string': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountConnectionString, self).__init__(**kwargs)
        self.connection_string = None
        self.description = None


class DatabaseAccountCreateUpdateParameters(Resource):
    """Parameters to create and update Cosmos DB database accounts.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param kind: Indicates the type of database account. This can only be set
     at database account creation. Possible values include: 'GlobalDocumentDB',
     'MongoDB', 'Parse'. Default value: "GlobalDocumentDB" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.DatabaseAccountKind
    :param consistency_policy: The consistency policy for the Cosmos DB
     account.
    :type consistency_policy: ~azure.mgmt.cosmosdb.models.ConsistencyPolicy
    :param locations: Required. An array that contains the georeplication
     locations enabled for the Cosmos DB account.
    :type locations: list[~azure.mgmt.cosmosdb.models.Location]
    :ivar database_account_offer_type: Required. The offer type for the
     database. Default value: "Standard" .
    :vartype database_account_offer_type: str
    :param ip_range_filter: Cosmos DB Firewall Support: This value specifies
     the set of IP addresses or IP address ranges in CIDR form to be included
     as the allowed list of client IPs for a given database account. IP
     addresses/ranges must be comma separated and must not contain any spaces.
    :type ip_range_filter: str
    :param is_virtual_network_filter_enabled: Flag to indicate whether to
     enable/disable Virtual Network ACL rules.
    :type is_virtual_network_filter_enabled: bool
    :param enable_automatic_failover: Enables automatic failover of the write
     region in the rare event that the region is unavailable due to an outage.
     Automatic failover will result in a new write region for the account and
     is chosen based on the failover priorities configured for the account.
    :type enable_automatic_failover: bool
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    :param virtual_network_rules: List of Virtual Network ACL rules configured
     for the Cosmos DB account.
    :type virtual_network_rules:
     list[~azure.mgmt.cosmosdb.models.VirtualNetworkRule]
    :param enable_multiple_write_locations: Enables the account to write in
     multiple locations
    :type enable_multiple_write_locations: bool
    :param enable_cassandra_connector: Enables the cassandra connector on the
     Cosmos DB C* account
    :type enable_cassandra_connector: bool
    :param connector_offer: The cassandra connector offer type for the Cosmos
     DB database C* account. Possible values include: 'Small'
    :type connector_offer: str or ~azure.mgmt.cosmosdb.models.ConnectorOffer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'locations': {'required': True},
        'database_account_offer_type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'consistency_policy': {'key': 'properties.consistencyPolicy', 'type': 'ConsistencyPolicy'},
        'locations': {'key': 'properties.locations', 'type': '[Location]'},
        'database_account_offer_type': {'key': 'properties.databaseAccountOfferType', 'type': 'str'},
        'ip_range_filter': {'key': 'properties.ipRangeFilter', 'type': 'str'},
        'is_virtual_network_filter_enabled': {'key': 'properties.isVirtualNetworkFilterEnabled', 'type': 'bool'},
        'enable_automatic_failover': {'key': 'properties.enableAutomaticFailover', 'type': 'bool'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[Capability]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'enable_multiple_write_locations': {'key': 'properties.enableMultipleWriteLocations', 'type': 'bool'},
        'enable_cassandra_connector': {'key': 'properties.enableCassandraConnector', 'type': 'bool'},
        'connector_offer': {'key': 'properties.connectorOffer', 'type': 'str'},
    }

    database_account_offer_type = "Standard"

    def __init__(self, **kwargs):
        super(DatabaseAccountCreateUpdateParameters, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', "GlobalDocumentDB")
        self.consistency_policy = kwargs.get('consistency_policy', None)
        self.locations = kwargs.get('locations', None)
        self.ip_range_filter = kwargs.get('ip_range_filter', None)
        self.is_virtual_network_filter_enabled = kwargs.get('is_virtual_network_filter_enabled', None)
        self.enable_automatic_failover = kwargs.get('enable_automatic_failover', None)
        self.capabilities = kwargs.get('capabilities', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.enable_multiple_write_locations = kwargs.get('enable_multiple_write_locations', None)
        self.enable_cassandra_connector = kwargs.get('enable_cassandra_connector', None)
        self.connector_offer = kwargs.get('connector_offer', None)


class DatabaseAccountListConnectionStringsResult(Model):
    """The connection strings for the given database account.

    :param connection_strings: An array that contains the connection strings
     for the Cosmos DB account.
    :type connection_strings:
     list[~azure.mgmt.cosmosdb.models.DatabaseAccountConnectionString]
    """

    _attribute_map = {
        'connection_strings': {'key': 'connectionStrings', 'type': '[DatabaseAccountConnectionString]'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountListConnectionStringsResult, self).__init__(**kwargs)
        self.connection_strings = kwargs.get('connection_strings', None)


class DatabaseAccountListReadOnlyKeysResult(Model):
    """The read-only access keys for the given database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary
     read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the
     secondary read-only key.
    :vartype secondary_readonly_master_key: str
    """

    _validation = {
        'primary_readonly_master_key': {'readonly': True},
        'secondary_readonly_master_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_readonly_master_key': {'key': 'primaryReadonlyMasterKey', 'type': 'str'},
        'secondary_readonly_master_key': {'key': 'secondaryReadonlyMasterKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountListReadOnlyKeysResult, self).__init__(**kwargs)
        self.primary_readonly_master_key = None
        self.secondary_readonly_master_key = None


class DatabaseAccountListKeysResult(DatabaseAccountListReadOnlyKeysResult):
    """The access keys for the given database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_readonly_master_key: Base 64 encoded value of the primary
     read-only key.
    :vartype primary_readonly_master_key: str
    :ivar secondary_readonly_master_key: Base 64 encoded value of the
     secondary read-only key.
    :vartype secondary_readonly_master_key: str
    :ivar primary_master_key: Base 64 encoded value of the primary read-write
     key.
    :vartype primary_master_key: str
    :ivar secondary_master_key: Base 64 encoded value of the secondary
     read-write key.
    :vartype secondary_master_key: str
    """

    _validation = {
        'primary_readonly_master_key': {'readonly': True},
        'secondary_readonly_master_key': {'readonly': True},
        'primary_master_key': {'readonly': True},
        'secondary_master_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_readonly_master_key': {'key': 'primaryReadonlyMasterKey', 'type': 'str'},
        'secondary_readonly_master_key': {'key': 'secondaryReadonlyMasterKey', 'type': 'str'},
        'primary_master_key': {'key': 'primaryMasterKey', 'type': 'str'},
        'secondary_master_key': {'key': 'secondaryMasterKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountListKeysResult, self).__init__(**kwargs)
        self.primary_master_key = None
        self.secondary_master_key = None


class DatabaseAccountPatchParameters(Model):
    """Parameters for patching Azure Cosmos DB database account properties.

    :param tags:
    :type tags: dict[str, str]
    :param capabilities: List of Cosmos DB capabilities for the account
    :type capabilities: list[~azure.mgmt.cosmosdb.models.Capability]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[Capability]'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountPatchParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.capabilities = kwargs.get('capabilities', None)


class DatabaseAccountRegenerateKeyParameters(Model):
    """Parameters to regenerate the keys within the database account.

    All required parameters must be populated in order to send to Azure.

    :param key_kind: Required. The access key to regenerate. Possible values
     include: 'primary', 'secondary', 'primaryReadonly', 'secondaryReadonly'
    :type key_kind: str or ~azure.mgmt.cosmosdb.models.KeyKind
    """

    _validation = {
        'key_kind': {'required': True},
    }

    _attribute_map = {
        'key_kind': {'key': 'keyKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_kind = kwargs.get('key_kind', None)


class ErrorResponse(Model):
    """Error Response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ExcludedPath(Model):
    """ExcludedPath.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExcludedPath, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)


class ExtendedResourceProperties(Model):
    """The system generated resource properties associated with SQL databases and
    SQL containers.

    :param _rid: A system generated property. A unique identifier.
    :type _rid: str
    :param _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :type _ts: object
    :param _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :type _etag: str
    """

    _attribute_map = {
        '_rid': {'key': '_rid', 'type': 'str'},
        '_ts': {'key': '_ts', 'type': 'object'},
        '_etag': {'key': '_etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtendedResourceProperties, self).__init__(**kwargs)
        self._rid = kwargs.get('_rid', None)
        self._ts = kwargs.get('_ts', None)
        self._etag = kwargs.get('_etag', None)


class FailoverPolicies(Model):
    """The list of new failover policies for the failover priority change.

    All required parameters must be populated in order to send to Azure.

    :param failover_policies: Required. List of failover policies.
    :type failover_policies: list[~azure.mgmt.cosmosdb.models.FailoverPolicy]
    """

    _validation = {
        'failover_policies': {'required': True},
    }

    _attribute_map = {
        'failover_policies': {'key': 'failoverPolicies', 'type': '[FailoverPolicy]'},
    }

    def __init__(self, **kwargs):
        super(FailoverPolicies, self).__init__(**kwargs)
        self.failover_policies = kwargs.get('failover_policies', None)


class FailoverPolicy(Model):
    """The failover policy for a given region of a database account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique identifier of the region in which the database
     account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :param location_name: The name of the region in which the database account
     exists.
    :type location_name: str
    :param failover_priority: The failover priority of the region. A failover
     priority of 0 indicates a write region. The maximum value for a failover
     priority = (total number of regions - 1). Failover priority values must be
     unique for each of the regions in which the database account exists.
    :type failover_priority: int
    """

    _validation = {
        'id': {'readonly': True},
        'failover_priority': {'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location_name': {'key': 'locationName', 'type': 'str'},
        'failover_priority': {'key': 'failoverPriority', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(FailoverPolicy, self).__init__(**kwargs)
        self.id = None
        self.location_name = kwargs.get('location_name', None)
        self.failover_priority = kwargs.get('failover_priority', None)


class GremlinDatabase(Resource):
    """An Azure Cosmos DB Gremlin database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param gremlin_database_id: Required. Name of the Cosmos DB Gremlin
     database
    :type gremlin_database_id: str
    :param _rid: A system generated property. A unique identifier.
    :type _rid: str
    :param _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :type _ts: object
    :param _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :type _etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'gremlin_database_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'gremlin_database_id': {'key': 'properties.id', 'type': 'str'},
        '_rid': {'key': 'properties._rid', 'type': 'str'},
        '_ts': {'key': 'properties._ts', 'type': 'object'},
        '_etag': {'key': 'properties._etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GremlinDatabase, self).__init__(**kwargs)
        self.gremlin_database_id = kwargs.get('gremlin_database_id', None)
        self._rid = kwargs.get('_rid', None)
        self._ts = kwargs.get('_ts', None)
        self._etag = kwargs.get('_etag', None)


class GremlinDatabaseCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB Gremlin database.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a Gremlin database
    :type resource: ~azure.mgmt.cosmosdb.models.GremlinDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'GremlinDatabaseResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(GremlinDatabaseCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class GremlinDatabaseResource(Model):
    """Cosmos DB Gremlin database id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GremlinDatabaseResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class GremlinGraph(Resource):
    """An Azure Cosmos DB Gremlin graph.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param gremlin_graph_id: Required. Name of the Cosmos DB Gremlin graph
    :type gremlin_graph_id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the graph
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     graph.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :param _rid: A system generated property. A unique identifier.
    :type _rid: str
    :param _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :type _ts: object
    :param _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :type _etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'gremlin_graph_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'gremlin_graph_id': {'key': 'properties.id', 'type': 'str'},
        'indexing_policy': {'key': 'properties.indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'properties.defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'properties.uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'properties.conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
        '_rid': {'key': 'properties._rid', 'type': 'str'},
        '_ts': {'key': 'properties._ts', 'type': 'object'},
        '_etag': {'key': 'properties._etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GremlinGraph, self).__init__(**kwargs)
        self.gremlin_graph_id = kwargs.get('gremlin_graph_id', None)
        self.indexing_policy = kwargs.get('indexing_policy', None)
        self.partition_key = kwargs.get('partition_key', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.unique_key_policy = kwargs.get('unique_key_policy', None)
        self.conflict_resolution_policy = kwargs.get('conflict_resolution_policy', None)
        self._rid = kwargs.get('_rid', None)
        self._ts = kwargs.get('_ts', None)
        self._etag = kwargs.get('_etag', None)


class GremlinGraphCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB Gremlin graph.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a Gremlin graph
    :type resource: ~azure.mgmt.cosmosdb.models.GremlinGraphResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'GremlinGraphResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(GremlinGraphCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class GremlinGraphResource(Model):
    """Cosmos DB Gremlin graph resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB Gremlin graph
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the graph
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     graph.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
    }

    def __init__(self, **kwargs):
        super(GremlinGraphResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.indexing_policy = kwargs.get('indexing_policy', None)
        self.partition_key = kwargs.get('partition_key', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.unique_key_policy = kwargs.get('unique_key_policy', None)
        self.conflict_resolution_policy = kwargs.get('conflict_resolution_policy', None)


class IncludedPath(Model):
    """The paths that are included in indexing.

    :param path: The path for which the indexing behavior applies to. Index
     paths typically start with root and end with wildcard (/path/*)
    :type path: str
    :param indexes: List of indexes for this path
    :type indexes: list[~azure.mgmt.cosmosdb.models.Indexes]
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'indexes': {'key': 'indexes', 'type': '[Indexes]'},
    }

    def __init__(self, **kwargs):
        super(IncludedPath, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.indexes = kwargs.get('indexes', None)


class Indexes(Model):
    """The indexes for the path.

    :param data_type: The datatype for which the indexing behavior is applied
     to. Possible values include: 'String', 'Number', 'Point', 'Polygon',
     'LineString', 'MultiPolygon'. Default value: "String" .
    :type data_type: str or ~azure.mgmt.cosmosdb.models.DataType
    :param precision: The precision of the index. -1 is maximum precision.
    :type precision: int
    :param kind: Indicates the type of index. Possible values include: 'Hash',
     'Range', 'Spatial'. Default value: "Hash" .
    :type kind: str or ~azure.mgmt.cosmosdb.models.IndexKind
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'precision': {'key': 'precision', 'type': 'int'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Indexes, self).__init__(**kwargs)
        self.data_type = kwargs.get('data_type', "String")
        self.precision = kwargs.get('precision', None)
        self.kind = kwargs.get('kind', "Hash")


class IndexingPolicy(Model):
    """Cosmos DB indexing policy.

    :param automatic: Indicates if the indexing policy is automatic
    :type automatic: bool
    :param indexing_mode: Indicates the indexing mode. Possible values
     include: 'Consistent', 'Lazy', 'None'. Default value: "Consistent" .
    :type indexing_mode: str or ~azure.mgmt.cosmosdb.models.IndexingMode
    :param included_paths: List of paths to include in the indexing
    :type included_paths: list[~azure.mgmt.cosmosdb.models.IncludedPath]
    :param excluded_paths: List of paths to exclude from indexing
    :type excluded_paths: list[~azure.mgmt.cosmosdb.models.ExcludedPath]
    """

    _attribute_map = {
        'automatic': {'key': 'automatic', 'type': 'bool'},
        'indexing_mode': {'key': 'indexingMode', 'type': 'str'},
        'included_paths': {'key': 'includedPaths', 'type': '[IncludedPath]'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[ExcludedPath]'},
    }

    def __init__(self, **kwargs):
        super(IndexingPolicy, self).__init__(**kwargs)
        self.automatic = kwargs.get('automatic', None)
        self.indexing_mode = kwargs.get('indexing_mode', "Consistent")
        self.included_paths = kwargs.get('included_paths', None)
        self.excluded_paths = kwargs.get('excluded_paths', None)


class Location(Model):
    """A region in which the Azure Cosmos DB database account is deployed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique identifier of the region within the database account.
     Example: &lt;accountName&gt;-&lt;locationName&gt;.
    :vartype id: str
    :param location_name: The name of the region.
    :type location_name: str
    :ivar document_endpoint: The connection endpoint for the specific region.
     Example:
     https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
    :vartype document_endpoint: str
    :param provisioning_state:
    :type provisioning_state: str
    :param failover_priority: The failover priority of the region. A failover
     priority of 0 indicates a write region. The maximum value for a failover
     priority = (total number of regions - 1). Failover priority values must be
     unique for each of the regions in which the database account exists.
    :type failover_priority: int
    :param is_zone_redundant: Flag to indicate whether or not this region is
     an AvailabilityZone region
    :type is_zone_redundant: bool
    """

    _validation = {
        'id': {'readonly': True},
        'document_endpoint': {'readonly': True},
        'failover_priority': {'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location_name': {'key': 'locationName', 'type': 'str'},
        'document_endpoint': {'key': 'documentEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'failover_priority': {'key': 'failoverPriority', 'type': 'int'},
        'is_zone_redundant': {'key': 'isZoneRedundant', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Location, self).__init__(**kwargs)
        self.id = None
        self.location_name = kwargs.get('location_name', None)
        self.document_endpoint = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.failover_priority = kwargs.get('failover_priority', None)
        self.is_zone_redundant = kwargs.get('is_zone_redundant', None)


class Metric(Model):
    """Metric data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and
     timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
    }

    def __init__(self, **kwargs):
        super(Metric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = kwargs.get('unit', None)
        self.name = None
        self.metric_values = None


class MetricAvailability(Model):
    """The availability of the metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :ivar retention: The retention for the metric values.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class MetricDefinition(Model):
    """The definition of a metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar metric_availabilities: The list of metric availabilities for the
     account.
    :vartype metric_availabilities:
     list[~azure.mgmt.cosmosdb.models.MetricAvailability]
    :ivar primary_aggregation_type: The primary aggregation type of the
     metric. Possible values include: 'None', 'Average', 'Total', 'Minimimum',
     'Maximum', 'Last'
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.cosmosdb.models.PrimaryAggregationType
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    """

    _validation = {
        'metric_availabilities': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'resource_uri': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
    }

    def __init__(self, **kwargs):
        super(MetricDefinition, self).__init__(**kwargs)
        self.metric_availabilities = None
        self.primary_aggregation_type = None
        self.unit = kwargs.get('unit', None)
        self.resource_uri = None
        self.name = None


class MetricName(Model):
    """A metric name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The name of the metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the metric.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class MetricValue(Model):
    """Represents metrics values.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _count: The number of values for the metric.
    :vartype _count: float
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    """

    _validation = {
        '_count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
    }

    _attribute_map = {
        '_count': {'key': '_count', 'type': 'float'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(MetricValue, self).__init__(**kwargs)
        self._count = None
        self.average = None
        self.maximum = None
        self.minimum = None
        self.timestamp = None
        self.total = None


class MongoDBCollection(Resource):
    """An Azure Cosmos DB MongoDB collection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param mongo_db_collection_id: Required. Name of the Cosmos DB MongoDB
     collection
    :type mongo_db_collection_id: str
    :param shard_key: A key-value pair of shard keys to be applied for the
     request.
    :type shard_key: dict[str, str]
    :param indexes: List of index keys
    :type indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'mongo_db_collection_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'mongo_db_collection_id': {'key': 'properties.id', 'type': 'str'},
        'shard_key': {'key': 'properties.shardKey', 'type': '{str}'},
        'indexes': {'key': 'properties.indexes', 'type': '[MongoIndex]'},
    }

    def __init__(self, **kwargs):
        super(MongoDBCollection, self).__init__(**kwargs)
        self.mongo_db_collection_id = kwargs.get('mongo_db_collection_id', None)
        self.shard_key = kwargs.get('shard_key', None)
        self.indexes = kwargs.get('indexes', None)


class MongoDBCollectionCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB MongoDB collection.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a MongoDB
     collection
    :type resource: ~azure.mgmt.cosmosdb.models.MongoDBCollectionResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'MongoDBCollectionResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(MongoDBCollectionCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class MongoDBCollectionResource(Model):
    """Cosmos DB MongoDB collection resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB collection
    :type id: str
    :param shard_key: A key-value pair of shard keys to be applied for the
     request.
    :type shard_key: dict[str, str]
    :param indexes: List of index keys
    :type indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'shard_key': {'key': 'shardKey', 'type': '{str}'},
        'indexes': {'key': 'indexes', 'type': '[MongoIndex]'},
    }

    def __init__(self, **kwargs):
        super(MongoDBCollectionResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.shard_key = kwargs.get('shard_key', None)
        self.indexes = kwargs.get('indexes', None)


class MongoDBDatabase(Resource):
    """An Azure Cosmos DB MongoDB database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param mongo_db_database_id: Required. Name of the Cosmos DB MongoDB
     database
    :type mongo_db_database_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'mongo_db_database_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'mongo_db_database_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MongoDBDatabase, self).__init__(**kwargs)
        self.mongo_db_database_id = kwargs.get('mongo_db_database_id', None)


class MongoDBDatabaseCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB MongoDB database.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a MongoDB database
    :type resource: ~azure.mgmt.cosmosdb.models.MongoDBDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'MongoDBDatabaseResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(MongoDBDatabaseCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class MongoDBDatabaseResource(Model):
    """Cosmos DB MongoDB database id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MongoDBDatabaseResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class MongoIndex(Model):
    """Cosmos DB MongoDB collection index key.

    :param key: Cosmos DB MongoDB collection index keys
    :type key: ~azure.mgmt.cosmosdb.models.MongoIndexKeys
    :param options: Cosmos DB MongoDB collection index key options
    :type options: ~azure.mgmt.cosmosdb.models.MongoIndexOptions
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'MongoIndexKeys'},
        'options': {'key': 'options', 'type': 'MongoIndexOptions'},
    }

    def __init__(self, **kwargs):
        super(MongoIndex, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.options = kwargs.get('options', None)


class MongoIndexKeys(Model):
    """Cosmos DB MongoDB collection resource object.

    :param keys: List of keys for each MongoDB collection in the Azure Cosmos
     DB service
    :type keys: list[str]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MongoIndexKeys, self).__init__(**kwargs)
        self.keys = kwargs.get('keys', None)


class MongoIndexOptions(Model):
    """Cosmos DB MongoDB collection index options.

    :param expire_after_seconds: Expire after seconds
    :type expire_after_seconds: int
    :param unique: Is unique or not
    :type unique: bool
    """

    _attribute_map = {
        'expire_after_seconds': {'key': 'expireAfterSeconds', 'type': 'int'},
        'unique': {'key': 'unique', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(MongoIndexOptions, self).__init__(**kwargs)
        self.expire_after_seconds = kwargs.get('expire_after_seconds', None)
        self.unique = kwargs.get('unique', None)


class Operation(Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.cosmosdb.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.ResourceProvider
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile,
     endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Description of operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'Provider', 'type': 'str'},
        'resource': {'key': 'Resource', 'type': 'str'},
        'operation': {'key': 'Operation', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class PartitionMetric(Metric):
    """The metric values for a single partition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The metric values for the specified time window and
     timestep.
    :vartype metric_values: list[~azure.mgmt.cosmosdb.models.MetricValue]
    :ivar partition_id: The partition id (GUID identifier) of the metric
     values.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer
     identifier) of the metric values.
    :vartype partition_key_range_id: str
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
        'partition_id': {'readonly': True},
        'partition_key_range_id': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
        'partition_id': {'key': 'partitionId', 'type': 'str'},
        'partition_key_range_id': {'key': 'partitionKeyRangeId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionMetric, self).__init__(**kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class Usage(Model):
    """The usage data for a usage request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric
    :vartype limit: long
    :ivar current_value: Current value for this metric
    :vartype current_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'quota_period': {'readonly': True},
        'limit': {'readonly': True},
        'current_value': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.name = None
        self.quota_period = None
        self.limit = None
        self.current_value = None


class PartitionUsage(Usage):
    """The partition level usage data for a usage request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric
    :vartype limit: long
    :ivar current_value: Current value for this metric
    :vartype current_value: long
    :ivar partition_id: The partition id (GUID identifier) of the usages.
    :vartype partition_id: str
    :ivar partition_key_range_id: The partition key range id (integer
     identifier) of the usages.
    :vartype partition_key_range_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'quota_period': {'readonly': True},
        'limit': {'readonly': True},
        'current_value': {'readonly': True},
        'partition_id': {'readonly': True},
        'partition_key_range_id': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'partition_id': {'key': 'partitionId', 'type': 'str'},
        'partition_key_range_id': {'key': 'partitionKeyRangeId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionUsage, self).__init__(**kwargs)
        self.partition_id = None
        self.partition_key_range_id = None


class PercentileMetric(Model):
    """Percentile Metric data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time grain to be used to summarize the metric
     values.
    :vartype time_grain: str
    :param unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond',
     'Milliseconds'
    :type unit: str or ~azure.mgmt.cosmosdb.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cosmosdb.models.MetricName
    :ivar metric_values: The percentile metric values for the specified time
     window and timestep.
    :vartype metric_values:
     list[~azure.mgmt.cosmosdb.models.PercentileMetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[PercentileMetricValue]'},
    }

    def __init__(self, **kwargs):
        super(PercentileMetric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = kwargs.get('unit', None)
        self.name = None
        self.metric_values = None


class PercentileMetricValue(MetricValue):
    """Represents percentile metrics values.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar _count: The number of values for the metric.
    :vartype _count: float
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    :ivar p10: The 10th percentile value for the metric.
    :vartype p10: float
    :ivar p25: The 25th percentile value for the metric.
    :vartype p25: float
    :ivar p50: The 50th percentile value for the metric.
    :vartype p50: float
    :ivar p75: The 75th percentile value for the metric.
    :vartype p75: float
    :ivar p90: The 90th percentile value for the metric.
    :vartype p90: float
    :ivar p95: The 95th percentile value for the metric.
    :vartype p95: float
    :ivar p99: The 99th percentile value for the metric.
    :vartype p99: float
    """

    _validation = {
        '_count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
        'p10': {'readonly': True},
        'p25': {'readonly': True},
        'p50': {'readonly': True},
        'p75': {'readonly': True},
        'p90': {'readonly': True},
        'p95': {'readonly': True},
        'p99': {'readonly': True},
    }

    _attribute_map = {
        '_count': {'key': '_count', 'type': 'float'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
        'p10': {'key': 'P10', 'type': 'float'},
        'p25': {'key': 'P25', 'type': 'float'},
        'p50': {'key': 'P50', 'type': 'float'},
        'p75': {'key': 'P75', 'type': 'float'},
        'p90': {'key': 'P90', 'type': 'float'},
        'p95': {'key': 'P95', 'type': 'float'},
        'p99': {'key': 'P99', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(PercentileMetricValue, self).__init__(**kwargs)
        self.p10 = None
        self.p25 = None
        self.p50 = None
        self.p75 = None
        self.p90 = None
        self.p95 = None
        self.p99 = None


class RegionForOnlineOffline(Model):
    """Cosmos DB region to online or offline.

    All required parameters must be populated in order to send to Azure.

    :param region: Required. Cosmos DB region, with spaces between words and
     each word capitalized.
    :type region: str
    """

    _validation = {
        'region': {'required': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegionForOnlineOffline, self).__init__(**kwargs)
        self.region = kwargs.get('region', None)


class SqlContainer(Resource):
    """An Azure Cosmos DB container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param sql_container_id: Required. Name of the Cosmos DB SQL container
    :type sql_container_id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the
     container
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     container.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    :param _rid: A system generated property. A unique identifier.
    :type _rid: str
    :param _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :type _ts: object
    :param _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :type _etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sql_container_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sql_container_id': {'key': 'properties.id', 'type': 'str'},
        'indexing_policy': {'key': 'properties.indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'properties.defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'properties.uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'properties.conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
        '_rid': {'key': 'properties._rid', 'type': 'str'},
        '_ts': {'key': 'properties._ts', 'type': 'object'},
        '_etag': {'key': 'properties._etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlContainer, self).__init__(**kwargs)
        self.sql_container_id = kwargs.get('sql_container_id', None)
        self.indexing_policy = kwargs.get('indexing_policy', None)
        self.partition_key = kwargs.get('partition_key', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.unique_key_policy = kwargs.get('unique_key_policy', None)
        self.conflict_resolution_policy = kwargs.get('conflict_resolution_policy', None)
        self._rid = kwargs.get('_rid', None)
        self._ts = kwargs.get('_ts', None)
        self._etag = kwargs.get('_etag', None)


class SqlContainerCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB container.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a container
    :type resource: ~azure.mgmt.cosmosdb.models.SqlContainerResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'SqlContainerResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(SqlContainerCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class SqlContainerResource(Model):
    """Cosmos DB SQL container resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL container
    :type id: str
    :param indexing_policy: The configuration of the indexing policy. By
     default, the indexing is automatic for all document paths within the
     container
    :type indexing_policy: ~azure.mgmt.cosmosdb.models.IndexingPolicy
    :param partition_key: The configuration of the partition key to be used
     for partitioning data into multiple partitions
    :type partition_key: ~azure.mgmt.cosmosdb.models.ContainerPartitionKey
    :param default_ttl: Default time to live
    :type default_ttl: int
    :param unique_key_policy: The unique key policy configuration for
     specifying uniqueness constraints on documents in the collection in the
     Azure Cosmos DB service.
    :type unique_key_policy: ~azure.mgmt.cosmosdb.models.UniqueKeyPolicy
    :param conflict_resolution_policy: The conflict resolution policy for the
     container.
    :type conflict_resolution_policy:
     ~azure.mgmt.cosmosdb.models.ConflictResolutionPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'indexing_policy': {'key': 'indexingPolicy', 'type': 'IndexingPolicy'},
        'partition_key': {'key': 'partitionKey', 'type': 'ContainerPartitionKey'},
        'default_ttl': {'key': 'defaultTtl', 'type': 'int'},
        'unique_key_policy': {'key': 'uniqueKeyPolicy', 'type': 'UniqueKeyPolicy'},
        'conflict_resolution_policy': {'key': 'conflictResolutionPolicy', 'type': 'ConflictResolutionPolicy'},
    }

    def __init__(self, **kwargs):
        super(SqlContainerResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.indexing_policy = kwargs.get('indexing_policy', None)
        self.partition_key = kwargs.get('partition_key', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.unique_key_policy = kwargs.get('unique_key_policy', None)
        self.conflict_resolution_policy = kwargs.get('conflict_resolution_policy', None)


class SqlDatabase(Resource):
    """An Azure Cosmos DB SQL database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param sql_database_id: Required. Name of the Cosmos DB SQL database
    :type sql_database_id: str
    :param _rid: A system generated property. A unique identifier.
    :type _rid: str
    :param _ts: A system generated property that denotes the last updated
     timestamp of the resource.
    :type _ts: object
    :param _etag: A system generated property representing the resource etag
     required for optimistic concurrency control.
    :type _etag: str
    :param _colls: A system generated property that specified the addressable
     path of the collections resource.
    :type _colls: str
    :param _users: A system generated property that specifies the addressable
     path of the users resource.
    :type _users: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sql_database_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sql_database_id': {'key': 'properties.id', 'type': 'str'},
        '_rid': {'key': 'properties._rid', 'type': 'str'},
        '_ts': {'key': 'properties._ts', 'type': 'object'},
        '_etag': {'key': 'properties._etag', 'type': 'str'},
        '_colls': {'key': 'properties._colls', 'type': 'str'},
        '_users': {'key': 'properties._users', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlDatabase, self).__init__(**kwargs)
        self.sql_database_id = kwargs.get('sql_database_id', None)
        self._rid = kwargs.get('_rid', None)
        self._ts = kwargs.get('_ts', None)
        self._etag = kwargs.get('_etag', None)
        self._colls = kwargs.get('_colls', None)
        self._users = kwargs.get('_users', None)


class SqlDatabaseCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB SQL database.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a SQL database
    :type resource: ~azure.mgmt.cosmosdb.models.SqlDatabaseResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'SqlDatabaseResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(SqlDatabaseCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class SqlDatabaseResource(Model):
    """Cosmos DB SQL database id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB SQL database
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlDatabaseResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Table(Resource):
    """An Azure Cosmos DB Table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param table_id: Required. Name of the Cosmos DB table
    :type table_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'table_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'table_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Table, self).__init__(**kwargs)
        self.table_id = kwargs.get('table_id', None)


class TableCreateUpdateParameters(Model):
    """Parameters to create and update Cosmos DB Table.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a Table
    :type resource: ~azure.mgmt.cosmosdb.models.TableResource
    :param options: Required. A key-value pair of options to be applied for
     the request. This corresponds to the headers sent with the request.
    :type options: dict[str, str]
    """

    _validation = {
        'resource': {'required': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'TableResource'},
        'options': {'key': 'properties.options', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TableCreateUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)
        self.options = kwargs.get('options', None)


class TableResource(Model):
    """Cosmos DB table id object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB table
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TableResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Throughput(Resource):
    """An Azure Cosmos DB resource throughput.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param throughput: Required. Value of the Cosmos DB resource throughput
    :type throughput: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'throughput': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'throughput': {'key': 'properties.throughput', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Throughput, self).__init__(**kwargs)
        self.throughput = kwargs.get('throughput', None)


class ThroughputResource(Model):
    """Cosmos DB resource throughput object.

    All required parameters must be populated in order to send to Azure.

    :param throughput: Required. Value of the Cosmos DB resource throughput
    :type throughput: int
    """

    _validation = {
        'throughput': {'required': True},
    }

    _attribute_map = {
        'throughput': {'key': 'throughput', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ThroughputResource, self).__init__(**kwargs)
        self.throughput = kwargs.get('throughput', None)


class ThroughputUpdateParameters(Model):
    """Parameters to update Cosmos DB resource throughput.

    All required parameters must be populated in order to send to Azure.

    :param resource: Required. The standard JSON format of a resource
     throughput
    :type resource: ~azure.mgmt.cosmosdb.models.ThroughputResource
    """

    _validation = {
        'resource': {'required': True},
    }

    _attribute_map = {
        'resource': {'key': 'properties.resource', 'type': 'ThroughputResource'},
    }

    def __init__(self, **kwargs):
        super(ThroughputUpdateParameters, self).__init__(**kwargs)
        self.resource = kwargs.get('resource', None)


class UniqueKey(Model):
    """The unique key on that enforces uniqueness constraint on documents in the
    collection in the Azure Cosmos DB service.

    :param paths: List of paths must be unique for each document in the Azure
     Cosmos DB service
    :type paths: list[str]
    """

    _attribute_map = {
        'paths': {'key': 'paths', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(UniqueKey, self).__init__(**kwargs)
        self.paths = kwargs.get('paths', None)


class UniqueKeyPolicy(Model):
    """The unique key policy configuration for specifying uniqueness constraints
    on documents in the collection in the Azure Cosmos DB service.

    :param unique_keys: List of unique keys on that enforces uniqueness
     constraint on documents in the collection in the Azure Cosmos DB service.
    :type unique_keys: list[~azure.mgmt.cosmosdb.models.UniqueKey]
    """

    _attribute_map = {
        'unique_keys': {'key': 'uniqueKeys', 'type': '[UniqueKey]'},
    }

    def __init__(self, **kwargs):
        super(UniqueKeyPolicy, self).__init__(**kwargs)
        self.unique_keys = kwargs.get('unique_keys', None)


class VirtualNetworkRule(Model):
    """Virtual Network ACL Rule object.

    :param id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before
     the virtual network has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'ignoreMissingVNetServiceEndpoint', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.ignore_missing_vnet_service_endpoint = kwargs.get('ignore_missing_vnet_service_endpoint', None)
