/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.RobotRemote;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

public class ScreenRemote
extends Screen
implements IScreen {
    private ObjectInputStream in = null;
    private OutputStreamWriter out;
    private static Socket socket = null;
    private boolean socketValid;
    private int rw;
    private int rh;
    private RobotRemote rrobot;
    private String system = "";
    private int numberScreens = 0;
    private int curID;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "ScreenRemote: " + message, args);
    }

    private static void log(String message, Object ... args) {
        ScreenRemote.log(3, message, args);
    }

    public ScreenRemote(String adr, String p) {
        this.init(adr, p);
    }

    private void init(String adr, String p) {
        this.socketValid = true;
        this.rrobot = null;
        this.setOtherScreen();
        String ip = FileManager.getAddress(adr);
        int port = FileManager.getPort(p);
        if (ip == null || port < 0) {
            ScreenRemote.log(-1, "fatal: not valid: " + adr + " / " + p, new Object[0]);
            System.exit(1);
        }
        try {
            socket = new Socket(ip, port);
        }
        catch (Exception ex) {
            ScreenRemote.log(-1, "fatal: no connection: " + adr + " / " + p, new Object[0]);
            this.socketValid = false;
        }
        try {
            if (this.socketValid) {
                this.in = new ObjectInputStream(socket.getInputStream());
                this.out = new OutputStreamWriter(socket.getOutputStream());
                ScreenRemote.log("connection at: " + socket, new Object[0]);
            }
        }
        catch (Exception ex) {
            ScreenRemote.log(-1, "fatal: problem starting pipes:\n", ex.getMessage());
            this.socketValid = false;
        }
        if (this.socketValid) {
            this.rrobot = new RobotRemote(this);
            this.numberScreens = this.rrobot.getNumberScreens();
            this.system = this.rrobot.getSystem();
            ScreenRemote.log("RobotRemote: System: %s NumberScreens: %d", this.system, this.numberScreens);
            Rectangle r = this.rrobot.getBounds();
            this.rw = r.width;
            this.rh = r.height;
            this.setX(0);
            this.setY(0);
            this.setW(this.rw);
            this.setH(this.rh);
        }
    }

    @Override
    public String toString() {
        return String.format("S(R-%d)[%dx%d]", this.curID, this.rw, this.rh);
    }

    @Override
    public String toStringShort() {
        return this.toString();
    }

    @Override
    public boolean isValid() {
        return this.socketValid && socket != null;
    }

    public ObjectInputStream getIn() {
        return this.in;
    }

    public OutputStreamWriter getOut() {
        return this.out;
    }

    public boolean close(boolean stopServer) {
        if (this.rrobot != null) {
            this.rrobot.cleanup();
        }
        if (socket != null) {
            try {
                if (stopServer) {
                    this.rrobot.send("EXIT STOP");
                } else {
                    this.rrobot.send("EXIT");
                }
                socket.close();
            }
            catch (IOException ex) {
                ScreenRemote.log(-1, "fatal: not closeable: %s\n" + ex.getMessage(), socket);
                return false;
            }
        }
        socket = null;
        this.socketValid = false;
        this.rrobot = null;
        return true;
    }

    public boolean close() {
        return this.close(false);
    }

    @Override
    public IRobot getRobot() {
        return this.rrobot;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.rw, this.rh);
    }

    @Override
    public ScreenImage capture() {
        return this.capture(0, 0, this.rw, this.rh);
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        return this.rrobot.captureScreen(new Rectangle(x, y, w, h));
    }

    @Override
    public ScreenImage capture(Rectangle r) {
        return this.capture(r.x, r.y, r.width, r.height);
    }

    @Override
    public ScreenImage capture(Region r) {
        return this.capture(r.x, r.y, r.w, r.h);
    }

    @Override
    public Location newLocation(Location loc) {
        return loc.setOtherScreen(this);
    }

    public Location newLocation(int x, int y) {
        return new Location(x, y).setOtherScreen(this);
    }

    @Override
    public Region newRegion(Location loc, int w, int h) {
        return new Region(loc.x, loc.y, w, h, loc.getScreen());
    }

    public Region newRegion(int x, int y, int w, int h) {
        return new Region(x, y, w, h, this);
    }

    public Region newRegion(Region r) {
        return new Region(r.x, r.y, r.w, r.h, this);
    }

    public Region newRegion(Rectangle r) {
        return new Region(r.x, r.y, r.width, r.height, this);
    }

    public Location mousePointer() {
        Location loc = this.rrobot.mousePointer();
        if (loc != null) {
            return loc.setOtherScreen(this);
        }
        return null;
    }
}

