/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.util.Date;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Keys;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.RobotDesktop;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.script.Sikulix;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.util.ScreenHighlighter;

public class Screen
extends Region
implements EventObserver,
IScreen {
    static RunTime runTime = RunTime.get();
    private static String me = "Screen: ";
    private static int lvl = 3;
    private static Region fakeRegion;
    private static IRobot globalRobot;
    protected static Screen[] screens;
    protected static int primaryScreen;
    private static int waitForScreenshot;
    protected IRobot robot = null;
    protected int curID = -1;
    protected int oldID = 0;
    protected int monitor = -1;
    protected boolean waitPrompt;
    protected OverlayCapturePrompt prompt;
    private static final String promptMsg = "Select a region on the screen";
    private ScreenImage lastScreenImage = null;
    private long lastCaptureTime = -1L;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public int getcurrentID() {
        return this.curID;
    }

    private static void initScreens(boolean reset) {
        if (screens != null && !reset) {
            return;
        }
        Screen.log(lvl + 1, "initScreens: entry", new Object[0]);
        primaryScreen = 0;
        globalRobot = Screen.getMouseRobot();
        screens = new Screen[Screen.runTime.nMonitors];
        Screen.screens[0] = new Screen(0, Screen.runTime.mainMonitor);
        screens[0].initScreen();
        int nMonitor = 0;
        for (int i = 1; i < screens.length; ++i) {
            if (nMonitor == Screen.runTime.mainMonitor) {
                ++nMonitor;
            }
            Screen.screens[i] = new Screen(i, nMonitor);
            screens[i].initScreen();
            ++nMonitor;
        }
        Mouse.init();
        Keys.init();
        if (Screen.getNumberScreens() > 1) {
            Screen.log(lvl, "initScreens: multi monitor mouse check", new Object[0]);
            Location lnow = Mouse.at();
            float mmd = Settings.MoveMouseDelay;
            Settings.MoveMouseDelay = 0.0f;
            Location lc = null;
            Location lcn = null;
            for (Screen s : screens) {
                lc = s.getCenter();
                Mouse.move(lc);
                lcn = Mouse.at();
                if (!lc.equals(lcn)) {
                    Screen.log(lvl, "*** multimonitor click check: %s center: (%d, %d) --- NOT OK:  (%d, %d)", s.toStringShort(), lc.x, lc.y, lcn.x, lcn.y);
                    continue;
                }
                Screen.log(lvl, "*** checking: %s center: (%d, %d) --- OK", s.toStringShort(), lc.x, lc.y);
            }
            Mouse.move(lnow);
            Settings.MoveMouseDelay = mmd;
        }
    }

    protected static IRobot getMouseRobot() {
        try {
            if (globalRobot == null) {
                globalRobot = new RobotDesktop();
            }
        }
        catch (AWTException e) {
            Debug.error("Can't initialize global Robot for Mouse: " + e.getMessage(), new Object[0]);
            Sikulix.terminate(999);
        }
        return globalRobot;
    }

    protected static Region getFakeRegion() {
        if (fakeRegion == null) {
            fakeRegion = new Region(0, 0, 5, 5);
        }
        return fakeRegion;
    }

    public static ScreenUnion all() {
        return new ScreenUnion();
    }

    private Screen(int id, boolean init) {
        this.curID = id;
    }

    private Screen(int id, int monitor) {
        this.curID = id;
        this.monitor = monitor;
    }

    public static Screen as(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, Screen.runTime.nMonitors - 1, primaryScreen);
            return screens[0];
        }
        return screens[id];
    }

    public Screen(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, Screen.runTime.nMonitors - 1, primaryScreen);
            this.curID = primaryScreen;
        } else {
            this.curID = id;
        }
        this.monitor = Screen.screens[id].monitor;
        this.initScreen();
    }

    public Screen(boolean isScreenUnion) {
        super(isScreenUnion);
    }

    public void setAsScreenUnion() {
        this.oldID = this.curID;
        this.curID = -1;
    }

    public void setAsScreen() {
        this.curID = this.oldID;
    }

    public Screen() {
        this.curID = primaryScreen;
        this.initScreen();
    }

    public void initScreen(Screen scr) {
        this.updateSelf();
    }

    private void initScreen() {
        Rectangle bounds = this.getBounds();
        this.x = (int)bounds.getX();
        this.y = (int)bounds.getY();
        this.w = (int)bounds.getWidth();
        this.h = (int)bounds.getHeight();
        this.robot = globalRobot;
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected Region setScreen(IScreen s) {
        throw new UnsupportedOperationException("The setScreen() method cannot be called from a Screen object.");
    }

    public static void showMonitors() {
        Debug.logp("*** monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < Screen.runTime.nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.logp("*** end monitor configuration ***", new Object[0]);
    }

    public static void resetMonitors() {
        Debug.error("*** BE AWARE: experimental - might not work ***", new Object[0]);
        Debug.error("Re-evaluation of the monitor setup has been requested", new Object[0]);
        Debug.error("... Current Region/Screen objects might not be valid any longer", new Object[0]);
        Debug.error("... Use existing Region/Screen objects only if you know what you are doing!", new Object[0]);
        Screen.initScreens(true);
        Debug.logp("*** new monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < Screen.runTime.nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.error("*** end new monitor configuration ***", new Object[0]);
    }

    protected boolean useFullscreen() {
        return false;
    }

    private static int getValidID(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            return primaryScreen;
        }
        return id;
    }

    private static int getValidMonitor(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            return Screen.runTime.mainMonitor;
        }
        return Screen.screens[id].monitor;
    }

    public static int getNumberScreens() {
        return Screen.runTime.nMonitors;
    }

    public static int getPrimaryId() {
        return primaryScreen;
    }

    public static Screen getPrimaryScreen() {
        return screens[primaryScreen];
    }

    public static Screen getScreen(int id) {
        return screens[Screen.getValidID(id)];
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(runTime.getMonitor(this.monitor));
    }

    public static Rectangle getBounds(int id) {
        return new Rectangle(runTime.getMonitor(Screen.getValidMonitor(id)));
    }

    public static IRobot getRobot(int id) {
        return Screen.getScreen(id).getRobot();
    }

    @Override
    public int getID() {
        return this.curID;
    }

    @Override
    public int getIdFromPoint(int x, int y) {
        return this.curID;
    }

    @Override
    public IRobot getRobot() {
        return this.robot;
    }

    public Region newRegion(Location loc, int width, int height) {
        return Region.create(loc.copyTo(this), width, height);
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    public Location newLocation(Location loc) {
        return new Location(loc).copyTo(this);
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getRect());
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        Rectangle rect = this.newRegion(new Location(x, y), w, h).getRect();
        return this.capture(rect);
    }

    public ScreenImage captureforHighlight(int x, int y, int w, int h) {
        return this.robot.captureScreen(new Rectangle(x, y, w, h));
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        this.lastCaptureTime = new Date().getTime();
        ScreenImage simg = this.robot.captureScreen(rect);
        if (Settings.FindProfiling) {
            Debug.logp("[FindProfiling] Screen.capture [%d x %d]: %d msec", rect.width, rect.height, new Date().getTime() - this.lastCaptureTime);
        }
        this.lastScreenImage = simg;
        if (Debug.getDebugLevel() > lvl) {
            simg.saveLastScreenImage(Screen.runTime.fSikulixStore);
        }
        return simg;
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.getRect());
    }

    public ScreenImage userCapture() {
        return this.userCapture("");
    }

    public static void startPrompt(String message, EventObserver obs) {
        String msg = message.isEmpty() ? promptMsg : message;
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            Screen.getScreen((int)is).prompt = new OverlayCapturePrompt(Screen.getScreen(is), obs);
            Screen.getScreen((int)is).prompt.prompt(msg);
        }
    }

    public static void closePrompt() {
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            Screen.getScreen((int)is).prompt.close();
        }
    }

    @Override
    public ScreenImage userCapture(final String message) {
        this.waitPrompt = true;
        Thread th = new Thread(){

            @Override
            public void run() {
                String msg = message.isEmpty() ? Screen.promptMsg : message;
                for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                    Screen.getScreen((int)is).prompt = new OverlayCapturePrompt(Screen.getScreen(is), (EventObserver)Screen.this);
                    Screen.getScreen((int)is).prompt.prompt(msg);
                }
            }
        };
        th.start();
        boolean hasShot = true;
        try {
            int count = 0;
            while (this.waitPrompt) {
                Thread.sleep(100L);
                if (count++ <= waitForScreenshot) continue;
                hasShot = false;
                break;
            }
        }
        catch (InterruptedException e) {
            hasShot = false;
        }
        ScreenImage simg = null;
        if (hasShot) {
            for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                if (simg == null && (simg = Screen.getScreen((int)is).prompt.getSelection()) != null) {
                    Screen.getScreen((int)is).lastScreenImage = simg;
                }
                Screen.getScreen((int)is).prompt.close();
            }
        }
        return simg;
    }

    public String saveCapture(String name) {
        return this.saveCapture(name, null);
    }

    public String saveCapture(String name, Region reg) {
        ScreenImage img = reg == null ? this.userCapture("Capture for image " + name) : this.capture(reg);
        if (img == null) {
            return null;
        }
        return img.saveInBundle(name);
    }

    public Region selectRegion() {
        return this.selectRegion(promptMsg);
    }

    public Region selectRegion(String message) {
        ScreenImage sim = this.userCapture(message);
        if (sim == null) {
            return null;
        }
        Rectangle r = sim.getROI();
        return Region.create((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public void update(EventSubject s) {
        this.waitPrompt = false;
    }

    @Override
    public void showTarget(Location loc) {
        this.showTarget(loc, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location loc, double secs) {
        if (Settings.isShowActions()) {
            ScreenHighlighter overlay = new ScreenHighlighter(this, null);
            overlay.showTarget(loc, (float)secs);
        }
    }

    @Override
    public String toString() {
        Rectangle r = this.getBounds();
        return String.format("S(%d)[%d,%d %dx%d] E:%s, T:%.1f", this.curID, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight(), this.getThrowException() ? "Y" : "N", this.getAutoWaitTimeout());
    }

    @Override
    public String toStringShort() {
        Rectangle r = this.getBounds();
        return String.format("S(%d)[%d,%d %dx%d]", this.curID, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public String toJSON() {
        Rectangle r = this.getBounds();
        return String.format("[\"S\", %d, %d, %d, %d, %d]", r.x, r.y, r.width, r.height, this.curID);
    }

    static {
        globalRobot = null;
        screens = null;
        primaryScreen = -1;
        waitForScreenshot = 300;
        RunTime.loadLibrary("VisionProxy");
        Screen.initScreens(false);
    }
}

