/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import org.sikuli.basics.Settings;
import org.sikuli.natives.FindResult;
import org.sikuli.script.IScreen;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.Region;

public class Match
extends Region
implements Comparable<Match> {
    private double simScore;
    private Location target = null;
    private Image image = null;
    private String ocrText = null;
    private long lastSearchTime = -1L;
    private long lastFindTime = -1L;
    private int index = -1;
    private boolean onScreen = true;

    public void setOnScreen(boolean state) {
        this.onScreen = state;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setTimes(long ftime, long stime) {
        this.lastFindTime = ftime;
        this.lastSearchTime = stime;
    }

    public long getTime() {
        return this.lastFindTime;
    }

    public Match(Match m) {
        this.init(m.x, m.y, m.w, m.h, m.getScreen());
        this.copy(m);
    }

    public Match(Region reg, double sc) {
        this.init(reg.x, reg.y, reg.w, reg.h, reg.getScreen());
        this.simScore = sc;
    }

    private Match(Match m, IScreen parent) {
        this.init(m.x, m.y, m.w, m.h, parent);
        this.copy(m);
    }

    protected Match(int x, int y, int w, int h, double Score, IScreen parent, String text) {
        this.init(x, y, w, h, parent);
        this.simScore = Score;
        this.ocrText = text;
    }

    private Match(int _x, int _y, int _w, int _h, double score, IScreen _parent) {
        this.init(_x, _y, _w, _h, _parent);
        this.simScore = score;
    }

    protected Match(FindResult f, IScreen _parent) {
        this.init(f.getX(), f.getY(), f.getW(), f.getH(), _parent);
        this.simScore = f.getScore();
    }

    private void init(int X, int Y, int W, int H, IScreen parent) {
        this.x = X;
        this.y = Y;
        this.w = W;
        this.h = H;
        this.setScreen(parent);
    }

    private void copy(Match m) {
        this.simScore = m.simScore;
        this.ocrText = m.ocrText;
        this.image = m.image;
        this.target = null;
        if (m.target != null) {
            this.target = new Location(m.target);
        }
        this.lastFindTime = m.lastFindTime;
        this.lastSearchTime = m.lastSearchTime;
    }

    public double getScore() {
        return this.simScore;
    }

    @Override
    public Location getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return this.getCenter();
    }

    public void setTargetOffset(Location offset) {
        this.target = new Location(this.getCenter());
        this.target.translate(offset.x, offset.y);
    }

    public void setTargetOffset(int x, int y) {
        this.setTargetOffset(new Location(x, y));
    }

    public Location getTargetOffset() {
        return this.getCenter().getOffset(this.getTarget());
    }

    protected void setImage(Image img) {
        this.image = img;
        if (Settings.Highlight) {
            this.highlight(Settings.DefaultHighlightTime);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getImageFilename() {
        return this.image.getFilename();
    }

    public String getText() {
        return this.ocrText;
    }

    @Override
    public int compareTo(Match m) {
        if (this.simScore != m.simScore) {
            return this.simScore < m.simScore ? -1 : 1;
        }
        if (this.x != m.x) {
            return this.x - m.x;
        }
        if (this.y != m.y) {
            return this.y - m.y;
        }
        if (this.w != m.w) {
            return this.w - m.w;
        }
        if (this.h != m.h) {
            return this.h - m.h;
        }
        if (this.equals(m)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof Match)) {
            return false;
        }
        Match that = (Match)oThat;
        return this.x == that.x && this.y == that.y && this.w == that.w && this.h == that.h && Math.abs(this.simScore - that.simScore) < 1.0E-5 && this.getTarget().equals(that.getTarget());
    }

    @Override
    public String toString() {
        Location c = this.getCenter();
        String starget = this.target != null && !c.equals(this.target) ? String.format("T:%d,%d", this.target.x, this.target.y) : String.format("C:%d,%d", c.x, c.y);
        String findTimes = String.format("[%d msec]", this.lastSearchTime);
        return String.format("M[%d,%d %dx%d]@S(%s) S:%.2f %s %s", this.x, this.y, this.w, this.h, this.getScreen() == null || !this.onScreen ? "?" : this.getScreen().toStringShort(), this.simScore, starget, findTimes);
    }

    @Override
    public String toStringShort() {
        return String.format("M[%d,%d %dx%d]@S(%s)", this.x, this.y, this.w, this.h, this.getScreen() == null ? "?" : Integer.valueOf(this.getScreen().getID()));
    }

    @Override
    public String toJSON() {
        int tx = 0;
        int ty = 0;
        if (this.target == null) {
            tx = this.getCenter().x;
            ty = this.getCenter().y;
        } else {
            tx = this.target.x;
            ty = this.target.y;
        }
        long intScore = Math.round(this.simScore * 100.0);
        return String.format("[\"M\", %d, %d, %d, %d, %d, %d, %d]", this.x, this.y, this.w, this.h, intScore, tx, ty);
    }

    public void setTarget(int tx, int ty) {
        this.target = new Location(tx, ty);
    }
}

