/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import org.sikuli.basics.Debug;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxCircle
extends Visual {
    public SxCircle(Region region) {
        this.init(region);
    }

    public SxCircle(Visual comp) {
        this.init(comp.getRegion());
    }

    public SxCircle() {
        this.init(null);
    }

    private void init(Region region) {
        if (region != null) {
            this.targetRegion = region;
        } else {
            Debug.log(2, "SikuliGuideRectangle: targetRegion is given as null", new Object[0]);
            this.targetRegion = Region.create(0, 0, 2 * this.stroke, 2 * this.stroke);
        }
        this.setColor(Color.RED);
    }

    @Override
    public void updateComponent() {
        this.setActualBounds(this.getTarget().getRect());
        this.setForeground(this.colorFront);
        super.setLocationRelative(Visual.Layout.OVER);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke pen = new BasicStroke(this.stroke);
        g2d.setStroke(pen);
        Rectangle r = new Rectangle(this.getActualBounds());
        r.grow(-(this.stroke - 1), -(this.stroke - 1));
        g2d.translate(this.stroke - 1, this.stroke - 1);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, r.width - 1, r.height - 1);
        g2d.draw(ellipse);
    }
}

