/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import org.sikuli.guide.HTMLTextPane;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxCallout
extends Visual {
    static final int TRIANGLE_SIZE = 20;
    static int defMaxWidth = 400;
    static int defFontSize = 14;
    static String defFont = "Verdana";
    HTMLTextPane textArea;
    RoundedBox rbox;
    Triangle triangle;
    int dx = 0;
    int dy = 0;

    public SxCallout(String text) {
        this.init(text);
    }

    void init(String text) {
        this.layout = Visual.Layout.RIGHT;
        this.maxWidth = defMaxWidth;
        this.fontName = defFont;
        this.fontSize = defFontSize;
        this.text = text;
        this.textArea = new HTMLTextPane(this);
        this.rbox = new RoundedBox(this.textArea.getBounds());
        this.add(this.textArea);
        this.add(this.rbox);
        this.triangle = new Triangle();
        this.add(this.triangle);
        this.targetRegion = null;
        this.setColors(null, Color.YELLOW, Color.YELLOW, null, null);
        this.makeComponent();
    }

    @Override
    public void updateComponent() {
        this.textArea.setText(this.text);
        this.textArea.setLocation(this.PADDING_X, this.PADDING_Y);
        Rectangle rect = this.textArea.getBounds();
        rect.grow(this.PADDING_X, this.PADDING_Y);
        this.rbox.setBounds(rect);
        this.makeComponent();
        this.triangle.setForeground(this.colorBack);
        this.rbox.setForeground(this.colorBack);
        if (this.targetRegion != null) {
            super.setLocationRelativeToRegion(this.targetRegion, this.layout);
        }
    }

    @Override
    public Visual setLocationRelativeToRegion(Region region, Visual.Layout side) {
        if (side != this.layout) {
            this.layout = side;
            this.updateComponent();
        }
        this.targetRegion = region;
        return super.setLocationRelativeToRegion(this.targetRegion, side);
    }

    private void makeComponent() {
        if (this.layout == Visual.Layout.TOP) {
            this.triangle.rotate(0.0);
            this.dx = 0;
            this.dy = 0;
            this.triangle.setLocationRelativeToComponent(this.rbox, Visual.Layout.BOTTOM);
        } else if (this.layout == Visual.Layout.BOTTOM) {
            this.dx = 0;
            this.dy = 20;
            this.triangle.rotate(Math.PI);
            this.triangle.setLocationRelativeToComponent(this.rbox, Visual.Layout.TOP);
        } else if (this.layout == Visual.Layout.LEFT) {
            this.dx = 0;
            this.dy = 0;
            this.triangle.rotate(-1.5707963267948966);
            this.triangle.setLocationRelativeToComponent(this.rbox, Visual.Layout.RIGHT);
        } else if (this.layout == Visual.Layout.RIGHT) {
            this.dx = 20;
            this.dy = 0;
            this.triangle.rotate(1.5707963267948966);
            this.triangle.setLocationRelativeToComponent(this.rbox, Visual.Layout.LEFT);
        }
        Rectangle bounds = this.rbox.getBounds();
        bounds.add(this.triangle.getBounds());
        this.setActualBounds(bounds);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.translate(this.dx, this.dy);
        super.paintComponent(g);
    }

    class RoundedBox
    extends Visual {
        public RoundedBox(Rectangle rect) {
            this.setActualBounds(rect);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 15.0f, 15.0f);
            g2d.fill(roundedRectangle);
        }
    }

    class Triangle
    extends Visual {
        GeneralPath gp;

        public Triangle() {
            this.init();
        }

        private void init() {
            this.gp = new GeneralPath();
            this.gp.moveTo(9.0, 0.0);
            this.gp.lineTo(10.0, 20.0);
            this.gp.lineTo(17.0, 0.0);
            this.gp.closePath();
            this.setActualSize(new Dimension(20, 20));
        }

        public void rotate(double radius) {
            this.init();
            AffineTransform rat = new AffineTransform();
            rat.rotate(radius, 10.0, 10.0);
            this.gp.transform(rat);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fill(this.gp);
        }
    }
}

