/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Point;
import org.sikuli.guide.LinearStepper;
import org.sikuli.guide.NewAnimator;
import org.sikuli.guide.Visual;

class CircleAnimator
extends NewAnimator {
    LinearStepper radiusStepper;
    Point origin;
    float radius;

    CircleAnimator(Visual sklComponent, Point origin, float radius) {
        super(sklComponent);
        this.radius = radius;
        this.origin = origin;
        this.setLooping(true);
    }

    @Override
    protected void init() {
        this.radiusStepper = new LinearStepper(0.0f, (float)Math.PI * 2, 20);
    }

    @Override
    protected boolean isRunning() {
        return this.radiusStepper.hasNext();
    }

    @Override
    protected void animate() {
        float theta = this.radiusStepper.next();
        int x = (int)((double)this.origin.x + (double)((int)this.radius) * Math.sin(theta));
        int y = (int)((double)this.origin.y + (double)((int)this.radius) * Math.cos(theta));
        this.sklComponent.setActualLocation(x, y);
    }
}

