/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import com.melloware.jintellitype.JIntellitype;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.HotkeyEvent;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;

public class WindowsHotkeyManager
extends HotkeyManager {
    private Map<Integer, HotkeyData> _idCallbackMap = new HashMap<Integer, HotkeyData>();
    private int _gHotkeyId = 1;

    @Override
    public boolean _addHotkey(int keyCode, int modifiers, HotkeyListener listener) {
        JIntellitype itype = null;
        try {
            itype = JIntellitype.getInstance();
        }
        catch (Exception ex) {
            Debug.error("WindowsHotkeyManager: JIntellitype problem: %s", ex.getMessage());
        }
        if (itype == null) {
            System.exit(1);
        }
        if (this._gHotkeyId == 1) {
            itype.addHotKeyListener(new JIntellitypeHandler());
        }
        this._removeHotkey(keyCode, modifiers);
        int id = this._gHotkeyId++;
        HotkeyData data = new HotkeyData(keyCode, modifiers, listener);
        this._idCallbackMap.put(id, data);
        itype.registerHotKey(id, this.translateMod(modifiers), keyCode);
        return true;
    }

    @Override
    public boolean _removeHotkey(int keyCode, int modifiers) {
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            HotkeyData data = entry.getValue();
            if (data.key != keyCode || data.modifiers != modifiers) continue;
            JIntellitype itype = JIntellitype.getInstance();
            int id = entry.getKey();
            itype.unregisterHotKey(id);
            this._idCallbackMap.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public void cleanUp() {
        JIntellitype itype = JIntellitype.getInstance();
        for (Map.Entry<Integer, HotkeyData> entry : this._idCallbackMap.entrySet()) {
            int id = entry.getKey();
            itype.unregisterHotKey(id);
        }
        this._gHotkeyId = 1;
        this._idCallbackMap.clear();
        itype.cleanUp();
    }

    private int translateMod(int mod) {
        int newMod = 0;
        if (1 == (mod & 1)) {
            newMod += 4;
        }
        if (2 == (mod & 2)) {
            newMod += 2;
        }
        if (4 == (mod & 4)) {
            newMod += 8;
        }
        if (8 == (mod & 8)) {
            ++newMod;
        }
        return newMod;
    }

    class JIntellitypeHandler
    implements com.melloware.jintellitype.HotkeyListener {
        JIntellitypeHandler() {
        }

        @Override
        public void onHotKey(int id) {
            Debug.log(4, "Hotkey pressed", new Object[0]);
            HotkeyData data = (HotkeyData)WindowsHotkeyManager.this._idCallbackMap.get(id);
            HotkeyEvent e = new HotkeyEvent(data.key, data.modifiers);
            data.listener.invokeHotkeyPressed(e);
        }
    }

    class HotkeyData {
        int key;
        int modifiers;
        HotkeyListener listener;

        public HotkeyData(int key_, int mod_, HotkeyListener l_) {
            this.key = key_;
            this.modifiers = mod_;
            this.listener = l_;
        }
    }
}

