/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.remoteserver.javalib.OverloadableKeyword;

public class SimpleKeywordExtractor
implements IKeywordExtractor<OverloadableKeyword> {
    @Override
    public Map<String, OverloadableKeyword> extractKeywords(Object keywordBean) {
        Method[] methods;
        HashMap<String, OverloadableKeyword> overloadableKeywords = new HashMap<String, OverloadableKeyword>();
        for (Method method : methods = keywordBean.getClass().getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isPublic(method.getModifiers())) continue;
            this.createOrUpdateKeyword(overloadableKeywords, keywordBean, method);
        }
        return overloadableKeywords;
    }

    private void createOrUpdateKeyword(Map<String, OverloadableKeyword> extractedKeywords, Object keywordBean, Method method) {
        String name = method.getName();
        if (extractedKeywords.containsKey(name)) {
            extractedKeywords.get(name).addOverload(method);
        } else {
            extractedKeywords.put(name, new OverloadableKeyword(keywordBean, method));
        }
    }
}

