/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver;

import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.robotframework.remoteserver.cli.CommandLineHelper;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.logging.Jetty2Log4J;
import org.robotframework.remoteserver.servlet.IllegalPathException;
import org.robotframework.remoteserver.servlet.RemoteServerServlet;

public class RemoteServer {
    private static org.apache.commons.logging.Log log = LogFactory.getLog(RemoteServer.class);
    protected Server server = new Server();
    private RemoteServerServlet servlet = new RemoteServerServlet();
    private SelectChannelConnector connector = new SelectChannelConnector();

    public RemoteServer() {
        this.connector.setName("jrobotremoteserver");
        this.server.setConnectors(new Connector[]{this.connector});
        ServletContextHandler servletContextHandler = new ServletContextHandler(this.server, "/", false, false);
        servletContextHandler.addServlet(new ServletHolder(this.servlet), "/");
    }

    public Integer getLocalPort() {
        return this.connector.getLocalPort();
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public boolean getAllowStop() {
        return this.servlet.getAllowStop();
    }

    public void setAllowStop(boolean allowed) {
        this.servlet.setAllowStop(allowed);
    }

    public String getHost() {
        return this.connector.getHost();
    }

    public void setHost(String hostName) {
        this.connector.setHost(hostName);
    }

    public static void main(String[] args) throws Exception {
        RemoteServer.configureLogging();
        CommandLineHelper helper = new CommandLineHelper(args);
        if (helper.getHelpRequested()) {
            System.out.print(helper.getUsage());
            System.exit(0);
        }
        RemoteServer remoteServer = new RemoteServer();
        String error = helper.getError();
        if (error == null) {
            try {
                for (String path : helper.getLibraryMap().keySet()) {
                    remoteServer.putLibrary(path, helper.getLibraryMap().get(path));
                }
            }
            catch (IllegalPathException e) {
                error = e.getMessage();
            }
        }
        if (error != null) {
            System.out.println("Error: " + error);
            System.out.println();
            System.out.println(helper.getUsage());
            System.exit(1);
        }
        remoteServer.setPort(helper.getPort());
        remoteServer.setAllowStop(helper.getAllowStop());
        remoteServer.setHost(helper.getHost());
        remoteServer.start();
    }

    public RemoteLibrary putLibrary(String path, Object library) {
        RemoteLibrary oldLibrary = this.servlet.putLibrary(path, library);
        String name = this.servlet.getLibraryMap().get(path).getName();
        log.info(String.format("Mapped path %s to library %s.", path, name));
        return oldLibrary;
    }

    public RemoteLibrary removeLibrary(String path) {
        return this.servlet.removeLibrary(path);
    }

    public Map<String, RemoteLibrary> getLibraryMap() {
        return this.servlet.getLibraryMap();
    }

    @Deprecated
    public void addLibrary(String className, int port) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addLibrary(clazz, port);
    }

    @Deprecated
    public void addLibrary(Class<?> clazz, int port) {
        Object library;
        if (!this.server.isStopped()) {
            throw new IllegalStateException("Cannot add a library once the server is started");
        }
        if (this.connector.getPort() != 0 && this.connector.getPort() != port) {
            throw new RuntimeException("Serving on multiple ports is no longer supported. Please use putLibrary with different paths instead.");
        }
        if (this.servlet.getLibraryMap().keySet().contains("/")) {
            throw new RuntimeException("A library has already been mapped to /.");
        }
        try {
            library = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setPort(port);
        this.putLibrary("/", library);
    }

    public void stop(int timeoutMS) throws Exception {
        log.info("Robot Framework remote server stopping");
        if (timeoutMS > 0) {
            this.server.setGracefulShutdown(timeoutMS);
            Thread stopper = new Thread(){

                @Override
                public void run() {
                    try {
                        RemoteServer.this.server.stop();
                    }
                    catch (Throwable e) {
                        log.error(String.format("Failed to stop the server: %s", e.getMessage()), e);
                    }
                }
            };
            stopper.start();
        } else {
            this.server.stop();
        }
    }

    public void stop() throws Exception {
        this.stop(0);
    }

    public void start() throws Exception {
        log.info("Robot Framework remote server starting");
        this.server.start();
        log.info(String.format("Robot Framework remote server started on port %d.", this.getLocalPort()));
    }

    public static void configureLogging() {
        Logger root = Logger.getRootLogger();
        root.removeAllAppenders();
        BasicConfigurator.configure();
        root.setLevel(Level.INFO);
        Log.setLog(new Jetty2Log4J());
        LogFactory.releaseAll();
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
        log = LogFactory.getLog(RemoteServer.class);
    }
}

