/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.reflection;

import java.lang.reflect.Method;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.com.thoughtworks.paranamer.CachingParanamer;
import org.robotframework.javalib.com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import org.robotframework.javalib.com.thoughtworks.paranamer.Paranamer;
import org.robotframework.javalib.reflection.ArgumentConverter;
import org.robotframework.javalib.reflection.ArgumentGrouper;
import org.robotframework.javalib.reflection.IArgumentConverter;
import org.robotframework.javalib.reflection.IArgumentGrouper;
import org.robotframework.javalib.reflection.IKeywordInvoker;

public class KeywordInvoker
implements IKeywordInvoker {
    protected Paranamer parameterNames = new CachingParanamer();
    private final Method method;
    private final Object obj;

    public KeywordInvoker(Object obj, Method method) {
        this.obj = obj;
        this.method = method;
    }

    public String[] getParameterNames() {
        if (this.method.isAnnotationPresent(ArgumentNames.class)) {
            return this.method.getAnnotation(ArgumentNames.class).value();
        }
        return this.getParameterNamesFromParanamer();
    }

    public Object invoke(Object[] args) {
        try {
            Object[] groupedArguments = this.createArgumentGrouper().groupArguments(args);
            Object[] convertedArguments = this.createArgumentConverter().convertArguments(groupedArguments);
            return this.method.invoke(this.obj, convertedArguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDocumentation() {
        return this.method.getAnnotation(RobotKeyword.class).value();
    }

    IArgumentConverter createArgumentConverter() {
        return new ArgumentConverter(this.method.getParameterTypes());
    }

    IArgumentGrouper createArgumentGrouper() {
        return new ArgumentGrouper(this.method.getParameterTypes());
    }

    private String[] getParameterNamesFromParanamer() {
        try {
            return this.parameterNames.lookupParameterNames(this.method);
        }
        catch (ParameterNamesNotFoundException e) {
            return null;
        }
    }
}

