/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.gpu;

public class DeviceInfo {
    protected final long nativeObj;

    protected DeviceInfo(long addr) {
        this.nativeObj = addr;
    }

    public DeviceInfo() {
        this.nativeObj = DeviceInfo.DeviceInfo_0();
    }

    public DeviceInfo(int device_id) {
        this.nativeObj = DeviceInfo.DeviceInfo_1(device_id);
    }

    public int deviceID() {
        int retVal = DeviceInfo.deviceID_0(this.nativeObj);
        return retVal;
    }

    public long freeMemory() {
        long retVal = DeviceInfo.freeMemory_0(this.nativeObj);
        return retVal;
    }

    public boolean isCompatible() {
        boolean retVal = DeviceInfo.isCompatible_0(this.nativeObj);
        return retVal;
    }

    public int majorVersion() {
        int retVal = DeviceInfo.majorVersion_0(this.nativeObj);
        return retVal;
    }

    public int minorVersion() {
        int retVal = DeviceInfo.minorVersion_0(this.nativeObj);
        return retVal;
    }

    public int multiProcessorCount() {
        int retVal = DeviceInfo.multiProcessorCount_0(this.nativeObj);
        return retVal;
    }

    public String name() {
        String retVal = DeviceInfo.name_0(this.nativeObj);
        return retVal;
    }

    public void queryMemory(long totalMemory, long freeMemory) {
        double[] totalMemory_out = new double[1];
        double[] freeMemory_out = new double[1];
        DeviceInfo.queryMemory_0(this.nativeObj, totalMemory_out, freeMemory_out);
        totalMemory = (long)totalMemory_out[0];
        freeMemory = (long)freeMemory_out[0];
    }

    public long sharedMemPerBlock() {
        long retVal = DeviceInfo.sharedMemPerBlock_0(this.nativeObj);
        return retVal;
    }

    public boolean supports(int feature_set) {
        boolean retVal = DeviceInfo.supports_0(this.nativeObj, feature_set);
        return retVal;
    }

    public long totalMemory() {
        long retVal = DeviceInfo.totalMemory_0(this.nativeObj);
        return retVal;
    }

    protected void finalize() throws Throwable {
        DeviceInfo.delete(this.nativeObj);
    }

    private static native long DeviceInfo_0();

    private static native long DeviceInfo_1(int var0);

    private static native int deviceID_0(long var0);

    private static native long freeMemory_0(long var0);

    private static native boolean isCompatible_0(long var0);

    private static native int majorVersion_0(long var0);

    private static native int minorVersion_0(long var0);

    private static native int multiProcessorCount_0(long var0);

    private static native String name_0(long var0);

    private static native void queryMemory_0(long var0, double[] var2, double[] var3);

    private static native long sharedMemPerBlock_0(long var0);

    private static native boolean supports_0(long var0, int var2);

    private static native long totalMemory_0(long var0);

    private static native void delete(long var0);
}

