/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.Framebuffer;
import edu.unh.iol.dlc.VNCClient;
import edu.unh.iol.dlc.VNCThread;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Locale;
import org.sikuli.basics.Debug;

public class ConnectionController
extends GraphicsEnvironment {
    protected ArrayList<VNCThread> threads = new ArrayList();
    private static ArrayList<ConnectionController> cons = new ArrayList();

    public ConnectionController(Socket ... sockets) {
        for (int i = 0; i < sockets.length; ++i) {
            this.threads.add(new VNCThread(sockets[i]));
        }
        cons.add(this);
    }

    protected VNCClient getC(int index) {
        return this.threads.get(index).getClient();
    }

    protected Framebuffer getF(int index) {
        return this.threads.get(index).getScreen();
    }

    public void openConnection(int index) {
        this.threads.get(index).openConnection(1, 1);
    }

    public void changeUpdateInterval(int index, int milliseconds) {
        this.threads.get(index).changePollInterval(milliseconds);
    }

    public void closeConnection(int index) {
        this.threads.get(index).terminate();
        this.threads.remove(index);
    }

    public void setPixelFormat(int index, String format, int bitsPerPixel, int bigEndianFlag) {
        try {
            Debug.log(3, "Setting Pixel format for thread: " + index, new Object[0]);
            this.threads.get(index).setPixelFormat(format, bitsPerPixel, bigEndianFlag);
        }
        catch (IOException io) {
            Debug.log(3, "Error: IO Exception" + io, new Object[0]);
        }
    }

    public void newConnection(Socket s) {
        this.threads.add(new VNCThread(s));
    }

    public void start(int index) {
        this.threads.get(index).start();
    }

    public int getNumberOfConnections() {
        return this.threads.size();
    }

    public static ConnectionController getActiveController(int index) {
        if (cons.isEmpty()) {
            return null;
        }
        return cons.get(index);
    }

    @Override
    public GraphicsDevice[] getScreenDevices() throws HeadlessException {
        if (ConnectionController.isHeadless()) {
            throw new HeadlessException();
        }
        GraphicsDevice[] fbs = new Framebuffer[this.threads.size()];
        for (int i = 0; i < fbs.length; ++i) {
            fbs[i] = this.threads.get(i).getScreen();
        }
        return fbs;
    }

    @Override
    public GraphicsDevice getDefaultScreenDevice() throws HeadlessException {
        if (ConnectionController.isHeadless()) {
            throw new HeadlessException();
        }
        return this.threads.get(0).getScreen();
    }

    @Override
    public Graphics2D createGraphics(BufferedImage img) {
        return img.createGraphics();
    }

    @Override
    public Font[] getAllFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    @Override
    public String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    @Override
    public String[] getAvailableFontFamilyNames(Locale l) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(l);
    }
}

