/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.task.OnTaskError;
import org.ow2.proactive.scheduler.common.task.RestartMode;
import org.ow2.proactive.scheduler.common.task.UpdatableProperties;
import org.ow2.proactive.scheduler.common.task.util.IntegerWrapper;
import org.ow2.proactive.scheduler.common.task.util.LongWrapper;
import org.ow2.proactive.scheduler.common.util.VariableSubstitutor;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class CommonAttribute
implements Serializable {
    public static final String GENERIC_INFO_START_AT_KEY = "START_AT";
    public static final Long DEFAULT_TASK_RETRY_DELAY = -1L;
    protected UpdatableProperties<RestartMode> restartTaskOnError = new UpdatableProperties<RestartMode>(RestartMode.ANYWHERE);
    protected UpdatableProperties<LongWrapper> taskRetryDelay = new UpdatableProperties<LongWrapper>(new LongWrapper(DEFAULT_TASK_RETRY_DELAY));
    protected UpdatableProperties<IntegerWrapper> maxNumberOfExecution = new UpdatableProperties<IntegerWrapper>(new IntegerWrapper(1));
    protected Map<String, String> genericInformation = new LinkedHashMap<String, String>();
    protected Map<String, String> unresolvedGenericInformation = new LinkedHashMap<String, String>();
    protected UpdatableProperties<OnTaskError> onTaskError = new UpdatableProperties<OnTaskError>(OnTaskError.NONE);
    private static final long serialVersionUID = 131L;

    public void setOnTaskError(OnTaskError onTaskError) {
        if (onTaskError == null) {
            throw new IllegalArgumentException("OnTaskError cannot be set to null.");
        }
        this.onTaskError.setValue(onTaskError);
    }

    public UpdatableProperties<OnTaskError> getOnTaskErrorProperty() {
        return this.onTaskError;
    }

    public Long getTaskRetryDelay() {
        return this.taskRetryDelay.getValue().getLongValue();
    }

    public UpdatableProperties<LongWrapper> getTaskRetryDelayProperty() {
        return this.taskRetryDelay;
    }

    public void setTaskRetryDelay(long taskRetryDelay) {
        this.taskRetryDelay.setValue(new LongWrapper(taskRetryDelay));
    }

    public RestartMode getRestartTaskOnError() {
        return this.restartTaskOnError.getValue();
    }

    public void setRestartTaskOnError(RestartMode restartOnError) {
        this.restartTaskOnError.setValue(restartOnError);
    }

    public UpdatableProperties<RestartMode> getRestartTaskOnErrorProperty() {
        return this.restartTaskOnError;
    }

    public int getMaxNumberOfExecution() {
        return this.maxNumberOfExecution.getValue().getIntegerValue();
    }

    public void setMaxNumberOfExecution(int numberOfExecution) {
        if (numberOfExecution <= 0) {
            throw new IllegalArgumentException("The number of execution must be a non negative integer (>0) !");
        }
        this.maxNumberOfExecution.setValue(new IntegerWrapper(numberOfExecution));
    }

    public UpdatableProperties<IntegerWrapper> getMaxNumberOfExecutionProperty() {
        return this.maxNumberOfExecution;
    }

    public Map<String, String> getGenericInformation() {
        Set<Map.Entry<String, String>> entries = this.genericInformation.entrySet();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, String> getUnresolvedGenericInformation() {
        Set<Map.Entry<String, String>> entries = this.unresolvedGenericInformation.entrySet();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void addGenericInformation(String key, String genericInformation) {
        if (key != null && key.length() > 255) {
            throw new IllegalArgumentException("Key is too long, it must have 255 chars length max : " + key);
        }
        this.genericInformation.put(key, genericInformation);
    }

    public void addGenericInformations(Map<String, String> genericInformations) {
        if (genericInformations != null) {
            Set<Map.Entry<String, String>> entries = genericInformations.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.addGenericInformation(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setGenericInformation(Map<String, String> genericInformation) {
        this.genericInformation = genericInformation != null ? genericInformation : new LinkedHashMap<String, String>();
    }

    public void setUnresolvedGenericInformation(Map<String, String> unresolvedGenericInformation) {
        this.unresolvedGenericInformation = unresolvedGenericInformation != null ? unresolvedGenericInformation : new LinkedHashMap<String, String>();
    }

    protected static Map<String, String> applyReplacementsOnGenericInformation(Map<String, String> genericInformation, Map<String, Serializable> variables) {
        return VariableSubstitutor.filterAndUpdate(genericInformation, variables);
    }
}

