#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Apr 29 08:31:10 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

from cybox.bindings import cybox_core
from cybox.bindings import cybox_common
from cybox.bindings import code_object
from cybox.bindings import process_object
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return unicode(s1)

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return unicode(s1)

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class BehaviorType(GeneratedsSuper):
    """The BehaviorType is one of the foundational MAEC types, and serves
    as a method for the characterization of malicious behaviors
    found or observed in malware. Behaviors can be thought of as
    representing the purpose behind groups of MAEC Actions, and are
    therefore representative of distinct portions of higher-level
    malware functionality. Thus, while a malware instance may
    perform some multitude of Actions, it is likely that these
    Actions represent only a few distinct behaviors. Some examples
    include vulnerability exploitation, email address harvesting,
    the disabling of a security service, etc.The required id field
    specifies a unique ID for this Behavior. The ID must follow the
    pattern defined in the BehaviorIDPattern simple type.The
    ordinal_position field specifies the ordinal position of the
    Behavior with respect to the execution of the malware.The status
    field specifies the execution status of the Behavior being
    characterized.The duration field specifies the duration of the
    Behavior. One way to derive such a value may be to calculate the
    difference between the timestamps of the first and last actions
    that compose the behavior."""
    subclass = None
    superclass = None
    def __init__(self, status=None, duration=None, ordinal_position=None, id=None, Purpose=None, Description=None, Discovery_Method=None, Action_Composition=None, Associated_Code=None, Relationships=None):
        self.status = _cast(None, status)
        self.duration = _cast(None, duration)
        self.ordinal_position = _cast(int, ordinal_position)
        self.id = _cast(None, id)
        self.Purpose = Purpose
        self.Description = Description
        self.Discovery_Method = Discovery_Method
        self.Action_Composition = Action_Composition
        self.Associated_Code = Associated_Code
        self.Relationships = Relationships
    def factory(*args_, **kwargs_):
        if BehaviorType.subclass:
            return BehaviorType.subclass(*args_, **kwargs_)
        else:
            return BehaviorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Action_Composition(self): return self.Action_Composition
    def set_Action_Composition(self, Action_Composition): self.Action_Composition = Action_Composition
    def get_Associated_Code(self): return self.Associated_Code
    def set_Associated_Code(self, Associated_Code): self.Associated_Code = Associated_Code
    def get_Relationships(self): return self.Relationships
    def set_Relationships(self, Relationships): self.Relationships = Relationships
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Purpose is not None or
            self.Description is not None or
            self.Discovery_Method is not None or
            self.Action_Composition is not None or
            self.Associated_Code is not None or
            self.Relationships is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorType'):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (quote_attrib(self.status), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (self.gds_format_string(quote_attrib(self.duration).encode(ExternalEncoding), input_name='duration'), ))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            outfile.write(' ordinal_position="%s"' % self.gds_format_integer(self.ordinal_position, input_name='ordinal_position'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Purpose is not None:
            self.Purpose.export(outfile, level, 'maecBundle:', name_='Purpose', pretty_print=pretty_print)
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
        if self.Discovery_Method is not None:
            self.Discovery_Method.export(outfile, level, 'maecBundle:', name_='Discovery_Method', pretty_print=pretty_print)
        if self.Action_Composition is not None:
            self.Action_Composition.export(outfile, level, 'maecBundle:', name_='Action_Composition', pretty_print=pretty_print)
        if self.Associated_Code is not None:
            self.Associated_Code.export(outfile, level, 'maecBundle:', name_='Associated_Code', pretty_print=pretty_print)
        if self.Relationships is not None:
            self.Relationships.export(outfile, level, 'maecBundle:', name_='Relationships', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status = %s,\n' % (self.status,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration = "%s",\n' % (self.duration,))
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Purpose is not None:
            outfile.write('Purpose=model_.BehaviorPurposeType(\n')
            self.Purpose.exportLiteral(outfile, level, name_='Purpose')
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Discovery_Method is not None:
            outfile.write('Discovery_Method=model_.cybox_common.MeasureSourceType(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            outfile.write('),\n')
        if self.Action_Composition is not None:
            outfile.write('Action_Composition=model_.BehavioralActionsType(\n')
            self.Action_Composition.exportLiteral(outfile, level, name_='Action_Composition')
            outfile.write('),\n')
        if self.Associated_Code is not None:
            outfile.write('Associated_Code=model_.AssociatedCodeType(\n')
            self.Associated_Code.exportLiteral(outfile, level, name_='Associated_Code')
            outfile.write('),\n')
        if self.Relationships is not None:
            outfile.write('Relationships=model_.BehaviorRelationshipListType(\n')
            self.Relationships.exportLiteral(outfile, level, name_='Relationships')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
        value = find_attr_value_('ordinal_position', node)
        if value is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            try:
                self.ordinal_position = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.ordinal_position <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Purpose':
            obj_ = BehaviorPurposeType.factory()
            obj_.build(child_)
            self.set_Purpose(obj_)
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Discovery_Method':
            obj_ = cybox_common.MeasureSourceType.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif nodeName_ == 'Action_Composition':
            obj_ = BehavioralActionsType.factory()
            obj_.build(child_)
            self.set_Action_Composition(obj_)
        elif nodeName_ == 'Associated_Code':
            obj_ = AssociatedCodeType.factory()
            obj_.build(child_)
            self.set_Associated_Code(obj_)
        elif nodeName_ == 'Relationships':
            obj_ = BehaviorRelationshipListType.factory()
            obj_.build(child_)
            self.set_Relationships(obj_)
# end class BehaviorType

class BundleType(GeneratedsSuper):
    """The BundleType serves as the high-level construct which encapsulates
    all Bundle elements, and represents some characterized analysis
    data (from any arbitrary set of analyses) for a single malware
    instance in terms of its MAEC Components (e.g., Behaviors,
    Actions, Objects, etc.).The required id field specifies a unique
    ID for this MAEC Bundle. The ID must follow the pattern defined
    in the BundleIDPattern simple type.The required schema_version
    field specifies the version of the MAEC Bundle Schema that the
    document has been written in and that should be used for
    validation.The required defined_subject field specifies whether
    the subject attributes of the malware instance characterized
    here are included inside this Bundle (via the top-level
    Malware_Instance_Object_Attributes element) or elsewhere (such
    as a MAEC Subject in a MAEC Package).The content_type field
    specifies the general type of content contained in this Bundle,
    e.g. static analysis tool output, dynamic analysis tool output,
    etc.The timestamp field specifies the date/time that the bundle
    was generated."""
    subclass = None
    superclass = None
    def __init__(self, defined_subject=None, content_type=None, id=None, schema_version=None, timestamp=None, Malware_Instance_Object_Attributes=None, AV_Classifications=None, Process_Tree=None, Behaviors=None, Actions=None, Objects=None, Candidate_Indicators=None, Collections=None):
        self.defined_subject = _cast(bool, defined_subject)
        self.content_type = _cast(None, content_type)
        self.id = _cast(None, id)
        self.schema_version = schema_version
        self.timestamp = _cast(None, timestamp)
        self.Malware_Instance_Object_Attributes = Malware_Instance_Object_Attributes
        self.AV_Classifications = AV_Classifications
        self.Process_Tree = Process_Tree
        self.Behaviors = Behaviors
        self.Actions = Actions
        self.Objects = Objects
        self.Candidate_Indicators = Candidate_Indicators
        self.Collections = Collections
    def factory(*args_, **kwargs_):
        if BundleType.subclass:
            return BundleType.subclass(*args_, **kwargs_)
        else:
            return BundleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Malware_Instance_Object_Attributes(self): return self.Malware_Instance_Object_Attributes
    def set_Malware_Instance_Object_Attributes(self, Malware_Instance_Object_Attributes): self.Malware_Instance_Object_Attributes = Malware_Instance_Object_Attributes
    def get_AV_Classifications(self): return self.AV_Classifications
    def set_AV_Classifications(self, AV_Classifications): self.AV_Classifications = AV_Classifications
    def get_Process_Tree(self): return self.Process_Tree
    def set_Process_Tree(self, Process_Tree): self.Process_Tree = Process_Tree
    def get_Behaviors(self): return self.Behaviors
    def set_Behaviors(self, Behaviors): self.Behaviors = Behaviors
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def get_Objects(self): return self.Objects
    def set_Objects(self, Objects): self.Objects = Objects
    def get_Candidate_Indicators(self): return self.Candidate_Indicators
    def set_Candidate_Indicators(self, Candidate_Indicators): self.Candidate_Indicators = Candidate_Indicators
    def get_Collections(self): return self.Collections
    def set_Collections(self, Collections): self.Collections = Collections
    def get_defined_subject(self): return self.defined_subject
    def set_defined_subject(self, defined_subject): self.defined_subject = defined_subject
    def get_content_type(self): return self.content_type
    def set_content_type(self, content_type): self.content_type = content_type
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_schema_version(self): return self.schema_version
    def set_schema_version(self, schema_version): self.schema_version = schema_version
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def hasContent_(self):
        if (
            self.Malware_Instance_Object_Attributes is not None or
            self.AV_Classifications is not None or
            self.Process_Tree is not None or
            self.Behaviors is not None or
            self.Actions is not None or
            self.Objects is not None or
            self.Candidate_Indicators is not None or
            self.Collections is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='MAEC_Bundle', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MAEC_Bundle')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='MAEC_Bundle'):
        if self.defined_subject is not None and 'defined_subject' not in already_processed:
            already_processed.add('defined_subject')
            outfile.write(' defined_subject="%s"' % self.gds_format_boolean(self.defined_subject, input_name='defined_subject'))
        if self.content_type is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            outfile.write(' content_type=%s' % (quote_attrib(self.content_type), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.schema_version is not None and 'schema_version' not in already_processed:
            already_processed.add('schema_version')
            outfile.write(' schema_version="%s"' % self.schema_version)
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            outfile.write(' timestamp="%s"' % self.timestamp)
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='MAEC_Bundle', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Malware_Instance_Object_Attributes is not None:
            self.Malware_Instance_Object_Attributes.export(outfile, level, 'maecBundle:', name_='Malware_Instance_Object_Attributes', pretty_print=pretty_print)
        if self.AV_Classifications is not None:
            self.AV_Classifications.export(outfile, level, 'maecBundle:', name_='AV_Classifications', pretty_print=pretty_print)
        if self.Process_Tree is not None:
            self.Process_Tree.export(outfile, level, 'maecBundle:', name_='Process_Tree', pretty_print=pretty_print)
        if self.Behaviors is not None:
            self.Behaviors.export(outfile, level, 'maecBundle:', name_='Behaviors', pretty_print=pretty_print)
        if self.Actions is not None:
            self.Actions.export(outfile, level, 'maecBundle:', name_='Actions', pretty_print=pretty_print)
        if self.Objects is not None:
            self.Objects.export(outfile, level, 'maecBundle:', name_='Objects', pretty_print=pretty_print)
        if self.Candidate_Indicators is not None:
            self.Candidate_Indicators.export(outfile, level, 'maecBundle:', name_='Candidate_Indicators', pretty_print=pretty_print)
        if self.Collections is not None:
            self.Collections.export(outfile, level, 'maecBundle:', name_='Collections', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MAEC_Bundle'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.defined_subject is not None and 'defined_subject' not in already_processed:
            already_processed.add('defined_subject')
            showIndent(outfile, level)
            outfile.write('defined_subject = %s,\n' % (self.defined_subject,))
        if self.content_type is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            showIndent(outfile, level)
            outfile.write('content_type = %s,\n' % (self.content_type,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.schema_version is not None and 'schema_version' not in already_processed:
            already_processed.add('schema_version')
            showIndent(outfile, level)
            outfile.write('schema_version = %s,\n' % (self.schema_version,))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            showIndent(outfile, level)
            outfile.write('timestamp = "%s",\n' % (self.timestamp,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Malware_Instance_Object_Attributes is not None:
            outfile.write('Malware_Instance_Object_Attributes=model_.cybox_core.ObjectType(\n')
            self.Malware_Instance_Object_Attributes.exportLiteral(outfile, level, name_='Malware_Instance_Object_Attributes')
            outfile.write('),\n')
        if self.AV_Classifications is not None:
            outfile.write('AV_Classifications=model_.AVClassificationsType(\n')
            self.AV_Classifications.exportLiteral(outfile, level, name_='AV_Classifications')
            outfile.write('),\n')
        if self.Process_Tree is not None:
            outfile.write('Process_Tree=model_.ProcessTreeType(\n')
            self.Process_Tree.exportLiteral(outfile, level, name_='Process_Tree')
            outfile.write('),\n')
        if self.Behaviors is not None:
            outfile.write('Behaviors=model_.BehaviorListType(\n')
            self.Behaviors.exportLiteral(outfile, level, name_='Behaviors')
            outfile.write('),\n')
        if self.Actions is not None:
            outfile.write('Actions=model_.ActionListType(\n')
            self.Actions.exportLiteral(outfile, level, name_='Actions')
            outfile.write('),\n')
        if self.Objects is not None:
            outfile.write('Objects=model_.ObjectListType(\n')
            self.Objects.exportLiteral(outfile, level, name_='Objects')
            outfile.write('),\n')
        if self.Candidate_Indicators is not None:
            outfile.write('Candidate_Indicators=model_.CandidateIndicatorListType(\n')
            self.Candidate_Indicators.exportLiteral(outfile, level, name_='Candidate_Indicators')
            outfile.write('),\n')
        if self.Collections is not None:
            outfile.write('Collections=model_.CollectionsType(\n')
            self.Collections.exportLiteral(outfile, level, name_='Collections')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('defined_subject', node)
        if value is not None and 'defined_subject' not in already_processed:
            already_processed.add('defined_subject')
            if value in ('true', '1'):
                self.defined_subject = True
            elif value in ('false', '0'):
                self.defined_subject = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('content_type', node)
        if value is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            self.content_type = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('schema_version', node)
        if value is not None and 'schema_version' not in already_processed:
            already_processed.add('schema_version')
            self.schema_version = value
        value = find_attr_value_('timestamp', node)
        if value is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            try:
                self.timestamp = value
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (timestamp): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Malware_Instance_Object_Attributes':
            obj_ = cybox_core.ObjectType.factory()
            obj_.build(child_)
            self.set_Malware_Instance_Object_Attributes(obj_)
        elif nodeName_ == 'AV_Classifications':
            obj_ = AVClassificationsType.factory()
            obj_.build(child_)
            self.set_AV_Classifications(obj_)
        elif nodeName_ == 'Process_Tree':
            obj_ = ProcessTreeType.factory()
            obj_.build(child_)
            self.set_Process_Tree(obj_)
        elif nodeName_ == 'Behaviors':
            obj_ = BehaviorListType.factory()
            obj_.build(child_)
            self.set_Behaviors(obj_)
        elif nodeName_ == 'Actions':
            obj_ = ActionListType.factory()
            obj_.build(child_)
            self.set_Actions(obj_)
        elif nodeName_ == 'Objects':
            obj_ = ObjectListType.factory()
            obj_.build(child_)
            self.set_Objects(obj_)
        elif nodeName_ == 'Candidate_Indicators':
            obj_ = CandidateIndicatorListType.factory()
            obj_.build(child_)
            self.set_Candidate_Indicators(obj_)
        elif nodeName_ == 'Collections':
            obj_ = CollectionsType.factory()
            obj_.build(child_)
            self.set_Collections(obj_)
# end class BundleType

class APICallType(GeneratedsSuper):
    """The APICallType provides a method for the characterization of API
    calls, including functions and their parameters.The
    function_name field contains the exact name of the API function
    called, e.g. CreateFileEx.The normalized_function_name field
    contains the normalized name of the API function called, e.g.
    CreateFile."""
    subclass = None
    superclass = None
    def __init__(self, normalized_function_name=None, function_name=None, Address=None, Return_Value=None, Parameters=None):
        self.normalized_function_name = _cast(None, normalized_function_name)
        self.function_name = _cast(None, function_name)
        self.Address = Address
        self.Return_Value = Return_Value
        self.Parameters = Parameters
    def factory(*args_, **kwargs_):
        if APICallType.subclass:
            return APICallType.subclass(*args_, **kwargs_)
        else:
            return APICallType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_Return_Value(self): return self.Return_Value
    def set_Return_Value(self, Return_Value): self.Return_Value = Return_Value
    def get_Parameters(self): return self.Parameters
    def set_Parameters(self, Parameters): self.Parameters = Parameters
    def get_normalized_function_name(self): return self.normalized_function_name
    def set_normalized_function_name(self, normalized_function_name): self.normalized_function_name = normalized_function_name
    def get_function_name(self): return self.function_name
    def set_function_name(self, function_name): self.function_name = function_name
    def hasContent_(self):
        if (
            self.Address is not None or
            self.Return_Value is not None or
            self.Parameters is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='APICallType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='APICallType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='APICallType'):
        if self.normalized_function_name is not None and 'normalized_function_name' not in already_processed:
            already_processed.add('normalized_function_name')
            outfile.write(' normalized_function_name=%s' % (self.gds_format_string(quote_attrib(self.normalized_function_name).encode(ExternalEncoding), input_name='normalized_function_name'), ))
        if self.function_name is not None and 'function_name' not in already_processed:
            already_processed.add('function_name')
            outfile.write(' function_name=%s' % (self.gds_format_string(quote_attrib(self.function_name).encode(ExternalEncoding), input_name='function_name'), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='APICallType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddress>%s</%sAddress>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Address).encode(ExternalEncoding), input_name='Address'), 'maecBundle:', eol_))
        if self.Return_Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReturn_Value>%s</%sReturn_Value>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Return_Value).encode(ExternalEncoding), input_name='Return_Value'), 'maecBundle:', eol_))
        if self.Parameters is not None:
            self.Parameters.export(outfile, level, 'maecBundle:', name_='Parameters', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='APICallType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.normalized_function_name is not None and 'normalized_function_name' not in already_processed:
            already_processed.add('normalized_function_name')
            showIndent(outfile, level)
            outfile.write('normalized_function_name = "%s",\n' % (self.normalized_function_name,))
        if self.function_name is not None and 'function_name' not in already_processed:
            already_processed.add('function_name')
            showIndent(outfile, level)
            outfile.write('function_name = "%s",\n' % (self.function_name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=%s,\n' % quote_python(self.Address).encode(ExternalEncoding))
        if self.Return_Value is not None:
            showIndent(outfile, level)
            outfile.write('Return_Value=%s,\n' % quote_python(self.Return_Value).encode(ExternalEncoding))
        if self.Parameters is not None:
            outfile.write('Parameters=model_.ParameterListType(\n')
            self.Parameters.exportLiteral(outfile, level, name_='Parameters')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('normalized_function_name', node)
        if value is not None and 'normalized_function_name' not in already_processed:
            already_processed.add('normalized_function_name')
            self.normalized_function_name = value
        value = find_attr_value_('function_name', node)
        if value is not None and 'function_name' not in already_processed:
            already_processed.add('function_name')
            self.function_name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address':
            Address_ = child_.text
            Address_ = self.gds_validate_string(Address_, node, 'Address')
            self.Address = Address_
        elif nodeName_ == 'Return_Value':
            Return_Value_ = child_.text
            Return_Value_ = self.gds_validate_string(Return_Value_, node, 'Return_Value')
            self.Return_Value = Return_Value_
        elif nodeName_ == 'Parameters':
            obj_ = ParameterListType.factory()
            obj_.build(child_)
            self.set_Parameters(obj_)
# end class APICallType

class ActionImplementationType(GeneratedsSuper):
    """The ActionImplementationType serves as a method for the
    characterization of Action Implementations. Currently supported
    are implementations achieved through API function calls and
    abstractly defined code. The id field specifies a unique ID for
    this Action Implementation. The ID must follow the pattern
    defined in the ActionImpIDPattern simple type. The required type
    field refers to the type of Action Implementation being
    characterized in this element."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, Compatible_Platforms=None, API_Call=None, Code=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Compatible_Platforms = Compatible_Platforms
        self.API_Call = API_Call
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
    def factory(*args_, **kwargs_):
        if ActionImplementationType.subclass:
            return ActionImplementationType.subclass(*args_, **kwargs_)
        else:
            return ActionImplementationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Compatible_Platforms(self): return self.Compatible_Platforms
    def set_Compatible_Platforms(self, Compatible_Platforms): self.Compatible_Platforms = Compatible_Platforms
    def get_API_Call(self): return self.API_Call
    def set_API_Call(self, API_Call): self.API_Call = API_Call
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Compatible_Platforms is not None or
            self.API_Call is not None or
            self.Code
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ActionImplementationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionImplementationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ActionImplementationType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ActionImplementationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Compatible_Platforms is not None:
            self.Compatible_Platforms.export(outfile, level, 'maecBundle:', name_='Compatible_Platforms', pretty_print=pretty_print)
        if self.API_Call is not None:
            self.API_Call.export(outfile, level, 'maecBundle:', name_='API_Call', pretty_print=pretty_print)
        for Code_ in self.Code:
            Code_.export(outfile, level, 'maecBundle:', name_='Code', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionImplementationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Compatible_Platforms is not None:
            outfile.write('Compatible_Platforms=model_.PlatformListType(\n')
            self.Compatible_Platforms.exportLiteral(outfile, level, name_='Compatible_Platforms')
            outfile.write('),\n')
        if self.API_Call is not None:
            outfile.write('API_Call=model_.APICallType(\n')
            self.API_Call.exportLiteral(outfile, level, name_='API_Call')
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            outfile.write('model_.code_object.CodeObjectType(\n')
            Code_.exportLiteral(outfile, level, name_='code_object.CodeObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Compatible_Platforms':
            obj_ = PlatformListType.factory()
            obj_.build(child_)
            self.set_Compatible_Platforms(obj_)
        elif nodeName_ == 'API_Call':
            obj_ = APICallType.factory()
            obj_.build(child_)
            self.set_API_Call(obj_)
        elif nodeName_ == 'Code':
            obj_ = code_object.CodeObjectType.factory()
            obj_.build(child_)
            self.Code.append(obj_)
# end class ActionImplementationType

class CVEVulnerabilityType(GeneratedsSuper):
    """The CVEVulnerabilityType provides a way of referencing specific
    vulnerabilities that malware exploits or attempts to exploit via
    a Common Vulnerabilities and Exposures (CVE) identifier. For
    more information on CVE please see http://cve.mitre.org. The
    cve_id attribute contains the ID of the CVE that is being
    referenced, e.g., CVE-1999-0002."""
    subclass = None
    superclass = None
    def __init__(self, cve_id=None, Description=None):
        self.cve_id = _cast(None, cve_id)
        self.Description = Description
    def factory(*args_, **kwargs_):
        if CVEVulnerabilityType.subclass:
            return CVEVulnerabilityType.subclass(*args_, **kwargs_)
        else:
            return CVEVulnerabilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_cve_id(self): return self.cve_id
    def set_cve_id(self, cve_id): self.cve_id = cve_id
    def hasContent_(self):
        if (
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CVEVulnerabilityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CVEVulnerabilityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CVEVulnerabilityType'):
        if self.cve_id is not None and 'cve_id' not in already_processed:
            already_processed.add('cve_id')
            outfile.write(' cve_id=%s' % (self.gds_format_string(quote_attrib(self.cve_id).encode(ExternalEncoding), input_name='cve_id'), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CVEVulnerabilityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
    def exportLiteral(self, outfile, level, name_='CVEVulnerabilityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cve_id is not None and 'cve_id' not in already_processed:
            already_processed.add('cve_id')
            showIndent(outfile, level)
            outfile.write('cve_id = "%s",\n' % (self.cve_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cve_id', node)
        if value is not None and 'cve_id' not in already_processed:
            already_processed.add('cve_id')
            self.cve_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
# end class CVEVulnerabilityType

class BaseCollectionType(GeneratedsSuper):
    """The BaseCollectionType is the base type for other MAEC collection
    types.The name field specifies the name of the collection."""
    subclass = None
    superclass = None
    def __init__(self, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, extensiontype_=None):
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Description = Description
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseCollectionType.subclass:
            return BaseCollectionType.subclass(*args_, **kwargs_)
        else:
            return BaseCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BaseCollectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BaseCollectionType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BaseCollectionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Affinity_Type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), 'maecBundle:', eol_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), 'maecBundle:', eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
    def exportLiteral(self, outfile, level, name_='BaseCollectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affinity_Type':
            Affinity_Type_ = child_.text
            Affinity_Type_ = self.gds_validate_string(Affinity_Type_, node, 'Affinity_Type')
            self.Affinity_Type = Affinity_Type_
        elif nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = child_.text
            Affinity_Degree_ = self.gds_validate_string(Affinity_Degree_, node, 'Affinity_Degree')
            self.Affinity_Degree = Affinity_Degree_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
# end class BaseCollectionType

class BehaviorRelationshipType(GeneratedsSuper):
    """The BehaviorRelationshipType provides a method for the
    characterization of relationships between Behaviors. The type
    field specifies the nature of the relationship between Behaviors
    that is being captured."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, Behavior_Reference=None):
        self.type_ = _cast(None, type_)
        if Behavior_Reference is None:
            self.Behavior_Reference = []
        else:
            self.Behavior_Reference = Behavior_Reference
    def factory(*args_, **kwargs_):
        if BehaviorRelationshipType.subclass:
            return BehaviorRelationshipType.subclass(*args_, **kwargs_)
        else:
            return BehaviorRelationshipType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def add_Behavior_Reference(self, value): self.Behavior_Reference.append(value)
    def insert_Behavior_Reference(self, index, value): self.Behavior_Reference[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.Behavior_Reference
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorRelationshipType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorRelationshipType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorRelationshipType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorRelationshipType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Behavior_Reference_ in self.Behavior_Reference:
            Behavior_Reference_.export(outfile, level, 'maecBundle:', name_='Behavior_Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorRelationshipType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Reference=[\n')
        level += 1
        for Behavior_Reference_ in self.Behavior_Reference:
            outfile.write('model_.BehaviorReferenceType(\n')
            Behavior_Reference_.exportLiteral(outfile, level, name_='BehaviorReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.Behavior_Reference.append(obj_)
# end class BehaviorRelationshipType

class AVClassificationsType(GeneratedsSuper):
    """The AVClassificationsType captures any Anti-Virus (AV) tool
    classifications for an Object."""
    subclass = None
    superclass = None
    def __init__(self, AV_Classification=None):
        if AV_Classification is None:
            self.AV_Classification = []
        else:
            self.AV_Classification = AV_Classification
    def factory(*args_, **kwargs_):
        if AVClassificationsType.subclass:
            return AVClassificationsType.subclass(*args_, **kwargs_)
        else:
            return AVClassificationsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AV_Classification(self): return self.AV_Classification
    def set_AV_Classification(self, AV_Classification): self.AV_Classification = AV_Classification
    def add_AV_Classification(self, value): self.AV_Classification.append(value)
    def insert_AV_Classification(self, index, value): self.AV_Classification[index] = value
    def hasContent_(self):
        if (
            self.AV_Classification
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='AVClassificationsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AVClassificationsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='AVClassificationsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='AVClassificationsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AV_Classification_ in self.AV_Classification:
            AV_Classification_.export(outfile, level, 'maecBundle:', name_='AV_Classification', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AVClassificationsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('AV_Classification=[\n')
        level += 1
        for AV_Classification_ in self.AV_Classification:
            outfile.write('model_.AVClassificationType(\n')
            AV_Classification_.exportLiteral(outfile, level, name_='AVClassificationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AV_Classification':
            obj_ = AVClassificationType.factory()
            obj_.build(child_)
            self.AV_Classification.append(obj_)
# end class AVClassificationsType

class ParameterType(GeneratedsSuper):
    """The ParameterType characterizes function parameters.This field
    refers to the ordinal position of the parameter with respect to
    the function where it is used.The name field specifies the name
    of the parameter.The value field specifies the actual value of
    the parameter."""
    subclass = None
    superclass = None
    def __init__(self, ordinal_position=None, name=None, value=None):
        self.ordinal_position = _cast(int, ordinal_position)
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if ParameterType.subclass:
            return ParameterType.subclass(*args_, **kwargs_)
        else:
            return ParameterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ParameterType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParameterType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ParameterType'):
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            outfile.write(' ordinal_position="%s"' % self.gds_format_integer(self.ordinal_position, input_name='ordinal_position'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ParameterType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ParameterType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ordinal_position is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ordinal_position', node)
        if value is not None and 'ordinal_position' not in already_processed:
            already_processed.add('ordinal_position')
            try:
                self.ordinal_position = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.ordinal_position <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ParameterType

class ParameterListType(GeneratedsSuper):
    """The ParametersType captures a list of function parameters."""
    subclass = None
    superclass = None
    def __init__(self, Parameter=None):
        if Parameter is None:
            self.Parameter = []
        else:
            self.Parameter = Parameter
    def factory(*args_, **kwargs_):
        if ParameterListType.subclass:
            return ParameterListType.subclass(*args_, **kwargs_)
        else:
            return ParameterListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Parameter(self): return self.Parameter
    def set_Parameter(self, Parameter): self.Parameter = Parameter
    def add_Parameter(self, value): self.Parameter.append(value)
    def insert_Parameter(self, index, value): self.Parameter[index] = value
    def hasContent_(self):
        if (
            self.Parameter
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ParameterListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParameterListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ParameterListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ParameterListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Parameter_ in self.Parameter:
            Parameter_.export(outfile, level, 'maecBundle:', name_='Parameter', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ParameterListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Parameter=[\n')
        level += 1
        for Parameter_ in self.Parameter:
            outfile.write('model_.ParameterType(\n')
            Parameter_.exportLiteral(outfile, level, name_='ParameterType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parameter':
            obj_ = ParameterType.factory()
            obj_.build(child_)
            self.Parameter.append(obj_)
# end class ParameterListType

class AssociatedCodeType(GeneratedsSuper):
    """The AssociatedCodeType serves as generic way of specifying any code
    snippets associated with a MAEC entity, such as a Behavior."""
    subclass = None
    superclass = None
    def __init__(self, Code_Snippet=None):
        if Code_Snippet is None:
            self.Code_Snippet = []
        else:
            self.Code_Snippet = Code_Snippet
    def factory(*args_, **kwargs_):
        if AssociatedCodeType.subclass:
            return AssociatedCodeType.subclass(*args_, **kwargs_)
        else:
            return AssociatedCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Code_Snippet(self): return self.Code_Snippet
    def set_Code_Snippet(self, Code_Snippet): self.Code_Snippet = Code_Snippet
    def add_Code_Snippet(self, value): self.Code_Snippet.append(value)
    def insert_Code_Snippet(self, index, value): self.Code_Snippet[index] = value
    def hasContent_(self):
        if (
            self.Code_Snippet
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='AssociatedCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AssociatedCodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='AssociatedCodeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='AssociatedCodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Code_Snippet_ in self.Code_Snippet:
            Code_Snippet_.export(outfile, level, 'maecBundle:', name_='Code_Snippet', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AssociatedCodeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Code_Snippet=[\n')
        level += 1
        for Code_Snippet_ in self.Code_Snippet:
            outfile.write('model_.code_object.CodeObjectType(\n')
            Code_Snippet_.exportLiteral(outfile, level, name_='code_object.CodeObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Code_Snippet':
            obj_ = code_object.CodeObjectType.factory()
            obj_.build(child_)
            self.Code_Snippet.append(obj_)
# end class AssociatedCodeType

class BehaviorPurposeType(GeneratedsSuper):
    """The BehaviorPurposeType captures the purpose behind a malware
    Behavior."""
    subclass = None
    superclass = None
    def __init__(self, Description=None, Vulnerability_Exploit=None):
        self.Description = Description
        self.Vulnerability_Exploit = Vulnerability_Exploit
    def factory(*args_, **kwargs_):
        if BehaviorPurposeType.subclass:
            return BehaviorPurposeType.subclass(*args_, **kwargs_)
        else:
            return BehaviorPurposeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Vulnerability_Exploit(self): return self.Vulnerability_Exploit
    def set_Vulnerability_Exploit(self, Vulnerability_Exploit): self.Vulnerability_Exploit = Vulnerability_Exploit
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Vulnerability_Exploit is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorPurposeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorPurposeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorPurposeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorPurposeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
        if self.Vulnerability_Exploit is not None:
            self.Vulnerability_Exploit.export(outfile, level, 'maecBundle:', name_='Vulnerability_Exploit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorPurposeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Vulnerability_Exploit is not None:
            outfile.write('Vulnerability_Exploit=model_.VulnerabilityExploitType(\n')
            self.Vulnerability_Exploit.exportLiteral(outfile, level, name_='Vulnerability_Exploit')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Vulnerability_Exploit':
            obj_ = VulnerabilityExploitType.factory()
            obj_.build(child_)
            self.set_Vulnerability_Exploit(obj_)
# end class BehaviorPurposeType

class PlatformListType(GeneratedsSuper):
    """The PlatformListType captures a list of software or hardware
    platforms."""
    subclass = None
    superclass = None
    def __init__(self, Platform=None):
        if Platform is None:
            self.Platform = []
        else:
            self.Platform = Platform
    def factory(*args_, **kwargs_):
        if PlatformListType.subclass:
            return PlatformListType.subclass(*args_, **kwargs_)
        else:
            return PlatformListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Platform(self): return self.Platform
    def set_Platform(self, Platform): self.Platform = Platform
    def add_Platform(self, value): self.Platform.append(value)
    def insert_Platform(self, index, value): self.Platform[index] = value
    def hasContent_(self):
        if (
            self.Platform
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='PlatformListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PlatformListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='PlatformListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='PlatformListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Platform_ in self.Platform:
            Platform_.export(outfile, level, 'maecBundle:', name_='Platform', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PlatformListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Platform=[\n')
        level += 1
        for Platform_ in self.Platform:
            outfile.write('model_.cybox_common.PlatformSpecificationType(\n')
            Platform_.exportLiteral(outfile, level, name_='cybox_common.PlatformSpecificationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Platform':
            obj_ = cybox_common.PlatformSpecificationType.factory()
            obj_.build(child_)
            self.Platform.append(obj_)
# end class PlatformListType

class VulnerabilityExploitType(GeneratedsSuper):
    """The VulnerabilityExploitType characterizes any vulnerability that
    may be exploited by malware through a Behavior.The
    known_vulnerability field specifies whether the vulnerability
    that the malware is exploiting has been previously identified.
    If so, it should be referenced via a CVE ID in the CVE element.
    If not, the platform(s) targeted by the vulnerability
    exploitation behavior may be specified in the Targeted_Platforms
    element."""
    subclass = None
    superclass = None
    def __init__(self, known_vulnerability=None, CVE=None, Targeted_Platforms=None):
        self.known_vulnerability = _cast(bool, known_vulnerability)
        self.CVE = CVE
        self.Targeted_Platforms = Targeted_Platforms
    def factory(*args_, **kwargs_):
        if VulnerabilityExploitType.subclass:
            return VulnerabilityExploitType.subclass(*args_, **kwargs_)
        else:
            return VulnerabilityExploitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CVE(self): return self.CVE
    def set_CVE(self, CVE): self.CVE = CVE
    def get_Targeted_Platforms(self): return self.Targeted_Platforms
    def set_Targeted_Platforms(self, Targeted_Platforms): self.Targeted_Platforms = Targeted_Platforms
    def get_known_vulnerability(self): return self.known_vulnerability
    def set_known_vulnerability(self, known_vulnerability): self.known_vulnerability = known_vulnerability
    def hasContent_(self):
        if (
            self.CVE is not None or
            self.Targeted_Platforms is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='VulnerabilityExploitType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VulnerabilityExploitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='VulnerabilityExploitType'):
        if self.known_vulnerability is not None and 'known_vulnerability' not in already_processed:
            already_processed.add('known_vulnerability')
            outfile.write(' known_vulnerability="%s"' % self.gds_format_boolean(self.known_vulnerability, input_name='known_vulnerability'))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='VulnerabilityExploitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CVE is not None:
            self.CVE.export(outfile, level, 'maecBundle:', name_='CVE', pretty_print=pretty_print)
        if self.Targeted_Platforms is not None:
            self.Targeted_Platforms.export(outfile, level, 'maecBundle:', name_='Targeted_Platforms', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VulnerabilityExploitType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.known_vulnerability is not None and 'known_vulnerability' not in already_processed:
            already_processed.add('known_vulnerability')
            showIndent(outfile, level)
            outfile.write('known_vulnerability = %s,\n' % (self.known_vulnerability,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CVE is not None:
            outfile.write('CVE=model_.CVEVulnerabilityType(\n')
            self.CVE.exportLiteral(outfile, level, name_='CVE')
            outfile.write('),\n')
        if self.Targeted_Platforms is not None:
            outfile.write('Targeted_Platforms=model_.PlatformListType(\n')
            self.Targeted_Platforms.exportLiteral(outfile, level, name_='Targeted_Platforms')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('known_vulnerability', node)
        if value is not None and 'known_vulnerability' not in already_processed:
            already_processed.add('known_vulnerability')
            if value in ('true', '1'):
                self.known_vulnerability = True
            elif value in ('false', '0'):
                self.known_vulnerability = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CVE':
            obj_ = CVEVulnerabilityType.factory()
            obj_.build(child_)
            self.set_CVE(obj_)
        elif nodeName_ == 'Targeted_Platforms':
            obj_ = PlatformListType.factory()
            obj_.build(child_)
            self.set_Targeted_Platforms(obj_)
# end class VulnerabilityExploitType

class BehaviorRelationshipListType(GeneratedsSuper):
    """The BehaviorRelationshipListType captures any relationships between
    a Behavior and other Behaviors."""
    subclass = None
    superclass = None
    def __init__(self, Relationship=None):
        if Relationship is None:
            self.Relationship = []
        else:
            self.Relationship = Relationship
    def factory(*args_, **kwargs_):
        if BehaviorRelationshipListType.subclass:
            return BehaviorRelationshipListType.subclass(*args_, **kwargs_)
        else:
            return BehaviorRelationshipListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Relationship(self): return self.Relationship
    def set_Relationship(self, Relationship): self.Relationship = Relationship
    def add_Relationship(self, value): self.Relationship.append(value)
    def insert_Relationship(self, index, value): self.Relationship[index] = value
    def hasContent_(self):
        if (
            self.Relationship
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorRelationshipListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorRelationshipListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorRelationshipListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorRelationshipListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Relationship_ in self.Relationship:
            Relationship_.export(outfile, level, 'maecBundle:', name_='Relationship', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorRelationshipListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Relationship=[\n')
        level += 1
        for Relationship_ in self.Relationship:
            outfile.write('model_.BehaviorRelationshipType(\n')
            Relationship_.exportLiteral(outfile, level, name_='BehaviorRelationshipType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Relationship':
            obj_ = BehaviorRelationshipType.factory()
            obj_.build(child_)
            self.Relationship.append(obj_)
# end class BehaviorRelationshipListType

class BehavioralActionsType(GeneratedsSuper):
    """The BehavioralActionsType is intended to capture the Actions or
    Action Collections that make up a Behavior."""
    subclass = None
    superclass = None
    def __init__(self, Action_Collection=None, Action=None, Action_Reference=None, Action_Equivalence_Reference=None):
        if Action_Collection is None:
            self.Action_Collection = []
        else:
            self.Action_Collection = Action_Collection
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
        if Action_Equivalence_Reference is None:
            self.Action_Equivalence_Reference = []
        else:
            self.Action_Equivalence_Reference = Action_Equivalence_Reference
    def factory(*args_, **kwargs_):
        if BehavioralActionsType.subclass:
            return BehavioralActionsType.subclass(*args_, **kwargs_)
        else:
            return BehavioralActionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Collection(self): return self.Action_Collection
    def set_Action_Collection(self, Action_Collection): self.Action_Collection = Action_Collection
    def add_Action_Collection(self, value): self.Action_Collection.append(value)
    def insert_Action_Collection(self, index, value): self.Action_Collection[index] = value
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def get_Action_Equivalence_Reference(self): return self.Action_Equivalence_Reference
    def set_Action_Equivalence_Reference(self, Action_Equivalence_Reference): self.Action_Equivalence_Reference = Action_Equivalence_Reference
    def add_Action_Equivalence_Reference(self, value): self.Action_Equivalence_Reference.append(value)
    def insert_Action_Equivalence_Reference(self, index, value): self.Action_Equivalence_Reference[index] = value
    def hasContent_(self):
        if (
            self.Action_Collection or
            self.Action or
            self.Action_Reference or
            self.Action_Equivalence_Reference
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehavioralActionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_Collection_ in self.Action_Collection:
            Action_Collection_.export(outfile, level, 'maecBundle:', name_='Action_Collection', pretty_print=pretty_print)
        for Action_ in self.Action:
            Action_.export(outfile, level, 'maecBundle:', name_='Action', pretty_print=pretty_print)
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, 'maecBundle:', name_='Action_Reference', pretty_print=pretty_print)
        for Action_Equivalence_Reference_ in self.Action_Equivalence_Reference:
            Action_Equivalence_Reference_.export(outfile, level, 'maecBundle:', name_='Action_Equivalence_Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehavioralActionsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Collection=[\n')
        level += 1
        for Action_Collection_ in self.Action_Collection:
            outfile.write('model_.ActionCollectionType(\n')
            Action_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            outfile.write('model_.BehavioralActionType(\n')
            Action_.exportLiteral(outfile, level, name_='BehavioralActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            outfile.write('model_.BehavioralActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='BehavioralActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Equivalence_Reference=[\n')
        level += 1
        for Action_Equivalence_Reference_ in self.Action_Equivalence_Reference:
            outfile.write('model_.BehavioralActionEquivalenceReferenceType(\n')
            Action_Equivalence_Reference_.exportLiteral(outfile, level, name_='BehavioralActionEquivalenceReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Collection.append(obj_)
        elif nodeName_ == 'Action':
            obj_ = MalwareActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
        elif nodeName_ == 'Action_Reference':
            obj_ = BehavioralActionReferenceType.factory()
            obj_.build(child_)
            self.Action_Reference.append(obj_)
        elif nodeName_ == 'Action_Equivalence_Reference':
            obj_ = BehavioralActionEquivalenceReferenceType.factory()
            obj_.build(child_)
            self.Action_Equivalence_Reference.append(obj_)
# end class BehavioralActionsType

class BehaviorListType(GeneratedsSuper):
    """The BehaviorListType captures a list of Behaviors."""
    subclass = None
    superclass = None
    def __init__(self, Behavior=None):
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
    def factory(*args_, **kwargs_):
        if BehaviorListType.subclass:
            return BehaviorListType.subclass(*args_, **kwargs_)
        else:
            return BehaviorListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def hasContent_(self):
        if (
            self.Behavior
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, 'maecBundle:', name_='Behavior', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
# end class BehaviorListType

class ActionListType(GeneratedsSuper):
    """The ActionListType captures a list of Actions."""
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if ActionListType.subclass:
            return ActionListType.subclass(*args_, **kwargs_)
        else:
            return ActionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ActionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ActionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ActionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_ in self.Action:
            Action_.export(outfile, level, 'maecBundle:', name_='Action', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            outfile.write('model_.MalwareActionType(\n')
            Action_.exportLiteral(outfile, level, name_='MalwareActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            obj_ = MalwareActionType.factory()
            obj_.build(child_)
            self.add_Action(obj_)
# end class ActionListType

class ObjectListType(GeneratedsSuper):
    """The ObjectListType captures a list of CybOX Objects."""
    subclass = None
    superclass = None
    def __init__(self, Object=None):
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if ObjectListType.subclass:
            return ObjectListType.subclass(*args_, **kwargs_)
        else:
            return ObjectListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def hasContent_(self):
        if (
            self.Object
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ObjectListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ObjectListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ObjectListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Object_ in self.Object:
            Object_.export(outfile, level, 'maecBundle:', name_='Object', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ObjectListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            outfile.write('model_.cybox_core.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='cybox_core.ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object':
            obj_ = cybox_core.ObjectType.factory()
            obj_.build(child_)
            self.add_Object(obj_)
# end class ObjectListType

class BehaviorReferenceType(GeneratedsSuper):
    """The BehaviorReferenceType serves as a method for referencing
    existing behaviors contained in the Bundle.The behavior_idref
    field specifies the id of the Behavior being referenced; this
    Behavior must be present in the current Bundle."""
    subclass = None
    superclass = None
    def __init__(self, behavior_idref=None):
        self.behavior_idref = _cast(None, behavior_idref)
        pass
    def factory(*args_, **kwargs_):
        if BehaviorReferenceType.subclass:
            return BehaviorReferenceType.subclass(*args_, **kwargs_)
        else:
            return BehaviorReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_behavior_idref(self): return self.behavior_idref
    def set_behavior_idref(self, behavior_idref): self.behavior_idref = behavior_idref
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorReferenceType'):
        if self.behavior_idref is not None and 'behavior_idref' not in already_processed:
            already_processed.add('behavior_idref')
            outfile.write(' behavior_idref=%s' % (quote_attrib(self.behavior_idref), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorReferenceType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='BehaviorReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.behavior_idref is not None and 'behavior_idref' not in already_processed:
            already_processed.add('behavior_idref')
            showIndent(outfile, level)
            outfile.write('behavior_idref = %s,\n' % (self.behavior_idref,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('behavior_idref', node)
        if value is not None and 'behavior_idref' not in already_processed:
            already_processed.add('behavior_idref')
            self.behavior_idref = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BehaviorReferenceType

class ObjectReferenceType(GeneratedsSuper):
    """The ObjectReferenceType serves as a method for linking to CybOX
    Objects embedded in the MAEC Bundle.The object_idref field
    specifies the id of a CybOX Object being referenced in the
    current MAEC Bundle."""
    subclass = None
    superclass = None
    def __init__(self, object_idref=None):
        self.object_idref = _cast(None, object_idref)
        pass
    def factory(*args_, **kwargs_):
        if ObjectReferenceType.subclass:
            return ObjectReferenceType.subclass(*args_, **kwargs_)
        else:
            return ObjectReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_object_idref(self): return self.object_idref
    def set_object_idref(self, object_idref): self.object_idref = object_idref
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ObjectReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ObjectReferenceType'):
        if self.object_idref is not None and 'object_idref' not in already_processed:
            already_processed.add('object_idref')
            outfile.write(' object_idref=%s' % (quote_attrib(self.object_idref), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ObjectReferenceType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ObjectReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.object_idref is not None and 'object_idref' not in already_processed:
            already_processed.add('object_idref')
            showIndent(outfile, level)
            outfile.write('object_idref = %s,\n' % (self.object_idref,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('object_idref', node)
        if value is not None and 'object_idref' not in already_processed:
            already_processed.add('object_idref')
            self.object_idref = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ObjectReferenceType

class BehavioralActionEquivalenceReferenceType(GeneratedsSuper):
    """The BehavioralActionEquivalenceReferenceType defines an Action
    Equivalence reference that can be used as part of a Behavior.
    Since the Action Equivalency equates two or more actions to a
    single one, this can be thought of as specifying one of the
    aforementioned Actions as part of the composition of the
    Behavior.The action_equivalence_idref field specifies the ID of
    an Action Equivalence contained in the same MAEC document as the
    Behavior that utilizes it.The behavioral_ordering field defines
    the ordering of the Action Equivalency with respect to the other
    actions that make up the behavior. So an action with a
    behavioral_ordering of "1" would come before an action with a
    behavioral_ordering of "2", etc."""
    subclass = None
    superclass = None
    def __init__(self, action_equivalence_idref=None, behavioral_ordering=None):
        self.action_equivalence_idref = _cast(None, action_equivalence_idref)
        self.behavioral_ordering = _cast(int, behavioral_ordering)
        pass
    def factory(*args_, **kwargs_):
        if BehavioralActionEquivalenceReferenceType.subclass:
            return BehavioralActionEquivalenceReferenceType.subclass(*args_, **kwargs_)
        else:
            return BehavioralActionEquivalenceReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_action_equivalence_idref(self): return self.action_equivalence_idref
    def set_action_equivalence_idref(self, action_equivalence_idref): self.action_equivalence_idref = action_equivalence_idref
    def get_behavioral_ordering(self): return self.behavioral_ordering
    def set_behavioral_ordering(self, behavioral_ordering): self.behavioral_ordering = behavioral_ordering
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionEquivalenceReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionEquivalenceReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehavioralActionEquivalenceReferenceType'):
        if self.action_equivalence_idref is not None and 'action_equivalence_idref' not in already_processed:
            already_processed.add('action_equivalence_idref')
            outfile.write(' action_equivalence_idref=%s' % (quote_attrib(self.action_equivalence_idref), ))
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            outfile.write(' behavioral_ordering="%s"' % self.gds_format_integer(self.behavioral_ordering, input_name='behavioral_ordering'))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionEquivalenceReferenceType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='BehavioralActionEquivalenceReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.action_equivalence_idref is not None and 'action_equivalence_idref' not in already_processed:
            already_processed.add('action_equivalence_idref')
            showIndent(outfile, level)
            outfile.write('action_equivalence_idref = %s,\n' % (self.action_equivalence_idref,))
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            showIndent(outfile, level)
            outfile.write('behavioral_ordering = %d,\n' % (self.behavioral_ordering,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('action_equivalence_idref', node)
        if value is not None and 'action_equivalence_idref' not in already_processed:
            already_processed.add('action_equivalence_idref')
            self.action_equivalence_idref = value
        value = find_attr_value_('behavioral_ordering', node)
        if value is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            try:
                self.behavioral_ordering = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.behavioral_ordering <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BehavioralActionEquivalenceReferenceType

class BehaviorReferenceListType(GeneratedsSuper):
    """The BehaviorReferenceListType captures a list of Behavior
    References."""
    subclass = None
    superclass = None
    def __init__(self, Behavior_Reference=None):
        if Behavior_Reference is None:
            self.Behavior_Reference = []
        else:
            self.Behavior_Reference = Behavior_Reference
    def factory(*args_, **kwargs_):
        if BehaviorReferenceListType.subclass:
            return BehaviorReferenceListType.subclass(*args_, **kwargs_)
        else:
            return BehaviorReferenceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def add_Behavior_Reference(self, value): self.Behavior_Reference.append(value)
    def insert_Behavior_Reference(self, index, value): self.Behavior_Reference[index] = value
    def hasContent_(self):
        if (
            self.Behavior_Reference
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorReferenceListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorReferenceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorReferenceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorReferenceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Behavior_Reference_ in self.Behavior_Reference:
            Behavior_Reference_.export(outfile, level, 'maecBundle:', name_='Behavior_Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorReferenceListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Reference=[\n')
        level += 1
        for Behavior_Reference_ in self.Behavior_Reference:
            outfile.write('model_.BehaviorReferenceType(\n')
            Behavior_Reference_.exportLiteral(outfile, level, name_='BehaviorReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.Behavior_Reference.append(obj_)
# end class BehaviorReferenceListType

class ActionReferenceListType(GeneratedsSuper):
    """The ActionReferenceListType captures a list of Action References."""
    subclass = None
    superclass = None
    def __init__(self, Action_Reference=None):
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
    def factory(*args_, **kwargs_):
        if ActionReferenceListType.subclass:
            return ActionReferenceListType.subclass(*args_, **kwargs_)
        else:
            return ActionReferenceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def hasContent_(self):
        if (
            self.Action_Reference
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ActionReferenceListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionReferenceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ActionReferenceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ActionReferenceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, 'maecBundle:', name_='Action_Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionReferenceListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            outfile.write('model_.cybox_core.ActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='cybox_core.ActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Reference':
            obj_ = cybox_core.ActionReferenceType.factory()
            obj_.build(child_)
            self.add_Action_Reference(obj_)
# end class ActionReferenceListType

class ObjectReferenceListType(GeneratedsSuper):
    """The ObjectReferenceListType captures a list of references to CybOX
    Objects."""
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None):
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
    def factory(*args_, **kwargs_):
        if ObjectReferenceListType.subclass:
            return ObjectReferenceListType.subclass(*args_, **kwargs_)
        else:
            return ObjectReferenceListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def hasContent_(self):
        if (
            self.Object_Reference
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ObjectReferenceListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectReferenceListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ObjectReferenceListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ObjectReferenceListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, 'maecBundle:', name_='Object_Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ObjectReferenceListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
# end class ObjectReferenceListType

class CandidateIndicatorType(GeneratedsSuper):
    """The CandidateIndicatorType provides a way of defining a MAEC entity-
    based Candidate Indicator, which specifies the particular
    components that may signify the presence of the malware instance
    on a host system or network.The id field specifies a unique ID
    for this Candidate Indicator. The ID must follow the pattern
    defined in the CandidateIndicatorIDPattern simple type.The
    creation_datetime field specifies the date/time that the
    Candidate Indicator was created.The lastupdate_datetime field
    specifies the last date/time that the Candidate Indicator was
    updated.The version field specifies the version of the Candidate
    Indicator."""
    subclass = None
    superclass = None
    def __init__(self, version=None, creation_datetime=None, id=None, lastupdate_datetime=None, Importance=None, Numeric_Importance=None, Author=None, Description=None, Malware_Entity=None, Composition=None):
        self.version = _cast(None, version)
        self.creation_datetime = _cast(None, creation_datetime)
        self.id = _cast(None, id)
        self.lastupdate_datetime = _cast(None, lastupdate_datetime)
        self.Importance = Importance
        self.Numeric_Importance = Numeric_Importance
        self.Author = Author
        self.Description = Description
        self.Malware_Entity = Malware_Entity
        self.Composition = Composition
    def factory(*args_, **kwargs_):
        if CandidateIndicatorType.subclass:
            return CandidateIndicatorType.subclass(*args_, **kwargs_)
        else:
            return CandidateIndicatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Importance(self): return self.Importance
    def set_Importance(self, Importance): self.Importance = Importance
    def get_Numeric_Importance(self): return self.Numeric_Importance
    def set_Numeric_Importance(self, Numeric_Importance): self.Numeric_Importance = Numeric_Importance
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Malware_Entity(self): return self.Malware_Entity
    def set_Malware_Entity(self, Malware_Entity): self.Malware_Entity = Malware_Entity
    def get_Composition(self): return self.Composition
    def set_Composition(self, Composition): self.Composition = Composition
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_creation_datetime(self): return self.creation_datetime
    def set_creation_datetime(self, creation_datetime): self.creation_datetime = creation_datetime
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_lastupdate_datetime(self): return self.lastupdate_datetime
    def set_lastupdate_datetime(self, lastupdate_datetime): self.lastupdate_datetime = lastupdate_datetime
    def hasContent_(self):
        if (
            self.Importance is not None or
            self.Numeric_Importance is not None or
            self.Author is not None or
            self.Description is not None or
            self.Malware_Entity is not None or
            self.Composition is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CandidateIndicatorType'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.creation_datetime is not None and 'creation_datetime' not in already_processed:
            already_processed.add('creation_datetime')
            outfile.write(' creation_datetime="%s"' % self.gds_format_datetime(self.creation_datetime, input_name='creation_datetime'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.lastupdate_datetime is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.add('lastupdate_datetime')
            outfile.write(' lastupdate_datetime="%s"' % self.gds_format_datetime(self.lastupdate_datetime, input_name='lastupdate_datetime'))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Importance is not None:
            self.Importance.export(outfile, level, 'maecBundle:', name_='Importance', pretty_print=pretty_print)
        if self.Numeric_Importance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNumeric_Importance>%s</%sNumeric_Importance>%s' % ('maecBundle:', self.gds_format_integer(self.Numeric_Importance, input_name='Numeric_Importance'), 'maecBundle:', eol_))
        if self.Author is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAuthor>%s</%sAuthor>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Author).encode(ExternalEncoding), input_name='Author'), 'maecBundle:', eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
        if self.Malware_Entity is not None:
            self.Malware_Entity.export(outfile, level, 'maecBundle:', name_='Malware_Entity', pretty_print=pretty_print)
        if self.Composition is not None:
            self.Composition.export(outfile, level, 'maecBundle:', name_='Composition', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CandidateIndicatorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version = "%s",\n' % (self.version,))
        if self.creation_datetime is not None and 'creation_datetime' not in already_processed:
            already_processed.add('creation_datetime')
            showIndent(outfile, level)
            outfile.write('creation_datetime = "%s",\n' % (self.creation_datetime,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.lastupdate_datetime is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.add('lastupdate_datetime')
            showIndent(outfile, level)
            outfile.write('lastupdate_datetime = "%s",\n' % (self.lastupdate_datetime,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Importance is not None:
            outfile.write('Importance=model_.cybox_common.ControlledVocabularyStringType(\n')
            self.Importance.exportLiteral(outfile, level, name_='Importance')
            outfile.write('),\n')
        if self.Numeric_Importance is not None:
            showIndent(outfile, level)
            outfile.write('Numeric_Importance=%d,\n' % self.Numeric_Importance)
        if self.Author is not None:
            showIndent(outfile, level)
            outfile.write('Author=%s,\n' % quote_python(self.Author).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Malware_Entity is not None:
            outfile.write('Malware_Entity=model_.MalwareEntityType(\n')
            self.Malware_Entity.exportLiteral(outfile, level, name_='Malware_Entity')
            outfile.write('),\n')
        if self.Composition is not None:
            outfile.write('Composition=model_.CandidateIndicatorCompositionType(\n')
            self.Composition.exportLiteral(outfile, level, name_='Composition')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('creation_datetime', node)
        if value is not None and 'creation_datetime' not in already_processed:
            already_processed.add('creation_datetime')
            try:
                self.creation_datetime = value
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creation_datetime): %s' % exp)
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('lastupdate_datetime', node)
        if value is not None and 'lastupdate_datetime' not in already_processed:
            already_processed.add('lastupdate_datetime')
            try:
                self.lastupdate_datetime = value
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (lastupdate_datetime): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Importance':
            obj_ = cybox_common.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.set_Importance(obj_)
        elif nodeName_ == 'Numeric_Importance':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Numeric_Importance')
            self.Numeric_Importance = ival_
        elif nodeName_ == 'Author':
            Author_ = child_.text
            Author_ = self.gds_validate_string(Author_, node, 'Author')
            self.Author = Author_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Malware_Entity':
            obj_ = MalwareEntityType.factory()
            obj_.build(child_)
            self.set_Malware_Entity(obj_)
        elif nodeName_ == 'Composition':
            obj_ = CandidateIndicatorCompositionType.factory()
            obj_.build(child_)
            self.set_Composition(obj_)
# end class CandidateIndicatorType

class CandidateIndicatorListType(GeneratedsSuper):
    """The CandidateIndicatorListType captures a list of Candidate
    Indicators."""
    subclass = None
    superclass = None
    def __init__(self, Candidate_Indicator=None):
        if Candidate_Indicator is None:
            self.Candidate_Indicator = []
        else:
            self.Candidate_Indicator = Candidate_Indicator
    def factory(*args_, **kwargs_):
        if CandidateIndicatorListType.subclass:
            return CandidateIndicatorListType.subclass(*args_, **kwargs_)
        else:
            return CandidateIndicatorListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Candidate_Indicator(self): return self.Candidate_Indicator
    def set_Candidate_Indicator(self, Candidate_Indicator): self.Candidate_Indicator = Candidate_Indicator
    def add_Candidate_Indicator(self, value): self.Candidate_Indicator.append(value)
    def insert_Candidate_Indicator(self, index, value): self.Candidate_Indicator[index] = value
    def hasContent_(self):
        if (
            self.Candidate_Indicator
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CandidateIndicatorListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Candidate_Indicator_ in self.Candidate_Indicator:
            Candidate_Indicator_.export(outfile, level, 'maecBundle:', name_='Candidate_Indicator', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CandidateIndicatorListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Candidate_Indicator=[\n')
        level += 1
        for Candidate_Indicator_ in self.Candidate_Indicator:
            outfile.write('model_.CandidateIndicatorType(\n')
            Candidate_Indicator_.exportLiteral(outfile, level, name_='CandidateIndicatorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Candidate_Indicator':
            obj_ = CandidateIndicatorType.factory()
            obj_.build(child_)
            self.Candidate_Indicator.append(obj_)
# end class CandidateIndicatorListType

class MalwareEntityType(GeneratedsSuper):
    """The MalwareEntityType provides a mechanism for characterizing the
    particular entity that an indicator or signature is written
    against, whether it is a particular malware instance, family,
    etc."""
    subclass = None
    superclass = None
    def __init__(self, Type=None, Name=None, Description=None):
        self.Type = Type
        self.Name = Name
        self.Description = Description
    def factory(*args_, **kwargs_):
        if MalwareEntityType.subclass:
            return MalwareEntityType.subclass(*args_, **kwargs_)
        else:
            return MalwareEntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Name is not None or
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='MalwareEntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MalwareEntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='MalwareEntityType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='MalwareEntityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type is not None:
            self.Type.export(outfile, level, 'maecBundle:', name_='Type', pretty_print=pretty_print)
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), 'maecBundle:', eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), 'maecBundle:', eol_))
    def exportLiteral(self, outfile, level, name_='MalwareEntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Type is not None:
            outfile.write('Type=model_.cybox_common.ControlledVocabularyStringType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            obj_ = cybox_common.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
# end class MalwareEntityType

class CollectionsType(GeneratedsSuper):
    """The CollectionsType captures the various types of MAEC entity
    collections."""
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collections=None, Action_Collections=None, Object_Collections=None, Candidate_Indicator_Collections=None):
        self.Behavior_Collections = Behavior_Collections
        self.Action_Collections = Action_Collections
        self.Object_Collections = Object_Collections
        self.Candidate_Indicator_Collections = Candidate_Indicator_Collections
    def factory(*args_, **kwargs_):
        if CollectionsType.subclass:
            return CollectionsType.subclass(*args_, **kwargs_)
        else:
            return CollectionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collections(self): return self.Behavior_Collections
    def set_Behavior_Collections(self, Behavior_Collections): self.Behavior_Collections = Behavior_Collections
    def get_Action_Collections(self): return self.Action_Collections
    def set_Action_Collections(self, Action_Collections): self.Action_Collections = Action_Collections
    def get_Object_Collections(self): return self.Object_Collections
    def set_Object_Collections(self, Object_Collections): self.Object_Collections = Object_Collections
    def get_Candidate_Indicator_Collections(self): return self.Candidate_Indicator_Collections
    def set_Candidate_Indicator_Collections(self, Candidate_Indicator_Collections): self.Candidate_Indicator_Collections = Candidate_Indicator_Collections
    def hasContent_(self):
        if (
            self.Behavior_Collections is not None or
            self.Action_Collections is not None or
            self.Object_Collections is not None or
            self.Candidate_Indicator_Collections is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CollectionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CollectionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CollectionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CollectionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Behavior_Collections is not None:
            self.Behavior_Collections.export(outfile, level, 'maecBundle:', name_='Behavior_Collections', pretty_print=pretty_print)
        if self.Action_Collections is not None:
            self.Action_Collections.export(outfile, level, 'maecBundle:', name_='Action_Collections', pretty_print=pretty_print)
        if self.Object_Collections is not None:
            self.Object_Collections.export(outfile, level, 'maecBundle:', name_='Object_Collections', pretty_print=pretty_print)
        if self.Candidate_Indicator_Collections is not None:
            self.Candidate_Indicator_Collections.export(outfile, level, 'maecBundle:', name_='Candidate_Indicator_Collections', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CollectionsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Behavior_Collections is not None:
            outfile.write('Behavior_Collections=model_.BehaviorCollectionListType(\n')
            self.Behavior_Collections.exportLiteral(outfile, level, name_='Behavior_Collections')
            outfile.write('),\n')
        if self.Action_Collections is not None:
            outfile.write('Action_Collections=model_.ActionCollectionListType(\n')
            self.Action_Collections.exportLiteral(outfile, level, name_='Action_Collections')
            outfile.write('),\n')
        if self.Object_Collections is not None:
            outfile.write('Object_Collections=model_.ObjectCollectionListType(\n')
            self.Object_Collections.exportLiteral(outfile, level, name_='Object_Collections')
            outfile.write('),\n')
        if self.Candidate_Indicator_Collections is not None:
            outfile.write('Candidate_Indicator_Collections=model_.CandidateIndicatorCollectionListType(\n')
            self.Candidate_Indicator_Collections.exportLiteral(outfile, level, name_='Candidate_Indicator_Collections')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Collections':
            obj_ = BehaviorCollectionListType.factory()
            obj_.build(child_)
            self.set_Behavior_Collections(obj_)
        elif nodeName_ == 'Action_Collections':
            obj_ = ActionCollectionListType.factory()
            obj_.build(child_)
            self.set_Action_Collections(obj_)
        elif nodeName_ == 'Object_Collections':
            obj_ = ObjectCollectionListType.factory()
            obj_.build(child_)
            self.set_Object_Collections(obj_)
        elif nodeName_ == 'Candidate_Indicator_Collections':
            obj_ = CandidateIndicatorCollectionListType.factory()
            obj_.build(child_)
            self.set_Candidate_Indicator_Collections(obj_)
# end class CollectionsType

class BundleReferenceType(GeneratedsSuper):
    """The BundleReferenceType serves as a method for linking to Bundles
    embedded in other locations.The bundle_idref field references
    the ID of a Bundle contained inside the current MAEC document."""
    subclass = None
    superclass = None
    def __init__(self, bundle_idref=None):
        self.bundle_idref = _cast(None, bundle_idref)
        pass
    def factory(*args_, **kwargs_):
        if BundleReferenceType.subclass:
            return BundleReferenceType.subclass(*args_, **kwargs_)
        else:
            return BundleReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_bundle_idref(self): return self.bundle_idref
    def set_bundle_idref(self, bundle_idref): self.bundle_idref = bundle_idref
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BundleReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BundleReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BundleReferenceType'):
        if self.bundle_idref is not None and 'bundle_idref' not in already_processed:
            already_processed.add('bundle_idref')
            outfile.write(' bundle_idref=%s' % (quote_attrib(self.bundle_idref), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BundleReferenceType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='BundleReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.bundle_idref is not None and 'bundle_idref' not in already_processed:
            already_processed.add('bundle_idref')
            showIndent(outfile, level)
            outfile.write('bundle_idref = %s,\n' % (self.bundle_idref,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bundle_idref', node)
        if value is not None and 'bundle_idref' not in already_processed:
            already_processed.add('bundle_idref')
            self.bundle_idref = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BundleReferenceType

class ProcessTreeType(GeneratedsSuper):
    """The ProcessTreeType captures the process tree for the malware
    instance, including the parent process and processes spawned by
    it, along with any Actions initiated by each."""
    subclass = None
    superclass = None
    def __init__(self, Root_Process=None):
        self.Root_Process = Root_Process
    def factory(*args_, **kwargs_):
        if ProcessTreeType.subclass:
            return ProcessTreeType.subclass(*args_, **kwargs_)
        else:
            return ProcessTreeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Root_Process(self): return self.Root_Process
    def set_Root_Process(self, Root_Process): self.Root_Process = Root_Process
    def hasContent_(self):
        if (
            self.Root_Process is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ProcessTreeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessTreeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ProcessTreeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ProcessTreeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Root_Process is not None:
            self.Root_Process.export(outfile, level, 'maecBundle:', name_='Root_Process', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ProcessTreeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Root_Process is not None:
            outfile.write('Root_Process=model_.ProcessTreeNodeType(\n')
            self.Root_Process.exportLiteral(outfile, level, name_='Root_Process')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Root_Process':
            obj_ = ProcessTreeNodeType.factory()
            obj_.build(child_)
            self.set_Root_Process(obj_)
# end class ProcessTreeType

class CandidateIndicatorCompositionType(GeneratedsSuper):
    """The CandidateIndicatorCompositionType captures the composition of a
    Candidate Indicator, via references to any corresponding MAEC
    entities contained in the Bundle.The operator field specifies
    the Boolean operator for this level of the Candidate Indicator's
    composition."""
    subclass = None
    superclass = None
    def __init__(self, operator=None, Behavior_Reference=None, Action_Reference=None, Object_Reference=None, Sub_Composition=None):
        self.operator = _cast(None, operator)
        if Behavior_Reference is None:
            self.Behavior_Reference = []
        else:
            self.Behavior_Reference = Behavior_Reference
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
        if Sub_Composition is None:
            self.Sub_Composition = []
        else:
            self.Sub_Composition = Sub_Composition
    def factory(*args_, **kwargs_):
        if CandidateIndicatorCompositionType.subclass:
            return CandidateIndicatorCompositionType.subclass(*args_, **kwargs_)
        else:
            return CandidateIndicatorCompositionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def add_Behavior_Reference(self, value): self.Behavior_Reference.append(value)
    def insert_Behavior_Reference(self, index, value): self.Behavior_Reference[index] = value
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_Sub_Composition(self): return self.Sub_Composition
    def set_Sub_Composition(self, Sub_Composition): self.Sub_Composition = Sub_Composition
    def add_Sub_Composition(self, value): self.Sub_Composition.append(value)
    def insert_Sub_Composition(self, index, value): self.Sub_Composition[index] = value
    def get_operator(self): return self.operator
    def set_operator(self, operator): self.operator = operator
    def hasContent_(self):
        if (
            self.Behavior_Reference or
            self.Action_Reference or
            self.Object_Reference or
            self.Sub_Composition
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCompositionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorCompositionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CandidateIndicatorCompositionType'):
        if self.operator is not None and 'operator' not in already_processed:
            already_processed.add('operator')
            outfile.write(' operator=%s' % (quote_attrib(self.operator), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCompositionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Behavior_Reference_ in self.Behavior_Reference:
            Behavior_Reference_.export(outfile, level, 'maecBundle:', name_='Behavior_Reference', pretty_print=pretty_print)
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, 'maecBundle:', name_='Action_Reference', pretty_print=pretty_print)
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, 'maecBundle:', name_='Object_Reference', pretty_print=pretty_print)
        for Sub_Composition_ in self.Sub_Composition:
            Sub_Composition_.export(outfile, level, 'maecBundle:', name_='Sub_Composition', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CandidateIndicatorCompositionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.operator is not None and 'operator' not in already_processed:
            already_processed.add('operator')
            showIndent(outfile, level)
            outfile.write('operator = %s,\n' % (self.operator,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Reference=[\n')
        level += 1
        for Behavior_Reference_ in self.Behavior_Reference:
            outfile.write('model_.BehaviorReferenceType(\n')
            Behavior_Reference_.exportLiteral(outfile, level, name_='BehaviorReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            outfile.write('model_.cybox_core.ActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='cybox_core.ActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Sub_Composition=[\n')
        level += 1
        for Sub_Composition_ in self.Sub_Composition:
            outfile.write('model_.CandidateIndicatorCompositionType(\n')
            Sub_Composition_.exportLiteral(outfile, level, name_='CandidateIndicatorCompositionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('operator', node)
        if value is not None and 'operator' not in already_processed:
            already_processed.add('operator')
            self.operator = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.Behavior_Reference.append(obj_)
        elif nodeName_ == 'Action_Reference':
            obj_ = BehavioralActionReferenceType.factory()
            obj_.build(child_)
            self.set_Action_Reference(obj_)
        elif nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
        elif nodeName_ == 'Sub_Composition':
            obj_ = CandidateIndicatorCompositionType.factory()
            obj_.build(child_)
            self.Sub_Composition.append(obj_)
# end class CandidateIndicatorCompositionType

class CandidateIndicatorCollectionType(BaseCollectionType):
    """The CandidateIndicatorCollectionType provides a mechanism for
    characterizing collections of Candidate Indicators.The id field
    specifies a unique ID for this Candidate Indicator Collection.
    The ID must follow the pattern defined in the
    CandidateIndicatorCollIDPattern simple type."""
    subclass = None
    superclass = BaseCollectionType
    def __init__(self, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, id=None, Candidate_Indicator_List=None):
        super(CandidateIndicatorCollectionType, self).__init__(name, Affinity_Type, Affinity_Degree, Description, )
        self.id = _cast(None, id)
        self.Candidate_Indicator_List = Candidate_Indicator_List
    def factory(*args_, **kwargs_):
        if CandidateIndicatorCollectionType.subclass:
            return CandidateIndicatorCollectionType.subclass(*args_, **kwargs_)
        else:
            return CandidateIndicatorCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Candidate_Indicator_List(self): return self.Candidate_Indicator_List
    def set_Candidate_Indicator_List(self, Candidate_Indicator_List): self.Candidate_Indicator_List = Candidate_Indicator_List
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Candidate_Indicator_List is not None or
            super(CandidateIndicatorCollectionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCollectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CandidateIndicatorCollectionType'):
        super(CandidateIndicatorCollectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorCollectionType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCollectionType', fromsubclass_=False, pretty_print=True):
        super(CandidateIndicatorCollectionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Candidate_Indicator_List is not None:
            self.Candidate_Indicator_List.export(outfile, level, 'maecBundle:', name_='Candidate_Indicator_List', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CandidateIndicatorCollectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        super(CandidateIndicatorCollectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CandidateIndicatorCollectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Candidate_Indicator_List is not None:
            outfile.write('Candidate_Indicator_List=model_.CandidateIndicatorListType(\n')
            self.Candidate_Indicator_List.exportLiteral(outfile, level, name_='Candidate_Indicator_List')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        super(CandidateIndicatorCollectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Candidate_Indicator_List':
            obj_ = CandidateIndicatorListType.factory()
            obj_.build(child_)
            self.set_Candidate_Indicator_List(obj_)
        super(CandidateIndicatorCollectionType, self).buildChildren(child_, node, nodeName_, True)
# end class CandidateIndicatorCollectionType

class CandidateIndicatorCollectionListType(GeneratedsSuper):
    """The CandidateIndicatorCollectionListType captures a list of
    Candidate Indicators."""
    subclass = None
    superclass = None
    def __init__(self, Candidate_Indicator_Collection=None):
        if Candidate_Indicator_Collection is None:
            self.Candidate_Indicator_Collection = []
        else:
            self.Candidate_Indicator_Collection = Candidate_Indicator_Collection
    def factory(*args_, **kwargs_):
        if CandidateIndicatorCollectionListType.subclass:
            return CandidateIndicatorCollectionListType.subclass(*args_, **kwargs_)
        else:
            return CandidateIndicatorCollectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Candidate_Indicator_Collection(self): return self.Candidate_Indicator_Collection
    def set_Candidate_Indicator_Collection(self, Candidate_Indicator_Collection): self.Candidate_Indicator_Collection = Candidate_Indicator_Collection
    def add_Candidate_Indicator_Collection(self, value): self.Candidate_Indicator_Collection.append(value)
    def insert_Candidate_Indicator_Collection(self, index, value): self.Candidate_Indicator_Collection[index] = value
    def hasContent_(self):
        if (
            self.Candidate_Indicator_Collection
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCollectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CandidateIndicatorCollectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='CandidateIndicatorCollectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='CandidateIndicatorCollectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Candidate_Indicator_Collection_ in self.Candidate_Indicator_Collection:
            Candidate_Indicator_Collection_.export(outfile, level, 'maecBundle:', name_='Candidate_Indicator_Collection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CandidateIndicatorCollectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Candidate_Indicator_Collection=[\n')
        level += 1
        for Candidate_Indicator_Collection_ in self.Candidate_Indicator_Collection:
            outfile.write('model_.CandidateIndicatorCollectionType(\n')
            Candidate_Indicator_Collection_.exportLiteral(outfile, level, name_='CandidateIndicatorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Candidate_Indicator_Collection':
            obj_ = CandidateIndicatorCollectionType.factory()
            obj_.build(child_)
            self.Candidate_Indicator_Collection.append(obj_)
# end class CandidateIndicatorCollectionListType

class BehaviorCollectionListType(GeneratedsSuper):
    """The BehaviorCollectionListType captures a list of Behaviors
    Collections."""
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collection=None):
        if Behavior_Collection is None:
            self.Behavior_Collection = []
        else:
            self.Behavior_Collection = Behavior_Collection
    def factory(*args_, **kwargs_):
        if BehaviorCollectionListType.subclass:
            return BehaviorCollectionListType.subclass(*args_, **kwargs_)
        else:
            return BehaviorCollectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collection(self): return self.Behavior_Collection
    def set_Behavior_Collection(self, Behavior_Collection): self.Behavior_Collection = Behavior_Collection
    def add_Behavior_Collection(self, value): self.Behavior_Collection.append(value)
    def insert_Behavior_Collection(self, index, value): self.Behavior_Collection[index] = value
    def hasContent_(self):
        if (
            self.Behavior_Collection
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorCollectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorCollectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorCollectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorCollectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Behavior_Collection_ in self.Behavior_Collection:
            Behavior_Collection_.export(outfile, level, 'maecBundle:', name_='Behavior_Collection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorCollectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Collection=[\n')
        level += 1
        for Behavior_Collection_ in self.Behavior_Collection:
            outfile.write('model_.BehaviorCollectionType(\n')
            Behavior_Collection_.exportLiteral(outfile, level, name_='BehaviorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Behavior_Collection':
            obj_ = BehaviorCollectionType.factory()
            obj_.build(child_)
            self.Behavior_Collection.append(obj_)
# end class BehaviorCollectionListType

class ActionCollectionListType(GeneratedsSuper):
    """The ActionCollectionListType captures a list of Actions Collections."""
    subclass = None
    superclass = None
    def __init__(self, Action_Collection=None):
        if Action_Collection is None:
            self.Action_Collection = []
        else:
            self.Action_Collection = Action_Collection
    def factory(*args_, **kwargs_):
        if ActionCollectionListType.subclass:
            return ActionCollectionListType.subclass(*args_, **kwargs_)
        else:
            return ActionCollectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Collection(self): return self.Action_Collection
    def set_Action_Collection(self, Action_Collection): self.Action_Collection = Action_Collection
    def add_Action_Collection(self, value): self.Action_Collection.append(value)
    def insert_Action_Collection(self, index, value): self.Action_Collection[index] = value
    def hasContent_(self):
        if (
            self.Action_Collection
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ActionCollectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionCollectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ActionCollectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ActionCollectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Action_Collection_ in self.Action_Collection:
            Action_Collection_.export(outfile, level, 'maecBundle:', name_='Action_Collection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionCollectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Collection=[\n')
        level += 1
        for Action_Collection_ in self.Action_Collection:
            outfile.write('model_.ActionCollectionType(\n')
            Action_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Collection.append(obj_)
# end class ActionCollectionListType

class ObjectCollectionListType(GeneratedsSuper):
    """The ObjectCollectionListType captures a list of Object Collections."""
    subclass = None
    superclass = None
    def __init__(self, Object_Collection=None):
        if Object_Collection is None:
            self.Object_Collection = []
        else:
            self.Object_Collection = Object_Collection
    def factory(*args_, **kwargs_):
        if ObjectCollectionListType.subclass:
            return ObjectCollectionListType.subclass(*args_, **kwargs_)
        else:
            return ObjectCollectionListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Collection(self): return self.Object_Collection
    def set_Object_Collection(self, Object_Collection): self.Object_Collection = Object_Collection
    def add_Object_Collection(self, value): self.Object_Collection.append(value)
    def insert_Object_Collection(self, index, value): self.Object_Collection[index] = value
    def hasContent_(self):
        if (
            self.Object_Collection
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ObjectCollectionListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectCollectionListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ObjectCollectionListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ObjectCollectionListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Object_Collection_ in self.Object_Collection:
            Object_Collection_.export(outfile, level, 'maecBundle:', name_='Object_Collection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ObjectCollectionListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Collection=[\n')
        level += 1
        for Object_Collection_ in self.Object_Collection:
            outfile.write('model_.ObjectCollectionType(\n')
            Object_Collection_.exportLiteral(outfile, level, name_='ObjectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_Collection':
            obj_ = ObjectCollectionType.factory()
            obj_.build(child_)
            self.Object_Collection.append(obj_)
# end class ObjectCollectionListType

class AVClassificationType(cybox_common.ToolInformationType):
    """The AVClassificationType captures information on AV scanner
    classifications for the malware instance object captured in the
    Bundle or Package."""
    subclass = None
    superclass = cybox_common.ToolInformationType
    def __init__(self, idref=None, id=None, Name=None, Type=None, Description=None, References=None, Vendor=None, Version=None, Service_Pack=None, Tool_Specific_Data=None, Tool_Hashes=None, Tool_Configuration=None, Execution_Environment=None, Errors=None, Metadata=None, Engine_Version=None, Definition_Version=None, Classification_Name=None):
        super(AVClassificationType, self).__init__(idref, id, Name, Type, Description, References, Vendor, Version, Service_Pack, Tool_Specific_Data, Tool_Hashes, Tool_Configuration, Execution_Environment, Errors, Metadata, )
        self.Engine_Version = Engine_Version
        self.Definition_Version = Definition_Version
        self.Classification_Name = Classification_Name
    def factory(*args_, **kwargs_):
        if AVClassificationType.subclass:
            return AVClassificationType.subclass(*args_, **kwargs_)
        else:
            return AVClassificationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Engine_Version(self): return self.Engine_Version
    def set_Engine_Version(self, Engine_Version): self.Engine_Version = Engine_Version
    def get_Definition_Version(self): return self.Definition_Version
    def set_Definition_Version(self, Definition_Version): self.Definition_Version = Definition_Version
    def get_Classification_Name(self): return self.Classification_Name
    def set_Classification_Name(self, Classification_Name): self.Classification_Name = Classification_Name
    def hasContent_(self):
        if (
            self.Engine_Version is not None or
            self.Definition_Version is not None or
            self.Classification_Name is not None or
            super(AVClassificationType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='AVClassificationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AVClassificationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='AVClassificationType'):
        super(AVClassificationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AVClassificationType')
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='AVClassificationType', fromsubclass_=False, pretty_print=True):
        super(AVClassificationType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Engine_Version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEngine_Version>%s</%sEngine_Version>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Engine_Version).encode(ExternalEncoding), input_name='Engine_Version'), 'maecBundle:', eol_))
        if self.Definition_Version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDefinition_Version>%s</%sDefinition_Version>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Definition_Version).encode(ExternalEncoding), input_name='Definition_Version'), 'maecBundle:', eol_))
        if self.Classification_Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sClassification_Name>%s</%sClassification_Name>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Classification_Name).encode(ExternalEncoding), input_name='Classification_Name'), 'maecBundle:', eol_))
    def exportLiteral(self, outfile, level, name_='AVClassificationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AVClassificationType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AVClassificationType, self).exportLiteralChildren(outfile, level, name_)
        if self.Engine_Version is not None:
            showIndent(outfile, level)
            outfile.write('Engine_Version=%s,\n' % quote_python(self.Engine_Version).encode(ExternalEncoding))
        if self.Definition_Version is not None:
            showIndent(outfile, level)
            outfile.write('Definition_Version=%s,\n' % quote_python(self.Definition_Version).encode(ExternalEncoding))
        if self.Classification_Name is not None:
            showIndent(outfile, level)
            outfile.write('Classification_Name=%s,\n' % quote_python(self.Classification_Name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AVClassificationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Engine_Version':
            Engine_Version_ = child_.text
            Engine_Version_ = self.gds_validate_string(Engine_Version_, node, 'Engine_Version')
            self.Engine_Version = Engine_Version_
        elif nodeName_ == 'Definition_Version':
            Definition_Version_ = child_.text
            Definition_Version_ = self.gds_validate_string(Definition_Version_, node, 'Definition_Version')
            self.Definition_Version = Definition_Version_
        elif nodeName_ == 'Classification_Name':
            Classification_Name_ = child_.text
            Classification_Name_ = self.gds_validate_string(Classification_Name_, node, 'Classification_Name')
            self.Classification_Name = Classification_Name_
        super(AVClassificationType, self).buildChildren(child_, node, nodeName_, True)
# end class AVClassificationType

class ProcessTreeNodeType(process_object.ProcessObjectType):
    """The ProcessTreeNodeType captures a single process, or node, in the
    process tree. It imports and extends the process_object.ProcessObjectType from
    the CybOX Process Object.The required id field specifies a
    unique ID for the Process Node. The ID must follow the pattern
    defined in the ProcessTreeNodeIDPattern simple type.The
    parent_action_idref field specifies the id of the action that
    created or injected this process."""
    subclass = None
    superclass = process_object.ProcessObjectType
    def __init__(self, object_reference=None, Custom_Properties=None, is_hidden=None, PID=None, Name=None, Creation_Time=None, Parent_PID=None, Child_PID_List=None, Image_Info=None, Argument_List=None, Environment_Variable_List=None, Kernel_Time=None, Port_List=None, Network_Connection_List=None, Start_Time=None, Status=None, Username=None, User_Time=None, Extracted_Features=None, id=None, parent_action_idref=None, Initiated_Actions=None, Spawned_Process=None, Injected_Process=None):
        super(ProcessTreeNodeType, self).__init__(object_reference, Custom_Properties, is_hidden, PID, Name, Creation_Time, Parent_PID, Child_PID_List, Image_Info, Argument_List, Environment_Variable_List, Kernel_Time, Port_List, Network_Connection_List, Start_Time, Status, Username, User_Time, Extracted_Features, )
        self.id = _cast(None, id)
        self.parent_action_idref = _cast(None, parent_action_idref)
        self.Initiated_Actions = Initiated_Actions
        if Spawned_Process is None:
            self.Spawned_Process = []
        else:
            self.Spawned_Process = Spawned_Process
        if Injected_Process is None:
            self.Injected_Process = []
        else:
            self.Injected_Process = Injected_Process
    def factory(*args_, **kwargs_):
        if ProcessTreeNodeType.subclass:
            return ProcessTreeNodeType.subclass(*args_, **kwargs_)
        else:
            return ProcessTreeNodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Initiated_Actions(self): return self.Initiated_Actions
    def set_Initiated_Actions(self, Initiated_Actions): self.Initiated_Actions = Initiated_Actions
    def get_Spawned_Process(self): return self.Spawned_Process
    def set_Spawned_Process(self, Spawned_Process): self.Spawned_Process = Spawned_Process
    def add_Spawned_Process(self, value): self.Spawned_Process.append(value)
    def insert_Spawned_Process(self, index, value): self.Spawned_Process[index] = value
    def get_Injected_Process(self): return self.Injected_Process
    def set_Injected_Process(self, Injected_Process): self.Injected_Process = Injected_Process
    def add_Injected_Process(self, value): self.Injected_Process.append(value)
    def insert_Injected_Process(self, index, value): self.Injected_Process[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_parent_action_idref(self): return self.parent_action_idref
    def set_parent_action_idref(self, parent_action_idref): self.parent_action_idref = parent_action_idref
    def hasContent_(self):
        if (
            self.Initiated_Actions is not None or
            self.Spawned_Process or
            self.Injected_Process or
            super(ProcessTreeNodeType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ProcessTreeNodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessTreeNodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ProcessTreeNodeType'):
        super(ProcessTreeNodeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProcessTreeNodeType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.parent_action_idref is not None and 'parent_action_idref' not in already_processed:
            already_processed.add('parent_action_idref')
            outfile.write(' parent_action_idref=%s' % (quote_attrib(self.parent_action_idref), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ProcessTreeNodeType', fromsubclass_=False, pretty_print=True):
        super(ProcessTreeNodeType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Initiated_Actions is not None:
            self.Initiated_Actions.export(outfile, level, 'maecBundle:', name_='Initiated_Actions', pretty_print=pretty_print)
        for Spawned_Process_ in self.Spawned_Process:
            Spawned_Process_.export(outfile, level, 'maecBundle:', name_='Spawned_Process', pretty_print=pretty_print)
        for Injected_Process_ in self.Injected_Process:
            Injected_Process_.export(outfile, level, 'maecBundle:', name_='Injected_Process', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ProcessTreeNodeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.parent_action_idref is not None and 'parent_action_idref' not in already_processed:
            already_processed.add('parent_action_idref')
            showIndent(outfile, level)
            outfile.write('parent_action_idref = %s,\n' % (self.parent_action_idref,))
        super(ProcessTreeNodeType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProcessTreeNodeType, self).exportLiteralChildren(outfile, level, name_)
        if self.Initiated_Actions is not None:
            outfile.write('Initiated_Actions=model_.ActionReferenceListType(\n')
            self.Initiated_Actions.exportLiteral(outfile, level, name_='Initiated_Actions')
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Spawned_Process=[\n')
        level += 1
        for Spawned_Process_ in self.Spawned_Process:
            outfile.write('model_.ProcessTreeNodeType(\n')
            Spawned_Process_.exportLiteral(outfile, level, name_='ProcessTreeNodeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Injected_Process=[\n')
        level += 1
        for Injected_Process_ in self.Injected_Process:
            outfile.write('model_.ProcessTreeNodeType(\n')
            Injected_Process_.exportLiteral(outfile, level, name_='ProcessTreeNodeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('parent_action_idref', node)
        if value is not None and 'parent_action_idref' not in already_processed:
            already_processed.add('parent_action_idref')
            self.parent_action_idref = value
        super(ProcessTreeNodeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Initiated_Actions':
            obj_ = ActionReferenceListType.factory()
            obj_.build(child_)
            self.set_Initiated_Actions(obj_)
        elif nodeName_ == 'Spawned_Process':
            obj_ = ProcessTreeNodeType.factory()
            obj_.build(child_)
            self.Spawned_Process.append(obj_)
        elif nodeName_ == 'Injected_Process':
            obj_ = ProcessTreeNodeType.factory()
            obj_.build(child_)
            self.Injected_Process.append(obj_)
        super(ProcessTreeNodeType, self).buildChildren(child_, node, nodeName_, True)
# end class ProcessTreeNodeType

class BehavioralActionReferenceType(cybox_core.ActionReferenceType):
    """The BehavioralActionReferenceType defines an action reference that
    can be used as part of a Behavior.The behavioral_ordering field
    defines the ordering of the Action with respect to the other
    Actions that make up the Behavior. For example, an Action with a
    behavioral_ordering of "1" would come before an Action with a
    behavioral_ordering of "2", etc."""
    subclass = None
    superclass = cybox_core.ActionReferenceType
    def __init__(self, action_id=None, behavioral_ordering=None):
        super(BehavioralActionReferenceType, self).__init__(action_id, )
        self.behavioral_ordering = _cast(int, behavioral_ordering)
        pass
    def factory(*args_, **kwargs_):
        if BehavioralActionReferenceType.subclass:
            return BehavioralActionReferenceType.subclass(*args_, **kwargs_)
        else:
            return BehavioralActionReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_behavioral_ordering(self): return self.behavioral_ordering
    def set_behavioral_ordering(self, behavioral_ordering): self.behavioral_ordering = behavioral_ordering
    def hasContent_(self):
        if (
            super(BehavioralActionReferenceType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehavioralActionReferenceType'):
        super(BehavioralActionReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionReferenceType')
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            outfile.write(' behavioral_ordering="%s"' % self.gds_format_integer(self.behavioral_ordering, input_name='behavioral_ordering'))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionReferenceType', fromsubclass_=False, pretty_print=True):
        super(BehavioralActionReferenceType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='BehavioralActionReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            showIndent(outfile, level)
            outfile.write('behavioral_ordering = %d,\n' % (self.behavioral_ordering,))
        super(BehavioralActionReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BehavioralActionReferenceType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('behavioral_ordering', node)
        if value is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            try:
                self.behavioral_ordering = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.behavioral_ordering <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(BehavioralActionReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BehavioralActionReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BehavioralActionReferenceType

class ObjectCollectionType(BaseCollectionType):
    """The ObjectCollectionType provides a mechanism for characterizing
    collections of Objects. For instance, it can be used to group
    all of the Objects that are associated with a specific
    behavior.The id attribute specifies a unique ID for this Object
    Collection. The ID must follow the pattern defined in the
    ObjectCollIDPattern simple type."""
    subclass = None
    superclass = BaseCollectionType
    def __init__(self, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, id=None, Object_List=None):
        super(ObjectCollectionType, self).__init__(name, Affinity_Type, Affinity_Degree, Description, )
        self.id = _cast(None, id)
        self.Object_List = Object_List
    def factory(*args_, **kwargs_):
        if ObjectCollectionType.subclass:
            return ObjectCollectionType.subclass(*args_, **kwargs_)
        else:
            return ObjectCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_List(self): return self.Object_List
    def set_Object_List(self, Object_List): self.Object_List = Object_List
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Object_List is not None or
            super(ObjectCollectionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ObjectCollectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ObjectCollectionType'):
        super(ObjectCollectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ObjectCollectionType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ObjectCollectionType', fromsubclass_=False, pretty_print=True):
        super(ObjectCollectionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Object_List is not None:
            self.Object_List.export(outfile, level, 'maecBundle:', name_='Object_List', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ObjectCollectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        super(ObjectCollectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ObjectCollectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Object_List is not None:
            outfile.write('Object_List=model_.ObjectListType(\n')
            self.Object_List.exportLiteral(outfile, level, name_='Object_List')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        super(ObjectCollectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Object_List':
            obj_ = ObjectListType.factory()
            obj_.build(child_)
            self.set_Object_List(obj_)
        super(ObjectCollectionType, self).buildChildren(child_, node, nodeName_, True)
# end class ObjectCollectionType

class ActionCollectionType(BaseCollectionType):
    """The ActionCollectionType provides a method for characterizing
    collections of actions. This can be useful for organizing
    actions that may be related and where the exact relationship is
    unknown, as well as actions whose associated behavior has not
    yet been established.The id field specifies a unique ID for this
    Action Collection. The ID must follow the pattern defined in the
    ActionCollIDPattern simple type."""
    subclass = None
    superclass = BaseCollectionType
    def __init__(self, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, id=None, Action_List=None):
        super(ActionCollectionType, self).__init__(name, Affinity_Type, Affinity_Degree, Description, )
        self.id = _cast(None, id)
        self.Action_List = Action_List
    def factory(*args_, **kwargs_):
        if ActionCollectionType.subclass:
            return ActionCollectionType.subclass(*args_, **kwargs_)
        else:
            return ActionCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_List(self): return self.Action_List
    def set_Action_List(self, Action_List): self.Action_List = Action_List
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Action_List is not None or
            super(ActionCollectionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='ActionCollectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ActionCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='ActionCollectionType'):
        super(ActionCollectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ActionCollectionType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='ActionCollectionType', fromsubclass_=False, pretty_print=True):
        super(ActionCollectionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Action_List is not None:
            self.Action_List.export(outfile, level, 'maecBundle:', name_='Action_List', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ActionCollectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        super(ActionCollectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ActionCollectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Action_List is not None:
            outfile.write('Action_List=model_.ActionListType(\n')
            self.Action_List.exportLiteral(outfile, level, name_='Action_List')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        super(ActionCollectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action_List':
            obj_ = ActionListType.factory()
            obj_.build(child_)
            self.set_Action_List(obj_)
        super(ActionCollectionType, self).buildChildren(child_, node, nodeName_, True)
# end class ActionCollectionType

class BehaviorCollectionType(BaseCollectionType):
    """The BehaviorCollectionType provides a mechanism for characterizing
    collections of behaviors.The id field specifies a unique ID for
    this Behavior Collection. The ID must follow the pattern defined
    in the BehaviorCollIDPattern simple type."""
    subclass = None
    superclass = BaseCollectionType
    def __init__(self, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, id=None, Purpose=None, Behavior_List=None):
        super(BehaviorCollectionType, self).__init__(name, Affinity_Type, Affinity_Degree, Description, )
        self.id = _cast(None, id)
        self.Purpose = Purpose
        self.Behavior_List = Behavior_List
    def factory(*args_, **kwargs_):
        if BehaviorCollectionType.subclass:
            return BehaviorCollectionType.subclass(*args_, **kwargs_)
        else:
            return BehaviorCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Behavior_List(self): return self.Behavior_List
    def set_Behavior_List(self, Behavior_List): self.Behavior_List = Behavior_List
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Purpose is not None or
            self.Behavior_List is not None or
            super(BehaviorCollectionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehaviorCollectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehaviorCollectionType'):
        super(BehaviorCollectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorCollectionType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehaviorCollectionType', fromsubclass_=False, pretty_print=True):
        super(BehaviorCollectionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Purpose is not None:
            outfile.write('<%sPurpose>%s</%sPurpose>%s' % ('maecBundle:', self.gds_format_string(quote_xml(self.Purpose).encode(ExternalEncoding), input_name='Purpose'), 'maecBundle:', eol_))
        if self.Behavior_List is not None:
            self.Behavior_List.export(outfile, level, 'maecBundle:', name_='Behavior_List', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorCollectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        super(BehaviorCollectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BehaviorCollectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Purpose is not None:
            outfile.write('Purpose=%s,\n' % quote_python(self.Purpose).encode(ExternalEncoding))
        if self.Behavior_List is not None:
            outfile.write('Behavior_List=model_.BehaviorListType(\n')
            self.Behavior_List.exportLiteral(outfile, level, name_='Behavior_List')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        super(BehaviorCollectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Purpose':
            obj_ = BehaviorPurposeType.factory()
            obj_.build(child_)
            self.set_Purpose(obj_)
        elif nodeName_ == 'Behavior_List':
            obj_ = BehaviorListType.factory()
            obj_.build(child_)
            self.set_Behavior_List(obj_)
        super(BehaviorCollectionType, self).buildChildren(child_, node, nodeName_, True)
# end class BehaviorCollectionType

class MalwareActionType(cybox_core.ActionType):
    """The MalwareActionType is one of the foundational MAEC types, and
    serves as a method for the characterization of actions found or
    observed in malware. Actions can be thought of as system state
    changes and similar operations that represent the fundamental
    low-level operation of malware. Some examples include the
    creation of a file, deletion of a registry key, and the sending
    of some data on a socket. It imports and extends the CybOX
    cybox_core.ActionType. For MAEC, the id attribute is required and must
    follow the proper syntax: A dash-delimited format is used with
    the id or idref starting with the word maec followed by a unique
    string, followed by the three letter code 'act', and ending with
    an integer."""
    subclass = None
    superclass = cybox_core.ActionType
    def __init__(self, timestamp=None, action_status=None, ordinal_position=None, context=None, idref=None, id=None, Type=None, Name=None, Description=None, Action_Aliases=None, Action_Arguments=None, Discovery_Method=None, Associated_Objects=None, Relationships=None, Frequency=None, Implementation=None, extensiontype_=None):
        super(MalwareActionType, self).__init__(timestamp, action_status, ordinal_position, context, idref, id, Type, Name, Description, Action_Aliases, Action_Arguments, Discovery_Method, Associated_Objects, Relationships, Frequency)
        self.Implementation = Implementation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if MalwareActionType.subclass:
            return MalwareActionType.subclass(*args_, **kwargs_)
        else:
            return MalwareActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Implementation(self): return self.Implementation
    def set_Implementation(self, Implementation): self.Implementation = Implementation
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Implementation is not None or
            super(MalwareActionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='MalwareActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MalwareActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='MalwareActionType'):
        super(MalwareActionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MalwareActionType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='MalwareActionType', fromsubclass_=False, pretty_print=True):
        super(MalwareActionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Implementation is not None:
            # This is kluge to handle a python-cybox compatibility issue
            from maec.bundle.malware_action import ActionImplementation
            if isinstance(self.Implementation, ActionImplementation):
                self.Implementation = self.Implementation.to_obj()
            self.Implementation.export(outfile, level, 'maecBundle:', name_='Implementation', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MalwareActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MalwareActionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MalwareActionType, self).exportLiteralChildren(outfile, level, name_)
        if self.Implementation is not None:
            outfile.write('Implementation=model_.ActionImplementationType(\n')
            self.Implementation.exportLiteral(outfile, level, name_='Implementation')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(MalwareActionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Implementation':
            obj_ = ActionImplementationType.factory()
            obj_.build(child_)
            self.set_Implementation(obj_)
        super(MalwareActionType, self).buildChildren(child_, node, nodeName_, True)
# end class MalwareActionType

class BehavioralActionType(MalwareActionType):
    """The BehavioralActionType defines an Action that can be used as part
    of a Behavior.The behavioral_ordering field defines the ordering
    of the Action with respect to the other Actions that make up the
    behavior. So an action with a behavioral_ordering of "1" would
    come before an Action with a behavioral_ordering of "2", etc."""
    subclass = None
    superclass = MalwareActionType
    def __init__(self, timestamp=None, action_status=None, ordinal_position=None, context=None, idref=None, id=None, Type=None, Name=None, Description=None, Action_Aliases=None, Action_Arguments=None, Discovery_Method=None, Associated_Objects=None, Relationships=None, Frequency=None, Implementation=None, behavioral_ordering=None):
        super(BehavioralActionType, self).__init__(timestamp, action_status, ordinal_position, context, idref, id, Type, Name, Description, Action_Aliases, Action_Arguments, Discovery_Method, Associated_Objects, Relationships, Frequency, Implementation, )
        self.behavioral_ordering = _cast(int, behavioral_ordering)
        pass
    def factory(*args_, **kwargs_):
        if BehavioralActionType.subclass:
            return BehavioralActionType.subclass(*args_, **kwargs_)
        else:
            return BehavioralActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_behavioral_ordering(self): return self.behavioral_ordering
    def set_behavioral_ordering(self, behavioral_ordering): self.behavioral_ordering = behavioral_ordering
    def hasContent_(self):
        if (
            super(BehavioralActionType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='maecBundle:', name_='BehavioralActionType'):
        super(BehavioralActionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BehavioralActionType')
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            outfile.write(' behavioral_ordering="%s"' % self.gds_format_integer(self.behavioral_ordering, input_name='behavioral_ordering'))
    def exportChildren(self, outfile, level, namespace_='maecBundle:', name_='BehavioralActionType', fromsubclass_=False, pretty_print=True):
        super(BehavioralActionType, self).exportChildren(outfile, level, 'maecBundle:', name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehavioralActionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.behavioral_ordering is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            showIndent(outfile, level)
            outfile.write('behavioral_ordering = %d,\n' % (self.behavioral_ordering,))
        super(BehavioralActionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BehavioralActionType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('behavioral_ordering', node)
        if value is not None and 'behavioral_ordering' not in already_processed:
            already_processed.add('behavioral_ordering')
            try:
                self.behavioral_ordering = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.behavioral_ordering <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(BehavioralActionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BehavioralActionType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BehavioralActionType

GDSClassesMapping = {
    'Relationships': cybox_core.RelationshipsType,
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Defined_Effect': cybox_core.DefinedEffectType,
    'Action': cybox_core.ActionType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'P3P': cybox_common.StringObjectPropertyType,
    'Proxy_Authorization': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Processor_Family': code_object.ProcessorTypeType,
    'Importance': cybox_common.ControlledVocabularyStringType,
    'Entry_Type': cybox_common.StringObjectPropertyType,
    'Object': cybox_core.ObjectType,
    'PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Argument_List': process_object.ArgumentListType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Path': cybox_common.StringObjectPropertyType,
    'Segment_Hash': cybox_common.HashValueType,
    'Observable': cybox_core.ObservableType,
    'Action_Argument': cybox_core.ActionArgumentType,
    'Tool_Hashes': cybox_common.HashListType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'X_Forwarded_Proto': cybox_common.StringObjectPropertyType,
    'X_ATT_DeviceId': cybox_common.StringObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Related_Object': cybox_core.RelatedObjectType,
    'Value': cybox_common.AnyURIObjectPropertyType,
    'Refresh': cybox_common.IntegerObjectPropertyType,
    'Length': cybox_common.PositiveIntegerObjectPropertyType,
    'Expect': cybox_common.StringObjectPropertyType,
    'If_Range': cybox_common.StringObjectPropertyType,
    'Evasion_Techniques': cybox_core.ObfuscationTechniquesType,
    'Parent_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Associated_Objects': cybox_core.AssociatedObjectsType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Warning': cybox_common.StringObjectPropertyType,
    'Imports': cybox_common.ImportsType,
    'Code_Language': code_object.CodeLanguageType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Event': cybox_core.EventType,
    'Segments': cybox_common.HashSegmentsType,
    'Content_Length': cybox_common.IntegerObjectPropertyType,
    'X_UA_Compatible': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Start_Time': cybox_common.DateTimeObjectPropertyType,
    'Max_Forwards': cybox_common.IntegerObjectPropertyType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'State': cybox_common.ControlledVocabularyStringType,
    'Version': cybox_common.StringObjectPropertyType,
    'Property_Pool': cybox_core.PropertyPoolType,
    'Accept_Language': cybox_common.StringObjectPropertyType,
    'Import': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Code_Segment_XOR': code_object.CodeSegmentXORType,
    'Expires': cybox_common.DateTimeObjectPropertyType,
    'Compilers': cybox_common.CompilersType,
    'Username': cybox_common.StringObjectPropertyType,
    'Digital_Signatures': cybox_common.DigitalSignaturesType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'Relationship': cybox_common.ControlledVocabularyStringType,
    'Accept_Charset': cybox_common.StringObjectPropertyType,
    'Accept': cybox_common.StringObjectPropertyType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Obfuscation_Technique': cybox_core.ObfuscationTechniqueType,
    'Link': cybox_common.StringObjectPropertyType,
    'Observable_Composition': cybox_core.ObservableCompositionType,
    'TTL': cybox_common.IntegerObjectPropertyType,
    'Code_Segment': cybox_common.StringObjectPropertyType,
    'X_Frame_Options': cybox_common.StringObjectPropertyType,
    'Targeted_Platforms': code_object.TargetedPlatformsType,
    'Age': cybox_common.IntegerObjectPropertyType,
    'Message_Body': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Access_Control_Allow_Origin': cybox_common.StringObjectPropertyType,
    'Action_Pool': cybox_core.ActionPoolType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Server': cybox_common.StringObjectPropertyType,
    'Image_Info': process_object.ImageInfoType,
    'Range': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Retry_After': cybox_common.IntegerObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'WWW_Authenticate': cybox_common.StringObjectPropertyType,
    'Via': cybox_common.StringObjectPropertyType,
    'X_Requested_For': cybox_common.StringObjectPropertyType,
    'Contributors': cybox_common.PersonnelType,
    'Transfer_Encoding': cybox_common.StringObjectPropertyType,
    'Command_Line': cybox_common.StringObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Child_PID': cybox_common.UnsignedIntegerObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Flags': cybox_common.HexBinaryObjectPropertyType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Observable_Source': cybox_common.MeasureSourceType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'User_Time': cybox_common.DurationObjectPropertyType,
    'Record_Name': cybox_common.StringObjectPropertyType,
    'Association_Type': cybox_common.ControlledVocabularyStringType,
    'Accept_Ranges': cybox_common.StringObjectPropertyType,
    'Observable_Package_Source': cybox_common.MeasureSourceType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Associated_Object': cybox_core.AssociatedObjectType,
    'Related_Objects': cybox_core.RelatedObjectsType,
    'Reason_Phrase': cybox_common.StringObjectPropertyType,
    'Record_Type': cybox_common.StringObjectPropertyType,
    'Authorization': cybox_common.StringObjectPropertyType,
    'Accept_Encoding': cybox_common.StringObjectPropertyType,
    'Status': process_object.ProcessStatusType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Current_Directory': cybox_common.StringObjectPropertyType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Child_PID_List': process_object.ChildPIDListType,
    'Extracted_Features': cybox_common.ExtractedFeaturesType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'If_Modified_Since': cybox_common.DateTimeObjectPropertyType,
    'X_Content_Type_Options': cybox_common.StringObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Domain_Specific_Object_Properties': cybox_core.DomainSpecificObjectPropertiesType,
    'Dependencies': cybox_common.DependenciesType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateTimeObjectPropertyType,
    'Cookie': cybox_common.StringObjectPropertyType,
    'Hashes': cybox_common.HashListType,
    'Strict_Transport_Security': cybox_common.StringObjectPropertyType,
    'Data': cybox_common.DataSegmentType,
    'Properties': cybox_core.PropertiesType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Address_Class': cybox_common.StringObjectPropertyType,
    'Action_Reference': cybox_core.ActionReferenceType,
    'Language': cybox_common.StringObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Cache_Control': cybox_common.StringObjectPropertyType,
    'Creation_Time': cybox_common.DateTimeObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Connection': cybox_common.StringObjectPropertyType,
    'X_Requested_With': cybox_common.StringObjectPropertyType,
    'Kernel_Time': cybox_common.DurationObjectPropertyType,
    'Pools': cybox_core.PoolsType,
    'Event_Pool': cybox_core.EventPoolType,
    'If_Unmodified_Since': cybox_common.DateTimeObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'Start_Address': cybox_common.HexBinaryObjectPropertyType,
    'Code': code_object.CodeObjectType,
    'Code_Object': code_object.CodeObjectType,
    'Old_Object': cybox_core.ObjectType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Process': process_object.ProcessObjectType,
    'Object_Pool': cybox_core.ObjectPoolType,
    'X_Powered_By': cybox_common.StringObjectPropertyType,
    'Library': cybox_common.LibraryType,
    'Action_Arguments': cybox_core.ActionArgumentsType,
    'Frequency': cybox_core.FrequencyType,
    'References': cybox_common.ToolReferencesType,
    'Service_Used': cybox_common.StringObjectPropertyType,
    'Keywords': cybox_core.KeywordsType,
    'Pattern_Fidelity': cybox_core.PatternFidelityType,
    'X_XSS_Protection': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Time': cybox_common.TimeType,
    'Trailer': cybox_common.StringObjectPropertyType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'File_Name': cybox_common.StringObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Content_Location': cybox_common.StringObjectPropertyType,
    'Malware_Instance_Object_Attributes': cybox_core.ObjectType,
    'Argument': cybox_common.StringObjectPropertyType,
    'Libraries': cybox_common.LibrariesType,
    'QClass': cybox_common.StringObjectPropertyType,
    'SubDatum': cybox_common.MetadataType,
    'Content_Language': cybox_common.StringObjectPropertyType,
    'Content_MD5': cybox_common.StringObjectPropertyType,
    'Content_Disposition': cybox_common.StringObjectPropertyType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Type': code_object.CodeTypeType,
    'Discovery_Method': cybox_common.MeasureSourceType,
    'TE': cybox_common.StringObjectPropertyType,
    'Action_Pertinent_Object_Properties': cybox_core.ActionPertinentObjectPropertiesType,
    'Content_Range': cybox_common.StringObjectPropertyType,
    'Observation_Method': cybox_common.MeasureSourceType,
    'If_None_Match': cybox_common.StringObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'Purpose': code_object.CodePurposeType,
    'Pragma': cybox_common.StringObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Port_Value': cybox_common.PositiveIntegerObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Set_Cookie': cybox_common.StringObjectPropertyType,
    'Network_Connection_List': process_object.NetworkConnectionListType,
    'Accept_Datetime': cybox_common.StringObjectPropertyType,
    'Environment_Variable_List': cybox_common.EnvironmentVariableListType,
    'Last_Modified': cybox_common.DateTimeObjectPropertyType,
    'Values': cybox_core.ValuesType,
    'Port_List': process_object.PortListType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'Observables': cybox_core.ObservablesType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Proxy_Authenticate': cybox_common.StringObjectPropertyType,
    'String': cybox_common.ExtractedStringType,
    'Content_Encoding': cybox_common.StringObjectPropertyType,
    'New_Object': cybox_core.ObjectType,
    'Tools': cybox_common.ToolsInformationType,
    'Data_Length': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Actions': cybox_core.ActionsType,
    'Data_Size': cybox_common.DataSizeType,
    'Targeted_Platform': cybox_common.PlatformSpecificationType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'ETag': cybox_common.StringObjectPropertyType,
    'Date_Ran': cybox_common.DateTimeObjectPropertyType,
    'Status_Code': cybox_common.PositiveIntegerObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'Action_Aliases': cybox_core.ActionAliasesType,
    'If_Match': cybox_common.StringObjectPropertyType,
    'Argument_Name': cybox_common.ControlledVocabularyStringType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MAEC_Bundle'
        rootClass = BundleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    #sys.stdout.write('<?xml version="1.0" ?>\n')
    #rootObj.export(sys.stdout, 0, name_=rootTag,
    #    namespacedef_='',
    #    pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MAEC_Bundle'
        rootClass = BundleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MAEC_Bundle'
        rootClass = BundleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    #sys.stdout.write('<?xml version="1.0" ?>\n')
    #rootObj.export(sys.stdout, 0, name_="MAEC_Bundle",
    #    namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MAEC_Bundle'
        rootClass = BundleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from maec_bundle_temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import maec_bundle_temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "MalwareActionType",
    "BehaviorType",
    "BundleType",
    "BehaviorCollectionType",
    "ActionCollectionType",
    "APICallType",
    "ActionImplementationType",
    "CVEVulnerabilityType",
    "ObjectCollectionType",
    "BaseCollectionType",
    "BehaviorRelationshipType",
    "AVClassificationsType",
    "ParameterType",
    "ParameterListType",
    "AssociatedCodeType",
    "BehaviorPurposeType",
    "PlatformListType",
    "VulnerabilityExploitType",
    "BehaviorRelationshipListType",
    "BehavioralActionsType",
    "BehaviorListType",
    "ActionListType",
    "ObjectListType",
    "BehaviorReferenceType",
    "ObjectReferenceType",
    "BehavioralActionType",
    "BehavioralActionReferenceType",
    "BehavioralActionEquivalenceReferenceType",
    "BehaviorReferenceListType",
    "ActionReferenceListType",
    "ObjectReferenceListType",
    "CandidateIndicatorType",
    "CandidateIndicatorListType",
    "MalwareEntityType",
    "CollectionsType",
    "BundleReferenceType",
    "ProcessTreeType",
    "ProcessTreeNodeType",
    "CandidateIndicatorCompositionType",
    "CandidateIndicatorCollectionType",
    "CandidateIndicatorCollectionListType",
    "BehaviorCollectionListType",
    "ActionCollectionListType",
    "ObjectCollectionListType",
    "AVClassificationType"
    ]