# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Iterable, Optional, TypeVar, Union

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._vendor import _convert_request, _format_url_section
T = TypeVar('T')
JSONType = Any
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False

def build_get_request(
    subscription_id: str,
    provider_id: str,
    location: str,
    resource_name: str,
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2020-10-25")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str'),
        "providerId": _SERIALIZER.url("provider_id", provider_id, 'str'),
        "location": _SERIALIZER.url("location", location, 'str'),
        "resourceName": _SERIALIZER.url("resource_name", resource_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_create_or_update_request_initial(
    subscription_id: str,
    provider_id: str,
    location: str,
    resource_name: str,
    *,
    json: JSONType = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str'),
        "providerId": _SERIALIZER.url("provider_id", provider_id, 'str'),
        "location": _SERIALIZER.url("location", location, 'str'),
        "resourceName": _SERIALIZER.url("resource_name", resource_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_update_request_initial(
    subscription_id: str,
    provider_id: str,
    location: str,
    resource_name: str,
    *,
    json: JSONType = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str'),
        "providerId": _SERIALIZER.url("provider_id", provider_id, 'str'),
        "location": _SERIALIZER.url("location", location, 'str'),
        "resourceName": _SERIALIZER.url("resource_name", resource_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_request(
    subscription_id: str,
    provider_id: str,
    location: str,
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2020-10-25")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str'),
        "providerId": _SERIALIZER.url("provider_id", provider_id, 'str'),
        "location": _SERIALIZER.url("location", location, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

class QuotaOperations(object):
    """QuotaOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.reservations.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        **kwargs: Any
    ) -> "_models.CurrentQuotaLimitBase":
        """Get the current quota (service limit) and usage of a resource. You can use the response from
        the GET operation to submit quota update request.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :keyword api_version: Api Version. Default value is "2020-10-25". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CurrentQuotaLimitBase, or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CurrentQuotaLimitBase"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str

        
        request = build_get_request(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore


    def _create_or_update_initial(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: "_models.CurrentQuotaLimitBase",
        **kwargs: Any
    ) -> Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')

        request = build_create_or_update_request_initial(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('QuotaRequestSubmitResponse201', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_initial.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore


    @distributed_trace
    def begin_create_or_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: "_models.CurrentQuotaLimitBase",
        **kwargs: Any
    ) -> LROPoller[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]:
        """Create or update the quota (service limits) of a resource to the requested value.
         Steps:


        #.
           Make the Get request to get the quota information for specific resource.

        #.
           To increase the quota, update the limit field in the response from Get request to new value.

        #.
           Submit the JSON to the quota request API to update the quota.
           The Create quota request may be constructed as follows. The PUT operation can be used to
        update the quota.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :param create_quota_request: Quota requests payload.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword api_version: Api Version. Default value is "2020-10-25". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either CurrentQuotaLimitBase or
         QuotaRequestSubmitResponse201 or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase or
         ~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'original-uri'}, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    def _update_initial(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: "_models.CurrentQuotaLimitBase",
        **kwargs: Any
    ) -> Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')

        request = build_update_request_initial(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('QuotaRequestSubmitResponse201', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore


    @distributed_trace
    def begin_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: "_models.CurrentQuotaLimitBase",
        **kwargs: Any
    ) -> LROPoller[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]:
        """Update the quota (service limits) of this resource to the requested value.

          • To get the quota information for specific resource, send a GET request.

          • To increase the quota, update the limit field from the GET response to a new value.

          • To update the quota value, submit the JSON response to the quota request API to update the
        quota.
          • To update the quota. use the PATCH operation.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
        :type resource_name: str
        :param create_quota_request: Payload for the quota request.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword api_version: Api Version. Default value is "2020-10-25". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either CurrentQuotaLimitBase or
         QuotaRequestSubmitResponse201 or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase or
         ~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CurrentQuotaLimitBase", "_models.QuotaRequestSubmitResponse201"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_initial(
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'original-uri'}, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    @distributed_trace
    def list(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        **kwargs: Any
    ) -> Iterable["_models.QuotaLimits"]:
        """Gets a list of current quotas (service limits) and usage for all resources. The response from
        the list quota operation can be leveraged to request quota updates.

        :param subscription_id: Azure subscription ID.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID.
        :type provider_id: str
        :param location: Azure region.
        :type location: str
        :keyword api_version: Api Version. Default value is "2020-10-25". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either QuotaLimits or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.reservations.models.QuotaLimits]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2020-10-25")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.QuotaLimits"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    subscription_id=subscription_id,
                    provider_id=provider_id,
                    location=location,
                    api_version=api_version,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_request(
                    subscription_id=subscription_id,
                    provider_id=provider_id,
                    location=location,
                    api_version=api_version,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("QuotaLimits", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits"}  # type: ignore
