# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, List, Optional, TypeVar, Union

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._reservation_operations import build_available_scopes_request_initial, build_get_request, build_list_all_request, build_list_request, build_list_revisions_request, build_merge_request_initial, build_split_request_initial, build_update_request_initial
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ReservationOperations:
    """ReservationOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.reservations.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def _available_scopes_initial(
        self,
        reservation_order_id: str,
        reservation_id: str,
        body: "_models.AvailableScopeRequest",
        **kwargs: Any
    ) -> "_models.AvailableScopeProperties":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AvailableScopeProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'AvailableScopeRequest')

        request = build_available_scopes_request_initial(
            reservation_order_id=reservation_order_id,
            reservation_id=reservation_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._available_scopes_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('AvailableScopeProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _available_scopes_initial.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}/availableScopes"}  # type: ignore


    @distributed_trace_async
    async def begin_available_scopes(
        self,
        reservation_order_id: str,
        reservation_id: str,
        body: "_models.AvailableScopeRequest",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.AvailableScopeProperties"]:
        """Get Available Scopes for ``Reservation``.

        Get Available Scopes for ``Reservation``.

        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :param reservation_id: Id of the Reservation Item.
        :type reservation_id: str
        :param body:
        :type body: ~azure.mgmt.reservations.models.AvailableScopeRequest
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AvailableScopeProperties or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.AvailableScopeProperties]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AvailableScopeProperties"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._available_scopes_initial(
                reservation_order_id=reservation_order_id,
                reservation_id=reservation_id,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('AvailableScopeProperties', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_available_scopes.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}/availableScopes"}  # type: ignore

    async def _split_initial(
        self,
        reservation_order_id: str,
        body: "_models.SplitRequest",
        **kwargs: Any
    ) -> Optional[List["_models.ReservationResponse"]]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[List["_models.ReservationResponse"]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'SplitRequest')

        request = build_split_request_initial(
            reservation_order_id=reservation_order_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._split_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('[ReservationResponse]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _split_initial.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/split"}  # type: ignore


    @distributed_trace_async
    async def begin_split(
        self,
        reservation_order_id: str,
        body: "_models.SplitRequest",
        **kwargs: Any
    ) -> AsyncLROPoller[List["_models.ReservationResponse"]]:
        """Split the ``Reservation``.

        Split a ``Reservation`` into two ``Reservation``\ s with specified quantity distribution.

        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :param body: Information needed to Split a reservation item.
        :type body: ~azure.mgmt.reservations.models.SplitRequest
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either list of ReservationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[list[~azure.mgmt.reservations.models.ReservationResponse]]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[List["_models.ReservationResponse"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._split_initial(
                reservation_order_id=reservation_order_id,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('[ReservationResponse]', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_split.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/split"}  # type: ignore

    async def _merge_initial(
        self,
        reservation_order_id: str,
        body: "_models.MergeRequest",
        **kwargs: Any
    ) -> Optional[List["_models.ReservationResponse"]]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[List["_models.ReservationResponse"]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'MergeRequest')

        request = build_merge_request_initial(
            reservation_order_id=reservation_order_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._merge_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('[ReservationResponse]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _merge_initial.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/merge"}  # type: ignore


    @distributed_trace_async
    async def begin_merge(
        self,
        reservation_order_id: str,
        body: "_models.MergeRequest",
        **kwargs: Any
    ) -> AsyncLROPoller[List["_models.ReservationResponse"]]:
        """Merges two ``Reservation``\ s.

        Merge the specified ``Reservation``\ s into a new ``Reservation``. The two ``Reservation``\ s
        being merged must have same properties.

        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :param body: Information needed for commercial request for a reservation.
        :type body: ~azure.mgmt.reservations.models.MergeRequest
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either list of ReservationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[list[~azure.mgmt.reservations.models.ReservationResponse]]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[List["_models.ReservationResponse"]]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._merge_initial(
                reservation_order_id=reservation_order_id,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('[ReservationResponse]', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_merge.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/merge"}  # type: ignore

    @distributed_trace
    def list(
        self,
        reservation_order_id: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.ReservationList"]:
        """Get ``Reservation``\ s in a given reservation Order.

        List ``Reservation``\ s within a single ``ReservationOrder``.

        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ReservationList or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.reservations.models.ReservationList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ReservationList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    reservation_order_id=reservation_order_id,
                    api_version=api_version,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_request(
                    reservation_order_id=reservation_order_id,
                    api_version=api_version,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReservationList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        reservation_id: str,
        reservation_order_id: str,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.ReservationResponse":
        """Get ``Reservation`` details.

        Get specific ``Reservation`` details.

        :param reservation_id: Id of the Reservation Item.
        :type reservation_id: str
        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :param expand: Supported value of this query is renewProperties. Default value is None.
        :type expand: str
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReservationResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.ReservationResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ReservationResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        
        request = build_get_request(
            reservation_id=reservation_id,
            reservation_order_id=reservation_order_id,
            api_version=api_version,
            expand=expand,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ReservationResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}"}  # type: ignore


    async def _update_initial(
        self,
        reservation_order_id: str,
        reservation_id: str,
        parameters: "_models.Patch",
        **kwargs: Any
    ) -> Optional["_models.ReservationResponse"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ReservationResponse"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Patch')

        request = build_update_request_initial(
            reservation_order_id=reservation_order_id,
            reservation_id=reservation_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ReservationResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}"}  # type: ignore


    @distributed_trace_async
    async def begin_update(
        self,
        reservation_order_id: str,
        reservation_id: str,
        parameters: "_models.Patch",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.ReservationResponse"]:
        """Updates a ``Reservation``.

        Updates the applied scopes of the ``Reservation``.

        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :param reservation_id: Id of the Reservation Item.
        :type reservation_id: str
        :param parameters: Information needed to patch a reservation item.
        :type parameters: ~azure.mgmt.reservations.models.Patch
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either ReservationResponse or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.ReservationResponse]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ReservationResponse"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._update_initial(
                reservation_order_id=reservation_order_id,
                reservation_id=reservation_id,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('ReservationResponse', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}"}  # type: ignore

    @distributed_trace
    def list_revisions(
        self,
        reservation_id: str,
        reservation_order_id: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.ReservationList"]:
        """Get ``Reservation`` revisions.

        List of all the revisions for the ``Reservation``.

        :param reservation_id: Id of the Reservation Item.
        :type reservation_id: str
        :param reservation_order_id: Order Id of the reservation.
        :type reservation_order_id: str
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ReservationList or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.reservations.models.ReservationList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ReservationList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_revisions_request(
                    reservation_id=reservation_id,
                    reservation_order_id=reservation_order_id,
                    api_version=api_version,
                    template_url=self.list_revisions.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_revisions_request(
                    reservation_id=reservation_id,
                    reservation_order_id=reservation_order_id,
                    api_version=api_version,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReservationList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_revisions.metadata = {'url': "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}/revisions"}  # type: ignore

    @distributed_trace
    def list_all(
        self,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        refresh_summary: Optional[str] = None,
        skiptoken: Optional[float] = None,
        selected_state: Optional[str] = None,
        take: Optional[float] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ReservationsListResult"]:
        """List the reservations and the roll up counts of reservations group by provisioning states that
        the user has access to in the current tenant.

        :param filter: May be used to filter by reservation properties. The filter supports 'eq', 'or',
         and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'. Reservation
         properties include sku/name, properties/{appliedScopeType, archived, displayName,
         displayProvisioningState, effectiveDateTime, expiryDate, provisioningState, quantity, renew,
         reservedResourceType, term, userFriendlyAppliedScopeType, userFriendlyRenewState}. Default
         value is None.
        :type filter: str
        :param orderby: May be used to sort order by reservation properties. Default value is None.
        :type orderby: str
        :param refresh_summary: To indicate whether to refresh the roll up counts of the reservations
         group by provisioning states. Default value is None.
        :type refresh_summary: str
        :param skiptoken: The number of reservations to skip from the list before returning results.
         Default value is None.
        :type skiptoken: float
        :param selected_state: The selected provisioning state. Default value is None.
        :type selected_state: str
        :param take: To number of reservations to return. Default value is None.
        :type take: float
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ReservationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.reservations.models.ReservationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ReservationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_all_request(
                    api_version=api_version,
                    filter=filter,
                    orderby=orderby,
                    refresh_summary=refresh_summary,
                    skiptoken=skiptoken,
                    selected_state=selected_state,
                    take=take,
                    template_url=self.list_all.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_all_request(
                    api_version=api_version,
                    filter=filter,
                    orderby=orderby,
                    refresh_summary=refresh_summary,
                    skiptoken=skiptoken,
                    selected_state=selected_state,
                    take=take,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReservationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_all.metadata = {'url': "/providers/Microsoft.Capacity/reservations"}  # type: ignore
