# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, List, Optional, TypeVar

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._azure_reservation_api_operations import build_get_applied_reservation_list_request, build_get_catalog_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class AzureReservationAPIOperationsMixin:

    @distributed_trace_async
    async def get_catalog(
        self,
        subscription_id: str,
        reserved_resource_type: Optional[str] = None,
        location: Optional[str] = None,
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        **kwargs: Any
    ) -> List["_models.Catalog"]:
        """Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        :param subscription_id: Id of the subscription.
        :type subscription_id: str
        :param reserved_resource_type: The type of the resource for which the skus should be provided.
         Default value is None.
        :type reserved_resource_type: str
        :param location: Filters the skus based on the location specified in this parameter. This can
         be an azure region or global. Default value is None.
        :type location: str
        :param publisher_id: Publisher id used to get the third party products. Default value is None.
        :type publisher_id: str
        :param offer_id: Offer id used to get the third party products. Default value is None.
        :type offer_id: str
        :param plan_id: Plan id used to get the third party products. Default value is None.
        :type plan_id: str
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Catalog, or the result of cls(response)
        :rtype: list[~azure.mgmt.reservations.models.Catalog]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List["_models.Catalog"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        
        request = build_get_catalog_request(
            subscription_id=subscription_id,
            api_version=api_version,
            reserved_resource_type=reserved_resource_type,
            location=location,
            publisher_id=publisher_id,
            offer_id=offer_id,
            plan_id=plan_id,
            template_url=self.get_catalog.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('[Catalog]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_catalog.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs"}  # type: ignore


    @distributed_trace_async
    async def get_applied_reservation_list(
        self,
        subscription_id: str,
        **kwargs: Any
    ) -> "_models.AppliedReservations":
        """Get list of applicable ``Reservation``\ s.

        Get applicable ``Reservation``\ s that are applied to this subscription or a resource group
        under this subscription.

        :param subscription_id: Id of the subscription.
        :type subscription_id: str
        :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppliedReservations, or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.AppliedReservations
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AppliedReservations"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01")  # type: str

        
        request = build_get_applied_reservation_list_request(
            subscription_id=subscription_id,
            api_version=api_version,
            template_url=self.get_applied_reservation_list.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('AppliedReservations', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_applied_reservation_list.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"}  # type: ignore

