# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class TransparentDataEncryption(SubResource):
    """Represents a database transparent data encryption .

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar id: The resource ID.
    :vartype id: str
    :param status: The status of the database transparent data encryption.
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or :class:`TransparentDataEncryptionStatus
     <azure.mgmt.sql.models.TransparentDataEncryptionStatus>`
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'TransparentDataEncryptionStatus'},
    }

    def __init__(self, status=None):
        super(TransparentDataEncryption, self).__init__()
        self.status = status
