# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeployedServiceTypeInfo(Model):
    """Information about service type deployed on a node, information such as the
    status of the service type registration on a node.

    :param service_type_name:
    :type service_type_name: str
    :param service_manifest_name:
    :type service_manifest_name: str
    :param code_package_name:
    :type code_package_name: str
    :param status: Possible values include: 'Invalid', 'Disabled', 'Enabled',
     'Registered'
    :type status: str or :class:`enum <azure.servicefabric.models.enum>`
    :param service_package_activation_id:
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, service_type_name=None, service_manifest_name=None, code_package_name=None, status=None, service_package_activation_id=None):
        self.service_type_name = service_type_name
        self.service_manifest_name = service_manifest_name
        self.code_package_name = code_package_name
        self.status = status
        self.service_package_activation_id = service_package_activation_id
