# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ChaosReport(Model):
    """Contains detailed Chaos report.
    .

    :param chaos_parameters:
    :type chaos_parameters: :class:`ChaosParameters
     <azure.servicefabric.models.ChaosParameters>`
    :param status: Current status of the Chaos run.
     - Invalid - Indicates an invalid Chaos status. All Service Fabric
     enumerations have the invalid type.
     The valus is zero.
     - Running - Indicates that Chaos is not stopped.
     - Stopped - Indicates that Chaos is not scheduling futher faults. Possible
     values include: 'Invalid', 'Running', 'Stopped'
    :type status: str or :class:`enum <azure.servicefabric.models.enum>`
    :param continuation_token:
    :type continuation_token: str
    :param history:
    :type history: list of :class:`ChaosEventWrapper
     <azure.servicefabric.models.ChaosEventWrapper>`
    """

    _attribute_map = {
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'ChaosParameters'},
        'status': {'key': 'Status', 'type': 'str'},
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'history': {'key': 'History', 'type': '[ChaosEventWrapper]'},
    }

    def __init__(self, chaos_parameters=None, status=None, continuation_token=None, history=None):
        self.chaos_parameters = chaos_parameters
        self.status = status
        self.continuation_token = continuation_token
        self.history = history
