# pylint: disable=line-too-long, missing-module-docstring
from typing import Tuple
from pygame.image import fromstring
from pygame import Surface
from base64 import b64decode

# encoded and decoded by following this absolute chad's method:
# https://stackoverflow.com/a/19418452/9559549

default_image = "/wDV//8A1P//ANT//gHV//8B1f/+AdT//wDV//8B1P8AAQD/AQAB/wABAf8AAAD/AAAA/wABAP8AAAD/AAAA//8A1f//ANT//wDU//8A1P//AdT//wHU//8B1P//ANT/AAAA/wEBAP8AAQD/AAAA/wAAAP8AAAH/AAAB/wEBAP//ANT//wDV//8A1P//ANT//wDU//8B1P//ANT//wDU/wAAAP8AAAD/AAEB/wEAAf8AAAH/AAAA/wAAAP8AAQD//wDU//8B1P//ANT//wDU//8B1P//ANX//gDU//8A1f8AAAD/AAAA/wAAAP8AAAH/AAEA/wAAAP8AAAH/AAEA//4A1f//ANT//wDU//8B1P//ANT//wDU//8A1P/+ANT/AAAA/wABAP8AAAD/AAEB/wAAAP8AAAH/AAEA/wEBAP//ANX//wDV//8A1P/+ANT//gDU//8A1P//ANT//wHV/wEAAP8AAAH/AAAA/wAAAf8AAAD/AAAA/wEAAP8AAAH//wDU//8A1P//ANX//wDU//8A1f//ANX//wDU//8A1P8AAQD/AAEB/wAAAP8AAQD/AAEB/wEAAP8BAQD/AQAA//8A1P//ANX//wDU//8A1P//ANX//gDU//8B1P//ANT/AAAA/wEAAP8AAAD/AQAA/wABAP8AAAD/AAAB/wEAAP8AAAD/AAAA/wEAAP8AAAD/AAAA/wAAAP8AAAH/AAEA//8A1P//ANT//wDU//4A1f//AdT//gDU//8A1P//ANT/AQAA/wAAAf8AAAD/AAEA/wAAAP8AAQD/AQAA/wABAP//ANT//gDU//8A1P//AdT//wDU//4A1P//ANT//wHU/wABAP8BAAH/AAAA/wAAAf8AAAD/AAAA/wEBAP8BAAH//wHV//8B1P//ANT//wDU//4A1f//ANT//wDU//8A1P8AAAD/AAAA/wAAAP8AAAD/AQAB/wAAAP8AAQD/AAEA//4A1f//AdT//wHU//8A1P//ANX//wDU//8B1P//ANT/AQAB/wABAP8AAQH/AAAA/wEAAP8BAAH/AAAA/wEAAP//AdX//wDV//8A1P//ANT//wHU//8A1P//ANT//gDV/wABAP8AAQH/AQAA/wEAAP8AAAD/AAAA/wEAAP8AAAD//wHV//8A1P//AdT//gDU//8A1P/+AdT//gDU//8A1P8BAAD/AAAA/wABAP8AAQD/AAAA/wAAAP8AAAD/AAAB//4A1f//ANT//wDU//4A1P//ANT//wDV//8A1P//ANT/AQAA/wABAP8AAAH/AAAA/wABAP8AAAD/AAAB/wAAAP/+ANT//wDU//8A1P//ANT//wDU//4A1f//ANT//wDU/w=="
default_triangle = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wHU/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDU//8A1P8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDU//8A1P//ANT/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/gDU//4A1P//ANT//wDU/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/gDV//8A1f/+ANT//wDU//4A1P8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDU//8A1f//AdT//wHU//4B1P//ANT/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/gDU//8A1P//AdX//wDV//8A1f//AdX//gDV/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDV//4A1P//ANX//wDV//8A1P//ANT//gHU//8A1P8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDU/wAAAP8AAAD/AAAA/wAAAf8AAQD/AAAA/wEAAP8AAQD/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wDU//8A1f8AAAD/AAAB/wAAAP8BAQD/AAEA/wABAP8BAAD/AAEA/wAAAAAAAAAAAAAAAAAAAAAAAAAA/wDV//8A1P//ANT/AAAA/wAAAP8AAAD/AAAB/wEAAP8AAAH/AAEA/wAAAf8AAAAAAAAAAAAAAAAAAAAA/wHU//4B1P//ANX//gDU/wABAP8AAQD/AAEA/wEAAf8AAAD/AAAA/wAAAP8BAAD/AAAAAAAAAAAAAAAA/wDV//8A1P//ANT//wDV//4A1P8AAAD/AAAA/wABAP8BAQD/AAAA/wEAAP8AAAH/AQAA/wAAAAAAAAAA/wHU//4B1P//ANT//wDU//8A1P//ANX/AQAA/wAAAf8AAAD/AAAB/wEBAf8BAAD/AAEA/wAAAP8AAAAA/wDV//8A1P//ANT//wDU//8B1P//AdT//wDU/wAAAf8AAAH/AAEA/wABAf8AAAD/AAAA/wABAP8AAAH//gDU//8A1P//ANX//gDV//8B1f//AdT//wDU//8B1P8AAAD/AAAA/wAAAP8AAAH/AAAA/wABAP8AAAH/AQAA/w=="


def string_to_image(string: str, size: Tuple[int, int] = (16, 16)) -> Surface:

    return fromstring(b64decode(string.encode("utf-8")), size, "RGBX")
