# ![logo](./docs/source/_static/logo_small.png) <br> rubato

[![GitHub](https://img.shields.io/github/license/rubatopy/rubato?style=flat-square)](https://www.gnu.org/licenses/gpl-3.0.html)
[![PyPI](https://img.shields.io/pypi/v/rubato?style=flat-square)](https://pypi.org/project/rubato/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/rubato?style=flat-square)](https://pypi.org/project/rubato/)
[![GitHub Release Date](https://img.shields.io/github/release-date/rubatopy/rubato?style=flat-square)](https://github.com/rubatopy/rubato/releases)
[![GitHub Build Status](https://img.shields.io/github/workflow/status/rubatopy/rubato/Build?style=flat-square)](https://github.com/rubatopy/rubato/actions/workflows/build.yml)
[![GitHub Docs Status](https://img.shields.io/github/workflow/status/rubatopy/rubato/Docs?label=docs&style=flat-square)](https://rubatopy.github.io/)

Rubato is a modern 2D game engine for python. Accurate fixed-step physics simulations, robust scene and sprite management, event listener system and more all come prepackaged.

Fundamentally, Rubato is built developer-focused. From intricate rigidbody simulations to 2D games, Rubato streamlines development for beginners and the poweruser. And all that finally with some legible documentation.

Rubato currently relies on PyGame for underlying functionality, but we are actively working to depreciate this with SDL2. This will reduce overhead and remedy some nasty PyGame quirks. On older Rubato versions PyGame can still be accessed, but keep in mind porting to newer versions may break code.

_Wondering about the name? Rubato is a music term that indicates a phrase that should be performed expressively and freely. We aim to bring a fresh, modern take on game developement in python to a variety of users regardless of their coding background._

### Get started [here](https://rubatopy.github.io/).
