# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class CassandraTable(Resource):
    """An Azure Cosmos DB Cassandra table.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique resource identifier of the database account.
    :vartype id: str
    :ivar name: The name of the database account.
    :vartype name: str
    :ivar type: The type of Azure resource.
    :vartype type: str
    :param location: The location of the resource group to which the resource
     belongs.
    :type location: str
    :param tags:
    :type tags: dict[str, str]
    :param cassandra_table_id: Required. Name of the Cosmos DB Cassandra table
    :type cassandra_table_id: str
    :param default_ttl: Time to live of the Cosmos DB Cassandra table
    :type default_ttl: int
    :param schema: Schema of the Cosmos DB Cassandra table
    :type schema: ~azure.mgmt.cosmosdb.models.CassandraSchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cassandra_table_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'cassandra_table_id': {'key': 'properties.id', 'type': 'str'},
        'default_ttl': {'key': 'properties.defaultTtl', 'type': 'int'},
        'schema': {'key': 'properties.schema', 'type': 'CassandraSchema'},
    }

    def __init__(self, **kwargs):
        super(CassandraTable, self).__init__(**kwargs)
        self.cassandra_table_id = kwargs.get('cassandra_table_id', None)
        self.default_ttl = kwargs.get('default_ttl', None)
        self.schema = kwargs.get('schema', None)
