from Products.Five import BrowserView
from zope.component import getUtility
from plone.app.async.interfaces import IAsyncService
from Products.CMFPlone.utils import base_hasattr
from Products.Archetypes.utils import contentDispositionHeader
from wildcard.pdfpal.settings import PDFSettings
from os import fstat
from webdav.common import rfc1123_date
from wildcard.pdfpal.thumbnail import preview_field, thumb_field
from wildcard.pdfpal import mf as _
from wildcard.pdfpal.interfaces import IPDFPalConfiguration
from plone.app.controlpanel.form import ControlPanelForm
from zope.formlib import form

class AsyncMonitor(BrowserView):
    """
    
    """
    
    @property
    def jobs(self):
        async = getUtility(IAsyncService)
        queue = async.getQueues()['']
        jobs = [job for job in queue]
        results = []
        for job in jobs:
            results.append({
                'func' : job.args[-1].__name__, 
                'status' : job.status,
                'user' : job.args[-3]
            })
            
        return results
        
        
class AlbumView(BrowserView):
    
    def getContents(self, object=None, portal_type=('File',), full_objects=False, path=None):
        if not object:
            object = self.context
            
        opts = { 'portal_type' : portal_type }
        if path:
            opts['path'] = path
            
        if object.portal_type == 'Topic':
            res = object.queryCatalog(**opts)
        else:
            opts['sort_on'] = 'getObjPositionInParent'
            res = object.getFolderContents(contentFilter = opts, full_objects=full_objects)
        
        return res
    
    def results(self):

        result = {}

        result['files'] = self.getContents(portal_type=('File',), full_objects=True)
        result['folders'] = self.getContents(portal_type = ('Folder', 'Large Plone Folder'))

        return result
        
        
    def get_files(self, obj):
        #Handle brains or objects
        if base_hasattr(obj, 'getPath'):
            path = obj.getPath()
        else:
            path = '/'.join(obj.getPhysicalPath())
        # Explicitly set path to remove default depth
        return self.getContents(object=obj, portal_type = ('File',), path = path)
        
        
try:
    import plone.app.blob
    from plone.app.blob.download import handleRequestRange
    from plone.app.blob.iterators import BlobStreamIterator
    from plone.app.blob.utils import openBlob
    from ZODB.blob import Blob
    has_pab = True
except:
    has_pab = False
        
class PDFPreviewImageView(BrowserView):
    
    image_type = 'preview'
    field = preview_field
    
    def render_blob_version(self, blob):
        # done much like it is done in plone.app.blob's index_html
        header_value = contentDispositionHeader(disposition='attachment', filename='image_%s.jpg' % self.image_type)
        
        blobfi = openBlob(blob)
        length = fstat(blobfi.fileno()).st_size
        blobfi.close()
        
        self.request.response.setHeader('Last-Modified', rfc1123_date(self.context._p_mtime))
        self.request.response.setHeader('Accept-Ranges', 'bytes')
        self.request.response.setHeader('Content-Disposition', header_value)
        self.request.response.setHeader("Content-Length", length)
        self.request.response.setHeader('Content-Type', 'image/jpe  g')
        range = handleRequestRange(self.context, length, self.request, self.request.response)
        return BlobStreamIterator(blob, **range)
        
    def __call__(self):
        settings = PDFSettings(self.context)
        blob = getattr(settings, self.image_type + '_data', None)
        if has_pab and isinstance(blob, Blob):
            return self.render_blob_version(blob)
        else:
            try:
                return self.field.download(self.context)
            except:
                return ''
            
class PDFThumbImageView(PDFPreviewImageView):

    image_type = 'thumb'
    field = thumb_field
    
    
class PDFPalControlPanel(ControlPanelForm):
    """Control panel form for setting pdfpeek image and thumbnail sizes"""
    form_fields = form.FormFields(IPDFPalConfiguration)
    label = _(u'PDF Pal Settings')
    description = _(u'Manage PDF Pal settings')
    form_name = _(u'PDF Pal Settings')

