"""
Auto generated code

"""

import json
from snapp_email.datacontract.classes import Signature_20
from snapp_email.datacontract.utils import export_dict, fill


class Signature_20Endpoint:
    def __init__(self, api_client):
        self.api_client = api_client
    
    def options(self, impersonate_user_id=None, accept_type=None):
        """
        Retrieve options available for resource 'Signature_20'.
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Signature_20
        """
        url_parameters = {
        }
        endpoint_parameters = {
        }
        endpoint = 'signature'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.signature-5.15+json',
            'Accept': 'application/vnd.4thoffice.signature-5.15+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('options', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Signature_20, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def get(self, signatureId, impersonate_user_id=None, accept_type=None):
        """
        Retrieve signature resource
        
        :param signatureId: 
        :type signatureId: 
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Signature_20
        """
        url_parameters = {
        }
        endpoint_parameters = {
            'signatureId': signatureId,
        }
        endpoint = 'signature/{signatureId}'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.signature-5.15+json',
            'Accept': 'application/vnd.4thoffice.signature-5.15+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('get', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Signature_20, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def create(self, obj, default=None, impersonate_user_id=None, accept_type=None):
        """
        Create signature
        
        :param obj: Object to be persisted
        :type obj: Signature_20
        
        :param default: Specify if default
        :type default: Boolean
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Signature_20
        """
        url_parameters = {
            'default': default,
        }
        endpoint_parameters = {
        }
        endpoint = 'signature'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.signature-5.15+json',
            'Accept': 'application/vnd.4thoffice.signature-5.15+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Signature_20, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def update(self, obj, signatureId, default=None, impersonate_user_id=None, accept_type=None):
        """
        Update signature
        
        :param obj: Object to be persisted
        :type obj: Signature_20
        
        :param signatureId: 
        :type signatureId: 
        
        :param default: Specify if default
        :type default: Boolean
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Signature_20
        """
        url_parameters = {
            'default': default,
        }
        endpoint_parameters = {
            'signatureId': signatureId,
        }
        endpoint = 'signature/{signatureId}'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.signature-5.15+json',
            'Accept': 'application/vnd.4thoffice.signature-5.15+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('put', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Signature_20, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def delete(self, signatureId, impersonate_user_id=None, accept_type=None):
        """
        Delete signature
        
        :param signatureId: 
        :type signatureId: 
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: True if object was deleted, otherwise an exception is raised
        :rtype: bool
        """
        url_parameters = {
        }
        endpoint_parameters = {
            'signatureId': signatureId,
        }
        endpoint = 'signature/{signatureId}'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.signature-5.15+json',
            'Accept': 'application/vnd.4thoffice.signature-5.15+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('delete', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return True
