# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._data_migration_management_client_enums import *


class ApiError(msrest.serialization.Model):
    """Error information.

    :param error: Error information in OData format.
    :type error: ~azure.mgmt.datamigration.models.ODataError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ODataError'},
    }

    def __init__(
        self,
        *,
        error: Optional["ODataError"] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.error = error


class AvailableServiceSku(msrest.serialization.Model):
    """Describes the available service SKU.

    :param resource_type: The resource type, including the provider namespace.
    :type resource_type: str
    :param sku: SKU name, tier, etc.
    :type sku: ~azure.mgmt.datamigration.models.AvailableServiceSkuSku
    :param capacity: A description of the scaling capacities of the SKU.
    :type capacity: ~azure.mgmt.datamigration.models.AvailableServiceSkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AvailableServiceSkuSku'},
        'capacity': {'key': 'capacity', 'type': 'AvailableServiceSkuCapacity'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["AvailableServiceSkuSku"] = None,
        capacity: Optional["AvailableServiceSkuCapacity"] = None,
        **kwargs
    ):
        super(AvailableServiceSku, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class AvailableServiceSkuCapacity(msrest.serialization.Model):
    """A description of the scaling capacities of the SKU.

    :param minimum: The minimum capacity, usually 0 or 1.
    :type minimum: int
    :param maximum: The maximum capacity.
    :type maximum: int
    :param default: The default capacity.
    :type default: int
    :param scale_type: The scalability approach. Possible values include: "none", "manual",
     "automatic".
    :type scale_type: str or ~azure.mgmt.datamigration.models.ServiceScalability
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "ServiceScalability"]] = None,
        **kwargs
    ):
        super(AvailableServiceSkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class AvailableServiceSkuSku(msrest.serialization.Model):
    """SKU name, tier, etc.

    :param name: The name of the SKU.
    :type name: str
    :param family: SKU family.
    :type family: str
    :param size: SKU size.
    :type size: str
    :param tier: The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical".
    :type tier: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        super(AvailableServiceSkuSku, self).__init__(**kwargs)
        self.name = name
        self.family = family
        self.size = size
        self.tier = tier


class AzureActiveDirectoryApp(msrest.serialization.Model):
    """Azure Active Directory Application.

    All required parameters must be populated in order to send to Azure.

    :param application_id: Required. Application ID of the Azure Active Directory Application.
    :type application_id: str
    :param app_key: Required. Key used to authenticate to the Azure Active Directory Application.
    :type app_key: str
    :param tenant_id: Required. Tenant id of the customer.
    :type tenant_id: str
    """

    _validation = {
        'application_id': {'required': True},
        'app_key': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'app_key': {'key': 'appKey', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        application_id: str,
        app_key: str,
        tenant_id: str,
        **kwargs
    ):
        super(AzureActiveDirectoryApp, self).__init__(**kwargs)
        self.application_id = application_id
        self.app_key = app_key
        self.tenant_id = tenant_id


class BackupFileInfo(msrest.serialization.Model):
    """Information of the backup file.

    :param file_location: Location of the backup file in shared folder.
    :type file_location: str
    :param family_sequence_number: Sequence number of the backup file in the backup set.
    :type family_sequence_number: int
    :param status: Status of the backup file during migration. Possible values include: "Arrived",
     "Queued", "Uploading", "Uploaded", "Restoring", "Restored", "Cancelled".
    :type status: str or ~azure.mgmt.datamigration.models.BackupFileStatus
    """

    _attribute_map = {
        'file_location': {'key': 'fileLocation', 'type': 'str'},
        'family_sequence_number': {'key': 'familySequenceNumber', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_location: Optional[str] = None,
        family_sequence_number: Optional[int] = None,
        status: Optional[Union[str, "BackupFileStatus"]] = None,
        **kwargs
    ):
        super(BackupFileInfo, self).__init__(**kwargs)
        self.file_location = file_location
        self.family_sequence_number = family_sequence_number
        self.status = status


class BackupSetInfo(msrest.serialization.Model):
    """Information of backup set.

    :param backup_set_id: Id for the set of backup files.
    :type backup_set_id: str
    :param first_lsn: First log sequence number of the backup file.
    :type first_lsn: str
    :param last_lsn: Last log sequence number of the backup file.
    :type last_lsn: str
    :param last_modified_time: Last modified time of the backup file in share location.
    :type last_modified_time: ~datetime.datetime
    :param backup_type: Enum of the different backup types. Possible values include: "Database",
     "TransactionLog", "File", "DifferentialDatabase", "DifferentialFile", "Partial",
     "DifferentialPartial".
    :type backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :param list_of_backup_files: List of files in the backup set.
    :type list_of_backup_files: list[~azure.mgmt.datamigration.models.BackupFileInfo]
    :param database_name: Name of the database to which the backup set belongs.
    :type database_name: str
    :param backup_start_date: Date and time that the backup operation began.
    :type backup_start_date: ~datetime.datetime
    :param backup_finished_date: Date and time that the backup operation finished.
    :type backup_finished_date: ~datetime.datetime
    :param is_backup_restored: Whether the backup set is restored or not.
    :type is_backup_restored: bool
    """

    _attribute_map = {
        'backup_set_id': {'key': 'backupSetId', 'type': 'str'},
        'first_lsn': {'key': 'firstLsn', 'type': 'str'},
        'last_lsn': {'key': 'lastLsn', 'type': 'str'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'list_of_backup_files': {'key': 'listOfBackupFiles', 'type': '[BackupFileInfo]'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'backup_start_date': {'key': 'backupStartDate', 'type': 'iso-8601'},
        'backup_finished_date': {'key': 'backupFinishedDate', 'type': 'iso-8601'},
        'is_backup_restored': {'key': 'isBackupRestored', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        backup_set_id: Optional[str] = None,
        first_lsn: Optional[str] = None,
        last_lsn: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        backup_type: Optional[Union[str, "BackupType"]] = None,
        list_of_backup_files: Optional[List["BackupFileInfo"]] = None,
        database_name: Optional[str] = None,
        backup_start_date: Optional[datetime.datetime] = None,
        backup_finished_date: Optional[datetime.datetime] = None,
        is_backup_restored: Optional[bool] = None,
        **kwargs
    ):
        super(BackupSetInfo, self).__init__(**kwargs)
        self.backup_set_id = backup_set_id
        self.first_lsn = first_lsn
        self.last_lsn = last_lsn
        self.last_modified_time = last_modified_time
        self.backup_type = backup_type
        self.list_of_backup_files = list_of_backup_files
        self.database_name = database_name
        self.backup_start_date = backup_start_date
        self.backup_finished_date = backup_finished_date
        self.is_backup_restored = is_backup_restored


class BlobShare(msrest.serialization.Model):
    """Blob container storage information.

    All required parameters must be populated in order to send to Azure.

    :param sas_uri: Required. SAS URI of Azure Storage Account Container.
    :type sas_uri: str
    """

    _validation = {
        'sas_uri': {'required': True},
    }

    _attribute_map = {
        'sas_uri': {'key': 'sasUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_uri: str,
        **kwargs
    ):
        super(BlobShare, self).__init__(**kwargs)
        self.sas_uri = sas_uri


class CheckOCIDriverTaskInput(msrest.serialization.Model):
    """Input for the service task to check for OCI drivers.

    :param server_version: Version of the source server to check against.  Optional.
    :type server_version: str
    """

    _attribute_map = {
        'server_version': {'key': 'serverVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_version: Optional[str] = None,
        **kwargs
    ):
        super(CheckOCIDriverTaskInput, self).__init__(**kwargs)
        self.server_version = server_version


class CheckOCIDriverTaskOutput(msrest.serialization.Model):
    """Output for the service task to check for OCI drivers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param installed_driver: Information about the installed driver if found and valid.
    :type installed_driver: ~azure.mgmt.datamigration.models.OracleOCIDriverInfo
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'installed_driver': {'key': 'installedDriver', 'type': 'OracleOCIDriverInfo'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        *,
        installed_driver: Optional["OracleOCIDriverInfo"] = None,
        **kwargs
    ):
        super(CheckOCIDriverTaskOutput, self).__init__(**kwargs)
        self.installed_driver = installed_driver
        self.validation_errors = None


class ProjectTaskProperties(msrest.serialization.Model):
    """Base class for all types of DMS task properties. If task is not supported by current client, this object is returned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConnectToMongoDbTaskProperties, ConnectToSourceMySqlTaskProperties, ConnectToSourceOracleSyncTaskProperties, ConnectToSourcePostgreSqlSyncTaskProperties, ConnectToSourceSqlServerTaskProperties, ConnectToSourceSqlServerSyncTaskProperties, ConnectToTargetAzureDbForMySqlTaskProperties, ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties, ConnectToTargetSqlMITaskProperties, ConnectToTargetSqlMISyncTaskProperties, ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties, ConnectToTargetSqlDbTaskProperties, ConnectToTargetSqlDbSyncTaskProperties, GetTdeCertificatesSqlTaskProperties, GetUserTablesSqlSyncTaskProperties, GetUserTablesSqlTaskProperties, GetUserTablesOracleTaskProperties, GetUserTablesPostgreSqlTaskProperties, MigrateMongoDbTaskProperties, MigrateMySqlAzureDbForMySqlSyncTaskProperties, MigrateOracleAzureDbForPostgreSqlSyncTaskProperties, MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties, MigrateSqlServerSqlDbSyncTaskProperties, MigrateSqlServerSqlMITaskProperties, MigrateSqlServerSqlMISyncTaskProperties, MigrateSqlServerSqlDbTaskProperties, MigrateSsisTaskProperties, MigrateSchemaSqlServerSqlDbTaskProperties, CheckOCIDriverTaskProperties, InstallOCIDriverTaskProperties, UploadOCIDriverTaskProperties, ValidateMongoDbTaskProperties, ValidateOracleAzureDbForPostgreSqlSyncTaskProperties, ValidateMigrationInputSqlServerSqlMITaskProperties, ValidateMigrationInputSqlServerSqlMISyncTaskProperties, ValidateMigrationInputSqlServerSqlDbSyncTaskProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
    }

    _subtype_map = {
        'task_type': {'Connect.MongoDb': 'ConnectToMongoDbTaskProperties', 'ConnectToSource.MySql': 'ConnectToSourceMySqlTaskProperties', 'ConnectToSource.Oracle.Sync': 'ConnectToSourceOracleSyncTaskProperties', 'ConnectToSource.PostgreSql.Sync': 'ConnectToSourcePostgreSqlSyncTaskProperties', 'ConnectToSource.SqlServer': 'ConnectToSourceSqlServerTaskProperties', 'ConnectToSource.SqlServer.Sync': 'ConnectToSourceSqlServerSyncTaskProperties', 'ConnectToTarget.AzureDbForMySql': 'ConnectToTargetAzureDbForMySqlTaskProperties', 'ConnectToTarget.AzureDbForPostgreSql.Sync': 'ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties', 'ConnectToTarget.AzureSqlDbMI': 'ConnectToTargetSqlMITaskProperties', 'ConnectToTarget.AzureSqlDbMI.Sync.LRS': 'ConnectToTargetSqlMISyncTaskProperties', 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync': 'ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties', 'ConnectToTarget.SqlDb': 'ConnectToTargetSqlDbTaskProperties', 'ConnectToTarget.SqlDb.Sync': 'ConnectToTargetSqlDbSyncTaskProperties', 'GetTDECertificates.Sql': 'GetTdeCertificatesSqlTaskProperties', 'GetUserTables.AzureSqlDb.Sync': 'GetUserTablesSqlSyncTaskProperties', 'GetUserTables.Sql': 'GetUserTablesSqlTaskProperties', 'GetUserTablesOracle': 'GetUserTablesOracleTaskProperties', 'GetUserTablesPostgreSql': 'GetUserTablesPostgreSqlTaskProperties', 'Migrate.MongoDb': 'MigrateMongoDbTaskProperties', 'Migrate.MySql.AzureDbForMySql.Sync': 'MigrateMySqlAzureDbForMySqlSyncTaskProperties', 'Migrate.Oracle.AzureDbForPostgreSql.Sync': 'MigrateOracleAzureDbForPostgreSqlSyncTaskProperties', 'Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties', 'Migrate.SqlServer.AzureSqlDb.Sync': 'MigrateSqlServerSqlDbSyncTaskProperties', 'Migrate.SqlServer.AzureSqlDbMI': 'MigrateSqlServerSqlMITaskProperties', 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS': 'MigrateSqlServerSqlMISyncTaskProperties', 'Migrate.SqlServer.SqlDb': 'MigrateSqlServerSqlDbTaskProperties', 'Migrate.Ssis': 'MigrateSsisTaskProperties', 'MigrateSchemaSqlServerSqlDb': 'MigrateSchemaSqlServerSqlDbTaskProperties', 'Service.Check.OCI': 'CheckOCIDriverTaskProperties', 'Service.Install.OCI': 'InstallOCIDriverTaskProperties', 'Service.Upload.OCI': 'UploadOCIDriverTaskProperties', 'Validate.MongoDb': 'ValidateMongoDbTaskProperties', 'Validate.Oracle.AzureDbPostgreSql.Sync': 'ValidateOracleAzureDbForPostgreSqlSyncTaskProperties', 'ValidateMigrationInput.SqlServer.AzureSqlDbMI': 'ValidateMigrationInputSqlServerSqlMITaskProperties', 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS': 'ValidateMigrationInputSqlServerSqlMISyncTaskProperties', 'ValidateMigrationInput.SqlServer.SqlDb.Sync': 'ValidateMigrationInputSqlServerSqlDbSyncTaskProperties'}
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProjectTaskProperties, self).__init__(**kwargs)
        self.task_type = None  # type: Optional[str]
        self.errors = None
        self.state = None
        self.commands = None
        self.client_data = client_data


class CheckOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that checks for OCI drivers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Input for the service task to check for OCI drivers.
    :type input: ~azure.mgmt.datamigration.models.CheckOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.CheckOCIDriverTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'CheckOCIDriverTaskInput'},
        'output': {'key': 'output', 'type': '[CheckOCIDriverTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["CheckOCIDriverTaskInput"] = None,
        **kwargs
    ):
        super(CheckOCIDriverTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Service.Check.OCI'  # type: str
        self.input = input
        self.output = None


class CommandProperties(msrest.serialization.Model):
    """Base class for all types of DMS command properties. If command is not supported by current client, this object is returned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateMISyncCompleteCommandProperties, MigrateSyncCompleteCommandProperties, MongoDbCancelCommand, MongoDbFinishCommand, MongoDbRestartCommand.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
    }

    _subtype_map = {
        'command_type': {'Migrate.SqlServer.AzureDbSqlMi.Complete': 'MigrateMISyncCompleteCommandProperties', 'Migrate.Sync.Complete.Database': 'MigrateSyncCompleteCommandProperties', 'cancel': 'MongoDbCancelCommand', 'finish': 'MongoDbFinishCommand', 'restart': 'MongoDbRestartCommand'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommandProperties, self).__init__(**kwargs)
        self.command_type = None  # type: Optional[str]
        self.errors = None
        self.state = None


class ConnectionInfo(msrest.serialization.Model):
    """Defines the connection properties of a server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MiSqlConnectionInfo, MongoDbConnectionInfo, MySqlConnectionInfo, OracleConnectionInfo, PostgreSqlConnectionInfo, SqlConnectionInfo.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'MiSqlConnectionInfo': 'MiSqlConnectionInfo', 'MongoDbConnectionInfo': 'MongoDbConnectionInfo', 'MySqlConnectionInfo': 'MySqlConnectionInfo', 'OracleConnectionInfo': 'OracleConnectionInfo', 'PostgreSqlConnectionInfo': 'PostgreSqlConnectionInfo', 'SqlConnectionInfo': 'SqlConnectionInfo'}
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionInfo, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.user_name = user_name
        self.password = password


class ConnectToMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates the connection to and provides information about a MongoDB server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Describes a connection to a MongoDB data source.
    :type input: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :ivar output: An array containing a single MongoDbClusterInfo object.
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbClusterInfo]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MongoDbConnectionInfo'},
        'output': {'key': 'output', 'type': '[MongoDbClusterInfo]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MongoDbConnectionInfo"] = None,
        **kwargs
    ):
        super(ConnectToMongoDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Connect.MongoDb'  # type: str
        self.input = input
        self.output = None


class ConnectToSourceMySqlTaskInput(msrest.serialization.Model):
    """Input for the task that validates MySQL database connection.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to MySQL source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :param target_platform: Target Platform for the migration. Possible values include:
     "SqlServer", "AzureDbForMySQL".
    :type target_platform: str or ~azure.mgmt.datamigration.models.MySqlTargetPlatformType
    :param check_permissions_group: Permission group for validations. Possible values include:
     "Default", "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
     "MigrationFromMySQLToAzureDBForMySQL".
    :type check_permissions_group: str or
     ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
    """

    _validation = {
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'MySqlConnectionInfo'},
        'target_platform': {'key': 'targetPlatform', 'type': 'str'},
        'check_permissions_group': {'key': 'checkPermissionsGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "MySqlConnectionInfo",
        target_platform: Optional[Union[str, "MySqlTargetPlatformType"]] = None,
        check_permissions_group: Optional[Union[str, "ServerLevelPermissionsGroup"]] = None,
        **kwargs
    ):
        super(ConnectToSourceMySqlTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_platform = target_platform
        self.check_permissions_group = check_permissions_group


class ConnectToSourceMySqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates MySQL database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToSourceMySqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceNonSqlTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToSourceMySqlTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToSourceNonSqlTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToSourceMySqlTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToSourceMySqlTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToSource.MySql'  # type: str
        self.input = input
        self.output = None


class ConnectToSourceNonSqlTaskOutput(msrest.serialization.Model):
    """Output for connect to MySQL type source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar source_server_brand_version: Server brand version.
    :vartype source_server_brand_version: str
    :ivar server_properties: Server properties.
    :vartype server_properties: ~azure.mgmt.datamigration.models.ServerProperties
    :ivar databases: List of databases on the server.
    :vartype databases: list[str]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'server_properties': {'readonly': True},
        'databases': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'server_properties': {'key': 'serverProperties', 'type': 'ServerProperties'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceNonSqlTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.source_server_brand_version = None
        self.server_properties = None
        self.databases = None
        self.validation_errors = None


class ConnectToSourceOracleSyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates Oracle database connection.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to Oracle source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'OracleConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "OracleConnectionInfo",
        **kwargs
    ):
        super(ConnectToSourceOracleSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info


class ConnectToSourceOracleSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that validates Oracle database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_server_version: Version of the source server.
    :vartype source_server_version: str
    :ivar databases: List of schemas on source server.
    :vartype databases: list[str]
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'source_server_version': {'readonly': True},
        'databases': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceOracleSyncTaskOutput, self).__init__(**kwargs)
        self.source_server_version = None
        self.databases = None
        self.source_server_brand_version = None
        self.validation_errors = None


class ConnectToSourceOracleSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates Oracle database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToSourceOracleSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceOracleSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToSourceOracleSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToSourceOracleSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToSourceOracleSyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToSourceOracleSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToSource.Oracle.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToSourcePostgreSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to PostgreSQL and source server requirements.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for source PostgreSQL server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "PostgreSqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToSourcePostgreSqlSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info


class ConnectToSourcePostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to PostgreSQL and source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar source_server_version: Version of the source server.
    :vartype source_server_version: str
    :ivar databases: List of databases on source server.
    :vartype databases: list[str]
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'source_server_version': {'readonly': True},
        'databases': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourcePostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.source_server_version = None
        self.databases = None
        self.source_server_brand_version = None
        self.validation_errors = None


class ConnectToSourcePostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to PostgreSQL server and source server requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToSourcePostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourcePostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToSourcePostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToSourcePostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToSourcePostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToSourcePostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToSource.PostgreSql.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToSourceSqlServerSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL Server and source server requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToSourceSqlServerTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToSourceSqlServerTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToSourceSqlServerTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToSourceSqlServerSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToSource.SqlServer.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToSourceSqlServerTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to SQL Server and also validates source server requirements.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for Source SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param check_permissions_group: Permission group for validations. Possible values include:
     "Default", "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
     "MigrationFromMySQLToAzureDBForMySQL".
    :type check_permissions_group: str or
     ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
    :param collect_databases: Flag for whether to collect databases from source server.
    :type collect_databases: bool
    :param collect_logins: Flag for whether to collect logins from source server.
    :type collect_logins: bool
    :param collect_agent_jobs: Flag for whether to collect agent jobs from source server.
    :type collect_agent_jobs: bool
    :param collect_tde_certificate_info: Flag for whether to collect TDE Certificate names from
     source server.
    :type collect_tde_certificate_info: bool
    :param validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on
     the source server.
    :type validate_ssis_catalog_only: bool
    """

    _validation = {
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'check_permissions_group': {'key': 'checkPermissionsGroup', 'type': 'str'},
        'collect_databases': {'key': 'collectDatabases', 'type': 'bool'},
        'collect_logins': {'key': 'collectLogins', 'type': 'bool'},
        'collect_agent_jobs': {'key': 'collectAgentJobs', 'type': 'bool'},
        'collect_tde_certificate_info': {'key': 'collectTdeCertificateInfo', 'type': 'bool'},
        'validate_ssis_catalog_only': {'key': 'validateSsisCatalogOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        check_permissions_group: Optional[Union[str, "ServerLevelPermissionsGroup"]] = None,
        collect_databases: Optional[bool] = True,
        collect_logins: Optional[bool] = False,
        collect_agent_jobs: Optional[bool] = False,
        collect_tde_certificate_info: Optional[bool] = False,
        validate_ssis_catalog_only: Optional[bool] = False,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.check_permissions_group = check_permissions_group
        self.collect_databases = collect_databases
        self.collect_logins = collect_logins
        self.collect_agent_jobs = collect_agent_jobs
        self.collect_tde_certificate_info = collect_tde_certificate_info
        self.validate_ssis_catalog_only = validate_ssis_catalog_only


class ConnectToSourceSqlServerTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to SQL Server and also validates source server requirements.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConnectToSourceSqlServerTaskOutputAgentJobLevel, ConnectToSourceSqlServerTaskOutputDatabaseLevel, ConnectToSourceSqlServerTaskOutputLoginLevel, ConnectToSourceSqlServerTaskOutputTaskLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Type of result - database level or task level.Constant filled by
     server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'AgentJobLevelOutput': 'ConnectToSourceSqlServerTaskOutputAgentJobLevel', 'DatabaseLevelOutput': 'ConnectToSourceSqlServerTaskOutputDatabaseLevel', 'LoginLevelOutput': 'ConnectToSourceSqlServerTaskOutputLoginLevel', 'TaskLevelOutput': 'ConnectToSourceSqlServerTaskOutputTaskLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class ConnectToSourceSqlServerTaskOutputAgentJobLevel(ConnectToSourceSqlServerTaskOutput):
    """Agent Job level output for the task that validates connection to SQL Server and also validates source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Type of result - database level or task level.Constant filled by
     server.
    :type result_type: str
    :ivar name: Agent Job name.
    :vartype name: str
    :ivar job_category: The type of Agent Job.
    :vartype job_category: str
    :ivar is_enabled: The state of the original Agent Job.
    :vartype is_enabled: bool
    :ivar job_owner: The owner of the Agent Job.
    :vartype job_owner: str
    :ivar last_executed_on: UTC Date and time when the Agent Job was last executed.
    :vartype last_executed_on: ~datetime.datetime
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar migration_eligibility: Information about eligibility of agent job for migration.
    :vartype migration_eligibility: ~azure.mgmt.datamigration.models.MigrationEligibilityInfo
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'name': {'readonly': True},
        'job_category': {'readonly': True},
        'is_enabled': {'readonly': True},
        'job_owner': {'readonly': True},
        'last_executed_on': {'readonly': True},
        'validation_errors': {'readonly': True},
        'migration_eligibility': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'job_category': {'key': 'jobCategory', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'job_owner': {'key': 'jobOwner', 'type': 'str'},
        'last_executed_on': {'key': 'lastExecutedOn', 'type': 'iso-8601'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
        'migration_eligibility': {'key': 'migrationEligibility', 'type': 'MigrationEligibilityInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskOutputAgentJobLevel, self).__init__(**kwargs)
        self.result_type = 'AgentJobLevelOutput'  # type: str
        self.name = None
        self.job_category = None
        self.is_enabled = None
        self.job_owner = None
        self.last_executed_on = None
        self.validation_errors = None
        self.migration_eligibility = None


class ConnectToSourceSqlServerTaskOutputDatabaseLevel(ConnectToSourceSqlServerTaskOutput):
    """Database level output for the task that validates connection to SQL Server and also validates source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Type of result - database level or task level.Constant filled by
     server.
    :type result_type: str
    :ivar name: Database name.
    :vartype name: str
    :ivar size_mb: Size of the file in megabytes.
    :vartype size_mb: float
    :ivar database_files: The list of database files.
    :vartype database_files: list[~azure.mgmt.datamigration.models.DatabaseFileInfo]
    :ivar compatibility_level: SQL Server compatibility level of database. Possible values include:
     "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110", "CompatLevel120",
     "CompatLevel130", "CompatLevel140".
    :vartype compatibility_level: str or ~azure.mgmt.datamigration.models.DatabaseCompatLevel
    :ivar database_state: State of the database. Possible values include: "Online", "Restoring",
     "Recovering", "RecoveryPending", "Suspect", "Emergency", "Offline", "Copying",
     "OfflineSecondary".
    :vartype database_state: str or ~azure.mgmt.datamigration.models.DatabaseState
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'name': {'readonly': True},
        'size_mb': {'readonly': True},
        'database_files': {'readonly': True},
        'compatibility_level': {'readonly': True},
        'database_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size_mb': {'key': 'sizeMB', 'type': 'float'},
        'database_files': {'key': 'databaseFiles', 'type': '[DatabaseFileInfo]'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str'},
        'database_state': {'key': 'databaseState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.name = None
        self.size_mb = None
        self.database_files = None
        self.compatibility_level = None
        self.database_state = None


class ConnectToSourceSqlServerTaskOutputLoginLevel(ConnectToSourceSqlServerTaskOutput):
    """Login level output for the task that validates connection to SQL Server and also validates source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Type of result - database level or task level.Constant filled by
     server.
    :type result_type: str
    :ivar name: Login name.
    :vartype name: str
    :ivar login_type: The type of login. Possible values include: "WindowsUser", "WindowsGroup",
     "SqlLogin", "Certificate", "AsymmetricKey", "ExternalUser", "ExternalGroup".
    :vartype login_type: str or ~azure.mgmt.datamigration.models.LoginType
    :ivar default_database: The default database for the login.
    :vartype default_database: str
    :ivar is_enabled: The state of the login.
    :vartype is_enabled: bool
    :ivar migration_eligibility: Information about eligibility of login for migration.
    :vartype migration_eligibility: ~azure.mgmt.datamigration.models.MigrationEligibilityInfo
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'name': {'readonly': True},
        'login_type': {'readonly': True},
        'default_database': {'readonly': True},
        'is_enabled': {'readonly': True},
        'migration_eligibility': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'login_type': {'key': 'loginType', 'type': 'str'},
        'default_database': {'key': 'defaultDatabase', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'migration_eligibility': {'key': 'migrationEligibility', 'type': 'MigrationEligibilityInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskOutputLoginLevel, self).__init__(**kwargs)
        self.result_type = 'LoginLevelOutput'  # type: str
        self.name = None
        self.login_type = None
        self.default_database = None
        self.is_enabled = None
        self.migration_eligibility = None


class ConnectToSourceSqlServerTaskOutputTaskLevel(ConnectToSourceSqlServerTaskOutput):
    """Task level output for the task that validates connection to SQL Server and also validates source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Type of result - database level or task level.Constant filled by
     server.
    :type result_type: str
    :ivar databases: Source databases as a map from database name to database id.
    :vartype databases: str
    :ivar logins: Source logins as a map from login name to login id.
    :vartype logins: str
    :ivar agent_jobs: Source agent jobs as a map from agent job name to id.
    :vartype agent_jobs: str
    :ivar database_tde_certificate_mapping: Mapping from database name to TDE certificate name, if
     applicable.
    :vartype database_tde_certificate_mapping: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'databases': {'readonly': True},
        'logins': {'readonly': True},
        'agent_jobs': {'readonly': True},
        'database_tde_certificate_mapping': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'databases': {'key': 'databases', 'type': 'str'},
        'logins': {'key': 'logins', 'type': 'str'},
        'agent_jobs': {'key': 'agentJobs', 'type': 'str'},
        'database_tde_certificate_mapping': {'key': 'databaseTdeCertificateMapping', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskOutputTaskLevel, self).__init__(**kwargs)
        self.result_type = 'TaskLevelOutput'  # type: str
        self.databases = None
        self.logins = None
        self.agent_jobs = None
        self.database_tde_certificate_mapping = None
        self.source_server_version = None
        self.source_server_brand_version = None
        self.validation_errors = None


class ConnectToSourceSqlServerTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL Server and also validates source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToSourceSqlServerTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToSourceSqlServerTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToSourceSqlServerTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToSourceSqlServerTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToSource.SqlServer'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetAzureDbForMySqlTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure Database for MySQL and target server requirements.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for source MySQL server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :param target_connection_info: Required. Connection information for target Azure Database for
     MySQL server.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'MySqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MySqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "MySqlConnectionInfo",
        target_connection_info: "MySqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToTargetAzureDbForMySqlTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class ConnectToTargetAzureDbForMySqlTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to Azure Database for MySQL and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar server_version: Version of the target server.
    :vartype server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'server_version': {'readonly': True},
        'databases': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToTargetAzureDbForMySqlTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.server_version = None
        self.databases = None
        self.target_server_brand_version = None
        self.validation_errors = None


class ConnectToTargetAzureDbForMySqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure Database for MySQL and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForMySqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForMySqlTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetAzureDbForMySqlTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetAzureDbForMySqlTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetAzureDbForMySqlTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetAzureDbForMySqlTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.AzureDbForMySql'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetAzureDbForPostgreSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for source PostgreSQL server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :param target_connection_info: Required. Connection information for target Azure Database for
     PostgreSQL server.
    :type target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "PostgreSqlConnectionInfo",
        target_connection_info: "PostgreSqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToTargetAzureDbForPostgreSqlSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'target_server_version': {'readonly': True},
        'databases': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.target_server_version = None
        self.databases = None
        self.target_server_brand_version = None
        self.validation_errors = None


class ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetAzureDbForPostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetAzureDbForPostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.AzureDbForPostgreSql.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements for Oracle source.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Connection information for target Azure Database for
     PostgreSQL server.
    :type target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        target_connection_info: "PostgreSqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput, self).__init__(**kwargs)
        self.target_connection_info = target_connection_info


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to Azure Database for PostgreSQL and target server requirements for Oracle source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :param database_schema_map: Mapping of schemas per database.
    :type database_schema_map:
     list[~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem]
    """

    _validation = {
        'target_server_version': {'readonly': True},
        'databases': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
        'database_schema_map': {'key': 'databaseSchemaMap', 'type': '[ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem]'},
    }

    def __init__(
        self,
        *,
        database_schema_map: Optional[List["ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem"]] = None,
        **kwargs
    ):
        super(ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.target_server_version = None
        self.databases = None
        self.target_server_brand_version = None
        self.validation_errors = None
        self.database_schema_map = database_schema_map


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem(msrest.serialization.Model):
    """ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem.

    :param database:
    :type database: str
    :param schemas:
    :type schemas: list[str]
    """

    _attribute_map = {
        'database': {'key': 'database', 'type': 'str'},
        'schemas': {'key': 'schemas', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        database: Optional[str] = None,
        schemas: Optional[List[str]] = None,
        **kwargs
    ):
        super(ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem, self).__init__(**kwargs)
        self.database = database
        self.schemas = schemas


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration for Oracle source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input:
     ~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetSqlDbSyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure SQL DB and target server requirements.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for source SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Connection information for target SQL DB.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToTargetSqlDbSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class ConnectToTargetSqlDbSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL DB and target server requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetSqlDbSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetSqlDbTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetSqlDbSyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetSqlDbSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.SqlDb.Sync'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetSqlDbTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to SQL DB and target server requirements.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Connection information for target SQL DB.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    """

    _validation = {
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        target_connection_info: "SqlConnectionInfo",
        **kwargs
    ):
        super(ConnectToTargetSqlDbTaskInput, self).__init__(**kwargs)
        self.target_connection_info = target_connection_info


class ConnectToTargetSqlDbTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to SQL DB and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar databases: Source databases as a map from database name to database id.
    :vartype databases: str
    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'databases': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'databases': {'key': 'databases', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToTargetSqlDbTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.databases = None
        self.target_server_version = None
        self.target_server_brand_version = None


class ConnectToTargetSqlDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL DB and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetSqlDbTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetSqlDbTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetSqlDbTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetSqlDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.SqlDb'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetSqlMISyncTaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Connection information for Azure SQL Database Managed
     Instance.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :param azure_app: Required. Azure Active Directory Application the DMS instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account.
    :type azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        'target_connection_info': {'required': True},
        'azure_app': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MiSqlConnectionInfo'},
        'azure_app': {'key': 'azureApp', 'type': 'AzureActiveDirectoryApp'},
    }

    def __init__(
        self,
        *,
        target_connection_info: "MiSqlConnectionInfo",
        azure_app: "AzureActiveDirectoryApp",
        **kwargs
    ):
        super(ConnectToTargetSqlMISyncTaskInput, self).__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.azure_app = azure_app


class ConnectToTargetSqlMISyncTaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToTargetSqlMISyncTaskOutput, self).__init__(**kwargs)
        self.target_server_version = None
        self.target_server_brand_version = None
        self.validation_errors = None


class ConnectToTargetSqlMISyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlMISyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetSqlMISyncTaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetSqlMISyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetSqlMISyncTaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetSqlMISyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.AzureSqlDbMI.Sync.LRS'  # type: str
        self.input = input
        self.output = None


class ConnectToTargetSqlMITaskInput(msrest.serialization.Model):
    """Input for the task that validates connection to Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Connection information for target SQL Server.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param collect_logins: Flag for whether to collect logins from target SQL MI server.
    :type collect_logins: bool
    :param collect_agent_jobs: Flag for whether to collect agent jobs from target SQL MI server.
    :type collect_agent_jobs: bool
    :param validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on
     the target SQL MI server.
    :type validate_ssis_catalog_only: bool
    """

    _validation = {
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'collect_logins': {'key': 'collectLogins', 'type': 'bool'},
        'collect_agent_jobs': {'key': 'collectAgentJobs', 'type': 'bool'},
        'validate_ssis_catalog_only': {'key': 'validateSsisCatalogOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        target_connection_info: "SqlConnectionInfo",
        collect_logins: Optional[bool] = True,
        collect_agent_jobs: Optional[bool] = True,
        validate_ssis_catalog_only: Optional[bool] = False,
        **kwargs
    ):
        super(ConnectToTargetSqlMITaskInput, self).__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.collect_logins = collect_logins
        self.collect_agent_jobs = collect_agent_jobs
        self.validate_ssis_catalog_only = validate_ssis_catalog_only


class ConnectToTargetSqlMITaskOutput(msrest.serialization.Model):
    """Output for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar logins: List of logins on the target server.
    :vartype logins: list[str]
    :ivar agent_jobs: List of agent jobs on the target server.
    :vartype agent_jobs: list[str]
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'logins': {'readonly': True},
        'agent_jobs': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'logins': {'key': 'logins', 'type': '[str]'},
        'agent_jobs': {'key': 'agentJobs', 'type': '[str]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectToTargetSqlMITaskOutput, self).__init__(**kwargs)
        self.id = None
        self.target_server_version = None
        self.target_server_brand_version = None
        self.logins = None
        self.agent_jobs = None
        self.validation_errors = None


class ConnectToTargetSqlMITaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlMITaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ConnectToTargetSqlMITaskInput'},
        'output': {'key': 'output', 'type': '[ConnectToTargetSqlMITaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ConnectToTargetSqlMITaskInput"] = None,
        **kwargs
    ):
        super(ConnectToTargetSqlMITaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ConnectToTarget.AzureSqlDbMI'  # type: str
        self.input = input
        self.output = None


class Database(msrest.serialization.Model):
    """Information about a single database.

    :param id: Unique identifier for the database.
    :type id: str
    :param name: Name of the database.
    :type name: str
    :param compatibility_level: SQL Server compatibility level of database. Possible values
     include: "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110",
     "CompatLevel120", "CompatLevel130", "CompatLevel140".
    :type compatibility_level: str or ~azure.mgmt.datamigration.models.DatabaseCompatLevel
    :param collation: Collation name of the database.
    :type collation: str
    :param server_name: Name of the server.
    :type server_name: str
    :param fqdn: Fully qualified name.
    :type fqdn: str
    :param install_id: Install id of the database.
    :type install_id: str
    :param server_version: Version of the server.
    :type server_version: str
    :param server_edition: Edition of the server.
    :type server_edition: str
    :param server_level: Product level of the server (RTM, SP, CTP).
    :type server_level: str
    :param server_default_data_path: Default path of the data files.
    :type server_default_data_path: str
    :param server_default_log_path: Default path of the log files.
    :type server_default_log_path: str
    :param server_default_backup_path: Default path of the backup folder.
    :type server_default_backup_path: str
    :param server_core_count: Number of cores on the server.
    :type server_core_count: int
    :param server_visible_online_core_count: Number of cores on the server that have VISIBLE ONLINE
     status.
    :type server_visible_online_core_count: int
    :param database_state: State of the database. Possible values include: "Online", "Restoring",
     "Recovering", "RecoveryPending", "Suspect", "Emergency", "Offline", "Copying",
     "OfflineSecondary".
    :type database_state: str or ~azure.mgmt.datamigration.models.DatabaseState
    :param server_id: The unique Server Id.
    :type server_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'str'},
        'collation': {'key': 'collation', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'install_id': {'key': 'installId', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'server_edition': {'key': 'serverEdition', 'type': 'str'},
        'server_level': {'key': 'serverLevel', 'type': 'str'},
        'server_default_data_path': {'key': 'serverDefaultDataPath', 'type': 'str'},
        'server_default_log_path': {'key': 'serverDefaultLogPath', 'type': 'str'},
        'server_default_backup_path': {'key': 'serverDefaultBackupPath', 'type': 'str'},
        'server_core_count': {'key': 'serverCoreCount', 'type': 'int'},
        'server_visible_online_core_count': {'key': 'serverVisibleOnlineCoreCount', 'type': 'int'},
        'database_state': {'key': 'databaseState', 'type': 'str'},
        'server_id': {'key': 'serverId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        compatibility_level: Optional[Union[str, "DatabaseCompatLevel"]] = None,
        collation: Optional[str] = None,
        server_name: Optional[str] = None,
        fqdn: Optional[str] = None,
        install_id: Optional[str] = None,
        server_version: Optional[str] = None,
        server_edition: Optional[str] = None,
        server_level: Optional[str] = None,
        server_default_data_path: Optional[str] = None,
        server_default_log_path: Optional[str] = None,
        server_default_backup_path: Optional[str] = None,
        server_core_count: Optional[int] = None,
        server_visible_online_core_count: Optional[int] = None,
        database_state: Optional[Union[str, "DatabaseState"]] = None,
        server_id: Optional[str] = None,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.compatibility_level = compatibility_level
        self.collation = collation
        self.server_name = server_name
        self.fqdn = fqdn
        self.install_id = install_id
        self.server_version = server_version
        self.server_edition = server_edition
        self.server_level = server_level
        self.server_default_data_path = server_default_data_path
        self.server_default_log_path = server_default_log_path
        self.server_default_backup_path = server_default_backup_path
        self.server_core_count = server_core_count
        self.server_visible_online_core_count = server_visible_online_core_count
        self.database_state = database_state
        self.server_id = server_id


class DatabaseBackupInfo(msrest.serialization.Model):
    """Information about backup files when existing backup mode is used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar backup_type: Backup Type. Possible values include: "Database", "TransactionLog", "File",
     "DifferentialDatabase", "DifferentialFile", "Partial", "DifferentialPartial".
    :vartype backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :ivar backup_files: The list of backup files for the current database.
    :vartype backup_files: list[str]
    :ivar position: Position of current database backup in the file.
    :vartype position: int
    :ivar is_damaged: Database was damaged when backed up, but the backup operation was requested
     to continue despite errors.
    :vartype is_damaged: bool
    :ivar is_compressed: Whether the backup set is compressed.
    :vartype is_compressed: bool
    :ivar family_count: Number of files in the backup set.
    :vartype family_count: int
    :ivar backup_finish_date: Date and time when the backup operation finished.
    :vartype backup_finish_date: ~datetime.datetime
    """

    _validation = {
        'database_name': {'readonly': True},
        'backup_type': {'readonly': True},
        'backup_files': {'readonly': True},
        'position': {'readonly': True},
        'is_damaged': {'readonly': True},
        'is_compressed': {'readonly': True},
        'family_count': {'readonly': True},
        'backup_finish_date': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'backup_files': {'key': 'backupFiles', 'type': '[str]'},
        'position': {'key': 'position', 'type': 'int'},
        'is_damaged': {'key': 'isDamaged', 'type': 'bool'},
        'is_compressed': {'key': 'isCompressed', 'type': 'bool'},
        'family_count': {'key': 'familyCount', 'type': 'int'},
        'backup_finish_date': {'key': 'backupFinishDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseBackupInfo, self).__init__(**kwargs)
        self.database_name = None
        self.backup_type = None
        self.backup_files = None
        self.position = None
        self.is_damaged = None
        self.is_compressed = None
        self.family_count = None
        self.backup_finish_date = None


class DatabaseFileInfo(msrest.serialization.Model):
    """Database file specific information.

    :param database_name: Name of the database.
    :type database_name: str
    :param id: Unique identifier for database file.
    :type id: str
    :param logical_name: Logical name of the file.
    :type logical_name: str
    :param physical_full_name: Operating-system full path of the file.
    :type physical_full_name: str
    :param restore_full_name: Suggested full path of the file for restoring.
    :type restore_full_name: str
    :param file_type: Database file type. Possible values include: "Rows", "Log", "Filestream",
     "NotSupported", "Fulltext".
    :type file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
    :param size_mb: Size of the file in megabytes.
    :type size_mb: float
    """

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'logical_name': {'key': 'logicalName', 'type': 'str'},
        'physical_full_name': {'key': 'physicalFullName', 'type': 'str'},
        'restore_full_name': {'key': 'restoreFullName', 'type': 'str'},
        'file_type': {'key': 'fileType', 'type': 'str'},
        'size_mb': {'key': 'sizeMB', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        id: Optional[str] = None,
        logical_name: Optional[str] = None,
        physical_full_name: Optional[str] = None,
        restore_full_name: Optional[str] = None,
        file_type: Optional[Union[str, "DatabaseFileType"]] = None,
        size_mb: Optional[float] = None,
        **kwargs
    ):
        super(DatabaseFileInfo, self).__init__(**kwargs)
        self.database_name = database_name
        self.id = id
        self.logical_name = logical_name
        self.physical_full_name = physical_full_name
        self.restore_full_name = restore_full_name
        self.file_type = file_type
        self.size_mb = size_mb


class DatabaseFileInput(msrest.serialization.Model):
    """Database file specific information for input.

    :param id: Unique identifier for database file.
    :type id: str
    :param logical_name: Logical name of the file.
    :type logical_name: str
    :param physical_full_name: Operating-system full path of the file.
    :type physical_full_name: str
    :param restore_full_name: Suggested full path of the file for restoring.
    :type restore_full_name: str
    :param file_type: Database file type. Possible values include: "Rows", "Log", "Filestream",
     "NotSupported", "Fulltext".
    :type file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'logical_name': {'key': 'logicalName', 'type': 'str'},
        'physical_full_name': {'key': 'physicalFullName', 'type': 'str'},
        'restore_full_name': {'key': 'restoreFullName', 'type': 'str'},
        'file_type': {'key': 'fileType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        logical_name: Optional[str] = None,
        physical_full_name: Optional[str] = None,
        restore_full_name: Optional[str] = None,
        file_type: Optional[Union[str, "DatabaseFileType"]] = None,
        **kwargs
    ):
        super(DatabaseFileInput, self).__init__(**kwargs)
        self.id = id
        self.logical_name = logical_name
        self.physical_full_name = physical_full_name
        self.restore_full_name = restore_full_name
        self.file_type = file_type


class DatabaseInfo(msrest.serialization.Model):
    """Project Database Details.

    All required parameters must be populated in order to send to Azure.

    :param source_database_name: Required. Name of the database.
    :type source_database_name: str
    """

    _validation = {
        'source_database_name': {'required': True},
    }

    _attribute_map = {
        'source_database_name': {'key': 'sourceDatabaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_database_name: str,
        **kwargs
    ):
        super(DatabaseInfo, self).__init__(**kwargs)
        self.source_database_name = source_database_name


class DatabaseObjectName(msrest.serialization.Model):
    """A representation of the name of an object in a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: The unescaped name of the database containing the object.
    :vartype database_name: str
    :ivar object_name: The unescaped name of the object.
    :vartype object_name: str
    :ivar schema_name: The unescaped name of the schema containing the object.
    :vartype schema_name: str
    :param object_type: Type of the object in the database. Possible values include:
     "StoredProcedures", "Table", "User", "View", "Function".
    :type object_type: str or ~azure.mgmt.datamigration.models.ObjectType
    """

    _validation = {
        'database_name': {'readonly': True},
        'object_name': {'readonly': True},
        'schema_name': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_type: Optional[Union[str, "ObjectType"]] = None,
        **kwargs
    ):
        super(DatabaseObjectName, self).__init__(**kwargs)
        self.database_name = None
        self.object_name = None
        self.schema_name = None
        self.object_type = object_type


class DataItemMigrationSummaryResult(msrest.serialization.Model):
    """Basic summary of a data item migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the item.
    :vartype name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: long
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    """

    _validation = {
        'name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'status_message': {'readonly': True},
        'items_count': {'readonly': True},
        'items_completed_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'items_count': {'key': 'itemsCount', 'type': 'long'},
        'items_completed_count': {'key': 'itemsCompletedCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataItemMigrationSummaryResult, self).__init__(**kwargs)
        self.name = None
        self.started_on = None
        self.ended_on = None
        self.state = None
        self.status_message = None
        self.items_count = None
        self.items_completed_count = None
        self.error_prefix = None
        self.result_prefix = None


class DatabaseSummaryResult(DataItemMigrationSummaryResult):
    """Summary of database results in the migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the item.
    :vartype name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: long
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar size_mb: Size of the database in megabytes.
    :vartype size_mb: float
    """

    _validation = {
        'name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'status_message': {'readonly': True},
        'items_count': {'readonly': True},
        'items_completed_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
        'size_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'items_count': {'key': 'itemsCount', 'type': 'long'},
        'items_completed_count': {'key': 'itemsCompletedCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
        'size_mb': {'key': 'sizeMB', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseSummaryResult, self).__init__(**kwargs)
        self.size_mb = None


class DatabaseTable(msrest.serialization.Model):
    """Table properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_rows: Indicates whether table is empty or not.
    :vartype has_rows: bool
    :ivar name: Schema-qualified name of the table.
    :vartype name: str
    """

    _validation = {
        'has_rows': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'has_rows': {'key': 'hasRows', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseTable, self).__init__(**kwargs)
        self.has_rows = None
        self.name = None


class DataIntegrityValidationResult(msrest.serialization.Model):
    """Results for checksum based Data Integrity validation results.

    :param failed_objects: List of failed table names of source and target pair.
    :type failed_objects: dict[str, str]
    :param validation_errors: List of errors that happened while performing data integrity
     validation.
    :type validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    """

    _attribute_map = {
        'failed_objects': {'key': 'failedObjects', 'type': '{str}'},
        'validation_errors': {'key': 'validationErrors', 'type': 'ValidationError'},
    }

    def __init__(
        self,
        *,
        failed_objects: Optional[Dict[str, str]] = None,
        validation_errors: Optional["ValidationError"] = None,
        **kwargs
    ):
        super(DataIntegrityValidationResult, self).__init__(**kwargs)
        self.failed_objects = failed_objects
        self.validation_errors = validation_errors


class DataMigrationError(msrest.serialization.Model):
    """Migration Task errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Error description.
    :vartype message: str
    :param type: Error type. Possible values include: "Default", "Warning", "Error".
    :type type: str or ~azure.mgmt.datamigration.models.ErrorType
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ErrorType"]] = None,
        **kwargs
    ):
        super(DataMigrationError, self).__init__(**kwargs)
        self.message = None
        self.type = type


class DataMigrationProjectMetadata(msrest.serialization.Model):
    """Common metadata for migration projects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_server_name: Source server name.
    :vartype source_server_name: str
    :ivar source_server_port: Source server port number.
    :vartype source_server_port: str
    :ivar source_username: Source username.
    :vartype source_username: str
    :ivar target_server_name: Target server name.
    :vartype target_server_name: str
    :ivar target_username: Target username.
    :vartype target_username: str
    :ivar target_db_name: Target database name.
    :vartype target_db_name: str
    :ivar target_using_win_auth: Whether target connection is Windows authentication.
    :vartype target_using_win_auth: bool
    :ivar selected_migration_tables: List of tables selected for migration.
    :vartype selected_migration_tables:
     list[~azure.mgmt.datamigration.models.MigrationTableMetadata]
    """

    _validation = {
        'source_server_name': {'readonly': True},
        'source_server_port': {'readonly': True},
        'source_username': {'readonly': True},
        'target_server_name': {'readonly': True},
        'target_username': {'readonly': True},
        'target_db_name': {'readonly': True},
        'target_using_win_auth': {'readonly': True},
        'selected_migration_tables': {'readonly': True},
    }

    _attribute_map = {
        'source_server_name': {'key': 'sourceServerName', 'type': 'str'},
        'source_server_port': {'key': 'sourceServerPort', 'type': 'str'},
        'source_username': {'key': 'sourceUsername', 'type': 'str'},
        'target_server_name': {'key': 'targetServerName', 'type': 'str'},
        'target_username': {'key': 'targetUsername', 'type': 'str'},
        'target_db_name': {'key': 'targetDbName', 'type': 'str'},
        'target_using_win_auth': {'key': 'targetUsingWinAuth', 'type': 'bool'},
        'selected_migration_tables': {'key': 'selectedMigrationTables', 'type': '[MigrationTableMetadata]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataMigrationProjectMetadata, self).__init__(**kwargs)
        self.source_server_name = None
        self.source_server_port = None
        self.source_username = None
        self.target_server_name = None
        self.target_username = None
        self.target_db_name = None
        self.target_using_win_auth = None
        self.selected_migration_tables = None


class Resource(msrest.serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. Resource location.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class DataMigrationService(TrackedResource):
    """A Database Migration Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. Resource location.
    :type location: str
    :param etag: HTTP strong entity tag value. Ignored if submitted.
    :type etag: str
    :param kind: The resource kind. Only 'vm' (the default) is supported.
    :type kind: str
    :param sku: Service SKU.
    :type sku: ~azure.mgmt.datamigration.models.ServiceSku
    :ivar provisioning_state: The resource's provisioning state. Possible values include:
     "Accepted", "Deleting", "Deploying", "Stopped", "Stopping", "Starting", "FailedToStart",
     "FailedToStop", "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ServiceProvisioningState
    :param public_key: The public key of the service, used to encrypt secrets sent to the service.
    :type public_key: str
    :param virtual_subnet_id: The ID of the Microsoft.Network/virtualNetworks/subnets resource to
     which the service should be joined.
    :type virtual_subnet_id: str
    :param virtual_nic_id: The ID of the Microsoft.Network/networkInterfaces resource which the
     service have.
    :type virtual_nic_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ServiceSku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
        'virtual_subnet_id': {'key': 'properties.virtualSubnetId', 'type': 'str'},
        'virtual_nic_id': {'key': 'properties.virtualNicId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        sku: Optional["ServiceSku"] = None,
        public_key: Optional[str] = None,
        virtual_subnet_id: Optional[str] = None,
        virtual_nic_id: Optional[str] = None,
        **kwargs
    ):
        super(DataMigrationService, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.kind = kind
        self.sku = sku
        self.provisioning_state = None
        self.public_key = public_key
        self.virtual_subnet_id = virtual_subnet_id
        self.virtual_nic_id = virtual_nic_id


class DataMigrationServiceList(msrest.serialization.Model):
    """OData page of service objects.

    :param value: List of services.
    :type value: list[~azure.mgmt.datamigration.models.DataMigrationService]
    :param next_link: URL to load the next page of services.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataMigrationService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataMigrationService"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataMigrationServiceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataMigrationServiceStatusResponse(msrest.serialization.Model):
    """Service health status.

    :param agent_version: The DMS instance agent version.
    :type agent_version: str
    :param status: The machine-readable status, such as 'Initializing', 'Offline', 'Online',
     'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or
     'Failed'.
    :type status: str
    :param vm_size: The services virtual machine size, such as 'Standard_D2_v2'.
    :type vm_size: str
    :param supported_task_types: The list of supported task types.
    :type supported_task_types: list[str]
    """

    _attribute_map = {
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'supported_task_types': {'key': 'supportedTaskTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        agent_version: Optional[str] = None,
        status: Optional[str] = None,
        vm_size: Optional[str] = None,
        supported_task_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(DataMigrationServiceStatusResponse, self).__init__(**kwargs)
        self.agent_version = agent_version
        self.status = status
        self.vm_size = vm_size
        self.supported_task_types = supported_task_types


class ExecutionStatistics(msrest.serialization.Model):
    """Description about the errors happen while performing migration validation.

    :param execution_count: No. of query executions.
    :type execution_count: long
    :param cpu_time_ms: CPU Time in millisecond(s) for the query execution.
    :type cpu_time_ms: float
    :param elapsed_time_ms: Time taken in millisecond(s) for executing the query.
    :type elapsed_time_ms: float
    :param wait_stats: Dictionary of sql query execution wait types and the respective statistics.
    :type wait_stats: dict[str, ~azure.mgmt.datamigration.models.WaitStatistics]
    :param has_errors: Indicates whether the query resulted in an error.
    :type has_errors: bool
    :param sql_errors: List of sql Errors.
    :type sql_errors: list[str]
    """

    _attribute_map = {
        'execution_count': {'key': 'executionCount', 'type': 'long'},
        'cpu_time_ms': {'key': 'cpuTimeMs', 'type': 'float'},
        'elapsed_time_ms': {'key': 'elapsedTimeMs', 'type': 'float'},
        'wait_stats': {'key': 'waitStats', 'type': '{WaitStatistics}'},
        'has_errors': {'key': 'hasErrors', 'type': 'bool'},
        'sql_errors': {'key': 'sqlErrors', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        execution_count: Optional[int] = None,
        cpu_time_ms: Optional[float] = None,
        elapsed_time_ms: Optional[float] = None,
        wait_stats: Optional[Dict[str, "WaitStatistics"]] = None,
        has_errors: Optional[bool] = None,
        sql_errors: Optional[List[str]] = None,
        **kwargs
    ):
        super(ExecutionStatistics, self).__init__(**kwargs)
        self.execution_count = execution_count
        self.cpu_time_ms = cpu_time_ms
        self.elapsed_time_ms = elapsed_time_ms
        self.wait_stats = wait_stats
        self.has_errors = has_errors
        self.sql_errors = sql_errors


class FileList(msrest.serialization.Model):
    """OData page of files.

    :param value: List of files.
    :type value: list[~azure.mgmt.datamigration.models.ProjectFile]
    :param next_link: URL to load the next page of files.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProjectFile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProjectFile"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FileList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FileShare(msrest.serialization.Model):
    """File share information with Path, Username, and Password.

    All required parameters must be populated in order to send to Azure.

    :param user_name: User name credential to connect to the share location.
    :type user_name: str
    :param password: Password credential used to connect to the share location.
    :type password: str
    :param path: Required. The folder path for this share.
    :type path: str
    """

    _validation = {
        'path': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(FileShare, self).__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.path = path


class FileStorageInfo(msrest.serialization.Model):
    """File storage information.

    :param uri: A URI that can be used to access the file content.
    :type uri: str
    :param headers: Dictionary of :code:`<string>`.
    :type headers: dict[str, str]
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(FileStorageInfo, self).__init__(**kwargs)
        self.uri = uri
        self.headers = headers


class GetProjectDetailsNonSqlTaskInput(msrest.serialization.Model):
    """Input for the task that reads configuration from project artifacts.

    All required parameters must be populated in order to send to Azure.

    :param project_name: Required. Name of the migration project.
    :type project_name: str
    :param project_location: Required. A URL that points to the location to access project
     artifacts.
    :type project_location: str
    """

    _validation = {
        'project_name': {'required': True},
        'project_location': {'required': True},
    }

    _attribute_map = {
        'project_name': {'key': 'projectName', 'type': 'str'},
        'project_location': {'key': 'projectLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        project_name: str,
        project_location: str,
        **kwargs
    ):
        super(GetProjectDetailsNonSqlTaskInput, self).__init__(**kwargs)
        self.project_name = project_name
        self.project_location = project_location


class GetTdeCertificatesSqlTaskInput(msrest.serialization.Model):
    """Input for the task that gets TDE certificates in Base64 encoded format.

    All required parameters must be populated in order to send to Azure.

    :param connection_info: Required. Connection information for SQL Server.
    :type connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param backup_file_share: Required. Backup file share information for file share to be used for
     temporarily storing files.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param selected_certificates: Required. List containing certificate names and corresponding
     password to use for encrypting the exported certificate.
    :type selected_certificates: list[~azure.mgmt.datamigration.models.SelectedCertificateInput]
    """

    _validation = {
        'connection_info': {'required': True},
        'backup_file_share': {'required': True},
        'selected_certificates': {'required': True},
    }

    _attribute_map = {
        'connection_info': {'key': 'connectionInfo', 'type': 'SqlConnectionInfo'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'selected_certificates': {'key': 'selectedCertificates', 'type': '[SelectedCertificateInput]'},
    }

    def __init__(
        self,
        *,
        connection_info: "SqlConnectionInfo",
        backup_file_share: "FileShare",
        selected_certificates: List["SelectedCertificateInput"],
        **kwargs
    ):
        super(GetTdeCertificatesSqlTaskInput, self).__init__(**kwargs)
        self.connection_info = connection_info
        self.backup_file_share = backup_file_share
        self.selected_certificates = selected_certificates


class GetTdeCertificatesSqlTaskOutput(msrest.serialization.Model):
    """Output of the task that gets TDE certificates in Base64 encoded format.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base64_encoded_certificates: Mapping from certificate name to base 64 encoded format.
    :vartype base64_encoded_certificates: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'base64_encoded_certificates': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'base64_encoded_certificates': {'key': 'base64EncodedCertificates', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetTdeCertificatesSqlTaskOutput, self).__init__(**kwargs)
        self.base64_encoded_certificates = None
        self.validation_errors = None


class GetTdeCertificatesSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that gets TDE certificates in Base64 encoded format.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.GetTdeCertificatesSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetTdeCertificatesSqlTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'GetTdeCertificatesSqlTaskInput'},
        'output': {'key': 'output', 'type': '[GetTdeCertificatesSqlTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["GetTdeCertificatesSqlTaskInput"] = None,
        **kwargs
    ):
        super(GetTdeCertificatesSqlTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'GetTDECertificates.Sql'  # type: str
        self.input = input
        self.output = None


class GetUserTablesOracleTaskInput(msrest.serialization.Model):
    """Input for the task that gets the list of tables contained within a provided list of Oracle schemas.

    All required parameters must be populated in order to send to Azure.

    :param connection_info: Required. Information for connecting to Oracle source.
    :type connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    :param selected_schemas: Required. List of Oracle schemas for which to collect tables.
    :type selected_schemas: list[str]
    """

    _validation = {
        'connection_info': {'required': True},
        'selected_schemas': {'required': True},
    }

    _attribute_map = {
        'connection_info': {'key': 'connectionInfo', 'type': 'OracleConnectionInfo'},
        'selected_schemas': {'key': 'selectedSchemas', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        connection_info: "OracleConnectionInfo",
        selected_schemas: List[str],
        **kwargs
    ):
        super(GetUserTablesOracleTaskInput, self).__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_schemas = selected_schemas


class GetUserTablesOracleTaskOutput(msrest.serialization.Model):
    """Output for the task that gets the list of tables contained within a provided list of Oracle schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schema_name: The schema this result is for.
    :vartype schema_name: str
    :ivar tables: List of valid tables found for this schema.
    :vartype tables: list[~azure.mgmt.datamigration.models.DatabaseTable]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'schema_name': {'readonly': True},
        'tables': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'tables': {'key': 'tables', 'type': '[DatabaseTable]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetUserTablesOracleTaskOutput, self).__init__(**kwargs)
        self.schema_name = None
        self.tables = None
        self.validation_errors = None


class GetUserTablesOracleTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of Oracle schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.GetUserTablesOracleTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesOracleTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'GetUserTablesOracleTaskInput'},
        'output': {'key': 'output', 'type': '[GetUserTablesOracleTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["GetUserTablesOracleTaskInput"] = None,
        **kwargs
    ):
        super(GetUserTablesOracleTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'GetUserTablesOracle'  # type: str
        self.input = input
        self.output = None


class GetUserTablesPostgreSqlTaskInput(msrest.serialization.Model):
    """Input for the task that gets the list of tables for a provided list of PostgreSQL databases.

    All required parameters must be populated in order to send to Azure.

    :param connection_info: Required. Information for connecting to PostgreSQL source.
    :type connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :param selected_databases: Required. List of PostgreSQL databases for which to collect tables.
    :type selected_databases: list[str]
    """

    _validation = {
        'connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'connection_info': {'key': 'connectionInfo', 'type': 'PostgreSqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        connection_info: "PostgreSqlConnectionInfo",
        selected_databases: List[str],
        **kwargs
    ):
        super(GetUserTablesPostgreSqlTaskInput, self).__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_databases = selected_databases


class GetUserTablesPostgreSqlTaskOutput(msrest.serialization.Model):
    """Output for the task that gets the list of tables for a provided list of PostgreSQL databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: The database this result is for.
    :vartype database_name: str
    :ivar tables: List of valid tables found for this database.
    :vartype tables: list[~azure.mgmt.datamigration.models.DatabaseTable]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'database_name': {'readonly': True},
        'tables': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'tables': {'key': 'tables', 'type': '[DatabaseTable]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetUserTablesPostgreSqlTaskOutput, self).__init__(**kwargs)
        self.database_name = None
        self.tables = None
        self.validation_errors = None


class GetUserTablesPostgreSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.GetUserTablesPostgreSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesPostgreSqlTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'GetUserTablesPostgreSqlTaskInput'},
        'output': {'key': 'output', 'type': '[GetUserTablesPostgreSqlTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["GetUserTablesPostgreSqlTaskInput"] = None,
        **kwargs
    ):
        super(GetUserTablesPostgreSqlTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'GetUserTablesPostgreSql'  # type: str
        self.input = input
        self.output = None


class GetUserTablesSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that collects user tables for the given list of databases.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Connection information for SQL DB.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_source_databases: Required. List of source database names to collect tables
     for.
    :type selected_source_databases: list[str]
    :param selected_target_databases: Required. List of target database names to collect tables
     for.
    :type selected_target_databases: list[str]
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_source_databases': {'required': True},
        'selected_target_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_source_databases': {'key': 'selectedSourceDatabases', 'type': '[str]'},
        'selected_target_databases': {'key': 'selectedTargetDatabases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_source_databases: List[str],
        selected_target_databases: List[str],
        **kwargs
    ):
        super(GetUserTablesSqlSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_source_databases = selected_source_databases
        self.selected_target_databases = selected_target_databases


class GetUserTablesSqlSyncTaskOutput(msrest.serialization.Model):
    """Output of the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar databases_to_source_tables: Mapping from database name to list of source tables.
    :vartype databases_to_source_tables: str
    :ivar databases_to_target_tables: Mapping from database name to list of target tables.
    :vartype databases_to_target_tables: str
    :ivar table_validation_errors: Mapping from database name to list of validation errors.
    :vartype table_validation_errors: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'databases_to_source_tables': {'readonly': True},
        'databases_to_target_tables': {'readonly': True},
        'table_validation_errors': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'databases_to_source_tables': {'key': 'databasesToSourceTables', 'type': 'str'},
        'databases_to_target_tables': {'key': 'databasesToTargetTables', 'type': 'str'},
        'table_validation_errors': {'key': 'tableValidationErrors', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetUserTablesSqlSyncTaskOutput, self).__init__(**kwargs)
        self.databases_to_source_tables = None
        self.databases_to_target_tables = None
        self.table_validation_errors = None
        self.validation_errors = None


class GetUserTablesSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.GetUserTablesSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'GetUserTablesSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[GetUserTablesSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["GetUserTablesSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(GetUserTablesSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'GetUserTables.AzureSqlDb.Sync'  # type: str
        self.input = input
        self.output = None


class GetUserTablesSqlTaskInput(msrest.serialization.Model):
    """Input for the task that collects user tables for the given list of databases.

    All required parameters must be populated in order to send to Azure.

    :param connection_info: Required. Connection information for SQL Server.
    :type connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. List of database names to collect tables for.
    :type selected_databases: list[str]
    """

    _validation = {
        'connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'connection_info': {'key': 'connectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        connection_info: "SqlConnectionInfo",
        selected_databases: List[str],
        **kwargs
    ):
        super(GetUserTablesSqlTaskInput, self).__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_databases = selected_databases


class GetUserTablesSqlTaskOutput(msrest.serialization.Model):
    """Output of the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar databases_to_tables: Mapping from database name to list of tables.
    :vartype databases_to_tables: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'databases_to_tables': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'databases_to_tables': {'key': 'databasesToTables', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetUserTablesSqlTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.databases_to_tables = None
        self.validation_errors = None


class GetUserTablesSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.GetUserTablesSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesSqlTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'GetUserTablesSqlTaskInput'},
        'output': {'key': 'output', 'type': '[GetUserTablesSqlTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["GetUserTablesSqlTaskInput"] = None,
        **kwargs
    ):
        super(GetUserTablesSqlTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'GetUserTables.Sql'  # type: str
        self.input = input
        self.output = None


class InstallOCIDriverTaskInput(msrest.serialization.Model):
    """Input for the service task to install an OCI driver.

    :param driver_package_name: Name of the uploaded driver package to install.
    :type driver_package_name: str
    """

    _attribute_map = {
        'driver_package_name': {'key': 'driverPackageName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        driver_package_name: Optional[str] = None,
        **kwargs
    ):
        super(InstallOCIDriverTaskInput, self).__init__(**kwargs)
        self.driver_package_name = driver_package_name


class InstallOCIDriverTaskOutput(msrest.serialization.Model):
    """Output for the service task to install an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallOCIDriverTaskOutput, self).__init__(**kwargs)
        self.validation_errors = None


class InstallOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that installs an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Input for the service task to install an OCI driver.
    :type input: ~azure.mgmt.datamigration.models.InstallOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.InstallOCIDriverTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'InstallOCIDriverTaskInput'},
        'output': {'key': 'output', 'type': '[InstallOCIDriverTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["InstallOCIDriverTaskInput"] = None,
        **kwargs
    ):
        super(InstallOCIDriverTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Service.Install.OCI'  # type: str
        self.input = input
        self.output = None


class MigrateMISyncCompleteCommandInput(msrest.serialization.Model):
    """Input for command that completes online migration for an Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to Azure.

    :param source_database_name: Required. Name of managed instance database.
    :type source_database_name: str
    """

    _validation = {
        'source_database_name': {'required': True},
    }

    _attribute_map = {
        'source_database_name': {'key': 'sourceDatabaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_database_name: str,
        **kwargs
    ):
        super(MigrateMISyncCompleteCommandInput, self).__init__(**kwargs)
        self.source_database_name = source_database_name


class MigrateMISyncCompleteCommandOutput(msrest.serialization.Model):
    """Output for command that completes online migration for an Azure SQL Database Managed Instance.

    :param errors: List of errors that happened during the command execution.
    :type errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["ReportableException"]] = None,
        **kwargs
    ):
        super(MigrateMISyncCompleteCommandOutput, self).__init__(**kwargs)
        self.errors = errors


class MigrateMISyncCompleteCommandProperties(CommandProperties):
    """Properties for the command that completes online migration for an Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :param input: Command input.
    :type input: ~azure.mgmt.datamigration.models.MigrateMISyncCompleteCommandInput
    :ivar output: Command output. This is ignored if submitted.
    :vartype output: ~azure.mgmt.datamigration.models.MigrateMISyncCompleteCommandOutput
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'input': {'key': 'input', 'type': 'MigrateMISyncCompleteCommandInput'},
        'output': {'key': 'output', 'type': 'MigrateMISyncCompleteCommandOutput'},
    }

    def __init__(
        self,
        *,
        input: Optional["MigrateMISyncCompleteCommandInput"] = None,
        **kwargs
    ):
        super(MigrateMISyncCompleteCommandProperties, self).__init__(**kwargs)
        self.command_type = 'Migrate.SqlServer.AzureDbSqlMi.Complete'  # type: str
        self.input = input
        self.output = None


class MigrateMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates data between MongoDB data sources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Describes how a MongoDB data migration should be performed.
    :type input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
    :ivar output:
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbProgress]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MongoDbMigrationSettings'},
        'output': {'key': 'output', 'type': '[MongoDbProgress]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MongoDbMigrationSettings"] = None,
        **kwargs
    ):
        super(MigrateMongoDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.MongoDb'  # type: str
        self.input = input
        self.output = None


class MigrateMySqlAzureDbForMySqlSyncDatabaseInput(msrest.serialization.Model):
    """Database specific information for MySQL to Azure Database for MySQL migration task inputs.

    :param name: Name of the database.
    :type name: str
    :param target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :type target_database_name: str
    :param migration_setting: Migration settings which tune the migration behavior.
    :type migration_setting: dict[str, str]
    :param source_setting: Source settings to tune source endpoint migration behavior.
    :type source_setting: dict[str, str]
    :param target_setting: Target settings to tune target endpoint migration behavior.
    :type target_setting: dict[str, str]
    :param table_map: Mapping of source to target tables.
    :type table_map: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'migration_setting': {'key': 'migrationSetting', 'type': '{str}'},
        'source_setting': {'key': 'sourceSetting', 'type': '{str}'},
        'target_setting': {'key': 'targetSetting', 'type': '{str}'},
        'table_map': {'key': 'tableMap', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        table_map: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting
        self.table_map = table_map


class MigrateMySqlAzureDbForMySqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Connection information for source MySQL.
    :type source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :param target_connection_info: Required. Connection information for target Azure Database for
     MySQL.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncDatabaseInput]
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'MySqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MySqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateMySqlAzureDbForMySqlSyncDatabaseInput]'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "MySqlConnectionInfo",
        target_connection_info: "MySqlConnectionInfo",
        selected_databases: List["MigrateMySqlAzureDbForMySqlSyncDatabaseInput"],
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases


class MigrateMySqlAzureDbForMySqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates MySQL databases to Azure Database for MySQL for online migrations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError, MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel, MigrateMySqlAzureDbForMySqlSyncTaskOutputError, MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel, MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelErrorOutput': 'MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError', 'DatabaseLevelOutput': 'MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateMySqlAzureDbForMySqlSyncTaskOutputError', 'MigrationLevelOutput': 'MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel', 'TableLevelOutput': 'MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError(MigrateMySqlAzureDbForMySqlSyncTaskOutput):
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :param error_message: Error message.
    :type error_message: str
    :param events: List of error events.
    :type events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'events': {'key': 'events', 'type': '[SyncMigrationDatabaseErrorEvent]'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelErrorOutput'  # type: str
        self.error_message = error_message
        self.events = events


class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel(MigrateMySqlAzureDbForMySqlSyncTaskOutput):
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Possible values include:
     "UNDEFINED", "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE",
     "COMPLETING", "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING",
     "VALIDATION_COMPLETE", "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED",
     "BACKUP_IN_PROGRESS", "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: long
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: long
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: long
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: long
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: long
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: long
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: long
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: long
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: long
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'migration_state': {'readonly': True},
        'incoming_changes': {'readonly': True},
        'applied_changes': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'full_load_completed_tables': {'readonly': True},
        'full_load_loading_tables': {'readonly': True},
        'full_load_queued_tables': {'readonly': True},
        'full_load_errored_tables': {'readonly': True},
        'initialization_completed': {'readonly': True},
        'latency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'incoming_changes': {'key': 'incomingChanges', 'type': 'long'},
        'applied_changes': {'key': 'appliedChanges', 'type': 'long'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'full_load_completed_tables': {'key': 'fullLoadCompletedTables', 'type': 'long'},
        'full_load_loading_tables': {'key': 'fullLoadLoadingTables', 'type': 'long'},
        'full_load_queued_tables': {'key': 'fullLoadQueuedTables', 'type': 'long'},
        'full_load_errored_tables': {'key': 'fullLoadErroredTables', 'type': 'long'},
        'initialization_completed': {'key': 'initializationCompleted', 'type': 'bool'},
        'latency': {'key': 'latency', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.started_on = None
        self.ended_on = None
        self.migration_state = None
        self.incoming_changes = None
        self.applied_changes = None
        self.cdc_insert_counter = None
        self.cdc_delete_counter = None
        self.cdc_update_counter = None
        self.full_load_completed_tables = None
        self.full_load_loading_tables = None
        self.full_load_queued_tables = None
        self.full_load_errored_tables = None
        self.initialization_completed = None
        self.latency = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputError(MigrateMySqlAzureDbForMySqlSyncTaskOutput):
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel(MigrateMySqlAzureDbForMySqlSyncTaskOutput):
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server': {'key': 'sourceServer', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server': {'key': 'targetServer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.source_server_version = None
        self.source_server = None
        self.target_server_version = None
        self.target_server = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel(MigrateMySqlAzureDbForMySqlSyncTaskOutput):
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: str
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: str
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: str
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: long
    :ivar state: Current state of the table migration. Possible values include: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: long
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: long
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'table_name': {'readonly': True},
        'database_name': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'full_load_est_finish_time': {'readonly': True},
        'full_load_started_on': {'readonly': True},
        'full_load_ended_on': {'readonly': True},
        'full_load_total_rows': {'readonly': True},
        'state': {'readonly': True},
        'total_changes_applied': {'readonly': True},
        'data_errors_counter': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'str'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'str'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'str'},
        'full_load_est_finish_time': {'key': 'fullLoadEstFinishTime', 'type': 'iso-8601'},
        'full_load_started_on': {'key': 'fullLoadStartedOn', 'type': 'iso-8601'},
        'full_load_ended_on': {'key': 'fullLoadEndedOn', 'type': 'iso-8601'},
        'full_load_total_rows': {'key': 'fullLoadTotalRows', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
        'total_changes_applied': {'key': 'totalChangesApplied', 'type': 'long'},
        'data_errors_counter': {'key': 'dataErrorsCounter', 'type': 'long'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel, self).__init__(**kwargs)
        self.result_type = 'TableLevelOutput'  # type: str
        self.table_name = None
        self.database_name = None
        self.cdc_insert_counter = None
        self.cdc_update_counter = None
        self.cdc_delete_counter = None
        self.full_load_est_finish_time = None
        self.full_load_started_on = None
        self.full_load_ended_on = None
        self.full_load_total_rows = None
        self.state = None
        self.total_changes_applied = None
        self.data_errors_counter = None
        self.last_modified_time = None


class MigrateMySqlAzureDbForMySqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates MySQL databases to Azure Database for MySQL for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateMySqlAzureDbForMySqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateMySqlAzureDbForMySqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateMySqlAzureDbForMySqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(MigrateMySqlAzureDbForMySqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.MySql.AzureDbForMySql.Sync'  # type: str
        self.input = input
        self.output = None


class MigrateOracleAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates Oracle to Azure Database for PostgreSQL for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateOracleAzureDbPostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateOracleAzureDbPostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateOracleAzureDbPostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(MigrateOracleAzureDbForPostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.Oracle.AzureDbForPostgreSql.Sync'  # type: str
        self.input = input
        self.output = None


class MigrateOracleAzureDbPostgreSqlSyncDatabaseInput(msrest.serialization.Model):
    """Database specific information for Oracle to Azure Database for PostgreSQL migration task inputs.

    :param case_manipulation: How to handle object name casing: either Preserve or ToLower.
    :type case_manipulation: str
    :param name: Name of the migration pipeline.
    :type name: str
    :param schema_name: Name of the source schema.
    :type schema_name: str
    :param table_map: Mapping of source to target tables.
    :type table_map: dict[str, str]
    :param target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :type target_database_name: str
    :param migration_setting: Migration settings which tune the migration behavior.
    :type migration_setting: dict[str, str]
    :param source_setting: Source settings to tune source endpoint migration behavior.
    :type source_setting: dict[str, str]
    :param target_setting: Target settings to tune target endpoint migration behavior.
    :type target_setting: dict[str, str]
    """

    _attribute_map = {
        'case_manipulation': {'key': 'caseManipulation', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_map': {'key': 'tableMap', 'type': '{str}'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'migration_setting': {'key': 'migrationSetting', 'type': '{str}'},
        'source_setting': {'key': 'sourceSetting', 'type': '{str}'},
        'target_setting': {'key': 'targetSetting', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        case_manipulation: Optional[str] = None,
        name: Optional[str] = None,
        schema_name: Optional[str] = None,
        table_map: Optional[Dict[str, str]] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncDatabaseInput, self).__init__(**kwargs)
        self.case_manipulation = case_manipulation
        self.name = name
        self.schema_name = schema_name
        self.table_map = table_map
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting


class MigrateOracleAzureDbPostgreSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations.

    All required parameters must be populated in order to send to Azure.

    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncDatabaseInput]
    :param target_connection_info: Required. Connection information for target Azure Database for
     PostgreSQL.
    :type target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :param source_connection_info: Required. Connection information for source Oracle.
    :type source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    """

    _validation = {
        'selected_databases': {'required': True},
        'target_connection_info': {'required': True},
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateOracleAzureDbPostgreSqlSyncDatabaseInput]'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'OracleConnectionInfo'},
    }

    def __init__(
        self,
        *,
        selected_databases: List["MigrateOracleAzureDbPostgreSqlSyncDatabaseInput"],
        target_connection_info: "PostgreSqlConnectionInfo",
        source_connection_info: "OracleConnectionInfo",
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskInput, self).__init__(**kwargs)
        self.selected_databases = selected_databases
        self.target_connection_info = target_connection_info
        self.source_connection_info = source_connection_info


class MigrateOracleAzureDbPostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError, MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel, MigrateOracleAzureDbPostgreSqlSyncTaskOutputError, MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel, MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelErrorOutput': 'MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError', 'DatabaseLevelOutput': 'MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateOracleAzureDbPostgreSqlSyncTaskOutputError', 'MigrationLevelOutput': 'MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel', 'TableLevelOutput': 'MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError(MigrateOracleAzureDbPostgreSqlSyncTaskOutput):
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :param error_message: Error message.
    :type error_message: str
    :param events: List of error events.
    :type events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'events': {'key': 'events', 'type': '[SyncMigrationDatabaseErrorEvent]'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelErrorOutput'  # type: str
        self.error_message = error_message
        self.events = events


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel(MigrateOracleAzureDbPostgreSqlSyncTaskOutput):
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Possible values include:
     "UNDEFINED", "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE",
     "COMPLETING", "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING",
     "VALIDATION_COMPLETE", "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED",
     "BACKUP_IN_PROGRESS", "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: long
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: long
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: long
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: long
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: long
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: long
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: long
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: long
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: long
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'migration_state': {'readonly': True},
        'incoming_changes': {'readonly': True},
        'applied_changes': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'full_load_completed_tables': {'readonly': True},
        'full_load_loading_tables': {'readonly': True},
        'full_load_queued_tables': {'readonly': True},
        'full_load_errored_tables': {'readonly': True},
        'initialization_completed': {'readonly': True},
        'latency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'incoming_changes': {'key': 'incomingChanges', 'type': 'long'},
        'applied_changes': {'key': 'appliedChanges', 'type': 'long'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'full_load_completed_tables': {'key': 'fullLoadCompletedTables', 'type': 'long'},
        'full_load_loading_tables': {'key': 'fullLoadLoadingTables', 'type': 'long'},
        'full_load_queued_tables': {'key': 'fullLoadQueuedTables', 'type': 'long'},
        'full_load_errored_tables': {'key': 'fullLoadErroredTables', 'type': 'long'},
        'initialization_completed': {'key': 'initializationCompleted', 'type': 'bool'},
        'latency': {'key': 'latency', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.started_on = None
        self.ended_on = None
        self.migration_state = None
        self.incoming_changes = None
        self.applied_changes = None
        self.cdc_insert_counter = None
        self.cdc_delete_counter = None
        self.cdc_update_counter = None
        self.full_load_completed_tables = None
        self.full_load_loading_tables = None
        self.full_load_queued_tables = None
        self.full_load_errored_tables = None
        self.initialization_completed = None
        self.latency = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputError(MigrateOracleAzureDbPostgreSqlSyncTaskOutput):
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel(MigrateOracleAzureDbPostgreSqlSyncTaskOutput):
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server': {'key': 'sourceServer', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server': {'key': 'targetServer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.source_server_version = None
        self.source_server = None
        self.target_server_version = None
        self.target_server = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel(MigrateOracleAzureDbPostgreSqlSyncTaskOutput):
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: long
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: long
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: long
    :ivar state: Current state of the table migration. Possible values include: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: long
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: long
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'table_name': {'readonly': True},
        'database_name': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'full_load_est_finish_time': {'readonly': True},
        'full_load_started_on': {'readonly': True},
        'full_load_ended_on': {'readonly': True},
        'full_load_total_rows': {'readonly': True},
        'state': {'readonly': True},
        'total_changes_applied': {'readonly': True},
        'data_errors_counter': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'full_load_est_finish_time': {'key': 'fullLoadEstFinishTime', 'type': 'iso-8601'},
        'full_load_started_on': {'key': 'fullLoadStartedOn', 'type': 'iso-8601'},
        'full_load_ended_on': {'key': 'fullLoadEndedOn', 'type': 'iso-8601'},
        'full_load_total_rows': {'key': 'fullLoadTotalRows', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
        'total_changes_applied': {'key': 'totalChangesApplied', 'type': 'long'},
        'data_errors_counter': {'key': 'dataErrorsCounter', 'type': 'long'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel, self).__init__(**kwargs)
        self.result_type = 'TableLevelOutput'  # type: str
        self.table_name = None
        self.database_name = None
        self.cdc_insert_counter = None
        self.cdc_update_counter = None
        self.cdc_delete_counter = None
        self.full_load_est_finish_time = None
        self.full_load_started_on = None
        self.full_load_ended_on = None
        self.full_load_total_rows = None
        self.state = None
        self.total_changes_applied = None
        self.data_errors_counter = None
        self.last_modified_time = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput(msrest.serialization.Model):
    """Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs.

    :param name: Name of the database.
    :type name: str
    :param target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :type target_database_name: str
    :param migration_setting: Migration settings which tune the migration behavior.
    :type migration_setting: dict[str, str]
    :param source_setting: Source settings to tune source endpoint migration behavior.
    :type source_setting: dict[str, str]
    :param target_setting: Target settings to tune target endpoint migration behavior.
    :type target_setting: dict[str, str]
    :param selected_tables: Tables selected for migration.
    :type selected_tables:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'migration_setting': {'key': 'migrationSetting', 'type': '{str}'},
        'source_setting': {'key': 'sourceSetting', 'type': '{str}'},
        'target_setting': {'key': 'targetSetting', 'type': '{str}'},
        'selected_tables': {'key': 'selectedTables', 'type': '[MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        selected_tables: Optional[List["MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput"]] = None,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting
        self.selected_tables = selected_tables


class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput(msrest.serialization.Model):
    """Selected tables for the migration.

    :param name: Name of the table to migrate.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput, self).__init__(**kwargs)
        self.name = name


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput(msrest.serialization.Model):
    """Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations.

    All required parameters must be populated in order to send to Azure.

    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput]
    :param target_connection_info: Required. Connection information for target Azure Database for
     PostgreSQL.
    :type target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :param source_connection_info: Required. Connection information for source PostgreSQL.
    :type source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        'selected_databases': {'required': True},
        'target_connection_info': {'required': True},
        'source_connection_info': {'required': True},
    }

    _attribute_map = {
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput]'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'PostgreSqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        selected_databases: List["MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput"],
        target_connection_info: "PostgreSqlConnectionInfo",
        source_connection_info: "PostgreSqlConnectionInfo",
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput, self).__init__(**kwargs)
        self.selected_databases = selected_databases
        self.target_connection_info = target_connection_info
        self.source_connection_info = source_connection_info


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError, MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel, MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError, MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel, MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelErrorOutput': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError', 'DatabaseLevelOutput': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel', 'ErrorOutput': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError', 'MigrationLevelOutput': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel', 'TableLevelOutput': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput):
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :param error_message: Error message.
    :type error_message: str
    :param events: List of error events.
    :type events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'events': {'key': 'events', 'type': '[SyncMigrationDatabaseErrorEvent]'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelErrorOutput'  # type: str
        self.error_message = error_message
        self.events = events


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput):
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Possible values include:
     "UNDEFINED", "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE",
     "COMPLETING", "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING",
     "VALIDATION_COMPLETE", "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED",
     "BACKUP_IN_PROGRESS", "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: long
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: long
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: long
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: long
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: long
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: long
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: long
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: long
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: long
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'migration_state': {'readonly': True},
        'incoming_changes': {'readonly': True},
        'applied_changes': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'full_load_completed_tables': {'readonly': True},
        'full_load_loading_tables': {'readonly': True},
        'full_load_queued_tables': {'readonly': True},
        'full_load_errored_tables': {'readonly': True},
        'initialization_completed': {'readonly': True},
        'latency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'incoming_changes': {'key': 'incomingChanges', 'type': 'long'},
        'applied_changes': {'key': 'appliedChanges', 'type': 'long'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'full_load_completed_tables': {'key': 'fullLoadCompletedTables', 'type': 'long'},
        'full_load_loading_tables': {'key': 'fullLoadLoadingTables', 'type': 'long'},
        'full_load_queued_tables': {'key': 'fullLoadQueuedTables', 'type': 'long'},
        'full_load_errored_tables': {'key': 'fullLoadErroredTables', 'type': 'long'},
        'initialization_completed': {'key': 'initializationCompleted', 'type': 'bool'},
        'latency': {'key': 'latency', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.started_on = None
        self.ended_on = None
        self.migration_state = None
        self.incoming_changes = None
        self.applied_changes = None
        self.cdc_insert_counter = None
        self.cdc_delete_counter = None
        self.cdc_update_counter = None
        self.full_load_completed_tables = None
        self.full_load_loading_tables = None
        self.full_load_queued_tables = None
        self.full_load_errored_tables = None
        self.initialization_completed = None
        self.latency = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput):
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput):
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    :ivar source_server_type: Source server type. Possible values include: "Access", "DB2",
     "MySQL", "Oracle", "SQL", "Sybase", "PostgreSQL", "MongoDB", "SQLRDS", "MySQLRDS",
     "PostgreSQLRDS".
    :vartype source_server_type: str or ~azure.mgmt.datamigration.models.ScenarioSource
    :ivar target_server_type: Target server type. Possible values include: "SQLServer", "SQLDB",
     "SQLDW", "SQLMI", "AzureDBForMySql", "AzureDBForPostgresSQL", "MongoDB".
    :vartype target_server_type: str or ~azure.mgmt.datamigration.models.ScenarioTarget
    :ivar state: Migration status. Possible values include: "UNDEFINED", "VALIDATING", "PENDING",
     "COMPLETE", "ACTION_REQUIRED", "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.ReplicateMigrationState
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server': {'readonly': True},
        'source_server_type': {'readonly': True},
        'target_server_type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server': {'key': 'sourceServer', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server': {'key': 'targetServer', 'type': 'str'},
        'source_server_type': {'key': 'sourceServerType', 'type': 'str'},
        'target_server_type': {'key': 'targetServerType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.source_server_version = None
        self.source_server = None
        self.target_server_version = None
        self.target_server = None
        self.source_server_type = None
        self.target_server_type = None
        self.state = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput):
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: long
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: long
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: long
    :ivar state: Current state of the table migration. Possible values include: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: long
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: long
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'table_name': {'readonly': True},
        'database_name': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'full_load_est_finish_time': {'readonly': True},
        'full_load_started_on': {'readonly': True},
        'full_load_ended_on': {'readonly': True},
        'full_load_total_rows': {'readonly': True},
        'state': {'readonly': True},
        'total_changes_applied': {'readonly': True},
        'data_errors_counter': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'full_load_est_finish_time': {'key': 'fullLoadEstFinishTime', 'type': 'iso-8601'},
        'full_load_started_on': {'key': 'fullLoadStartedOn', 'type': 'iso-8601'},
        'full_load_ended_on': {'key': 'fullLoadEndedOn', 'type': 'iso-8601'},
        'full_load_total_rows': {'key': 'fullLoadTotalRows', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
        'total_changes_applied': {'key': 'totalChangesApplied', 'type': 'long'},
        'data_errors_counter': {'key': 'dataErrorsCounter', 'type': 'long'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel, self).__init__(**kwargs)
        self.result_type = 'TableLevelOutput'  # type: str
        self.table_name = None
        self.database_name = None
        self.cdc_insert_counter = None
        self.cdc_update_counter = None
        self.cdc_delete_counter = None
        self.full_load_est_finish_time = None
        self.full_load_started_on = None
        self.full_load_ended_on = None
        self.full_load_total_rows = None
        self.state = None
        self.total_changes_applied = None
        self.data_errors_counter = None
        self.last_modified_time = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input:
     ~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2'  # type: str
        self.input = input
        self.output = None


class MigrateSchemaSqlServerSqlDbDatabaseInput(msrest.serialization.Model):
    """Database input for migrate schema Sql Server to Azure SQL Server scenario.

    :param name: Name of source database.
    :type name: str
    :param target_database_name: Name of target database.
    :type target_database_name: str
    :param schema_setting: Database schema migration settings.
    :type schema_setting: ~azure.mgmt.datamigration.models.SchemaMigrationSetting
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'schema_setting': {'key': 'schemaSetting', 'type': 'SchemaMigrationSetting'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        schema_setting: Optional["SchemaMigrationSetting"] = None,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.schema_setting = schema_setting


class SqlMigrationTaskInput(msrest.serialization.Model):
    """Base class for migration task input.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        **kwargs
    ):
        super(SqlMigrationTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class MigrateSchemaSqlServerSqlDbTaskInput(SqlMigrationTaskInput):
    """Input for task that migrates Schema for SQL Server databases to Azure SQL databases.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbDatabaseInput]
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSchemaSqlServerSqlDbDatabaseInput]'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSchemaSqlServerSqlDbDatabaseInput"],
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskInput, self).__init__(source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs)
        self.selected_databases = selected_databases


class MigrateSchemaSqlServerSqlDbTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates Schema for SQL Server databases to Azure SQL databases.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel, MigrateSchemaSqlTaskOutputError, MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel, MigrateSchemaSqlServerSqlDbTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type.Constant filled by server.
    :vartype result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelOutput': 'MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateSchemaSqlTaskOutputError', 'MigrationLevelOutput': 'MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel', 'SchemaErrorOutput': 'MigrateSchemaSqlServerSqlDbTaskOutputError'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type.Constant filled by server.
    :vartype result_type: str
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar state: State of the schema migration for this database. Possible values include: "None",
     "InProgress", "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Schema migration stage for this database. Possible values include: "NotStarted",
     "ValidatingInputs", "CollectingObjects", "DownloadingScript", "GeneratingScript",
     "UploadingScript", "DeployingSchema", "Completed", "CompletedWithWarnings", "Failed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SchemaMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar database_error_result_prefix: Prefix string to use for querying errors for this database.
    :vartype database_error_result_prefix: str
    :ivar schema_error_result_prefix: Prefix string to use for querying schema errors for this
     database.
    :vartype schema_error_result_prefix: str
    :ivar number_of_successful_operations: Number of successful operations for this database.
    :vartype number_of_successful_operations: long
    :ivar number_of_failed_operations: Number of failed operations for this database.
    :vartype number_of_failed_operations: long
    :ivar file_id: Identifier for the file resource containing the schema of this database.
    :vartype file_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'readonly': True},
        'database_name': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'database_error_result_prefix': {'readonly': True},
        'schema_error_result_prefix': {'readonly': True},
        'number_of_successful_operations': {'readonly': True},
        'number_of_failed_operations': {'readonly': True},
        'file_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'database_error_result_prefix': {'key': 'databaseErrorResultPrefix', 'type': 'str'},
        'schema_error_result_prefix': {'key': 'schemaErrorResultPrefix', 'type': 'str'},
        'number_of_successful_operations': {'key': 'numberOfSuccessfulOperations', 'type': 'long'},
        'number_of_failed_operations': {'key': 'numberOfFailedOperations', 'type': 'long'},
        'file_id': {'key': 'fileId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.state = None
        self.stage = None
        self.started_on = None
        self.ended_on = None
        self.database_error_result_prefix = None
        self.schema_error_result_prefix = None
        self.number_of_successful_operations = None
        self.number_of_failed_operations = None
        self.file_id = None


class MigrateSchemaSqlServerSqlDbTaskOutputError(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlServerSqlDbTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type.Constant filled by server.
    :vartype result_type: str
    :ivar command_text: Schema command which failed.
    :vartype command_text: str
    :ivar error_text: Reason of failure.
    :vartype error_text: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'readonly': True},
        'command_text': {'readonly': True},
        'error_text': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'command_text': {'key': 'commandText', 'type': 'str'},
        'error_text': {'key': 'errorText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'SchemaErrorOutput'  # type: str
        self.command_text = None
        self.error_text = None


class MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type.Constant filled by server.
    :vartype result_type: str
    :ivar state: Overall state of the schema migration. Possible values include: "None",
     "InProgress", "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'readonly': True},
        'state': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.state = None
        self.started_on = None
        self.ended_on = None
        self.source_server_version = None
        self.source_server_brand_version = None
        self.target_server_version = None
        self.target_server_brand_version = None


class MigrateSchemaSqlServerSqlDbTaskProperties(ProjectTaskProperties):
    """Properties for task that migrates Schema for SQL Server databases to Azure SQL databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSchemaSqlServerSqlDbTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSchemaSqlServerSqlDbTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSchemaSqlServerSqlDbTaskInput"] = None,
        **kwargs
    ):
        super(MigrateSchemaSqlServerSqlDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'MigrateSchemaSqlServerSqlDb'  # type: str
        self.input = input
        self.output = None


class MigrateSchemaSqlTaskOutputError(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type.Constant filled by server.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSchemaSqlTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateSqlServerDatabaseInput(msrest.serialization.Model):
    """Database specific information for SQL to SQL migration task inputs.

    :param name: Name of the database.
    :type name: str
    :param restore_database_name: Name of the database at destination.
    :type restore_database_name: str
    :param backup_and_restore_folder: The backup and restore folder.
    :type backup_and_restore_folder: str
    :param database_files: The list of database files.
    :type database_files: list[~azure.mgmt.datamigration.models.DatabaseFileInput]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'restore_database_name': {'key': 'restoreDatabaseName', 'type': 'str'},
        'backup_and_restore_folder': {'key': 'backupAndRestoreFolder', 'type': 'str'},
        'database_files': {'key': 'databaseFiles', 'type': '[DatabaseFileInput]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        restore_database_name: Optional[str] = None,
        backup_and_restore_folder: Optional[str] = None,
        database_files: Optional[List["DatabaseFileInput"]] = None,
        **kwargs
    ):
        super(MigrateSqlServerDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.restore_database_name = restore_database_name
        self.backup_and_restore_folder = backup_and_restore_folder
        self.database_files = database_files


class MigrateSqlServerSqlDbDatabaseInput(msrest.serialization.Model):
    """Database specific information for SQL to Azure SQL DB migration task inputs.

    :param name: Name of the database.
    :type name: str
    :param target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :type target_database_name: str
    :param make_source_db_read_only: Whether to set database read only before migration.
    :type make_source_db_read_only: bool
    :param table_map: Mapping of source to target tables.
    :type table_map: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'make_source_db_read_only': {'key': 'makeSourceDbReadOnly', 'type': 'bool'},
        'table_map': {'key': 'tableMap', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        make_source_db_read_only: Optional[bool] = None,
        table_map: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.make_source_db_read_only = make_source_db_read_only
        self.table_map = table_map


class MigrateSqlServerSqlDbSyncDatabaseInput(msrest.serialization.Model):
    """Database specific information for SQL to Azure SQL DB sync migration task inputs.

    :param id: Unique identifier for database.
    :type id: str
    :param name: Name of database.
    :type name: str
    :param target_database_name: Target database name.
    :type target_database_name: str
    :param schema_name: Schema name to be migrated.
    :type schema_name: str
    :param table_map: Mapping of source to target tables.
    :type table_map: dict[str, str]
    :param migration_setting: Migration settings which tune the migration behavior.
    :type migration_setting: dict[str, str]
    :param source_setting: Source settings to tune source endpoint migration behavior.
    :type source_setting: dict[str, str]
    :param target_setting: Target settings to tune target endpoint migration behavior.
    :type target_setting: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_map': {'key': 'tableMap', 'type': '{str}'},
        'migration_setting': {'key': 'migrationSetting', 'type': '{str}'},
        'source_setting': {'key': 'sourceSetting', 'type': '{str}'},
        'target_setting': {'key': 'targetSetting', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        table_map: Optional[Dict[str, str]] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncDatabaseInput, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.target_database_name = target_database_name
        self.schema_name = schema_name
        self.table_map = table_map
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting


class MigrateSqlServerSqlDbSyncTaskInput(SqlMigrationTaskInput):
    """Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
    :param validation_options: Validation options.
    :type validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlDbSyncDatabaseInput]'},
        'validation_options': {'key': 'validationOptions', 'type': 'MigrationValidationOptions'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSqlServerSqlDbSyncDatabaseInput"],
        validation_options: Optional["MigrationValidationOptions"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskInput, self).__init__(source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs)
        self.selected_databases = selected_databases
        self.validation_options = validation_options


class MigrateSqlServerSqlDbSyncTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSqlServerSqlDbSyncTaskOutputDatabaseError, MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel, MigrateSqlServerSqlDbSyncTaskOutputError, MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel, MigrateSqlServerSqlDbSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelErrorOutput': 'MigrateSqlServerSqlDbSyncTaskOutputDatabaseError', 'DatabaseLevelOutput': 'MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateSqlServerSqlDbSyncTaskOutputError', 'MigrationLevelOutput': 'MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel', 'TableLevelOutput': 'MigrateSqlServerSqlDbSyncTaskOutputTableLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSqlServerSqlDbSyncTaskOutputDatabaseError(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :param error_message: Error message.
    :type error_message: str
    :param events: List of error events.
    :type events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'events': {'key': 'events', 'type': '[SyncMigrationDatabaseErrorEvent]'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutputDatabaseError, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelErrorOutput'  # type: str
        self.error_message = error_message
        self.events = events


class MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Possible values include:
     "UNDEFINED", "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE",
     "COMPLETING", "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING",
     "VALIDATION_COMPLETE", "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED",
     "BACKUP_IN_PROGRESS", "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: long
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: long
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: long
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: long
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: long
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: long
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: long
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: long
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: long
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'migration_state': {'readonly': True},
        'incoming_changes': {'readonly': True},
        'applied_changes': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'full_load_completed_tables': {'readonly': True},
        'full_load_loading_tables': {'readonly': True},
        'full_load_queued_tables': {'readonly': True},
        'full_load_errored_tables': {'readonly': True},
        'initialization_completed': {'readonly': True},
        'latency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'incoming_changes': {'key': 'incomingChanges', 'type': 'long'},
        'applied_changes': {'key': 'appliedChanges', 'type': 'long'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'full_load_completed_tables': {'key': 'fullLoadCompletedTables', 'type': 'long'},
        'full_load_loading_tables': {'key': 'fullLoadLoadingTables', 'type': 'long'},
        'full_load_queued_tables': {'key': 'fullLoadQueuedTables', 'type': 'long'},
        'full_load_errored_tables': {'key': 'fullLoadErroredTables', 'type': 'long'},
        'initialization_completed': {'key': 'initializationCompleted', 'type': 'bool'},
        'latency': {'key': 'latency', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.started_on = None
        self.ended_on = None
        self.migration_state = None
        self.incoming_changes = None
        self.applied_changes = None
        self.cdc_insert_counter = None
        self.cdc_delete_counter = None
        self.cdc_update_counter = None
        self.full_load_completed_tables = None
        self.full_load_loading_tables = None
        self.full_load_queued_tables = None
        self.full_load_errored_tables = None
        self.initialization_completed = None
        self.latency = None


class MigrateSqlServerSqlDbSyncTaskOutputError(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    :ivar database_count: Count of databases.
    :vartype database_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server': {'readonly': True},
        'database_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server': {'key': 'sourceServer', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server': {'key': 'targetServer', 'type': 'str'},
        'database_count': {'key': 'databaseCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.source_server_version = None
        self.source_server = None
        self.target_server_version = None
        self.target_server = None
        self.database_count = None


class MigrateSqlServerSqlDbSyncTaskOutputTableLevel(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: long
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: long
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: long
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: long
    :ivar state: Current state of the table migration. Possible values include: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: long
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: long
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'table_name': {'readonly': True},
        'database_name': {'readonly': True},
        'cdc_insert_counter': {'readonly': True},
        'cdc_update_counter': {'readonly': True},
        'cdc_delete_counter': {'readonly': True},
        'full_load_est_finish_time': {'readonly': True},
        'full_load_started_on': {'readonly': True},
        'full_load_ended_on': {'readonly': True},
        'full_load_total_rows': {'readonly': True},
        'state': {'readonly': True},
        'total_changes_applied': {'readonly': True},
        'data_errors_counter': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'cdc_insert_counter': {'key': 'cdcInsertCounter', 'type': 'long'},
        'cdc_update_counter': {'key': 'cdcUpdateCounter', 'type': 'long'},
        'cdc_delete_counter': {'key': 'cdcDeleteCounter', 'type': 'long'},
        'full_load_est_finish_time': {'key': 'fullLoadEstFinishTime', 'type': 'iso-8601'},
        'full_load_started_on': {'key': 'fullLoadStartedOn', 'type': 'iso-8601'},
        'full_load_ended_on': {'key': 'fullLoadEndedOn', 'type': 'iso-8601'},
        'full_load_total_rows': {'key': 'fullLoadTotalRows', 'type': 'long'},
        'state': {'key': 'state', 'type': 'str'},
        'total_changes_applied': {'key': 'totalChangesApplied', 'type': 'long'},
        'data_errors_counter': {'key': 'dataErrorsCounter', 'type': 'long'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskOutputTableLevel, self).__init__(**kwargs)
        self.result_type = 'TableLevelOutput'  # type: str
        self.table_name = None
        self.database_name = None
        self.cdc_insert_counter = None
        self.cdc_update_counter = None
        self.cdc_delete_counter = None
        self.full_load_est_finish_time = None
        self.full_load_started_on = None
        self.full_load_ended_on = None
        self.full_load_total_rows = None
        self.state = None
        self.total_changes_applied = None
        self.data_errors_counter = None
        self.last_modified_time = None


class MigrateSqlServerSqlDbSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSqlServerSqlDbSyncTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSqlServerSqlDbSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSqlServerSqlDbSyncTaskInput"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.SqlServer.AzureSqlDb.Sync'  # type: str
        self.input = input
        self.output = None


class MigrateSqlServerSqlDbTaskInput(SqlMigrationTaskInput):
    """Input for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbDatabaseInput]
    :param validation_options: Options for enabling various post migration validations. Available
     options,
      1.) Data Integrity Check: Performs a checksum based comparison on source and target tables
     after the migration to ensure the correctness of the data.
      2.) Schema Validation: Performs a thorough schema comparison between the source and target
     tables and provides a list of differences between the source and target database, 3.) Query
     Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or
     Query Store and execute them and compares the execution time between the source and target
     database.
    :type validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlDbDatabaseInput]'},
        'validation_options': {'key': 'validationOptions', 'type': 'MigrationValidationOptions'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSqlServerSqlDbDatabaseInput"],
        validation_options: Optional["MigrationValidationOptions"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskInput, self).__init__(source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs)
        self.selected_databases = selected_databases
        self.validation_options = validation_options


class MigrateSqlServerSqlDbTaskOutput(msrest.serialization.Model):
    """Output for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSqlServerSqlDbTaskOutputDatabaseLevel, MigrateSqlServerSqlDbTaskOutputError, MigrateSqlServerSqlDbTaskOutputMigrationLevel, MigrateSqlServerSqlDbTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelOutput': 'MigrateSqlServerSqlDbTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateSqlServerSqlDbTaskOutputError', 'MigrationLevelOutput': 'MigrateSqlServerSqlDbTaskOutputMigrationLevel', 'TableLevelOutput': 'MigrateSqlServerSqlDbTaskOutputTableLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSqlServerSqlDbTaskOutputDatabaseLevel(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the item.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Migration stage that this database is in. Possible values include: "None",
     "Initialize", "Backup", "FileCopy", "Restore", "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.DatabaseMigrationStage
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar number_of_objects: Number of objects.
    :vartype number_of_objects: long
    :ivar number_of_objects_completed: Number of successfully completed objects.
    :vartype number_of_objects_completed: long
    :ivar error_count: Number of database/object errors.
    :vartype error_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar object_summary: Summary of object results in the migration.
    :vartype object_summary: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'status_message': {'readonly': True},
        'message': {'readonly': True},
        'number_of_objects': {'readonly': True},
        'number_of_objects_completed': {'readonly': True},
        'error_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
        'object_summary': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'number_of_objects': {'key': 'numberOfObjects', 'type': 'long'},
        'number_of_objects_completed': {'key': 'numberOfObjectsCompleted', 'type': 'long'},
        'error_count': {'key': 'errorCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
        'object_summary': {'key': 'objectSummary', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.started_on = None
        self.ended_on = None
        self.state = None
        self.stage = None
        self.status_message = None
        self.message = None
        self.number_of_objects = None
        self.number_of_objects_completed = None
        self.error_count = None
        self.error_prefix = None
        self.result_prefix = None
        self.exceptions_and_warnings = None
        self.object_summary = None


class MigrateSqlServerSqlDbTaskOutputError(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateSqlServerSqlDbTaskOutputMigrationLevel(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar duration_in_seconds: Duration of task execution in seconds.
    :vartype duration_in_seconds: long
    :ivar status: Current status of migration. Possible values include: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar status_message: Migration status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar databases: Selected databases as a map from database name to database id.
    :vartype databases: str
    :ivar database_summary: Summary of database results in the migration.
    :vartype database_summary: str
    :param migration_validation_result: Migration Validation Results.
    :type migration_validation_result: ~azure.mgmt.datamigration.models.MigrationValidationResult
    :param migration_report_result: Migration Report Result, provides unique url for downloading
     your migration report.
    :type migration_report_result: ~azure.mgmt.datamigration.models.MigrationReportResult
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'duration_in_seconds': {'readonly': True},
        'status': {'readonly': True},
        'status_message': {'readonly': True},
        'message': {'readonly': True},
        'databases': {'readonly': True},
        'database_summary': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'long'},
        'status': {'key': 'status', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'databases': {'key': 'databases', 'type': 'str'},
        'database_summary': {'key': 'databaseSummary', 'type': 'str'},
        'migration_validation_result': {'key': 'migrationValidationResult', 'type': 'MigrationValidationResult'},
        'migration_report_result': {'key': 'migrationReportResult', 'type': 'MigrationReportResult'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        *,
        migration_validation_result: Optional["MigrationValidationResult"] = None,
        migration_report_result: Optional["MigrationReportResult"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.duration_in_seconds = None
        self.status = None
        self.status_message = None
        self.message = None
        self.databases = None
        self.database_summary = None
        self.migration_validation_result = migration_validation_result
        self.migration_report_result = migration_report_result
        self.source_server_version = None
        self.source_server_brand_version = None
        self.target_server_version = None
        self.target_server_brand_version = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlDbTaskOutputTableLevel(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar object_name: Name of the item.
    :vartype object_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: long
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'object_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'status_message': {'readonly': True},
        'items_count': {'readonly': True},
        'items_completed_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'items_count': {'key': 'itemsCount', 'type': 'long'},
        'items_completed_count': {'key': 'itemsCompletedCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskOutputTableLevel, self).__init__(**kwargs)
        self.result_type = 'TableLevelOutput'  # type: str
        self.object_name = None
        self.started_on = None
        self.ended_on = None
        self.state = None
        self.status_message = None
        self.items_count = None
        self.items_completed_count = None
        self.error_prefix = None
        self.result_prefix = None


class MigrateSqlServerSqlDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSqlServerSqlDbTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSqlServerSqlDbTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSqlServerSqlDbTaskInput"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.SqlServer.SqlDb'  # type: str
        self.input = input
        self.output = None


class MigrateSqlServerSqlMIDatabaseInput(msrest.serialization.Model):
    """Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the database.
    :type name: str
    :param restore_database_name: Required. Name of the database at destination.
    :type restore_database_name: str
    :param backup_file_share: Backup file share information for backing up this database.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param backup_file_paths: The list of backup files to be used in case of existing backups.
    :type backup_file_paths: list[str]
    """

    _validation = {
        'name': {'required': True},
        'restore_database_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'restore_database_name': {'key': 'restoreDatabaseName', 'type': 'str'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'backup_file_paths': {'key': 'backupFilePaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        restore_database_name: str,
        backup_file_share: Optional["FileShare"] = None,
        backup_file_paths: Optional[List[str]] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlMIDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.restore_database_name = restore_database_name
        self.backup_file_share = backup_file_share
        self.backup_file_paths = backup_file_paths


class SqlServerSqlMISyncTaskInput(msrest.serialization.Model):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.

    All required parameters must be populated in order to send to Azure.

    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :param backup_file_share: Backup file share information for all selected databases.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param storage_resource_id: Required. Fully qualified resourceId of storage.
    :type storage_resource_id: str
    :param source_connection_info: Required. Connection information for source SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Connection information for Azure SQL Database Managed
     Instance.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :param azure_app: Required. Azure Active Directory Application the DMS instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account.
    :type azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        'selected_databases': {'required': True},
        'storage_resource_id': {'required': True},
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'azure_app': {'required': True},
    }

    _attribute_map = {
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlMIDatabaseInput]'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'storage_resource_id': {'key': 'storageResourceId', 'type': 'str'},
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MiSqlConnectionInfo'},
        'azure_app': {'key': 'azureApp', 'type': 'AzureActiveDirectoryApp'},
    }

    def __init__(
        self,
        *,
        selected_databases: List["MigrateSqlServerSqlMIDatabaseInput"],
        storage_resource_id: str,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "MiSqlConnectionInfo",
        azure_app: "AzureActiveDirectoryApp",
        backup_file_share: Optional["FileShare"] = None,
        **kwargs
    ):
        super(SqlServerSqlMISyncTaskInput, self).__init__(**kwargs)
        self.selected_databases = selected_databases
        self.backup_file_share = backup_file_share
        self.storage_resource_id = storage_resource_id
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.azure_app = azure_app


class MigrateSqlServerSqlMISyncTaskInput(SqlServerSqlMISyncTaskInput):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.

    All required parameters must be populated in order to send to Azure.

    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :param backup_file_share: Backup file share information for all selected databases.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param storage_resource_id: Required. Fully qualified resourceId of storage.
    :type storage_resource_id: str
    :param source_connection_info: Required. Connection information for source SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Connection information for Azure SQL Database Managed
     Instance.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :param azure_app: Required. Azure Active Directory Application the DMS instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account.
    :type azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        'selected_databases': {'required': True},
        'storage_resource_id': {'required': True},
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'azure_app': {'required': True},
    }

    _attribute_map = {
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlMIDatabaseInput]'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'storage_resource_id': {'key': 'storageResourceId', 'type': 'str'},
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MiSqlConnectionInfo'},
        'azure_app': {'key': 'azureApp', 'type': 'AzureActiveDirectoryApp'},
    }

    def __init__(
        self,
        *,
        selected_databases: List["MigrateSqlServerSqlMIDatabaseInput"],
        storage_resource_id: str,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "MiSqlConnectionInfo",
        azure_app: "AzureActiveDirectoryApp",
        backup_file_share: Optional["FileShare"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskInput, self).__init__(selected_databases=selected_databases, backup_file_share=backup_file_share, storage_resource_id=storage_resource_id, source_connection_info=source_connection_info, target_connection_info=target_connection_info, azure_app=azure_app, **kwargs)


class MigrateSqlServerSqlMISyncTaskOutput(msrest.serialization.Model):
    """Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance using Log Replay Service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel, MigrateSqlServerSqlMISyncTaskOutputError, MigrateSqlServerSqlMISyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'DatabaseLevelOutput': 'MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateSqlServerSqlMISyncTaskOutputError', 'MigrationLevelOutput': 'MigrateSqlServerSqlMISyncTaskOutputMigrationLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel(MigrateSqlServerSqlMISyncTaskOutput):
    """MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar source_database_name: Name of the database.
    :vartype source_database_name: str
    :ivar migration_state: Current state of database. Possible values include: "UNDEFINED",
     "INITIAL", "FULL_BACKUP_UPLOAD_START", "LOG_SHIPPING_START", "UPLOAD_LOG_FILES_START",
     "CUTOVER_START", "POST_CUTOVER_COMPLETE", "COMPLETED", "CANCELLED", "FAILED".
    :vartype migration_state: str or ~azure.mgmt.datamigration.models.DatabaseMigrationState
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar full_backup_set_info: Details of full backup set.
    :vartype full_backup_set_info: ~azure.mgmt.datamigration.models.BackupSetInfo
    :ivar last_restored_backup_set_info: Last applied backup set information.
    :vartype last_restored_backup_set_info: ~azure.mgmt.datamigration.models.BackupSetInfo
    :ivar active_backup_sets: Backup sets that are currently active (Either being uploaded or
     getting restored).
    :vartype active_backup_sets: list[~azure.mgmt.datamigration.models.BackupSetInfo]
    :ivar container_name: Name of container created in the Azure Storage account where backups are
     copied to.
    :vartype container_name: str
    :ivar error_prefix: prefix string to use for querying errors for this database.
    :vartype error_prefix: str
    :ivar is_full_backup_restored: Whether full backup has been applied to the target database or
     not.
    :vartype is_full_backup_restored: bool
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'source_database_name': {'readonly': True},
        'migration_state': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'full_backup_set_info': {'readonly': True},
        'last_restored_backup_set_info': {'readonly': True},
        'active_backup_sets': {'readonly': True},
        'container_name': {'readonly': True},
        'error_prefix': {'readonly': True},
        'is_full_backup_restored': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'source_database_name': {'key': 'sourceDatabaseName', 'type': 'str'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'full_backup_set_info': {'key': 'fullBackupSetInfo', 'type': 'BackupSetInfo'},
        'last_restored_backup_set_info': {'key': 'lastRestoredBackupSetInfo', 'type': 'BackupSetInfo'},
        'active_backup_sets': {'key': 'activeBackupSets', 'type': '[BackupSetInfo]'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'is_full_backup_restored': {'key': 'isFullBackupRestored', 'type': 'bool'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.source_database_name = None
        self.migration_state = None
        self.started_on = None
        self.ended_on = None
        self.full_backup_set_info = None
        self.last_restored_backup_set_info = None
        self.active_backup_sets = None
        self.container_name = None
        self.error_prefix = None
        self.is_full_backup_restored = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlMISyncTaskOutputError(MigrateSqlServerSqlMISyncTaskOutput):
    """MigrateSqlServerSqlMISyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateSqlServerSqlMISyncTaskOutputMigrationLevel(MigrateSqlServerSqlMISyncTaskOutput):
    """MigrateSqlServerSqlMISyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_count: Count of databases.
    :vartype database_count: int
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_name: Source server name.
    :vartype source_server_name: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_name: Target server name.
    :vartype target_server_name: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar database_error_count: Number of database level errors.
    :vartype database_error_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_count': {'readonly': True},
        'state': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'source_server_name': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'target_server_name': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'database_error_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_count': {'key': 'databaseCount', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'source_server_name': {'key': 'sourceServerName', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'target_server_name': {'key': 'targetServerName', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'database_error_count': {'key': 'databaseErrorCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.database_count = None
        self.state = None
        self.started_on = None
        self.ended_on = None
        self.source_server_name = None
        self.source_server_version = None
        self.source_server_brand_version = None
        self.target_server_name = None
        self.target_server_version = None
        self.target_server_brand_version = None
        self.database_error_count = None


class MigrateSqlServerSqlMISyncTaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance sync scenario.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMISyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSqlServerSqlMISyncTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSqlServerSqlMISyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSqlServerSqlMISyncTaskInput"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlMISyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.SqlServer.AzureSqlDbMI.Sync.LRS'  # type: str
        self.input = input
        self.output = None


class MigrateSqlServerSqlMITaskInput(SqlMigrationTaskInput):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :param selected_logins: Logins to migrate.
    :type selected_logins: list[str]
    :param selected_agent_jobs: Agent Jobs to migrate.
    :type selected_agent_jobs: list[str]
    :param backup_file_share: Backup file share information for all selected databases.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param backup_blob_share: Required. SAS URI of Azure Storage Account Container to be used for
     storing backup files.
    :type backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
    :param backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
     If using existing backups, backup file paths are required to be provided in selectedDatabases.
     Possible values include: "CreateBackup", "ExistingBackup".
    :type backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
    :param aad_domain_name: Azure Active Directory domain name in the format of 'contoso.com' for
     federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if
     Windows logins are selected.
    :type aad_domain_name: str
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
        'backup_blob_share': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlMIDatabaseInput]'},
        'selected_logins': {'key': 'selectedLogins', 'type': '[str]'},
        'selected_agent_jobs': {'key': 'selectedAgentJobs', 'type': '[str]'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'backup_blob_share': {'key': 'backupBlobShare', 'type': 'BlobShare'},
        'backup_mode': {'key': 'backupMode', 'type': 'str'},
        'aad_domain_name': {'key': 'aadDomainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSqlServerSqlMIDatabaseInput"],
        backup_blob_share: "BlobShare",
        selected_logins: Optional[List[str]] = None,
        selected_agent_jobs: Optional[List[str]] = None,
        backup_file_share: Optional["FileShare"] = None,
        backup_mode: Optional[Union[str, "BackupMode"]] = None,
        aad_domain_name: Optional[str] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskInput, self).__init__(source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs)
        self.selected_databases = selected_databases
        self.selected_logins = selected_logins
        self.selected_agent_jobs = selected_agent_jobs
        self.backup_file_share = backup_file_share
        self.backup_blob_share = backup_blob_share
        self.backup_mode = backup_mode
        self.aad_domain_name = aad_domain_name


class MigrateSqlServerSqlMITaskOutput(msrest.serialization.Model):
    """Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSqlServerSqlMITaskOutputAgentJobLevel, MigrateSqlServerSqlMITaskOutputDatabaseLevel, MigrateSqlServerSqlMITaskOutputError, MigrateSqlServerSqlMITaskOutputLoginLevel, MigrateSqlServerSqlMITaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'AgentJobLevelOutput': 'MigrateSqlServerSqlMITaskOutputAgentJobLevel', 'DatabaseLevelOutput': 'MigrateSqlServerSqlMITaskOutputDatabaseLevel', 'ErrorOutput': 'MigrateSqlServerSqlMITaskOutputError', 'LoginLevelOutput': 'MigrateSqlServerSqlMITaskOutputLoginLevel', 'MigrationLevelOutput': 'MigrateSqlServerSqlMITaskOutputMigrationLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSqlServerSqlMITaskOutputAgentJobLevel(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputAgentJobLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar name: Agent Job name.
    :vartype name: str
    :ivar is_enabled: The state of the original Agent Job.
    :vartype is_enabled: bool
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration errors and warnings per job.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'name': {'readonly': True},
        'is_enabled': {'readonly': True},
        'state': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'message': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'state': {'key': 'state', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutputAgentJobLevel, self).__init__(**kwargs)
        self.result_type = 'AgentJobLevelOutput'  # type: str
        self.name = None
        self.is_enabled = None
        self.state = None
        self.started_on = None
        self.ended_on = None
        self.message = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlMITaskOutputDatabaseLevel(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar size_mb: Size of the database in megabytes.
    :vartype size_mb: float
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Current stage of migration. Possible values include: "None", "Initialize",
     "Backup", "FileCopy", "Restore", "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.DatabaseMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'size_mb': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'message': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'size_mb': {'key': 'sizeMB', 'type': 'float'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.result_type = 'DatabaseLevelOutput'  # type: str
        self.database_name = None
        self.size_mb = None
        self.state = None
        self.stage = None
        self.started_on = None
        self.ended_on = None
        self.message = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlMITaskOutputError(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ReportableException'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutputError, self).__init__(**kwargs)
        self.result_type = 'ErrorOutput'  # type: str
        self.error = None


class MigrateSqlServerSqlMITaskOutputLoginLevel(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputLoginLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar login_name: Login name.
    :vartype login_name: str
    :ivar state: Current state of login. Possible values include: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Current stage of login. Possible values include: "None", "Initialize",
     "LoginMigration", "EstablishUserMapping", "AssignRoleMembership", "AssignRoleOwnership",
     "EstablishServerPermissions", "EstablishObjectPermissions", "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.LoginMigrationStage
    :ivar started_on: Login migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Login migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Login migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Login migration errors and warnings per login.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'login_name': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'message': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'login_name': {'key': 'loginName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutputLoginLevel, self).__init__(**kwargs)
        self.result_type = 'LoginLevelOutput'  # type: str
        self.login_name = None
        self.state = None
        self.stage = None
        self.started_on = None
        self.ended_on = None
        self.message = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlMITaskOutputMigrationLevel(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of migration. Possible values include: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar agent_jobs: Selected agent jobs as a map from name to id.
    :vartype agent_jobs: str
    :ivar logins: Selected logins as a map from name to id.
    :vartype logins: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar server_role_results: Map of server role migration results.
    :vartype server_role_results: str
    :ivar orphaned_users_info: List of orphaned users.
    :vartype orphaned_users_info: list[~azure.mgmt.datamigration.models.OrphanedUserInfo]
    :ivar databases: Selected databases as a map from database name to database id.
    :vartype databases: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'status': {'readonly': True},
        'state': {'readonly': True},
        'agent_jobs': {'readonly': True},
        'logins': {'readonly': True},
        'message': {'readonly': True},
        'server_role_results': {'readonly': True},
        'orphaned_users_info': {'readonly': True},
        'databases': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'agent_jobs': {'key': 'agentJobs', 'type': 'str'},
        'logins': {'key': 'logins', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'server_role_results': {'key': 'serverRoleResults', 'type': 'str'},
        'orphaned_users_info': {'key': 'orphanedUsersInfo', 'type': '[OrphanedUserInfo]'},
        'databases': {'key': 'databases', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.status = None
        self.state = None
        self.agent_jobs = None
        self.logins = None
        self.message = None
        self.server_role_results = None
        self.orphaned_users_info = None
        self.databases = None
        self.source_server_version = None
        self.source_server_brand_version = None
        self.target_server_version = None
        self.target_server_brand_version = None
        self.exceptions_and_warnings = None


class MigrateSqlServerSqlMITaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMITaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSqlServerSqlMITaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSqlServerSqlMITaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSqlServerSqlMITaskInput"] = None,
        **kwargs
    ):
        super(MigrateSqlServerSqlMITaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.SqlServer.AzureSqlDbMI'  # type: str
        self.input = input
        self.output = None


class MigrateSsisTaskInput(SqlMigrationTaskInput):
    """Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param ssis_migration_info: Required. SSIS package migration information.
    :type ssis_migration_info: ~azure.mgmt.datamigration.models.SsisMigrationInfo
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'ssis_migration_info': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'ssis_migration_info': {'key': 'ssisMigrationInfo', 'type': 'SsisMigrationInfo'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        ssis_migration_info: "SsisMigrationInfo",
        **kwargs
    ):
        super(MigrateSsisTaskInput, self).__init__(source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs)
        self.ssis_migration_info = ssis_migration_info


class MigrateSsisTaskOutput(msrest.serialization.Model):
    """Output for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MigrateSsisTaskOutputMigrationLevel, MigrateSsisTaskOutputProjectLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
    }

    _subtype_map = {
        'result_type': {'MigrationLevelOutput': 'MigrateSsisTaskOutputMigrationLevel', 'SsisProjectLevelOutput': 'MigrateSsisTaskOutputProjectLevel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSsisTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.result_type = None  # type: Optional[str]


class MigrateSsisTaskOutputMigrationLevel(MigrateSsisTaskOutput):
    """MigrateSsisTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of migration. Possible values include: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar stage: Stage of SSIS migration. Possible values include: "None", "Initialize",
     "InProgress", "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SsisMigrationStage
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'source_server_version': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'target_server_version': {'readonly': True},
        'target_server_brand_version': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
        'stage': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'target_server_version': {'key': 'targetServerVersion', 'type': 'str'},
        'target_server_brand_version': {'key': 'targetServerBrandVersion', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
        'stage': {'key': 'stage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSsisTaskOutputMigrationLevel, self).__init__(**kwargs)
        self.result_type = 'MigrationLevelOutput'  # type: str
        self.started_on = None
        self.ended_on = None
        self.status = None
        self.message = None
        self.source_server_version = None
        self.source_server_brand_version = None
        self.target_server_version = None
        self.target_server_brand_version = None
        self.exceptions_and_warnings = None
        self.stage = None


class MigrateSsisTaskOutputProjectLevel(MigrateSsisTaskOutput):
    """MigrateSsisTaskOutputProjectLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier.
    :vartype id: str
    :param result_type: Required. Result type.Constant filled by server.
    :type result_type: str
    :ivar folder_name: Name of the folder.
    :vartype folder_name: str
    :ivar project_name: Name of the project.
    :vartype project_name: str
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Stage of SSIS migration. Possible values include: "None", "Initialize",
     "InProgress", "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SsisMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'folder_name': {'readonly': True},
        'project_name': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'message': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'folder_name': {'key': 'folderName', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSsisTaskOutputProjectLevel, self).__init__(**kwargs)
        self.result_type = 'SsisProjectLevelOutput'  # type: str
        self.folder_name = None
        self.project_name = None
        self.state = None
        self.stage = None
        self.started_on = None
        self.ended_on = None
        self.message = None
        self.exceptions_and_warnings = None


class MigrateSsisTaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSsisTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSsisTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateSsisTaskInput'},
        'output': {'key': 'output', 'type': '[MigrateSsisTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateSsisTaskInput"] = None,
        **kwargs
    ):
        super(MigrateSsisTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Migrate.Ssis'  # type: str
        self.input = input
        self.output = None


class MigrateSyncCompleteCommandInput(msrest.serialization.Model):
    """Input for command that completes sync migration for a database.

    All required parameters must be populated in order to send to Azure.

    :param database_name: Required. Name of database.
    :type database_name: str
    :param commit_time_stamp: Time stamp to complete.
    :type commit_time_stamp: ~datetime.datetime
    """

    _validation = {
        'database_name': {'required': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'commit_time_stamp': {'key': 'commitTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        database_name: str,
        commit_time_stamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(MigrateSyncCompleteCommandInput, self).__init__(**kwargs)
        self.database_name = database_name
        self.commit_time_stamp = commit_time_stamp


class MigrateSyncCompleteCommandOutput(msrest.serialization.Model):
    """Output for command that completes sync migration for a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar errors: List of errors that happened during the command execution.
    :vartype errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateSyncCompleteCommandOutput, self).__init__(**kwargs)
        self.id = None
        self.errors = None


class MigrateSyncCompleteCommandProperties(CommandProperties):
    """Properties for the command that completes sync migration for a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :param input: Command input.
    :type input: ~azure.mgmt.datamigration.models.MigrateSyncCompleteCommandInput
    :ivar output: Command output. This is ignored if submitted.
    :vartype output: ~azure.mgmt.datamigration.models.MigrateSyncCompleteCommandOutput
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'input': {'key': 'input', 'type': 'MigrateSyncCompleteCommandInput'},
        'output': {'key': 'output', 'type': 'MigrateSyncCompleteCommandOutput'},
    }

    def __init__(
        self,
        *,
        input: Optional["MigrateSyncCompleteCommandInput"] = None,
        **kwargs
    ):
        super(MigrateSyncCompleteCommandProperties, self).__init__(**kwargs)
        self.command_type = 'Migrate.Sync.Complete.Database'  # type: str
        self.input = input
        self.output = None


class MigrationEligibilityInfo(msrest.serialization.Model):
    """Information about migration eligibility of a server object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_eligible_for_migration: Whether object is eligible for migration or not.
    :vartype is_eligible_for_migration: bool
    :ivar validation_messages: Information about eligibility failure for the server object.
    :vartype validation_messages: list[str]
    """

    _validation = {
        'is_eligible_for_migration': {'readonly': True},
        'validation_messages': {'readonly': True},
    }

    _attribute_map = {
        'is_eligible_for_migration': {'key': 'isEligibleForMigration', 'type': 'bool'},
        'validation_messages': {'key': 'validationMessages', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationEligibilityInfo, self).__init__(**kwargs)
        self.is_eligible_for_migration = None
        self.validation_messages = None


class MigrationReportResult(msrest.serialization.Model):
    """Migration validation report result, contains the url for downloading the generated report.

    :param id: Migration validation result identifier.
    :type id: str
    :param report_url: The url of the report.
    :type report_url: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'report_url': {'key': 'reportUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        report_url: Optional[str] = None,
        **kwargs
    ):
        super(MigrationReportResult, self).__init__(**kwargs)
        self.id = id
        self.report_url = report_url


class MigrationTableMetadata(msrest.serialization.Model):
    """Metadata for tables selected in migration project.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_table_name: Source table name.
    :vartype source_table_name: str
    :ivar target_table_name: Target table name.
    :vartype target_table_name: str
    """

    _validation = {
        'source_table_name': {'readonly': True},
        'target_table_name': {'readonly': True},
    }

    _attribute_map = {
        'source_table_name': {'key': 'sourceTableName', 'type': 'str'},
        'target_table_name': {'key': 'targetTableName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationTableMetadata, self).__init__(**kwargs)
        self.source_table_name = None
        self.target_table_name = None


class MigrationValidationDatabaseLevelResult(msrest.serialization.Model):
    """Database level validation results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar target_database_name: Name of the target database.
    :vartype target_database_name: str
    :ivar started_on: Validation start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Validation end time.
    :vartype ended_on: ~datetime.datetime
    :ivar data_integrity_validation_result: Provides data integrity validation result between the
     source and target tables that are migrated.
    :vartype data_integrity_validation_result:
     ~azure.mgmt.datamigration.models.DataIntegrityValidationResult
    :ivar schema_validation_result: Provides schema comparison result between source and target
     database.
    :vartype schema_validation_result:
     ~azure.mgmt.datamigration.models.SchemaComparisonValidationResult
    :ivar query_analysis_validation_result: Results of some of the query execution result between
     source and target database.
    :vartype query_analysis_validation_result:
     ~azure.mgmt.datamigration.models.QueryAnalysisValidationResult
    :ivar status: Current status of validation at the database level. Possible values include:
     "Default", "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues",
     "Stopped", "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'migration_id': {'readonly': True},
        'source_database_name': {'readonly': True},
        'target_database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'data_integrity_validation_result': {'readonly': True},
        'schema_validation_result': {'readonly': True},
        'query_analysis_validation_result': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'migration_id': {'key': 'migrationId', 'type': 'str'},
        'source_database_name': {'key': 'sourceDatabaseName', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'data_integrity_validation_result': {'key': 'dataIntegrityValidationResult', 'type': 'DataIntegrityValidationResult'},
        'schema_validation_result': {'key': 'schemaValidationResult', 'type': 'SchemaComparisonValidationResult'},
        'query_analysis_validation_result': {'key': 'queryAnalysisValidationResult', 'type': 'QueryAnalysisValidationResult'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationValidationDatabaseLevelResult, self).__init__(**kwargs)
        self.id = None
        self.migration_id = None
        self.source_database_name = None
        self.target_database_name = None
        self.started_on = None
        self.ended_on = None
        self.data_integrity_validation_result = None
        self.schema_validation_result = None
        self.query_analysis_validation_result = None
        self.status = None


class MigrationValidationDatabaseSummaryResult(msrest.serialization.Model):
    """Migration Validation Database level summary result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar target_database_name: Name of the target database.
    :vartype target_database_name: str
    :ivar started_on: Validation start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Validation end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of validation at the database level. Possible values include:
     "Default", "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues",
     "Stopped", "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'migration_id': {'readonly': True},
        'source_database_name': {'readonly': True},
        'target_database_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'migration_id': {'key': 'migrationId', 'type': 'str'},
        'source_database_name': {'key': 'sourceDatabaseName', 'type': 'str'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationValidationDatabaseSummaryResult, self).__init__(**kwargs)
        self.id = None
        self.migration_id = None
        self.source_database_name = None
        self.target_database_name = None
        self.started_on = None
        self.ended_on = None
        self.status = None


class MigrationValidationOptions(msrest.serialization.Model):
    """Types of validations to run after the migration.

    :param enable_schema_validation: Allows to compare the schema information between source and
     target.
    :type enable_schema_validation: bool
    :param enable_data_integrity_validation: Allows to perform a checksum based data integrity
     validation between source and target for the selected database / tables .
    :type enable_data_integrity_validation: bool
    :param enable_query_analysis_validation: Allows to perform a quick and intelligent query
     analysis by retrieving queries from the source database and executes them in the target. The
     result will have execution statistics for executions in source and target databases for the
     extracted queries.
    :type enable_query_analysis_validation: bool
    """

    _attribute_map = {
        'enable_schema_validation': {'key': 'enableSchemaValidation', 'type': 'bool'},
        'enable_data_integrity_validation': {'key': 'enableDataIntegrityValidation', 'type': 'bool'},
        'enable_query_analysis_validation': {'key': 'enableQueryAnalysisValidation', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enable_schema_validation: Optional[bool] = None,
        enable_data_integrity_validation: Optional[bool] = None,
        enable_query_analysis_validation: Optional[bool] = None,
        **kwargs
    ):
        super(MigrationValidationOptions, self).__init__(**kwargs)
        self.enable_schema_validation = enable_schema_validation
        self.enable_data_integrity_validation = enable_data_integrity_validation
        self.enable_query_analysis_validation = enable_query_analysis_validation


class MigrationValidationResult(msrest.serialization.Model):
    """Migration Validation Result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Migration validation result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :param summary_results: Validation summary results for each database.
    :type summary_results: dict[str,
     ~azure.mgmt.datamigration.models.MigrationValidationDatabaseSummaryResult]
    :ivar status: Current status of validation at the migration level. Status from the database
     validation result status will be aggregated here. Possible values include: "Default",
     "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped",
     "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'migration_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'migration_id': {'key': 'migrationId', 'type': 'str'},
        'summary_results': {'key': 'summaryResults', 'type': '{MigrationValidationDatabaseSummaryResult}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        summary_results: Optional[Dict[str, "MigrationValidationDatabaseSummaryResult"]] = None,
        **kwargs
    ):
        super(MigrationValidationResult, self).__init__(**kwargs)
        self.id = None
        self.migration_id = None
        self.summary_results = summary_results
        self.status = None


class MiSqlConnectionInfo(ConnectionInfo):
    """Properties required to create a connection to Azure SQL database Managed instance.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param managed_instance_resource_id: Required. Resource id for Azure SQL database Managed
     instance.
    :type managed_instance_resource_id: str
    """

    _validation = {
        'type': {'required': True},
        'managed_instance_resource_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'managed_instance_resource_id': {'key': 'managedInstanceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        managed_instance_resource_id: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(MiSqlConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'MiSqlConnectionInfo'  # type: str
        self.managed_instance_resource_id = managed_instance_resource_id


class MongoDbCancelCommand(CommandProperties):
    """Properties for the command that cancels a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :param input: Command input.
    :type input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'input': {'key': 'input', 'type': 'MongoDbCommandInput'},
    }

    def __init__(
        self,
        *,
        input: Optional["MongoDbCommandInput"] = None,
        **kwargs
    ):
        super(MongoDbCancelCommand, self).__init__(**kwargs)
        self.command_type = 'cancel'  # type: str
        self.input = input


class MongoDbClusterInfo(msrest.serialization.Model):
    """Describes a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param databases: Required. A list of non-system databases in the cluster.
    :type databases: list[~azure.mgmt.datamigration.models.MongoDbDatabaseInfo]
    :param supports_sharding: Required. Whether the cluster supports sharded collections.
    :type supports_sharding: bool
    :param type: Required. The type of data source. Possible values include: "BlobContainer",
     "CosmosDb", "MongoDb".
    :type type: str or ~azure.mgmt.datamigration.models.MongoDbClusterType
    :param version: Required. The version of the data source in the form x.y.z (e.g. 3.6.7). Not
     used if Type is BlobContainer.
    :type version: str
    """

    _validation = {
        'databases': {'required': True},
        'supports_sharding': {'required': True},
        'type': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'databases': {'key': 'databases', 'type': '[MongoDbDatabaseInfo]'},
        'supports_sharding': {'key': 'supportsSharding', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databases: List["MongoDbDatabaseInfo"],
        supports_sharding: bool,
        type: Union[str, "MongoDbClusterType"],
        version: str,
        **kwargs
    ):
        super(MongoDbClusterInfo, self).__init__(**kwargs)
        self.databases = databases
        self.supports_sharding = supports_sharding
        self.type = type
        self.version = version


class MongoDbObjectInfo(msrest.serialization.Model):
    """Describes a database or collection within a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param average_document_size: Required. The average document size, or -1 if the average size is
     unknown.
    :type average_document_size: long
    :param data_size: Required. The estimated total data size, in bytes, or -1 if the size is
     unknown.
    :type data_size: long
    :param document_count: Required. The estimated total number of documents, or -1 if the document
     count is unknown.
    :type document_count: long
    :param name: Required. The unqualified name of the database or collection.
    :type name: str
    :param qualified_name: Required. The qualified name of the database or collection. For a
     collection, this is the database-qualified name.
    :type qualified_name: str
    """

    _validation = {
        'average_document_size': {'required': True},
        'data_size': {'required': True},
        'document_count': {'required': True},
        'name': {'required': True},
        'qualified_name': {'required': True},
    }

    _attribute_map = {
        'average_document_size': {'key': 'averageDocumentSize', 'type': 'long'},
        'data_size': {'key': 'dataSize', 'type': 'long'},
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        **kwargs
    ):
        super(MongoDbObjectInfo, self).__init__(**kwargs)
        self.average_document_size = average_document_size
        self.data_size = data_size
        self.document_count = document_count
        self.name = name
        self.qualified_name = qualified_name


class MongoDbCollectionInfo(MongoDbObjectInfo):
    """Describes a supported collection within a MongoDB database.

    All required parameters must be populated in order to send to Azure.

    :param average_document_size: Required. The average document size, or -1 if the average size is
     unknown.
    :type average_document_size: long
    :param data_size: Required. The estimated total data size, in bytes, or -1 if the size is
     unknown.
    :type data_size: long
    :param document_count: Required. The estimated total number of documents, or -1 if the document
     count is unknown.
    :type document_count: long
    :param name: Required. The unqualified name of the database or collection.
    :type name: str
    :param qualified_name: Required. The qualified name of the database or collection. For a
     collection, this is the database-qualified name.
    :type qualified_name: str
    :param database_name: Required. The name of the database containing the collection.
    :type database_name: str
    :param is_capped: Required. Whether the collection is a capped collection (i.e. whether it has
     a fixed size and acts like a circular buffer).
    :type is_capped: bool
    :param is_system_collection: Required. Whether the collection is system collection.
    :type is_system_collection: bool
    :param is_view: Required. Whether the collection is a view of another collection.
    :type is_view: bool
    :param shard_key: The shard key on the collection, or null if the collection is not sharded.
    :type shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeyInfo
    :param supports_sharding: Required. Whether the database has sharding enabled. Note that the
     migration task will enable sharding on the target if necessary.
    :type supports_sharding: bool
    :param view_of: The name of the collection that this is a view of, if IsView is true.
    :type view_of: str
    """

    _validation = {
        'average_document_size': {'required': True},
        'data_size': {'required': True},
        'document_count': {'required': True},
        'name': {'required': True},
        'qualified_name': {'required': True},
        'database_name': {'required': True},
        'is_capped': {'required': True},
        'is_system_collection': {'required': True},
        'is_view': {'required': True},
        'supports_sharding': {'required': True},
    }

    _attribute_map = {
        'average_document_size': {'key': 'averageDocumentSize', 'type': 'long'},
        'data_size': {'key': 'dataSize', 'type': 'long'},
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'is_capped': {'key': 'isCapped', 'type': 'bool'},
        'is_system_collection': {'key': 'isSystemCollection', 'type': 'bool'},
        'is_view': {'key': 'isView', 'type': 'bool'},
        'shard_key': {'key': 'shardKey', 'type': 'MongoDbShardKeyInfo'},
        'supports_sharding': {'key': 'supportsSharding', 'type': 'bool'},
        'view_of': {'key': 'viewOf', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        database_name: str,
        is_capped: bool,
        is_system_collection: bool,
        is_view: bool,
        supports_sharding: bool,
        shard_key: Optional["MongoDbShardKeyInfo"] = None,
        view_of: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbCollectionInfo, self).__init__(average_document_size=average_document_size, data_size=data_size, document_count=document_count, name=name, qualified_name=qualified_name, **kwargs)
        self.database_name = database_name
        self.is_capped = is_capped
        self.is_system_collection = is_system_collection
        self.is_view = is_view
        self.shard_key = shard_key
        self.supports_sharding = supports_sharding
        self.view_of = view_of


class MongoDbProgress(msrest.serialization.Model):
    """Base class for MongoDB migration outputs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MongoDbCollectionProgress, MongoDbDatabaseProgress, MongoDbMigrationProgress.

    All required parameters must be populated in order to send to Azure.

    :param bytes_copied: Required. The number of document bytes copied during the Copying stage.
    :type bytes_copied: long
    :param documents_copied: Required. The number of documents copied during the Copying stage.
    :type documents_copied: long
    :param elapsed_time: Required. The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e.
     TimeSpan format).
    :type elapsed_time: str
    :param errors: Required. The errors and warnings that have occurred for the current object. The
     keys are the error codes.
    :type errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :param events_pending: Required. The number of oplog events awaiting replay.
    :type events_pending: long
    :param events_replayed: Required. The number of oplog events replayed so far.
    :type events_replayed: long
    :param last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :type last_event_time: ~datetime.datetime
    :param last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :type last_replay_time: ~datetime.datetime
    :param name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :type name: str
    :param qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :type qualified_name: str
    :param result_type: Required. The type of progress object.Constant filled by server.  Possible
     values include: "Migration", "Database", "Collection".
    :type result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :param state: Required.  Possible values include: "NotStarted", "ValidatingInput",
     "Initializing", "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing",
     "Complete", "Canceled", "Failed".
    :type state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :param total_bytes: Required. The total number of document bytes on the source at the beginning
     of the Copying stage, or -1 if the total size was unknown.
    :type total_bytes: long
    :param total_documents: Required. The total number of documents on the source at the beginning
     of the Copying stage, or -1 if the total count was unknown.
    :type total_documents: long
    """

    _validation = {
        'bytes_copied': {'required': True},
        'documents_copied': {'required': True},
        'elapsed_time': {'required': True},
        'errors': {'required': True},
        'events_pending': {'required': True},
        'events_replayed': {'required': True},
        'result_type': {'required': True},
        'state': {'required': True},
        'total_bytes': {'required': True},
        'total_documents': {'required': True},
    }

    _attribute_map = {
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'documents_copied': {'key': 'documentsCopied', 'type': 'long'},
        'elapsed_time': {'key': 'elapsedTime', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '{MongoDbError}'},
        'events_pending': {'key': 'eventsPending', 'type': 'long'},
        'events_replayed': {'key': 'eventsReplayed', 'type': 'long'},
        'last_event_time': {'key': 'lastEventTime', 'type': 'iso-8601'},
        'last_replay_time': {'key': 'lastReplayTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
        'total_documents': {'key': 'totalDocuments', 'type': 'long'},
    }

    _subtype_map = {
        'result_type': {'Collection': 'MongoDbCollectionProgress', 'Database': 'MongoDbDatabaseProgress', 'Migration': 'MongoDbMigrationProgress'}
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbProgress, self).__init__(**kwargs)
        self.bytes_copied = bytes_copied
        self.documents_copied = documents_copied
        self.elapsed_time = elapsed_time
        self.errors = errors
        self.events_pending = events_pending
        self.events_replayed = events_replayed
        self.last_event_time = last_event_time
        self.last_replay_time = last_replay_time
        self.name = name
        self.qualified_name = qualified_name
        self.result_type = None  # type: Optional[str]
        self.state = state
        self.total_bytes = total_bytes
        self.total_documents = total_documents


class MongoDbCollectionProgress(MongoDbProgress):
    """Describes the progress of a collection.

    All required parameters must be populated in order to send to Azure.

    :param bytes_copied: Required. The number of document bytes copied during the Copying stage.
    :type bytes_copied: long
    :param documents_copied: Required. The number of documents copied during the Copying stage.
    :type documents_copied: long
    :param elapsed_time: Required. The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e.
     TimeSpan format).
    :type elapsed_time: str
    :param errors: Required. The errors and warnings that have occurred for the current object. The
     keys are the error codes.
    :type errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :param events_pending: Required. The number of oplog events awaiting replay.
    :type events_pending: long
    :param events_replayed: Required. The number of oplog events replayed so far.
    :type events_replayed: long
    :param last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :type last_event_time: ~datetime.datetime
    :param last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :type last_replay_time: ~datetime.datetime
    :param name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :type name: str
    :param qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :type qualified_name: str
    :param result_type: Required. The type of progress object.Constant filled by server.  Possible
     values include: "Migration", "Database", "Collection".
    :type result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :param state: Required.  Possible values include: "NotStarted", "ValidatingInput",
     "Initializing", "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing",
     "Complete", "Canceled", "Failed".
    :type state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :param total_bytes: Required. The total number of document bytes on the source at the beginning
     of the Copying stage, or -1 if the total size was unknown.
    :type total_bytes: long
    :param total_documents: Required. The total number of documents on the source at the beginning
     of the Copying stage, or -1 if the total count was unknown.
    :type total_documents: long
    """

    _validation = {
        'bytes_copied': {'required': True},
        'documents_copied': {'required': True},
        'elapsed_time': {'required': True},
        'errors': {'required': True},
        'events_pending': {'required': True},
        'events_replayed': {'required': True},
        'result_type': {'required': True},
        'state': {'required': True},
        'total_bytes': {'required': True},
        'total_documents': {'required': True},
    }

    _attribute_map = {
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'documents_copied': {'key': 'documentsCopied', 'type': 'long'},
        'elapsed_time': {'key': 'elapsedTime', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '{MongoDbError}'},
        'events_pending': {'key': 'eventsPending', 'type': 'long'},
        'events_replayed': {'key': 'eventsReplayed', 'type': 'long'},
        'last_event_time': {'key': 'lastEventTime', 'type': 'iso-8601'},
        'last_replay_time': {'key': 'lastReplayTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
        'total_documents': {'key': 'totalDocuments', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbCollectionProgress, self).__init__(bytes_copied=bytes_copied, documents_copied=documents_copied, elapsed_time=elapsed_time, errors=errors, events_pending=events_pending, events_replayed=events_replayed, last_event_time=last_event_time, last_replay_time=last_replay_time, name=name, qualified_name=qualified_name, state=state, total_bytes=total_bytes, total_documents=total_documents, **kwargs)
        self.result_type = 'Collection'  # type: str


class MongoDbCollectionSettings(msrest.serialization.Model):
    """Describes how an individual MongoDB collection should be migrated.

    :param can_delete: Whether the migrator is allowed to drop the target collection in the course
     of performing a migration. The default is true.
    :type can_delete: bool
    :param shard_key: Describes a MongoDB shard key.
    :type shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeySetting
    :param target_r_us: The RUs that should be configured on a CosmosDB target, or null to use the
     default. This has no effect on non-CosmosDB targets.
    :type target_r_us: int
    """

    _attribute_map = {
        'can_delete': {'key': 'canDelete', 'type': 'bool'},
        'shard_key': {'key': 'shardKey', 'type': 'MongoDbShardKeySetting'},
        'target_r_us': {'key': 'targetRUs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        shard_key: Optional["MongoDbShardKeySetting"] = None,
        target_r_us: Optional[int] = None,
        **kwargs
    ):
        super(MongoDbCollectionSettings, self).__init__(**kwargs)
        self.can_delete = can_delete
        self.shard_key = shard_key
        self.target_r_us = target_r_us


class MongoDbCommandInput(msrest.serialization.Model):
    """Describes the input to the 'cancel' and 'restart' MongoDB migration commands.

    :param object_name: The qualified name of a database or collection to act upon, or null to act
     upon the entire migration.
    :type object_name: str
    """

    _attribute_map = {
        'object_name': {'key': 'objectName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_name: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbCommandInput, self).__init__(**kwargs)
        self.object_name = object_name


class MongoDbConnectionInfo(ConnectionInfo):
    """Describes a connection to a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param connection_string: Required. A MongoDB connection string or blob container URL. The user
     name and password can be specified here or in the userName and password properties.
    :type connection_string: str
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'MongoDbConnectionInfo'  # type: str
        self.connection_string = connection_string


class MongoDbDatabaseInfo(MongoDbObjectInfo):
    """Describes a database within a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param average_document_size: Required. The average document size, or -1 if the average size is
     unknown.
    :type average_document_size: long
    :param data_size: Required. The estimated total data size, in bytes, or -1 if the size is
     unknown.
    :type data_size: long
    :param document_count: Required. The estimated total number of documents, or -1 if the document
     count is unknown.
    :type document_count: long
    :param name: Required. The unqualified name of the database or collection.
    :type name: str
    :param qualified_name: Required. The qualified name of the database or collection. For a
     collection, this is the database-qualified name.
    :type qualified_name: str
    :param collections: Required. A list of supported collections in a MongoDB database.
    :type collections: list[~azure.mgmt.datamigration.models.MongoDbCollectionInfo]
    :param supports_sharding: Required. Whether the database has sharding enabled. Note that the
     migration task will enable sharding on the target if necessary.
    :type supports_sharding: bool
    """

    _validation = {
        'average_document_size': {'required': True},
        'data_size': {'required': True},
        'document_count': {'required': True},
        'name': {'required': True},
        'qualified_name': {'required': True},
        'collections': {'required': True},
        'supports_sharding': {'required': True},
    }

    _attribute_map = {
        'average_document_size': {'key': 'averageDocumentSize', 'type': 'long'},
        'data_size': {'key': 'dataSize', 'type': 'long'},
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'collections': {'key': 'collections', 'type': '[MongoDbCollectionInfo]'},
        'supports_sharding': {'key': 'supportsSharding', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        collections: List["MongoDbCollectionInfo"],
        supports_sharding: bool,
        **kwargs
    ):
        super(MongoDbDatabaseInfo, self).__init__(average_document_size=average_document_size, data_size=data_size, document_count=document_count, name=name, qualified_name=qualified_name, **kwargs)
        self.collections = collections
        self.supports_sharding = supports_sharding


class MongoDbDatabaseProgress(MongoDbProgress):
    """Describes the progress of a database.

    All required parameters must be populated in order to send to Azure.

    :param bytes_copied: Required. The number of document bytes copied during the Copying stage.
    :type bytes_copied: long
    :param documents_copied: Required. The number of documents copied during the Copying stage.
    :type documents_copied: long
    :param elapsed_time: Required. The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e.
     TimeSpan format).
    :type elapsed_time: str
    :param errors: Required. The errors and warnings that have occurred for the current object. The
     keys are the error codes.
    :type errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :param events_pending: Required. The number of oplog events awaiting replay.
    :type events_pending: long
    :param events_replayed: Required. The number of oplog events replayed so far.
    :type events_replayed: long
    :param last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :type last_event_time: ~datetime.datetime
    :param last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :type last_replay_time: ~datetime.datetime
    :param name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :type name: str
    :param qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :type qualified_name: str
    :param result_type: Required. The type of progress object.Constant filled by server.  Possible
     values include: "Migration", "Database", "Collection".
    :type result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :param state: Required.  Possible values include: "NotStarted", "ValidatingInput",
     "Initializing", "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing",
     "Complete", "Canceled", "Failed".
    :type state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :param total_bytes: Required. The total number of document bytes on the source at the beginning
     of the Copying stage, or -1 if the total size was unknown.
    :type total_bytes: long
    :param total_documents: Required. The total number of documents on the source at the beginning
     of the Copying stage, or -1 if the total count was unknown.
    :type total_documents: long
    :param collections: The progress of the collections in the database. The keys are the
     unqualified names of the collections.
    :type collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionProgress]
    """

    _validation = {
        'bytes_copied': {'required': True},
        'documents_copied': {'required': True},
        'elapsed_time': {'required': True},
        'errors': {'required': True},
        'events_pending': {'required': True},
        'events_replayed': {'required': True},
        'result_type': {'required': True},
        'state': {'required': True},
        'total_bytes': {'required': True},
        'total_documents': {'required': True},
    }

    _attribute_map = {
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'documents_copied': {'key': 'documentsCopied', 'type': 'long'},
        'elapsed_time': {'key': 'elapsedTime', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '{MongoDbError}'},
        'events_pending': {'key': 'eventsPending', 'type': 'long'},
        'events_replayed': {'key': 'eventsReplayed', 'type': 'long'},
        'last_event_time': {'key': 'lastEventTime', 'type': 'iso-8601'},
        'last_replay_time': {'key': 'lastReplayTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
        'total_documents': {'key': 'totalDocuments', 'type': 'long'},
        'collections': {'key': 'collections', 'type': '{MongoDbCollectionProgress}'},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        collections: Optional[Dict[str, "MongoDbCollectionProgress"]] = None,
        **kwargs
    ):
        super(MongoDbDatabaseProgress, self).__init__(bytes_copied=bytes_copied, documents_copied=documents_copied, elapsed_time=elapsed_time, errors=errors, events_pending=events_pending, events_replayed=events_replayed, last_event_time=last_event_time, last_replay_time=last_replay_time, name=name, qualified_name=qualified_name, state=state, total_bytes=total_bytes, total_documents=total_documents, **kwargs)
        self.result_type = 'Database'  # type: str
        self.collections = collections


class MongoDbDatabaseSettings(msrest.serialization.Model):
    """Describes how an individual MongoDB database should be migrated.

    All required parameters must be populated in order to send to Azure.

    :param collections: Required. The collections on the source database to migrate to the target.
     The keys are the unqualified names of the collections.
    :type collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionSettings]
    :param target_r_us: The RUs that should be configured on a CosmosDB target, or null to use the
     default, or 0 if throughput should not be provisioned for the database. This has no effect on
     non-CosmosDB targets.
    :type target_r_us: int
    """

    _validation = {
        'collections': {'required': True},
    }

    _attribute_map = {
        'collections': {'key': 'collections', 'type': '{MongoDbCollectionSettings}'},
        'target_r_us': {'key': 'targetRUs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        collections: Dict[str, "MongoDbCollectionSettings"],
        target_r_us: Optional[int] = None,
        **kwargs
    ):
        super(MongoDbDatabaseSettings, self).__init__(**kwargs)
        self.collections = collections
        self.target_r_us = target_r_us


class MongoDbError(msrest.serialization.Model):
    """Describes an error or warning that occurred during a MongoDB migration.

    :param code: The non-localized, machine-readable code that describes the error or warning.
    :type code: str
    :param count: The number of times the error or warning has occurred.
    :type count: int
    :param message: The localized, human-readable message that describes the error or warning.
    :type message: str
    :param type: The type of error or warning. Possible values include: "Error", "ValidationError",
     "Warning".
    :type type: str or ~azure.mgmt.datamigration.models.MongoDbErrorType
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        count: Optional[int] = None,
        message: Optional[str] = None,
        type: Optional[Union[str, "MongoDbErrorType"]] = None,
        **kwargs
    ):
        super(MongoDbError, self).__init__(**kwargs)
        self.code = code
        self.count = count
        self.message = message
        self.type = type


class MongoDbFinishCommand(CommandProperties):
    """Properties for the command that finishes a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :param input: Command input.
    :type input: ~azure.mgmt.datamigration.models.MongoDbFinishCommandInput
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'input': {'key': 'input', 'type': 'MongoDbFinishCommandInput'},
    }

    def __init__(
        self,
        *,
        input: Optional["MongoDbFinishCommandInput"] = None,
        **kwargs
    ):
        super(MongoDbFinishCommand, self).__init__(**kwargs)
        self.command_type = 'finish'  # type: str
        self.input = input


class MongoDbFinishCommandInput(MongoDbCommandInput):
    """Describes the input to the 'finish' MongoDB migration command.

    All required parameters must be populated in order to send to Azure.

    :param object_name: The qualified name of a database or collection to act upon, or null to act
     upon the entire migration.
    :type object_name: str
    :param immediate: Required. If true, replication for the affected objects will be stopped
     immediately. If false, the migrator will finish replaying queued events before finishing the
     replication.
    :type immediate: bool
    """

    _validation = {
        'immediate': {'required': True},
    }

    _attribute_map = {
        'object_name': {'key': 'objectName', 'type': 'str'},
        'immediate': {'key': 'immediate', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        immediate: bool,
        object_name: Optional[str] = None,
        **kwargs
    ):
        super(MongoDbFinishCommandInput, self).__init__(object_name=object_name, **kwargs)
        self.immediate = immediate


class MongoDbMigrationProgress(MongoDbProgress):
    """Describes the progress of the overall migration.

    All required parameters must be populated in order to send to Azure.

    :param bytes_copied: Required. The number of document bytes copied during the Copying stage.
    :type bytes_copied: long
    :param documents_copied: Required. The number of documents copied during the Copying stage.
    :type documents_copied: long
    :param elapsed_time: Required. The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e.
     TimeSpan format).
    :type elapsed_time: str
    :param errors: Required. The errors and warnings that have occurred for the current object. The
     keys are the error codes.
    :type errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :param events_pending: Required. The number of oplog events awaiting replay.
    :type events_pending: long
    :param events_replayed: Required. The number of oplog events replayed so far.
    :type events_replayed: long
    :param last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :type last_event_time: ~datetime.datetime
    :param last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :type last_replay_time: ~datetime.datetime
    :param name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :type name: str
    :param qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :type qualified_name: str
    :param result_type: Required. The type of progress object.Constant filled by server.  Possible
     values include: "Migration", "Database", "Collection".
    :type result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :param state: Required.  Possible values include: "NotStarted", "ValidatingInput",
     "Initializing", "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing",
     "Complete", "Canceled", "Failed".
    :type state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :param total_bytes: Required. The total number of document bytes on the source at the beginning
     of the Copying stage, or -1 if the total size was unknown.
    :type total_bytes: long
    :param total_documents: Required. The total number of documents on the source at the beginning
     of the Copying stage, or -1 if the total count was unknown.
    :type total_documents: long
    :param databases: The progress of the databases in the migration. The keys are the names of the
     databases.
    :type databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseProgress]
    """

    _validation = {
        'bytes_copied': {'required': True},
        'documents_copied': {'required': True},
        'elapsed_time': {'required': True},
        'errors': {'required': True},
        'events_pending': {'required': True},
        'events_replayed': {'required': True},
        'result_type': {'required': True},
        'state': {'required': True},
        'total_bytes': {'required': True},
        'total_documents': {'required': True},
    }

    _attribute_map = {
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'documents_copied': {'key': 'documentsCopied', 'type': 'long'},
        'elapsed_time': {'key': 'elapsedTime', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '{MongoDbError}'},
        'events_pending': {'key': 'eventsPending', 'type': 'long'},
        'events_replayed': {'key': 'eventsReplayed', 'type': 'long'},
        'last_event_time': {'key': 'lastEventTime', 'type': 'iso-8601'},
        'last_replay_time': {'key': 'lastReplayTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
        'total_documents': {'key': 'totalDocuments', 'type': 'long'},
        'databases': {'key': 'databases', 'type': '{MongoDbDatabaseProgress}'},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        databases: Optional[Dict[str, "MongoDbDatabaseProgress"]] = None,
        **kwargs
    ):
        super(MongoDbMigrationProgress, self).__init__(bytes_copied=bytes_copied, documents_copied=documents_copied, elapsed_time=elapsed_time, errors=errors, events_pending=events_pending, events_replayed=events_replayed, last_event_time=last_event_time, last_replay_time=last_replay_time, name=name, qualified_name=qualified_name, state=state, total_bytes=total_bytes, total_documents=total_documents, **kwargs)
        self.result_type = 'Migration'  # type: str
        self.databases = databases


class MongoDbMigrationSettings(msrest.serialization.Model):
    """Describes how a MongoDB data migration should be performed.

    All required parameters must be populated in order to send to Azure.

    :param boost_r_us: The RU limit on a CosmosDB target that collections will be temporarily
     increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0
     to use the default boost (which is generally the maximum), or null to not boost the RUs. This
     setting has no effect on non-CosmosDB targets.
    :type boost_r_us: int
    :param databases: Required. The databases on the source cluster to migrate to the target. The
     keys are the names of the databases.
    :type databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseSettings]
    :param replication: Describes how changes will be replicated from the source to the target. The
     default is OneTime. Possible values include: "Disabled", "OneTime", "Continuous".
    :type replication: str or ~azure.mgmt.datamigration.models.MongoDbReplication
    :param source: Required. Settings used to connect to the source cluster.
    :type source: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :param target: Required. Settings used to connect to the target cluster.
    :type target: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :param throttling: Settings used to limit the resource usage of the migration.
    :type throttling: ~azure.mgmt.datamigration.models.MongoDbThrottlingSettings
    """

    _validation = {
        'databases': {'required': True},
        'source': {'required': True},
        'target': {'required': True},
    }

    _attribute_map = {
        'boost_r_us': {'key': 'boostRUs', 'type': 'int'},
        'databases': {'key': 'databases', 'type': '{MongoDbDatabaseSettings}'},
        'replication': {'key': 'replication', 'type': 'str'},
        'source': {'key': 'source', 'type': 'MongoDbConnectionInfo'},
        'target': {'key': 'target', 'type': 'MongoDbConnectionInfo'},
        'throttling': {'key': 'throttling', 'type': 'MongoDbThrottlingSettings'},
    }

    def __init__(
        self,
        *,
        databases: Dict[str, "MongoDbDatabaseSettings"],
        source: "MongoDbConnectionInfo",
        target: "MongoDbConnectionInfo",
        boost_r_us: Optional[int] = None,
        replication: Optional[Union[str, "MongoDbReplication"]] = None,
        throttling: Optional["MongoDbThrottlingSettings"] = None,
        **kwargs
    ):
        super(MongoDbMigrationSettings, self).__init__(**kwargs)
        self.boost_r_us = boost_r_us
        self.databases = databases
        self.replication = replication
        self.source = source
        self.target = target
        self.throttling = throttling


class MongoDbRestartCommand(CommandProperties):
    """Properties for the command that restarts a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param command_type: Required. Command type.Constant filled by server.
    :type command_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Possible values include:
     "Unknown", "Accepted", "Running", "Succeeded", "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :param input: Command input.
    :type input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
    """

    _validation = {
        'command_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'command_type': {'key': 'commandType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'input': {'key': 'input', 'type': 'MongoDbCommandInput'},
    }

    def __init__(
        self,
        *,
        input: Optional["MongoDbCommandInput"] = None,
        **kwargs
    ):
        super(MongoDbRestartCommand, self).__init__(**kwargs)
        self.command_type = 'restart'  # type: str
        self.input = input


class MongoDbShardKeyField(msrest.serialization.Model):
    """Describes a field reference within a MongoDB shard key.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the field.
    :type name: str
    :param order: Required. The field ordering. Possible values include: "Forward", "Reverse",
     "Hashed".
    :type order: str or ~azure.mgmt.datamigration.models.MongoDbShardKeyOrder
    """

    _validation = {
        'name': {'required': True},
        'order': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        order: Union[str, "MongoDbShardKeyOrder"],
        **kwargs
    ):
        super(MongoDbShardKeyField, self).__init__(**kwargs)
        self.name = name
        self.order = order


class MongoDbShardKeyInfo(msrest.serialization.Model):
    """Describes a MongoDB shard key.

    All required parameters must be populated in order to send to Azure.

    :param fields: Required. The fields within the shard key.
    :type fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
    :param is_unique: Required. Whether the shard key is unique.
    :type is_unique: bool
    """

    _validation = {
        'fields': {'required': True},
        'is_unique': {'required': True},
    }

    _attribute_map = {
        'fields': {'key': 'fields', 'type': '[MongoDbShardKeyField]'},
        'is_unique': {'key': 'isUnique', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        fields: List["MongoDbShardKeyField"],
        is_unique: bool,
        **kwargs
    ):
        super(MongoDbShardKeyInfo, self).__init__(**kwargs)
        self.fields = fields
        self.is_unique = is_unique


class MongoDbShardKeySetting(msrest.serialization.Model):
    """Describes a MongoDB shard key.

    All required parameters must be populated in order to send to Azure.

    :param fields: Required. The fields within the shard key.
    :type fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
    :param is_unique: Required. Whether the shard key is unique.
    :type is_unique: bool
    """

    _validation = {
        'fields': {'required': True},
        'is_unique': {'required': True},
    }

    _attribute_map = {
        'fields': {'key': 'fields', 'type': '[MongoDbShardKeyField]'},
        'is_unique': {'key': 'isUnique', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        fields: List["MongoDbShardKeyField"],
        is_unique: bool,
        **kwargs
    ):
        super(MongoDbShardKeySetting, self).__init__(**kwargs)
        self.fields = fields
        self.is_unique = is_unique


class MongoDbThrottlingSettings(msrest.serialization.Model):
    """Specifies resource limits for the migration.

    :param min_free_cpu: The percentage of CPU time that the migrator will try to avoid using, from
     0 to 100.
    :type min_free_cpu: int
    :param min_free_memory_mb: The number of megabytes of RAM that the migrator will try to avoid
     using.
    :type min_free_memory_mb: int
    :param max_parallelism: The maximum number of work items (e.g. collection copies) that will be
     processed in parallel.
    :type max_parallelism: int
    """

    _attribute_map = {
        'min_free_cpu': {'key': 'minFreeCpu', 'type': 'int'},
        'min_free_memory_mb': {'key': 'minFreeMemoryMb', 'type': 'int'},
        'max_parallelism': {'key': 'maxParallelism', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_free_cpu: Optional[int] = None,
        min_free_memory_mb: Optional[int] = None,
        max_parallelism: Optional[int] = None,
        **kwargs
    ):
        super(MongoDbThrottlingSettings, self).__init__(**kwargs)
        self.min_free_cpu = min_free_cpu
        self.min_free_memory_mb = min_free_memory_mb
        self.max_parallelism = max_parallelism


class MySqlConnectionInfo(ConnectionInfo):
    """Information for connecting to MySQL server.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param server_name: Required. Name of the server.
    :type server_name: str
    :param port: Required. Port for Server.
    :type port: int
    """

    _validation = {
        'type': {'required': True},
        'server_name': {'required': True},
        'port': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        server_name: str,
        port: int,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(MySqlConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'MySqlConnectionInfo'  # type: str
        self.server_name = server_name
        self.port = port


class NameAvailabilityRequest(msrest.serialization.Model):
    """A resource type and proposed name.

    :param name: The proposed resource name.
    :type name: str
    :param type: The resource type chain (e.g. virtualMachines/extensions).
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class NameAvailabilityResponse(msrest.serialization.Model):
    """Indicates whether a proposed resource name is available.

    :param name_available: If true, the name is valid and available. If false, 'reason' describes
     why not.
    :type name_available: bool
    :param reason: The reason why the name is not available, if nameAvailable is false. Possible
     values include: "AlreadyExists", "Invalid".
    :type reason: str or ~azure.mgmt.datamigration.models.NameCheckFailureReason
    :param message: The localized reason why the name is not available, if nameAvailable is false.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "NameCheckFailureReason"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailabilityResponse, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NonSqlDataMigrationTable(msrest.serialization.Model):
    """Defines metadata for table to be migrated.

    :param source_name: Source table name.
    :type source_name: str
    """

    _attribute_map = {
        'source_name': {'key': 'sourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_name: Optional[str] = None,
        **kwargs
    ):
        super(NonSqlDataMigrationTable, self).__init__(**kwargs)
        self.source_name = source_name


class NonSqlDataMigrationTableResult(msrest.serialization.Model):
    """Object used to report the data migration results of a table.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result_code: Result code of the data migration. Possible values include: "Initial",
     "Completed", "ObjectNotExistsInSource", "ObjectNotExistsInTarget",
     "TargetObjectIsInaccessible", "FatalError".
    :vartype result_code: str or ~azure.mgmt.datamigration.models.DataMigrationResultCode
    :ivar source_name: Name of the source table.
    :vartype source_name: str
    :ivar target_name: Name of the target table.
    :vartype target_name: str
    :ivar source_row_count: Number of rows in the source table.
    :vartype source_row_count: long
    :ivar target_row_count: Number of rows in the target table.
    :vartype target_row_count: long
    :ivar elapsed_time_in_miliseconds: Time taken to migrate the data.
    :vartype elapsed_time_in_miliseconds: float
    :ivar errors: List of errors, if any, during migration.
    :vartype errors: list[~azure.mgmt.datamigration.models.DataMigrationError]
    """

    _validation = {
        'result_code': {'readonly': True},
        'source_name': {'readonly': True},
        'target_name': {'readonly': True},
        'source_row_count': {'readonly': True},
        'target_row_count': {'readonly': True},
        'elapsed_time_in_miliseconds': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'result_code': {'key': 'resultCode', 'type': 'str'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'target_name': {'key': 'targetName', 'type': 'str'},
        'source_row_count': {'key': 'sourceRowCount', 'type': 'long'},
        'target_row_count': {'key': 'targetRowCount', 'type': 'long'},
        'elapsed_time_in_miliseconds': {'key': 'elapsedTimeInMiliseconds', 'type': 'float'},
        'errors': {'key': 'errors', 'type': '[DataMigrationError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NonSqlDataMigrationTableResult, self).__init__(**kwargs)
        self.result_code = None
        self.source_name = None
        self.target_name = None
        self.source_row_count = None
        self.target_row_count = None
        self.elapsed_time_in_miliseconds = None
        self.errors = None


class NonSqlMigrationTaskInput(msrest.serialization.Model):
    """Base class for non sql migration task input.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_database_name: Required. Target database name.
    :type target_database_name: str
    :param project_name: Required. Name of the migration project.
    :type project_name: str
    :param project_location: Required. A URL that points to the drop location to access project
     artifacts.
    :type project_location: str
    :param selected_tables: Required. Metadata of the tables selected for migration.
    :type selected_tables: list[~azure.mgmt.datamigration.models.NonSqlDataMigrationTable]
    """

    _validation = {
        'target_connection_info': {'required': True},
        'target_database_name': {'required': True},
        'project_name': {'required': True},
        'project_location': {'required': True},
        'selected_tables': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'project_location': {'key': 'projectLocation', 'type': 'str'},
        'selected_tables': {'key': 'selectedTables', 'type': '[NonSqlDataMigrationTable]'},
    }

    def __init__(
        self,
        *,
        target_connection_info: "SqlConnectionInfo",
        target_database_name: str,
        project_name: str,
        project_location: str,
        selected_tables: List["NonSqlDataMigrationTable"],
        **kwargs
    ):
        super(NonSqlMigrationTaskInput, self).__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.target_database_name = target_database_name
        self.project_name = project_name
        self.project_location = project_location
        self.selected_tables = selected_tables


class NonSqlMigrationTaskOutput(msrest.serialization.Model):
    """Base class for non sql migration task output.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current state of migration. Possible values include: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar data_migration_table_results: Results of the migration. The key contains the table name
     and the value the table result object.
    :vartype data_migration_table_results: str
    :ivar progress_message: Message about the progress of the migration.
    :vartype progress_message: str
    :ivar source_server_name: Name of source server.
    :vartype source_server_name: str
    :ivar target_server_name: Name of target server.
    :vartype target_server_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'status': {'readonly': True},
        'data_migration_table_results': {'readonly': True},
        'progress_message': {'readonly': True},
        'source_server_name': {'readonly': True},
        'target_server_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'data_migration_table_results': {'key': 'dataMigrationTableResults', 'type': 'str'},
        'progress_message': {'key': 'progressMessage', 'type': 'str'},
        'source_server_name': {'key': 'sourceServerName', 'type': 'str'},
        'target_server_name': {'key': 'targetServerName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NonSqlMigrationTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.started_on = None
        self.ended_on = None
        self.status = None
        self.data_migration_table_results = None
        self.progress_message = None
        self.source_server_name = None
        self.target_server_name = None


class ODataError(msrest.serialization.Model):
    """Error information in OData format.

    :param code: The machine-readable description of the error, such as 'InvalidRequest' or
     'InternalServerError'.
    :type code: str
    :param message: The human-readable description of the error.
    :type message: str
    :param details: Inner errors that caused this error.
    :type details: list[~azure.mgmt.datamigration.models.ODataError]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ODataError]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ODataError"]] = None,
        **kwargs
    ):
        super(ODataError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class OracleConnectionInfo(ConnectionInfo):
    """Information for connecting to Oracle server.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param data_source: Required. EZConnect or TNSName connection string.
    :type data_source: str
    """

    _validation = {
        'type': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_source: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(OracleConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'OracleConnectionInfo'  # type: str
        self.data_source = data_source


class OracleOCIDriverInfo(msrest.serialization.Model):
    """Information about an Oracle OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar driver_name: The name of the driver package.
    :vartype driver_name: str
    :ivar driver_size: The size in bytes of the driver package.
    :vartype driver_size: str
    :ivar archive_checksum: The MD5 Base64 encoded checksum for the driver package.
    :vartype archive_checksum: str
    :ivar oracle_checksum: The checksum for the driver package provided by Oracle.
    :vartype oracle_checksum: str
    :ivar assembly_version: Version listed in the OCI assembly 'oci.dll'.
    :vartype assembly_version: str
    :ivar supported_oracle_versions: List of Oracle database versions supported by this driver.
     Only major minor of the version is listed.
    :vartype supported_oracle_versions: list[str]
    """

    _validation = {
        'driver_name': {'readonly': True},
        'driver_size': {'readonly': True},
        'archive_checksum': {'readonly': True},
        'oracle_checksum': {'readonly': True},
        'assembly_version': {'readonly': True},
        'supported_oracle_versions': {'readonly': True},
    }

    _attribute_map = {
        'driver_name': {'key': 'driverName', 'type': 'str'},
        'driver_size': {'key': 'driverSize', 'type': 'str'},
        'archive_checksum': {'key': 'archiveChecksum', 'type': 'str'},
        'oracle_checksum': {'key': 'oracleChecksum', 'type': 'str'},
        'assembly_version': {'key': 'assemblyVersion', 'type': 'str'},
        'supported_oracle_versions': {'key': 'supportedOracleVersions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleOCIDriverInfo, self).__init__(**kwargs)
        self.driver_name = None
        self.driver_size = None
        self.archive_checksum = None
        self.oracle_checksum = None
        self.assembly_version = None
        self.supported_oracle_versions = None


class OrphanedUserInfo(msrest.serialization.Model):
    """Information of orphaned users on the SQL server database.

    :param name: Name of the orphaned user.
    :type name: str
    :param database_name: Parent database of the user.
    :type database_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        database_name: Optional[str] = None,
        **kwargs
    ):
        super(OrphanedUserInfo, self).__init__(**kwargs)
        self.name = name
        self.database_name = database_name


class PostgreSqlConnectionInfo(ConnectionInfo):
    """Information for connecting to PostgreSQL server.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param server_name: Required. Name of the server.
    :type server_name: str
    :param database_name: Name of the database.
    :type database_name: str
    :param port: Required. Port for Server.
    :type port: int
    :param encrypt_connection: Whether to encrypt the connection.
    :type encrypt_connection: bool
    :param trust_server_certificate: Whether to trust the server certificate.
    :type trust_server_certificate: bool
    """

    _validation = {
        'type': {'required': True},
        'server_name': {'required': True},
        'port': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'encrypt_connection': {'key': 'encryptConnection', 'type': 'bool'},
        'trust_server_certificate': {'key': 'trustServerCertificate', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        server_name: str,
        port: int,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        database_name: Optional[str] = None,
        encrypt_connection: Optional[bool] = True,
        trust_server_certificate: Optional[bool] = False,
        **kwargs
    ):
        super(PostgreSqlConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'PostgreSqlConnectionInfo'  # type: str
        self.server_name = server_name
        self.database_name = database_name
        self.port = port
        self.encrypt_connection = encrypt_connection
        self.trust_server_certificate = trust_server_certificate


class Project(TrackedResource):
    """A project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. Resource location.
    :type location: str
    :param source_platform: Source platform for the project. Possible values include: "SQL",
     "MySQL", "PostgreSql", "MongoDb", "Unknown".
    :type source_platform: str or ~azure.mgmt.datamigration.models.ProjectSourcePlatform
    :param target_platform: Target platform for the project. Possible values include: "SQLDB",
     "SQLMI", "AzureDbForMySql", "AzureDbForPostgreSql", "MongoDb", "Unknown".
    :type target_platform: str or ~azure.mgmt.datamigration.models.ProjectTargetPlatform
    :ivar creation_time: UTC Date and time when project was created.
    :vartype creation_time: ~datetime.datetime
    :param source_connection_info: Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
    :param target_connection_info: Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
    :param databases_info: List of DatabaseInfo.
    :type databases_info: list[~azure.mgmt.datamigration.models.DatabaseInfo]
    :ivar provisioning_state: The project's provisioning state. Possible values include:
     "Deleting", "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProjectProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'source_platform': {'key': 'properties.sourcePlatform', 'type': 'str'},
        'target_platform': {'key': 'properties.targetPlatform', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'source_connection_info': {'key': 'properties.sourceConnectionInfo', 'type': 'ConnectionInfo'},
        'target_connection_info': {'key': 'properties.targetConnectionInfo', 'type': 'ConnectionInfo'},
        'databases_info': {'key': 'properties.databasesInfo', 'type': '[DatabaseInfo]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source_platform: Optional[Union[str, "ProjectSourcePlatform"]] = None,
        target_platform: Optional[Union[str, "ProjectTargetPlatform"]] = None,
        source_connection_info: Optional["ConnectionInfo"] = None,
        target_connection_info: Optional["ConnectionInfo"] = None,
        databases_info: Optional[List["DatabaseInfo"]] = None,
        **kwargs
    ):
        super(Project, self).__init__(tags=tags, location=location, **kwargs)
        self.source_platform = source_platform
        self.target_platform = target_platform
        self.creation_time = None
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.databases_info = databases_info
        self.provisioning_state = None


class ProjectFile(Resource):
    """A file resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param etag: HTTP strong entity tag value. This is ignored if submitted.
    :type etag: str
    :param properties: Custom file properties.
    :type properties: ~azure.mgmt.datamigration.models.ProjectFileProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProjectFileProperties'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        properties: Optional["ProjectFileProperties"] = None,
        **kwargs
    ):
        super(ProjectFile, self).__init__(**kwargs)
        self.etag = etag
        self.properties = properties


class ProjectFileProperties(msrest.serialization.Model):
    """Base class for file properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param extension: Optional File extension. If submitted it should not have a leading period and
     must match the extension from filePath.
    :type extension: str
    :param file_path: Relative path of this file resource. This property can be set when creating
     or updating the file resource.
    :type file_path: str
    :ivar last_modified: Modification DateTime.
    :vartype last_modified: ~datetime.datetime
    :param media_type: File content type. This property can be modified to reflect the file content
     type.
    :type media_type: str
    :ivar size: File size.
    :vartype size: long
    """

    _validation = {
        'last_modified': {'readonly': True},
        'size': {'readonly': True},
    }

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        file_path: Optional[str] = None,
        media_type: Optional[str] = None,
        **kwargs
    ):
        super(ProjectFileProperties, self).__init__(**kwargs)
        self.extension = extension
        self.file_path = file_path
        self.last_modified = None
        self.media_type = media_type
        self.size = None


class ProjectList(msrest.serialization.Model):
    """OData page of project resources.

    :param value: List of projects.
    :type value: list[~azure.mgmt.datamigration.models.Project]
    :param next_link: URL to load the next page of projects.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Project]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Project"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProjectList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProjectTask(Resource):
    """A task resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param etag: HTTP strong entity tag value. This is ignored if submitted.
    :type etag: str
    :param properties: Custom task properties.
    :type properties: ~azure.mgmt.datamigration.models.ProjectTaskProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProjectTaskProperties'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        properties: Optional["ProjectTaskProperties"] = None,
        **kwargs
    ):
        super(ProjectTask, self).__init__(**kwargs)
        self.etag = etag
        self.properties = properties


class QueryAnalysisValidationResult(msrest.serialization.Model):
    """Results for query analysis comparison between the source and target.

    :param query_results: List of queries executed and it's execution results in source and target.
    :type query_results: ~azure.mgmt.datamigration.models.QueryExecutionResult
    :param validation_errors: Errors that are part of the execution.
    :type validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    """

    _attribute_map = {
        'query_results': {'key': 'queryResults', 'type': 'QueryExecutionResult'},
        'validation_errors': {'key': 'validationErrors', 'type': 'ValidationError'},
    }

    def __init__(
        self,
        *,
        query_results: Optional["QueryExecutionResult"] = None,
        validation_errors: Optional["ValidationError"] = None,
        **kwargs
    ):
        super(QueryAnalysisValidationResult, self).__init__(**kwargs)
        self.query_results = query_results
        self.validation_errors = validation_errors


class QueryExecutionResult(msrest.serialization.Model):
    """Describes query analysis results for execution in source and target.

    :param query_text: Query text retrieved from the source server.
    :type query_text: str
    :param statements_in_batch: Total no. of statements in the batch.
    :type statements_in_batch: long
    :param source_result: Query analysis result from the source.
    :type source_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
    :param target_result: Query analysis result from the target.
    :type target_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
    """

    _attribute_map = {
        'query_text': {'key': 'queryText', 'type': 'str'},
        'statements_in_batch': {'key': 'statementsInBatch', 'type': 'long'},
        'source_result': {'key': 'sourceResult', 'type': 'ExecutionStatistics'},
        'target_result': {'key': 'targetResult', 'type': 'ExecutionStatistics'},
    }

    def __init__(
        self,
        *,
        query_text: Optional[str] = None,
        statements_in_batch: Optional[int] = None,
        source_result: Optional["ExecutionStatistics"] = None,
        target_result: Optional["ExecutionStatistics"] = None,
        **kwargs
    ):
        super(QueryExecutionResult, self).__init__(**kwargs)
        self.query_text = query_text
        self.statements_in_batch = statements_in_batch
        self.source_result = source_result
        self.target_result = target_result


class Quota(msrest.serialization.Model):
    """Describes a quota for or usage details about a resource.

    :param current_value: The current value of the quota. If null or missing, the current value
     cannot be determined in the context of the request.
    :type current_value: float
    :param id: The resource ID of the quota object.
    :type id: str
    :param limit: The maximum value of the quota. If null or missing, the quota has no maximum, in
     which case it merely tracks usage.
    :type limit: float
    :param name: The name of the quota.
    :type name: ~azure.mgmt.datamigration.models.QuotaName
    :param unit: The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
    :type unit: str
    """

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'id': {'key': 'id', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'float'},
        'name': {'key': 'name', 'type': 'QuotaName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        current_value: Optional[float] = None,
        id: Optional[str] = None,
        limit: Optional[float] = None,
        name: Optional["QuotaName"] = None,
        unit: Optional[str] = None,
        **kwargs
    ):
        super(Quota, self).__init__(**kwargs)
        self.current_value = current_value
        self.id = id
        self.limit = limit
        self.name = name
        self.unit = unit


class QuotaList(msrest.serialization.Model):
    """OData page of quota objects.

    :param value: List of quotas.
    :type value: list[~azure.mgmt.datamigration.models.Quota]
    :param next_link: URL to load the next page of quotas, or null or missing if this is the last
     page.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Quota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Quota"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(QuotaList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaName(msrest.serialization.Model):
    """The name of the quota.

    :param localized_value: The localized name of the quota.
    :type localized_value: str
    :param value: The unlocalized name (or ID) of the quota.
    :type value: str
    """

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        localized_value: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(QuotaName, self).__init__(**kwargs)
        self.localized_value = localized_value
        self.value = value


class ReportableException(msrest.serialization.Model):
    """Exception object for all custom exceptions.

    :param message: Error message.
    :type message: str
    :param actionable_message: Actionable steps for this exception.
    :type actionable_message: str
    :param file_path: The path to the file where exception occurred.
    :type file_path: str
    :param line_number: The line number where exception occurred.
    :type line_number: str
    :param h_result: Coded numerical value that is assigned to a specific exception.
    :type h_result: int
    :param stack_trace: Stack trace.
    :type stack_trace: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'actionable_message': {'key': 'actionableMessage', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'line_number': {'key': 'lineNumber', 'type': 'str'},
        'h_result': {'key': 'hResult', 'type': 'int'},
        'stack_trace': {'key': 'stackTrace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        actionable_message: Optional[str] = None,
        file_path: Optional[str] = None,
        line_number: Optional[str] = None,
        h_result: Optional[int] = None,
        stack_trace: Optional[str] = None,
        **kwargs
    ):
        super(ReportableException, self).__init__(**kwargs)
        self.message = message
        self.actionable_message = actionable_message
        self.file_path = file_path
        self.line_number = line_number
        self.h_result = h_result
        self.stack_trace = stack_trace


class ResourceSku(msrest.serialization.Model):
    """Describes an available DMS SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of DMS in a scale set.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Not used.
    :vartype capacity: ~azure.mgmt.datamigration.models.ResourceSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~azure.mgmt.datamigration.models.ResourceSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~azure.mgmt.datamigration.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.datamigration.models.ResourceSkuRestrictions]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'size': {'readonly': True},
        'family': {'readonly': True},
        'kind': {'readonly': True},
        'capacity': {'readonly': True},
        'locations': {'readonly': True},
        'api_versions': {'readonly': True},
        'costs': {'readonly': True},
        'capabilities': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ResourceSkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'costs': {'key': 'costs', 'type': '[ResourceSkuCosts]'},
        'capabilities': {'key': 'capabilities', 'type': '[ResourceSkuCapabilities]'},
        'restrictions': {'key': 'restrictions', 'type': '[ResourceSkuRestrictions]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.size = None
        self.family = None
        self.kind = None
        self.capacity = None
        self.locations = None
        self.api_versions = None
        self.costs = None
        self.capabilities = None
        self.restrictions = None


class ResourceSkuCapabilities(msrest.serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCapabilities, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ResourceSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: long
    :ivar maximum: The maximum capacity.
    :vartype maximum: long
    :ivar default: The default capacity.
    :vartype default: long
    :ivar scale_type: The scale type applicable to the SKU. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.datamigration.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class ResourceSkuCosts(msrest.serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: long
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'quantity': {'readonly': True},
        'extended_unit': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterID', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'long'},
        'extended_unit': {'key': 'extendedUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCosts, self).__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None


class ResourceSkuRestrictions(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Possible values include: "location".
    :vartype type: str or ~azure.mgmt.datamigration.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason code for restriction. Possible values include: "QuotaId",
     "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.datamigration.models.ResourceSkuRestrictionsReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
        'reason_code': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuRestrictions, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = None


class ResourceSkusResult(msrest.serialization.Model):
    """The DMS List SKUs operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of SKUs available for the subscription.
    :type value: list[~azure.mgmt.datamigration.models.ResourceSku]
    :param next_link: The uri to fetch the next page of DMS SKUs. Call ListNext() with this to
     fetch the next page of DMS SKUs.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceSku"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SchemaComparisonValidationResult(msrest.serialization.Model):
    """Results for schema comparison between the source and target.

    :param schema_differences: List of schema differences between the source and target databases.
    :type schema_differences: ~azure.mgmt.datamigration.models.SchemaComparisonValidationResultType
    :param validation_errors: List of errors that happened while performing schema compare
     validation.
    :type validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    :param source_database_object_count: Count of source database objects.
    :type source_database_object_count: dict[str, long]
    :param target_database_object_count: Count of target database objects.
    :type target_database_object_count: dict[str, long]
    """

    _attribute_map = {
        'schema_differences': {'key': 'schemaDifferences', 'type': 'SchemaComparisonValidationResultType'},
        'validation_errors': {'key': 'validationErrors', 'type': 'ValidationError'},
        'source_database_object_count': {'key': 'sourceDatabaseObjectCount', 'type': '{long}'},
        'target_database_object_count': {'key': 'targetDatabaseObjectCount', 'type': '{long}'},
    }

    def __init__(
        self,
        *,
        schema_differences: Optional["SchemaComparisonValidationResultType"] = None,
        validation_errors: Optional["ValidationError"] = None,
        source_database_object_count: Optional[Dict[str, int]] = None,
        target_database_object_count: Optional[Dict[str, int]] = None,
        **kwargs
    ):
        super(SchemaComparisonValidationResult, self).__init__(**kwargs)
        self.schema_differences = schema_differences
        self.validation_errors = validation_errors
        self.source_database_object_count = source_database_object_count
        self.target_database_object_count = target_database_object_count


class SchemaComparisonValidationResultType(msrest.serialization.Model):
    """Description about the errors happen while performing migration validation.

    :param object_name: Name of the object that has the difference.
    :type object_name: str
    :param object_type: Type of the object that has the difference. e.g
     (Table/View/StoredProcedure). Possible values include: "StoredProcedures", "Table", "User",
     "View", "Function".
    :type object_type: str or ~azure.mgmt.datamigration.models.ObjectType
    :param update_action: Update action type with respect to target. Possible values include:
     "DeletedOnTarget", "ChangedOnTarget", "AddedOnTarget".
    :type update_action: str or ~azure.mgmt.datamigration.models.UpdateActionType
    """

    _attribute_map = {
        'object_name': {'key': 'objectName', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'update_action': {'key': 'updateAction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_name: Optional[str] = None,
        object_type: Optional[Union[str, "ObjectType"]] = None,
        update_action: Optional[Union[str, "UpdateActionType"]] = None,
        **kwargs
    ):
        super(SchemaComparisonValidationResultType, self).__init__(**kwargs)
        self.object_name = object_name
        self.object_type = object_type
        self.update_action = update_action


class SchemaMigrationSetting(msrest.serialization.Model):
    """Settings for migrating schema from source to target.

    :param schema_option: Option on how to migrate the schema. Possible values include: "None",
     "ExtractFromSource", "UseStorageFile".
    :type schema_option: str or ~azure.mgmt.datamigration.models.SchemaMigrationOption
    :param file_id: Resource Identifier of a file resource containing the uploaded schema file.
    :type file_id: str
    """

    _attribute_map = {
        'schema_option': {'key': 'schemaOption', 'type': 'str'},
        'file_id': {'key': 'fileId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema_option: Optional[Union[str, "SchemaMigrationOption"]] = None,
        file_id: Optional[str] = None,
        **kwargs
    ):
        super(SchemaMigrationSetting, self).__init__(**kwargs)
        self.schema_option = schema_option
        self.file_id = file_id


class SelectedCertificateInput(msrest.serialization.Model):
    """Info for certificate to be exported for TDE enabled databases.

    All required parameters must be populated in order to send to Azure.

    :param certificate_name: Required. Name of certificate to be exported.
    :type certificate_name: str
    :param password: Required. Password to use for encrypting the exported certificate.
    :type password: str
    """

    _validation = {
        'certificate_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'certificate_name': {'key': 'certificateName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_name: str,
        password: str,
        **kwargs
    ):
        super(SelectedCertificateInput, self).__init__(**kwargs)
        self.certificate_name = certificate_name
        self.password = password


class ServerProperties(msrest.serialization.Model):
    """Server properties for MySQL type source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar server_platform: Name of the server platform.
    :vartype server_platform: str
    :ivar server_name: Name of the server.
    :vartype server_name: str
    :ivar server_version: Version of the database server.
    :vartype server_version: str
    :ivar server_edition: Edition of the database server.
    :vartype server_edition: str
    :ivar server_operating_system_version: Version of the operating system.
    :vartype server_operating_system_version: str
    :ivar server_database_count: Number of databases in the server.
    :vartype server_database_count: int
    """

    _validation = {
        'server_platform': {'readonly': True},
        'server_name': {'readonly': True},
        'server_version': {'readonly': True},
        'server_edition': {'readonly': True},
        'server_operating_system_version': {'readonly': True},
        'server_database_count': {'readonly': True},
    }

    _attribute_map = {
        'server_platform': {'key': 'serverPlatform', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'server_edition': {'key': 'serverEdition', 'type': 'str'},
        'server_operating_system_version': {'key': 'serverOperatingSystemVersion', 'type': 'str'},
        'server_database_count': {'key': 'serverDatabaseCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerProperties, self).__init__(**kwargs)
        self.server_platform = None
        self.server_name = None
        self.server_version = None
        self.server_edition = None
        self.server_operating_system_version = None
        self.server_database_count = None


class ServiceOperation(msrest.serialization.Model):
    """Description of an action supported by the Database Migration Service.

    :param name: The fully qualified action name, e.g. Microsoft.DataMigration/services/read.
    :type name: str
    :param display: Localized display text.
    :type display: ~azure.mgmt.datamigration.models.ServiceOperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ServiceOperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["ServiceOperationDisplay"] = None,
        **kwargs
    ):
        super(ServiceOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class ServiceOperationDisplay(msrest.serialization.Model):
    """Localized display text.

    :param provider: The localized resource provider name.
    :type provider: str
    :param resource: The localized resource type name.
    :type resource: str
    :param operation: The localized operation name.
    :type operation: str
    :param description: The localized operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ServiceOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ServiceOperationList(msrest.serialization.Model):
    """OData page of action (operation) objects.

    :param value: List of actions.
    :type value: list[~azure.mgmt.datamigration.models.ServiceOperation]
    :param next_link: URL to load the next page of actions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServiceOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServiceOperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSku(msrest.serialization.Model):
    """An Azure SKU instance.

    :param name: The unique name of the SKU, such as 'P3'.
    :type name: str
    :param tier: The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'.
    :type tier: str
    :param family: The SKU family, used when the service has multiple performance classes within a
     tier, such as 'A', 'D', etc. for virtual machines.
    :type family: str
    :param size: The size of the SKU, used when the name alone does not denote a service size or
     when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines.
    :type size: str
    :param capacity: The capacity of the SKU, if it supports scaling.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ServiceSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family
        self.size = size
        self.capacity = capacity


class ServiceSkuList(msrest.serialization.Model):
    """OData page of available SKUs.

    :param value: List of service SKUs.
    :type value: list[~azure.mgmt.datamigration.models.AvailableServiceSku]
    :param next_link: URL to load the next page of service SKUs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableServiceSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AvailableServiceSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServiceSkuList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlConnectionInfo(ConnectionInfo):
    """Information for connecting to SQL database server.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of connection info.Constant filled by server.
    :type type: str
    :param user_name: User name.
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param data_source: Required. Data source in the format
     Protocol:MachineName\SQLServerInstanceName,PortNumber.
    :type data_source: str
    :param authentication: Authentication type to use for connection. Possible values include:
     "None", "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated",
     "ActiveDirectoryPassword".
    :type authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    :param encrypt_connection: Whether to encrypt the connection.
    :type encrypt_connection: bool
    :param additional_settings: Additional connection settings.
    :type additional_settings: str
    :param trust_server_certificate: Whether to trust the server certificate.
    :type trust_server_certificate: bool
    :param platform: Server platform type for connection. Possible values include: "SqlOnPrem".
    :type platform: str or ~azure.mgmt.datamigration.models.SqlSourcePlatform
    """

    _validation = {
        'type': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'str'},
        'encrypt_connection': {'key': 'encryptConnection', 'type': 'bool'},
        'additional_settings': {'key': 'additionalSettings', 'type': 'str'},
        'trust_server_certificate': {'key': 'trustServerCertificate', 'type': 'bool'},
        'platform': {'key': 'platform', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_source: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        authentication: Optional[Union[str, "AuthenticationType"]] = None,
        encrypt_connection: Optional[bool] = True,
        additional_settings: Optional[str] = None,
        trust_server_certificate: Optional[bool] = False,
        platform: Optional[Union[str, "SqlSourcePlatform"]] = None,
        **kwargs
    ):
        super(SqlConnectionInfo, self).__init__(user_name=user_name, password=password, **kwargs)
        self.type = 'SqlConnectionInfo'  # type: str
        self.data_source = data_source
        self.authentication = authentication
        self.encrypt_connection = encrypt_connection
        self.additional_settings = additional_settings
        self.trust_server_certificate = trust_server_certificate
        self.platform = platform


class SsisMigrationInfo(msrest.serialization.Model):
    """SSIS migration info with SSIS store type, overwrite policy.

    :param ssis_store_type: The SSIS store type of source, only SSIS catalog is supported now in
     DMS. Possible values include: "SsisCatalog".
    :type ssis_store_type: str or ~azure.mgmt.datamigration.models.SsisStoreType
    :param project_overwrite_option: The overwrite option for the SSIS project migration. Possible
     values include: "Ignore", "Overwrite".
    :type project_overwrite_option: str or
     ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
    :param environment_overwrite_option: The overwrite option for the SSIS environment migration.
     Possible values include: "Ignore", "Overwrite".
    :type environment_overwrite_option: str or
     ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
    """

    _attribute_map = {
        'ssis_store_type': {'key': 'ssisStoreType', 'type': 'str'},
        'project_overwrite_option': {'key': 'projectOverwriteOption', 'type': 'str'},
        'environment_overwrite_option': {'key': 'environmentOverwriteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ssis_store_type: Optional[Union[str, "SsisStoreType"]] = None,
        project_overwrite_option: Optional[Union[str, "SsisMigrationOverwriteOption"]] = None,
        environment_overwrite_option: Optional[Union[str, "SsisMigrationOverwriteOption"]] = None,
        **kwargs
    ):
        super(SsisMigrationInfo, self).__init__(**kwargs)
        self.ssis_store_type = ssis_store_type
        self.project_overwrite_option = project_overwrite_option
        self.environment_overwrite_option = environment_overwrite_option


class StartMigrationScenarioServerRoleResult(msrest.serialization.Model):
    """Server role migration result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of server role.
    :vartype name: str
    :ivar state: Current state of migration. Possible values include: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'name': {'readonly': True},
        'state': {'readonly': True},
        'exceptions_and_warnings': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'exceptions_and_warnings': {'key': 'exceptionsAndWarnings', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StartMigrationScenarioServerRoleResult, self).__init__(**kwargs)
        self.name = None
        self.state = None
        self.exceptions_and_warnings = None


class SyncMigrationDatabaseErrorEvent(msrest.serialization.Model):
    """Database migration errors for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_string: String value of timestamp.
    :vartype timestamp_string: str
    :ivar event_type_string: Event type.
    :vartype event_type_string: str
    :ivar event_text: Event text.
    :vartype event_text: str
    """

    _validation = {
        'timestamp_string': {'readonly': True},
        'event_type_string': {'readonly': True},
        'event_text': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_string': {'key': 'timestampString', 'type': 'str'},
        'event_type_string': {'key': 'eventTypeString', 'type': 'str'},
        'event_text': {'key': 'eventText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncMigrationDatabaseErrorEvent, self).__init__(**kwargs)
        self.timestamp_string = None
        self.event_type_string = None
        self.event_text = None


class TaskList(msrest.serialization.Model):
    """OData page of tasks.

    :param value: List of tasks.
    :type value: list[~azure.mgmt.datamigration.models.ProjectTask]
    :param next_link: URL to load the next page of tasks.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProjectTask]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProjectTask"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(TaskList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UploadOCIDriverTaskInput(msrest.serialization.Model):
    """Input for the service task to upload an OCI driver.

    :param driver_share: File share information for the OCI driver archive.
    :type driver_share: ~azure.mgmt.datamigration.models.FileShare
    """

    _attribute_map = {
        'driver_share': {'key': 'driverShare', 'type': 'FileShare'},
    }

    def __init__(
        self,
        *,
        driver_share: Optional["FileShare"] = None,
        **kwargs
    ):
        super(UploadOCIDriverTaskInput, self).__init__(**kwargs)
        self.driver_share = driver_share


class UploadOCIDriverTaskOutput(msrest.serialization.Model):
    """Output for the service task to upload an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar driver_package_name: The name of the driver package that was validated and uploaded.
    :vartype driver_package_name: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'driver_package_name': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'driver_package_name': {'key': 'driverPackageName', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UploadOCIDriverTaskOutput, self).__init__(**kwargs)
        self.driver_package_name = None
        self.validation_errors = None


class UploadOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that uploads an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Input for the service task to upload an OCI driver.
    :type input: ~azure.mgmt.datamigration.models.UploadOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.UploadOCIDriverTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'UploadOCIDriverTaskInput'},
        'output': {'key': 'output', 'type': '[UploadOCIDriverTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["UploadOCIDriverTaskInput"] = None,
        **kwargs
    ):
        super(UploadOCIDriverTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Service.Upload.OCI'  # type: str
        self.input = input
        self.output = None


class ValidateMigrationInputSqlServerSqlDbSyncTaskProperties(ProjectTaskProperties):
    """Properties for task that validates migration input for SQL to Azure SQL DB sync migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ValidateSyncMigrationInputSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateSyncMigrationInputSqlServerTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ValidateSyncMigrationInputSqlServerTaskInput'},
        'output': {'key': 'output', 'type': '[ValidateSyncMigrationInputSqlServerTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ValidateSyncMigrationInputSqlServerTaskInput"] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlDbSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ValidateMigrationInput.SqlServer.SqlDb.Sync'  # type: str
        self.input = input
        self.output = None


class ValidateMigrationInputSqlServerSqlMISyncTaskInput(SqlServerSqlMISyncTaskInput):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.

    All required parameters must be populated in order to send to Azure.

    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :param backup_file_share: Backup file share information for all selected databases.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param storage_resource_id: Required. Fully qualified resourceId of storage.
    :type storage_resource_id: str
    :param source_connection_info: Required. Connection information for source SQL Server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Connection information for Azure SQL Database Managed
     Instance.
    :type target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :param azure_app: Required. Azure Active Directory Application the DMS instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account.
    :type azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        'selected_databases': {'required': True},
        'storage_resource_id': {'required': True},
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'azure_app': {'required': True},
    }

    _attribute_map = {
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlMIDatabaseInput]'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'storage_resource_id': {'key': 'storageResourceId', 'type': 'str'},
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'MiSqlConnectionInfo'},
        'azure_app': {'key': 'azureApp', 'type': 'AzureActiveDirectoryApp'},
    }

    def __init__(
        self,
        *,
        selected_databases: List["MigrateSqlServerSqlMIDatabaseInput"],
        storage_resource_id: str,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "MiSqlConnectionInfo",
        azure_app: "AzureActiveDirectoryApp",
        backup_file_share: Optional["FileShare"] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMISyncTaskInput, self).__init__(selected_databases=selected_databases, backup_file_share=backup_file_share, storage_resource_id=storage_resource_id, source_connection_info=source_connection_info, target_connection_info=target_connection_info, azure_app=azure_app, **kwargs)


class ValidateMigrationInputSqlServerSqlMISyncTaskOutput(msrest.serialization.Model):
    """Output for task that validates migration input for Azure SQL Database Managed Instance online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Database identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMISyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.validation_errors = None


class ValidateMigrationInputSqlServerSqlMISyncTaskProperties(ProjectTaskProperties):
    """Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance sync scenario.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ValidateMigrationInputSqlServerSqlMISyncTaskInput'},
        'output': {'key': 'output', 'type': '[ValidateMigrationInputSqlServerSqlMISyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ValidateMigrationInputSqlServerSqlMISyncTaskInput"] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMISyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS'  # type: str
        self.input = input
        self.output = None


class ValidateMigrationInputSqlServerSqlMITaskInput(msrest.serialization.Model):
    """Input for task that validates migration input for SQL to Azure SQL Managed Instance.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :param selected_logins: Logins to migrate.
    :type selected_logins: list[str]
    :param backup_file_share: Backup file share information for all selected databases.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param backup_blob_share: Required. SAS URI of Azure Storage Account Container to be used for
     storing backup files.
    :type backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
    :param backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
     Possible values include: "CreateBackup", "ExistingBackup".
    :type backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
        'backup_blob_share': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlMIDatabaseInput]'},
        'selected_logins': {'key': 'selectedLogins', 'type': '[str]'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'backup_blob_share': {'key': 'backupBlobShare', 'type': 'BlobShare'},
        'backup_mode': {'key': 'backupMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSqlServerSqlMIDatabaseInput"],
        backup_blob_share: "BlobShare",
        selected_logins: Optional[List[str]] = None,
        backup_file_share: Optional["FileShare"] = None,
        backup_mode: Optional[Union[str, "BackupMode"]] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMITaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases
        self.selected_logins = selected_logins
        self.backup_file_share = backup_file_share
        self.backup_blob_share = backup_blob_share
        self.backup_mode = backup_mode


class ValidateMigrationInputSqlServerSqlMITaskOutput(msrest.serialization.Model):
    """Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar restore_database_name_errors: Errors associated with the RestoreDatabaseName.
    :vartype restore_database_name_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_folder_errors: Errors associated with the BackupFolder path.
    :vartype backup_folder_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_share_credentials_errors: Errors associated with backup share user name and
     password credentials.
    :vartype backup_share_credentials_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_storage_account_errors: Errors associated with the storage account provided.
    :vartype backup_storage_account_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar existing_backup_errors: Errors associated with existing backup files.
    :vartype existing_backup_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :param database_backup_info: Information about backup files when existing backup mode is used.
    :type database_backup_info: ~azure.mgmt.datamigration.models.DatabaseBackupInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'restore_database_name_errors': {'readonly': True},
        'backup_folder_errors': {'readonly': True},
        'backup_share_credentials_errors': {'readonly': True},
        'backup_storage_account_errors': {'readonly': True},
        'existing_backup_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'restore_database_name_errors': {'key': 'restoreDatabaseNameErrors', 'type': '[ReportableException]'},
        'backup_folder_errors': {'key': 'backupFolderErrors', 'type': '[ReportableException]'},
        'backup_share_credentials_errors': {'key': 'backupShareCredentialsErrors', 'type': '[ReportableException]'},
        'backup_storage_account_errors': {'key': 'backupStorageAccountErrors', 'type': '[ReportableException]'},
        'existing_backup_errors': {'key': 'existingBackupErrors', 'type': '[ReportableException]'},
        'database_backup_info': {'key': 'databaseBackupInfo', 'type': 'DatabaseBackupInfo'},
    }

    def __init__(
        self,
        *,
        database_backup_info: Optional["DatabaseBackupInfo"] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMITaskOutput, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.restore_database_name_errors = None
        self.backup_folder_errors = None
        self.backup_share_credentials_errors = None
        self.backup_storage_account_errors = None
        self.existing_backup_errors = None
        self.database_backup_info = database_backup_info


class ValidateMigrationInputSqlServerSqlMITaskProperties(ProjectTaskProperties):
    """Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Task input.
    :type input: ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'ValidateMigrationInputSqlServerSqlMITaskInput'},
        'output': {'key': 'output', 'type': '[ValidateMigrationInputSqlServerSqlMITaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["ValidateMigrationInputSqlServerSqlMITaskInput"] = None,
        **kwargs
    ):
        super(ValidateMigrationInputSqlServerSqlMITaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'  # type: str
        self.input = input
        self.output = None


class ValidateMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates a migration between MongoDB data sources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Describes how a MongoDB data migration should be performed.
    :type input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
    :ivar output: An array containing a single MongoDbMigrationProgress object.
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbMigrationProgress]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MongoDbMigrationSettings'},
        'output': {'key': 'output', 'type': '[MongoDbMigrationProgress]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MongoDbMigrationSettings"] = None,
        **kwargs
    ):
        super(ValidateMongoDbTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Validate.MongoDb'  # type: str
        self.input = input
        self.output = None


class ValidateOracleAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates a migration for Oracle to Azure Database for PostgreSQL for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param task_type: Required. Task type.Constant filled by server.
    :type task_type: str
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Possible values include:
     "Unknown", "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation",
     "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :param client_data: Key value pairs of client data to attach meta data information to task.
    :type client_data: dict[str, str]
    :param input: Input for the task that migrates Oracle databases to Azure Database for
     PostgreSQL for online migrations.
    :type input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
    :ivar output: An array containing a single validation error response object.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateOracleAzureDbPostgreSqlSyncTaskOutput]
    """

    _validation = {
        'task_type': {'required': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'commands': {'readonly': True},
        'output': {'readonly': True},
    }

    _attribute_map = {
        'task_type': {'key': 'taskType', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ODataError]'},
        'state': {'key': 'state', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[CommandProperties]'},
        'client_data': {'key': 'clientData', 'type': '{str}'},
        'input': {'key': 'input', 'type': 'MigrateOracleAzureDbPostgreSqlSyncTaskInput'},
        'output': {'key': 'output', 'type': '[ValidateOracleAzureDbPostgreSqlSyncTaskOutput]'},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["MigrateOracleAzureDbPostgreSqlSyncTaskInput"] = None,
        **kwargs
    ):
        super(ValidateOracleAzureDbForPostgreSqlSyncTaskProperties, self).__init__(client_data=client_data, **kwargs)
        self.task_type = 'Validate.Oracle.AzureDbPostgreSql.Sync'  # type: str
        self.input = input
        self.output = None


class ValidateOracleAzureDbPostgreSqlSyncTaskOutput(msrest.serialization.Model):
    """Output for task that validates migration input for Oracle to Azure Database for PostgreSQL for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateOracleAzureDbPostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.validation_errors = None


class ValidateSyncMigrationInputSqlServerTaskInput(msrest.serialization.Model):
    """Input for task that validates migration input for SQL sync migrations.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to source SQL server.
    :type source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to target.
    :type target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate.
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSqlServerSqlDbSyncDatabaseInput]'},
    }

    def __init__(
        self,
        *,
        source_connection_info: "SqlConnectionInfo",
        target_connection_info: "SqlConnectionInfo",
        selected_databases: List["MigrateSqlServerSqlDbSyncDatabaseInput"],
        **kwargs
    ):
        super(ValidateSyncMigrationInputSqlServerTaskInput, self).__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases


class ValidateSyncMigrationInputSqlServerTaskOutput(msrest.serialization.Model):
    """Output for task that validates migration input for SQL sync migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Database identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateSyncMigrationInputSqlServerTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.validation_errors = None


class ValidationError(msrest.serialization.Model):
    """Description about the errors happen while performing migration validation.

    :param text: Error Text.
    :type text: str
    :param severity: Severity of the error. Possible values include: "Message", "Warning", "Error".
    :type severity: str or ~azure.mgmt.datamigration.models.Severity
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        severity: Optional[Union[str, "Severity"]] = None,
        **kwargs
    ):
        super(ValidationError, self).__init__(**kwargs)
        self.text = text
        self.severity = severity


class WaitStatistics(msrest.serialization.Model):
    """Wait statistics gathered during query batch execution.

    :param wait_type: Type of the Wait.
    :type wait_type: str
    :param wait_time_ms: Total wait time in millisecond(s).
    :type wait_time_ms: float
    :param wait_count: Total no. of waits.
    :type wait_count: long
    """

    _attribute_map = {
        'wait_type': {'key': 'waitType', 'type': 'str'},
        'wait_time_ms': {'key': 'waitTimeMs', 'type': 'float'},
        'wait_count': {'key': 'waitCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        wait_type: Optional[str] = None,
        wait_time_ms: Optional[float] = 0,
        wait_count: Optional[int] = None,
        **kwargs
    ):
        super(WaitStatistics, self).__init__(**kwargs)
        self.wait_type = wait_type
        self.wait_time_ms = wait_time_ms
        self.wait_count = wait_count
