# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from .operations.custom_instance_operations import CustomInstanceOperations
from . import models


class CustomImageSearchAPIConfiguration(Configuration):
    """Configuration for CustomImageSearchAPI
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://api.cognitive.microsoft.com/bingcustomsearch/v7.0'

        super(CustomImageSearchAPIConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-cognitiveservices-search-customimagesearch/{}'.format(VERSION))

        self.credentials = credentials


class CustomImageSearchAPI(SDKClient):
    """The Bing Custom Image Search API lets you send an image search query to Bing and get back image search results customized to meet your custom search definition.

    :ivar config: Configuration for client.
    :vartype config: CustomImageSearchAPIConfiguration

    :ivar custom_instance: CustomInstance operations
    :vartype custom_instance: azure.cognitiveservices.search.customimagesearch.operations.CustomInstanceOperations

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = CustomImageSearchAPIConfiguration(credentials, base_url)
        super(CustomImageSearchAPI, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.custom_instance = CustomInstanceOperations(
            self._client, self.config, self._serialize, self._deserialize)
