# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class Category(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Identity system of the device.
    """

    AZURE_AD = "AzureAD"
    ADFS = "ADFS"

class CompatibilityIssue(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Compatibility issue
    """

    HIGHER_DEVICE_VERSION_REQUIRED = "HigherDeviceVersionRequired"
    LOWER_DEVICE_VERSION_REQUIRED = "LowerDeviceVersionRequired"
    CAPACITY_BILLING_MODEL_REQUIRED = "CapacityBillingModelRequired"
    PAY_AS_YOU_GO_BILLING_MODEL_REQUIRED = "PayAsYouGoBillingModelRequired"
    DEVELOPMENT_BILLING_MODEL_REQUIRED = "DevelopmentBillingModelRequired"
    AZURE_AD_IDENTITY_SYSTEM_REQUIRED = "AzureADIdentitySystemRequired"
    ADFS_IDENTITY_SYSTEM_REQUIRED = "ADFSIdentitySystemRequired"
    CONNECTION_TO_INTERNET_REQUIRED = "ConnectionToInternetRequired"
    CONNECTION_TO_AZURE_REQUIRED = "ConnectionToAzureRequired"
    DISCONNECTED_ENVIRONMENT_REQUIRED = "DisconnectedEnvironmentRequired"

class ComputeRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Compute role type (IaaS or PaaS).
    """

    NONE = "None"
    IAA_S = "IaaS"
    PAA_S = "PaaS"

class Location(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Location of the resource.
    """

    GLOBAL_ENUM = "global"

class OperatingSystem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operating system type (Windows or Linux).
    """

    NONE = "None"
    WINDOWS = "Windows"
    LINUX = "Linux"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource.
    """

    CREATING = "Creating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
