# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import AzureStackManagementClientConfiguration
from .operations import Operations
from .operations import CloudManifestFileOperations
from .operations import ProductsOperations
from .operations import RegistrationsOperations
from .operations import CustomerSubscriptionsOperations
from .. import models


class AzureStackManagementClient(object):
    """Azure Stack.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.azurestack.aio.operations.Operations
    :ivar cloud_manifest_file: CloudManifestFileOperations operations
    :vartype cloud_manifest_file: azure.mgmt.azurestack.aio.operations.CloudManifestFileOperations
    :ivar products: ProductsOperations operations
    :vartype products: azure.mgmt.azurestack.aio.operations.ProductsOperations
    :ivar registrations: RegistrationsOperations operations
    :vartype registrations: azure.mgmt.azurestack.aio.operations.RegistrationsOperations
    :ivar customer_subscriptions: CustomerSubscriptionsOperations operations
    :vartype customer_subscriptions: azure.mgmt.azurestack.aio.operations.CustomerSubscriptionsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Subscription credentials that uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AzureStackManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_manifest_file = CloudManifestFileOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.products = ProductsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registrations = RegistrationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.customer_subscriptions = CustomerSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "AzureStackManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
