# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PostRestoreRequest(Model):
    """Post Restore Request.

    :param partition: Post Restore partition.
    :type partition: str
    :param replica_group: Post Restore replica group.
    :type replica_group: str
    :param request_id: Post Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Post Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Post Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Post Restore Azure source azure file
     share uri.
    :type source_azure_file_share_uri: str
    :param failed_file_list: Post Restore Azure failed file list.
    :type failed_file_list: str
    :param restore_file_spec: Post Restore restore file spec array.
    :type restore_file_spec:
     list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'failed_file_list': {'key': 'failedFileList', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
    }

    def __init__(self, *, partition: str=None, replica_group: str=None, request_id: str=None, azure_file_share_uri: str=None, status: str=None, source_azure_file_share_uri: str=None, failed_file_list: str=None, restore_file_spec=None, **kwargs) -> None:
        super(PostRestoreRequest, self).__init__(**kwargs)
        self.partition = partition
        self.replica_group = replica_group
        self.request_id = request_id
        self.azure_file_share_uri = azure_file_share_uri
        self.status = status
        self.source_azure_file_share_uri = source_azure_file_share_uri
        self.failed_file_list = failed_file_list
        self.restore_file_spec = restore_file_spec
