########################################################################
# test/xslt/st_20000210.py
# From Steve Tinney's word-count templates, 10 Feb 2000

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_word_count_1_st_20000210(xslt_test):
    source = stringsource("""<test><a> a a </a><b>b<one>1</one><two>2</two></b></test>""")
    transform = stringsource("""<?xml version='1.0'?>
<!-- wctest.xsl -->
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="text"/>
<xsl:include href="Xml/Xslt/Borrowed/wc-nt.xslt"/>

<xsl:variable name="nwords">
  <xsl:call-template name="word-count">
    <xsl:with-param name="in" select="/"/>
  </xsl:call-template>
</xsl:variable>

<xsl:template match="/">
  Word count = <xsl:value-of select="$nwords"/>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """
  Word count = 5"""

class test_xslt_word_count_2_st_20000210(xslt_test):
    source = stringsource("""<test><a> a a </a><b>b<one>1</one><two>2</two></b></test>""")
    transform = stringsource("""<?xml version='1.0'?>
<!-- wctest.xsl -->
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="text"/>
<xsl:include href="Xml/Xslt/Borrowed/wc.xslt"/>

<xsl:variable name="nwords">
  <xsl:call-template name="word-count">
    <xsl:with-param name="in" select="/"/>
  </xsl:call-template>
</xsl:variable>

<xsl:template match="/">
  Word count = <xsl:value-of select="$nwords"/>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """
  Word count = 5"""

if __name__ == '__main__':
    test_main()

