########################################################################
# test/xslt/oc_20010817.py
# Olivier Cayrol <olivier.cayrol@logilab.fr> reports 
# (https://sourceforge.net/tracker/index.php?func=detail&aid=452113&group_id=6473&atid=106473) 
# bug with spacing and nbsps

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_spacing_and_nbsp_oc_20010817(xslt_test):
    source = stringsource("""\
<?xml version="1.0" encoding="ISO-8859-1"?>
<root/>
""")
    transform = stringsource("""\
<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html"
            version="4.0" 
            encoding="ISO-8859-1" 
            indent="yes" 
            doctype-public="-//W3C//DTD HTML 4.0//EN"/>

<xsl:template match="/">
  <html>
    <head/>
    <body>
      <p>&#160;</p>
      <p> &#160;</p>
      <p>&#160; </p>
      <p> &#160;*</p>
      <p>*&#160; </p>
      <p>*&#160;*</p>
      <p>*</p>
      <table width="100%" border="1">
       <tr>
        <td bgcolor="blue">&#160;</td>
        <td bgcolor="blue"> &#160;</td>
        <td bgcolor="blue">&#160; </td>
        <td bgcolor="blue"> &#160;*</td>
        <td bgcolor="blue">*&#160; </td>
        <td bgcolor="blue">*&#160;*</td>
        <td bgcolor="blue">*</td>
       </tr>
      </table>
    </body>
  </html>
</xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0//EN">\n<html>\n  <head>\n    <meta http-equiv=\'Content-Type\' content=\'text/html; charset=ISO-8859-1\'>\n  </head>\n  <body>\n    <p>&nbsp;</p>\n    <p> &nbsp;</p>\n    <p>&nbsp; </p>\n    <p> &nbsp;*</p>\n    <p>*&nbsp; </p>\n    <p>*&nbsp;*</p>\n    <p>*</p>\n    <table width=\'100%\' border=\'1\'>\n      <tr>\n        <td bgcolor=\'blue\'>&nbsp;</td>\n        <td bgcolor=\'blue\'> &nbsp;</td>\n        <td bgcolor=\'blue\'>&nbsp; </td>\n        <td bgcolor=\'blue\'> &nbsp;*</td>\n        <td bgcolor=\'blue\'>*&nbsp; </td>\n        <td bgcolor=\'blue\'>*&nbsp;*</td>\n        <td bgcolor=\'blue\'>*</td>\n      </tr>\n    </table>\n  </body>\n</html>'


if __name__ == '__main__':
    test_main()
