########################################################################
# test/xslt/km_20000204.py
# Example from Michael Kay to ??? on 4 Feb 2000, with well-formedness 
# corrections

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

commonsource = stringsource("""<?xml version="1.0"?>
<elementList>
    <element>
        <x>
            <y>a</y>
        </x>
    </element>
    <element>
        <x>
            <y>z</y>
        </x>
    </element>
</elementList>""")

class test_xslt_descendants_1_km_20000204(xslt_test):
    source = commonsource
    transform = stringsource("""<xsl:transform
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 version="1.0"
>

<xsl:output method='text'/>

<xsl:variable name="pos">
  <xsl:for-each select="//element[descendant::y[.='z']][1]">
    <xsl:number/>
  </xsl:for-each>
</xsl:variable>

<xsl:template match="/">
result: <xsl:value-of select='$pos'/>
</xsl:template>

</xsl:transform>""")
    parameters = {}
    expected = """
result: 2"""

class test_xslt_descendants_2_km_20000204(xslt_test):
    source = commonsource
    transform = stringsource("""<xsl:transform
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 version="1.0"
>

<xsl:output method='text'/>

<xsl:variable name="pos">
   <xsl:for-each select="//element">
       <xsl:if test="*[descendant::y[.='z']]">
           <xsl:value-of select="position()"/>
       </xsl:if>
   </xsl:for-each>
</xsl:variable>

<xsl:template match="/">
result: <xsl:value-of select='$pos'/>
</xsl:template>

</xsl:transform>""")
    parameters = {}
    expected = """
result: 2"""

class test_xslt_descendants_3_km_20000204(xslt_test):
    # This third approach actually by Senthil 
    # Vaiyapuri <senthil@portal.com> on 2000-02-04
    source = commonsource
    transform = stringsource("""<?xml version="1.0" standalone="yes"?> 
<xsl:stylesheet
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      version="1.0">
<xsl:output method="text"/>

<xsl:template match="element">
  <xsl:if test=".//y"> 
    <xsl:variable name="yvalue"><xsl:value-of select=".//y"/></xsl:variable>
     <xsl:if test="$yvalue = 'z'">
       <xsl:number count="element" format="1." level="any"/>
     </xsl:if>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>
""")
    parameters = {}
    expected = """
    
    2.
"""

if __name__ == '__main__':
    test_main()
