########################################################################
# test/xslt/evdv_20030203-2.py
# http://sourceforge.net/tracker/index.php?func=detail&aid=679374&group_id=39954&atid=428292

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_matches_evdv_20030203_2(xslt_test):
    source = stringsource("""\
<?xml version="1.0" encoding="UTF-8"?>
<foo bar="xxx"/>
""")
    transform = stringsource("""\
<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="foo">
    <res>
      <xsl:apply-templates select="@*"/>
    </res>
  </xsl:template>

  <xsl:template match="@bar[. = 'xxx']">
    <ok>
      <xsl:copy-of select="."/>
    </ok>
  </xsl:template>

</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>
<res><ok bar="xxx"/></res>"""

if __name__ == '__main__':
    test_main()

