#!/usr/bin/env python
# -*- coding: utf-8 -*-

from distutils.core import setup
import ittybitty
import sys, os

def fullsplit(path, result=None):
    """
    Split a pathname into components (the opposite of os.path.join) in a
    platform-neutral way.
    """
    if result is None:
        result = []
    head, tail = os.path.split(path)
    if head == '':
        return [tail] + result
    if head == path:
        return result
    return fullsplit(head, [tail] + result)

packages, data_files = [], []
root_dir = os.path.dirname(__file__)
if root_dir != '':
    os.chdir(root_dir)
ittybitty_dir = 'ittybitty'

for path, dirs, files in os.walk(ittybitty_dir):
    # ignore hidden directories and files
    for i, d in enumerate(dirs):
        if d.startswith('.'): del dirs[i]

    if '__init__.py' in files:
        packages.append('.'.join(fullsplit(path)))
    elif files:
        data_files.append((path, [os.path.join(path, f) for f in files]))

setup(
    name='django-ittybitty',
    version=ittybitty.version(),
    url='http://code.google.com/p/django-ittybitty/',
    author='Josh VanderLinden',
    author_email='codekoala@gmail.com',
    license='MIT',
    packages=packages,
    data_files=data_files,
    description="Shortened URLs for your Django-powered site!",
    long_description="""
This application offers those with Django-powered sites to have their very own
URL-shortening capabilities with great ease. For an idea of what "URL-shortening"
means, have a gander at http://mashable.com/2008/01/08/url-shortening-services/
or just Google "url shortening". It's kind of a big deal all of the sudden.

Why should you use this when all of those services already exist online? Maybe
it's just me, but I don't like relying on 3rd party servers in order for my
site to function, and that includes relying on other servers for people to
follow a link to my site. With this application installed, you no longer need
to worry about downtime on those other servers affecting your traffic at all.
If people can't get to your site using the shortened URLs generated by this
application, you probably have bigger problems (ie your site itself is down).
""",
    keywords='django, urls, compression',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ]
)