from sqlalchemy import create_engine
from sqlalchemy import Column, Integer, String, Text, ForeignKey, DateTime, UniqueConstraint, Index,Float,Date
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declarative_base
import traceback
class SqlalchemyTool:
    Model = declarative_base()
    Column=Column
    Integer=Integer
    String=String
    Text=Text
    ForeignKey=ForeignKey
    DateTime=DateTime
    Float=Float
    Date=Date






    def __init__(self):
        self.conn=None
    def initmysql(self,host='127.0.0.1',port='3306',database=None,user='root',pwd=None):
        try:
           self._conn = create_engine('mysql+pymysql://{0}:{1}@{2}:{3}/{4}?charset=utf8'.format(user,pwd,host,port,database))
        except:
            traceback.print_exc()

    def initsqlite(self,database='sqlite3.db',echo=False):
        if echo==False:
            self._conn=create_engine('sqlite:///{0}'.format(database))
        else:
            self._conn = create_engine('sqlite:///:memory:', echo=True)

    '''获取游标'''
    def cursors(self):
        Connection = sessionmaker(bind=self._conn)
        self._cursor=Connection()
        return  self._cursor

    '''创建数据库'''
    def createtable(self):
        SqlalchemyTool.Model.metadata.create_all(self._conn)



# 示例
#
# db=SqlalchemyTool()
#
# db.initmysql(database='tasks',pwd='123456')
# class  Users(db.Model):
#     __tablename__ = 'olll'  # 数据库表名称
#     id = db.Column(db.Integer, primary_key=True)
#     name = db.Column(db.String(32), index=True, nullable=False)
#
# class  Users(db.Model):
#     __tablename__ = 'loginsss'  # 数据库表名称
#     id = db.Column(db.Integer, primary_key=True)
#     name = db.Column(db.String(32), index=True, nullable=False)
# db.createtable()





