# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource import TrackedResource


class Profile(TrackedResource):
    """
    CDN profile represents the top level resource and the entry point into the
    CDN API. This allows users to set up a logical grouping of endpoints in
    addition to creating shared configuration settings and selecting pricing
    tiers and providers.

    :param id: Resource ID
    :type id: str
    :param name: Resource name
    :type name: str
    :param type: Resource type
    :type type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param sku: The SKU (pricing tier) of the CDN profile.
    :type sku: :class:`Sku <azure.mgmt.cdn.models.Sku>`
    :param resource_state: Resource status of the profile. Possible values
     include: 'Creating', 'Active', 'Deleting', 'Disabled'
    :type resource_state: str
    :param provisioning_state: Provisioning status of the profile. Possible
     values include: 'Creating', 'Succeeded', 'Failed'
    :type provisioning_state: str
    """ 

    _validation = {
        'location': {'required': True},
        'tags': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'ProfileResourceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
    }

    def __init__(self, location, tags, id=None, name=None, type=None, sku=None, resource_state=None, provisioning_state=None, **kwargs):
        super(Profile, self).__init__(id=id, name=name, type=type, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.resource_state = resource_state
        self.provisioning_state = provisioning_state
