# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class CustomDomain(Resource):
    """
    CDN CustomDomain represents a mapping between a user specified domain name
    and a CDN endpoint. This is to use custom domain names to represent the
    URLs for branding purposes.

    :param id: Resource ID
    :type id: str
    :param name: Resource name
    :type name: str
    :param type: Resource type
    :type type: str
    :param host_name: The host name of the custom domain. Must be a domain
     name.
    :type host_name: str
    :param resource_state: Resource status of the custom domain. Possible
     values include: 'Creating', 'Active', 'Deleting'
    :type resource_state: str
    :param provisioning_state: Provisioning status of the custom domain.
     Possible values include: 'Creating', 'Succeeded', 'Failed'
    :type provisioning_state: str
    """ 

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'CustomDomainResourceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
    }

    def __init__(self, host_name, id=None, name=None, type=None, resource_state=None, provisioning_state=None, **kwargs):
        super(CustomDomain, self).__init__(id=id, name=name, type=type, **kwargs)
        self.host_name = host_name
        self.resource_state = resource_state
        self.provisioning_state = provisioning_state
