/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Version;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriverShell;
import net.sf.saxon.testdriver.TestReport;

public abstract class TestDriver {
    protected String resultsDir = null;
    protected TestReport resultsDoc;
    protected int successes = 0;
    protected int failures = 0;
    protected int notrun = 0;
    protected int wrongErrorResults = 0;
    protected TestDriverShell shell = new TestDriverShell();
    protected boolean unfolded = false;
    protected boolean saveResults = false;
    protected int generateByteCode = 0;
    protected int streaming = 1;
    protected TreeModel treeModel = TreeModel.TINY_TREE;
    protected boolean debug = false;
    protected Pattern testPattern = null;
    protected String requestedTestSet = null;
    protected String testSuiteDir;
    protected Processor driverProc = null;
    protected Serializer driverSerializer = null;
    protected HashMap<String, XdmNode> exceptionsMap = new HashMap();
    protected HashMap<String, String> optimizationAssertions = new HashMap();
    protected Map<String, Environment> globalEnvironments = new HashMap<String, Environment>();
    protected Map<String, Environment> localEnvironments = new HashMap<String, Environment>();
    protected Spec spec;
    protected String lang;
    protected boolean useXslt30Transformer = true;

    public abstract String catalogNamespace();

    public void go(String[] args) throws Exception {
        if (this.driverProc == null) {
            this.driverProc = new Processor(false);
        }
        this.driverSerializer = this.driverProc.newSerializer();
        System.err.println("Testing " + this.getProductEdition() + " " + Version.getProductVersion());
        System.err.println("Java version " + System.getProperty("java.version"));
        this.testSuiteDir = args[0];
        String catalog = args[1];
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-t:")) {
                this.testPattern = Pattern.compile(args[i].substring(3));
            }
            if (args[i].startsWith("-s:")) {
                this.requestedTestSet = args[i].substring(3);
            }
            if (args[i].startsWith("-o")) {
                this.resultsDir = args[i].substring(3);
            }
            if (args[i].startsWith("-debug")) {
                this.debug = true;
            }
            if (args[i].equals("-unfolded")) {
                this.unfolded = true;
            }
            if (args[i].equals("-save")) {
                this.saveResults = true;
            }
            if (args[i].startsWith("-bytecode")) {
                this.generateByteCode = args[i].substring(10).equals("on") ? 1 : (args[i].substring(10).equals("debug") ? 2 : 0);
            }
            if (args[i].startsWith("-streaming")) {
                if (args[i].substring(11).equals("off")) {
                    this.streaming = 0;
                } else if (args[i].substring(11).equals("std")) {
                    this.streaming = 1;
                } else if (args[i].substring(11).equals("ext")) {
                    this.streaming = 2;
                }
            }
            if (args[i].startsWith("-tree")) {
                String model = args[i].substring(6);
                this.treeModel = this.getTreeModel(model);
                if (this.treeModel == null) {
                    throw new Exception("The requested TreeModel '" + model + "' does not exist");
                }
            }
            if (args[i].startsWith("-lang")) {
                String specStr = null;
                this.lang = specStr = args[i].substring(6);
                this.processSpec(specStr);
            }
            if (!args[i].startsWith("-xt30")) continue;
            if (args[i].substring(6).equals("on")) {
                this.useXslt30Transformer = true;
                continue;
            }
            if (!args[i].substring(6).equals("off")) continue;
            this.useXslt30Transformer = false;
        }
        if (this.resultsDoc == null) {
            this.printError("No result document: missing -lang option", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        if (this.resultsDir == null) {
            this.printError("No results directory specified (use -o:dirname)", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        System.err.println("UsingXslt30Transformer: " + this.useXslt30Transformer);
        this.driverSerializer.setOutputStream((OutputStream)System.err);
        this.driverSerializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        this.processCatalog(new File(catalog));
        this.printResults(this.resultsDir + "/results" + Version.getProductVersion() + ".xml");
    }

    protected TreeModel getTreeModel(String s) {
        DOMObjectModel tree = null;
        if (s.equalsIgnoreCase("dom")) {
            tree = new DOMObjectModel();
        } else if (s.equalsIgnoreCase("tinytree")) {
            tree = TreeModel.TINY_TREE;
        } else if (s.equalsIgnoreCase("condensed")) {
            tree = TreeModel.TINY_TREE_CONDENSED;
        } else if (s.equalsIgnoreCase("linked")) {
            tree = TreeModel.LINKED_TREE;
        }
        return tree;
    }

    public String getResultsDir() {
        return this.resultsDir;
    }

    public abstract void processSpec(String var1);

    public boolean isByteCode() {
        return this.generateByteCode != 0;
    }

    public String getProductEdition() {
        return "Saxon-" + this.driverProc.getSaxonEdition();
    }

    protected void processCatalog(File catalogFile) throws SaxonApiException {
        if (this.driverProc.getSaxonEdition().equals("EE")) {
            if (this.generateByteCode == 1) {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"true");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"false");
            } else if (this.generateByteCode == 2) {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"true");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"true");
            } else {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"false");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"false");
            }
        }
        DocumentBuilder catbuilder = this.driverProc.newDocumentBuilder();
        catbuilder.setTreeModel(this.treeModel);
        XdmNode catalog = catbuilder.build(catalogFile);
        XPathCompiler xpc = this.driverProc.newXPathCompiler();
        xpc.setLanguageVersion("3.0");
        xpc.setCaching(true);
        xpc.declareNamespace("", this.catalogNamespace());
        this.createGlobalEnvironments(catalog, xpc);
        try {
            this.writeResultFilePreamble(this.driverProc, catalog);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.readExceptionsFile();
        if (this.requestedTestSet != null) {
            try {
                XdmNode funcSetNode = (XdmNode)xpc.evaluateSingle("//test-set[@name='" + this.requestedTestSet + "']", (XdmItem)catalog);
                if (funcSetNode == null) {
                    throw new Exception("Test-set " + this.requestedTestSet + " not found!");
                }
                this.processTestSet(catbuilder, xpc, funcSetNode);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            for (XdmItem testSet : xpc.evaluate("//test-set", (XdmItem)catalog)) {
                this.processTestSet(catbuilder, xpc, (XdmNode)testSet);
            }
        }
        try {
            this.writeResultFilePostamble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readExceptionsFile() {
        XdmNode exceptionsDoc = null;
        DocumentBuilder exceptBuilder = this.driverProc.newDocumentBuilder();
        QName testCase = new QName("", "test-case");
        QName run = new QName("", "run");
        QName edition = new QName("", "edition");
        String saxonEdition = this.driverProc.getSaxonEdition();
        try {
            exceptionsDoc = exceptBuilder.build(new File(this.resultsDir + "/exceptions.xml"));
            XdmSequenceIterator iter = exceptionsDoc.axisIterator(Axis.DESCENDANT, new QName("", "exception"));
            while (iter.hasNext()) {
                XdmNode entry = (XdmNode)iter.next();
                String testName = entry.getAttributeValue(testCase);
                String runVal = entry.getAttributeValue(run);
                String editionVal = entry.getAttributeValue(edition);
                if (runVal == null) {
                    runVal = "false";
                }
                if (editionVal == null) {
                    editionVal = saxonEdition;
                }
                boolean appliesThisEdition = false;
                for (String ed : editionVal.trim().split("\\s+")) {
                    if (!ed.equals(saxonEdition)) continue;
                    appliesThisEdition = true;
                    break;
                }
                if (testName == null || !appliesThisEdition) continue;
                if (runVal.equals("false")) {
                    this.exceptionsMap.put(testName, entry);
                    continue;
                }
                XdmSequenceIterator iter2 = entry.axisIterator(Axis.CHILD, new QName("optimization"));
                if (!iter2.hasNext()) continue;
                XdmNode optim = (XdmNode)iter2.next();
                this.optimizationAssertions.put(testName, optim.getAttributeValue(new QName("", "assert")));
            }
        }
        catch (SaxonApiException e) {
            this.printError("*** Failed to process exceptions file: ", e.getMessage());
        }
    }

    protected abstract void createGlobalEnvironments(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    protected void createLocalEnvironments(XdmNode testSetDocNode) {
        this.localEnvironments.clear();
        Environment defaultEnvironment = Environment.createLocalEnvironment(testSetDocNode.getBaseURI(), this.generateByteCode, this.unfolded, this.spec, this);
        this.localEnvironments.put("default", defaultEnvironment);
    }

    protected Environment getEnvironment(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        Environment env;
        String testCaseName = testCase.getAttributeValue(new QName("name"));
        XdmNode environmentNode = (XdmNode)xpc.evaluateSingle("environment", (XdmItem)testCase);
        if (environmentNode == null) {
            env = this.localEnvironments.get("default");
        } else {
            String envName = environmentNode.getAttributeValue(new QName("ref"));
            if (envName == null || envName.equals("")) {
                boolean baseUriCheck;
                block11: {
                    baseUriCheck = false;
                    env = null;
                    try {
                        env = Environment.processEnvironment(this, xpc, (XdmItem)environmentNode, null, this.localEnvironments.get("default"));
                        baseUriCheck = ((XdmAtomicValue)xpc.evaluateSingle("static-base-uri/@uri='#UNDEFINED'", (XdmItem)environmentNode)).getBooleanValue();
                    }
                    catch (NullPointerException ex) {
                        System.err.println("Failure loading environment");
                        if (env == null) break block11;
                        env.usable = false;
                    }
                }
                if (baseUriCheck) {
                    return null;
                }
            } else {
                env = this.localEnvironments.get(envName);
                if (env == null) {
                    env = this.globalEnvironments.get(envName);
                }
                if (env == null) {
                    for (XdmItem e : xpc.evaluate("//environment[@name='" + envName + "']", (XdmItem)testCase)) {
                        Environment.processEnvironment(this, xpc, e, this.localEnvironments, this.localEnvironments.get("default"));
                    }
                    env = this.localEnvironments.get(envName);
                }
                if (env == null) {
                    this.println("*** Unknown environment " + envName);
                    ++this.failures;
                    return null;
                }
            }
        }
        return env;
    }

    public void addInjection(XQueryCompiler compiler) {
    }

    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws IOException, SaxonApiException, XMLStreamException, Exception {
        this.resultsDoc.writeResultFilePreamble(processor, catalog);
    }

    protected void writeResultFilePostamble() throws XMLStreamException {
        this.resultsDoc.writeResultFilePostamble();
    }

    protected void startTestSetElement(XdmNode testSetNode) {
        this.resultsDoc.startTestSetElement(testSetNode);
    }

    protected void writeTestSetEndElement() {
        this.resultsDoc.endElement();
    }

    private void processTestSet(DocumentBuilder catbuilder, XPathCompiler xpc, XdmNode testSetNode) throws SaxonApiException {
        this.startTestSetElement(testSetNode);
        File testSetFile = new File(this.testSuiteDir + "/" + testSetNode.getAttributeValue(new QName("file")));
        XdmNode testSetDocNode = catbuilder.build(testSetFile);
        this.createLocalEnvironments(testSetDocNode);
        boolean run = true;
        if (((XdmAtomicValue)xpc.evaluate("exists(/test-set/dependency)", (XdmItem)testSetDocNode).itemAt(0)).getBooleanValue()) {
            for (XdmItem dependency : xpc.evaluate("/test-set/dependency", (XdmItem)testSetDocNode)) {
                if (this.dependencyIsSatisfied((XdmNode)dependency, this.localEnvironments.get("default"))) continue;
                for (XdmItem testCase : xpc.evaluate("//test-case", (XdmItem)testSetDocNode)) {
                    String testCaseName = ((XdmNode)testCase).getAttributeValue(new QName("name"));
                    this.resultsDoc.writeTestcaseElement(testCaseName, "n/a", "test-set dependencies not satisfied");
                    ++this.notrun;
                }
                run = false;
            }
        }
        if (run) {
            if (this.testPattern == null) {
                for (XdmItem env : xpc.evaluate("//environment[@name]", (XdmItem)testSetDocNode)) {
                    try {
                        Environment.processEnvironment(this, xpc, env, this.localEnvironments, this.localEnvironments.get("default"));
                    }
                    catch (NullPointerException ex) {
                        System.err.println("Failure loading environment, processTestSet");
                    }
                }
            }
            String testSet = xpc.evaluateSingle("/test-set/@name", (XdmItem)testSetDocNode).getStringValue();
            for (XdmItem testCase : xpc.evaluate("//test-case", (XdmItem)testSetDocNode)) {
                String testName = xpc.evaluateSingle("@name", testCase).getStringValue();
                if (this.testPattern != null && !this.testPattern.matcher(testName).matches()) continue;
                this.println("-s:" + testSet + " -t:" + testName);
                this.runTestCase((XdmNode)testCase, xpc);
            }
        }
        this.writeTestSetEndElement();
    }

    protected abstract void runTestCase(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    public void setTestDriverShell(TestDriverShell gui) {
        this.shell = gui;
    }

    public void println(String data) {
        this.shell.println(data);
    }

    public void printResults(String resultsFileStr) {
        this.shell.printResults("Result: " + this.successes + " successes, " + this.failures + " failures, " + this.wrongErrorResults + " incorrect ErrorCode, " + this.notrun + " not run", resultsFileStr, this.resultsDir);
    }

    public void printError(String error, String message) {
        this.shell.alert(error);
        this.shell.println(error + message);
    }

    public void printError(String error, Exception e) {
        this.shell.alert(error);
        e.printStackTrace();
    }

    public abstract boolean dependencyIsSatisfied(XdmNode var1, Environment var2);
}

