from typing import ClassVar, List, Union

from typing import overload

class AntiHookOpt:
    def __init__(self, value: bool) -> None: ...

class ArithmeticOpt:
    @overload
    def __init__(self, rounds: int) -> None: ...
    @overload
    def __init__(self, value: bool) -> None: ...

class BreakControlFlowOpt:
    def __init__(self, arg0: bool) -> None: ...

class ControlFlowFlatteningOpt:
    def __init__(self, value: bool) -> None: ...

class Function:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def name(self) -> str: ...

class GlobalVariable:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def name(self) -> str: ...

class LOG_LEVEL:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    DEBUG: ClassVar["LOG_LEVEL"] = ...
    ERR: ClassVar["LOG_LEVEL"] = ...
    INFO: ClassVar["LOG_LEVEL"] = ...
    TRACE: ClassVar["LOG_LEVEL"] = ...
    WARN: ClassVar["LOG_LEVEL"] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Module:
    def __init__(self, *args, **kwargs) -> None: ...
    def dump(self, file: str) -> None: ...
    @property
    def data_layout(self) -> str: ...
    @property
    def identifier(self) -> str: ...
    @property
    def instruction_count(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def source_filename(self) -> str: ...
class OpaqueConstantsBool:
    def __init__(self, value: bool) -> None: ...

class OpaqueConstantsLowerLimit:
    def __init__(self, limit: int) -> None: ...

class OpaqueConstantsSet:
    def __init__(self, constants: List[int]) -> None: ...

class OpaqueConstantsSkip:
    def __init__(self) -> None: ...

class StringEncOptDefault:
    def __init__(self) -> None: ...

class StringEncOptGlobal:
    def __init__(self) -> None: ...

class StringEncOptReplace:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, new_string: str) -> None: ...

class StringEncOptSkip:
    def __init__(self) -> None: ...

class StringEncOptStack:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, loopThreshold: int) -> None: ...

class Struct:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def name(self) -> str: ...

class StructAccessOpt:
    def __init__(self, arg0: bool) -> None: ...

class VarAccessOpt:
    def __init__(self, arg0: bool) -> None: ...

class config_t:
    inline_jni_wrappers: bool
    passes: List[str]
    shuffle_functions: bool
    def __init__(self, *args, **kwargs) -> None: ...


class ObfuscationConfig:
    def __init__(self) -> None: ...
    def anti_hooking(self, module: Module, function: Function) -> AntiHookOpt: ...
    def break_control_flow(self, module: Module, function: Function) -> BreakControlFlowOpt: ...
    def flatten_cfg(self, module: Module, function: Function) -> ControlFlowFlatteningOpt: ...
    def obfuscate_arithmetic(self, module: Module, function: Function) -> ArithmeticOpt: ...
    def obfuscate_constants(self, module: Module, function: Function) -> Union[OpaqueConstantsSkip,OpaqueConstantsBool,OpaqueConstantsLowerLimit,OpaqueConstantsSet]: ...
    def obfuscate_string(self, module: Module, function: Function, string: str) -> Union[StringEncOptSkip,StringEncOptStack,StringEncOptGlobal,StringEncOptReplace,StringEncOptDefault]: ...
    def obfuscate_struct_access(self, module: Module, function: Function, struct: Struct) -> StructAccessOpt: ...
    def obfuscate_variable_access(self, module: Module, function: Function, variable: GlobalVariable) -> VarAccessOpt: ...



def set_log_level(arg0: LOG_LEVEL) -> None: ...

LLVM_VERSION: str
OMVLL_VERSION: str
OMVLL_VERSION_FULL: str
config: config_t
