/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// Description
// ===========
// The tool is used to test the rebuilding of a binary.
// It take a binary as first argument, decompose it, rebuild the binary and then
// save it (second argument)

#include <iostream>
#include <memory>
#include <fstream>
#include <algorithm>
#include <iterator>

#include <LIEF/logging.hpp>
#include <LIEF/ELF.hpp>

int main(int argc, char **argv) {
  std::cout << "ELF builder" << std::endl;
  if (argc != 3) {
    std::cerr << "Usage: " << argv[0] << " <Input Binary> <Output Binary>" << std::endl;
    return -1;
  }

  std::unique_ptr<LIEF::ELF::Binary> binary{LIEF::ELF::Parser::parse(argv[1])};
  //LIEF::ELF::Builder builder{binary.release()};
  //builder.empties_gnuhash(true);
  //builder.build();
  //builder.write(argv[2]);
  binary->write(argv[2]);

  return 0;
}
